# Configure paths for XPK
# Bertrand Guiheneuf 98-10-21
# stolen from esd.m4 in esound :
# Manish Singh    98-9-30
# stolen back from Frank Belew
# stolen from Manish Singh
# Shamelessly stolen from Owen Taylor

dnl AM_PATH_XPK([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for XPK, and define XPK_CFLAGS and XPK_LIBS
dnl
AC_DEFUN(AM_PATH_XPK,
[dnl 
dnl Get the cflags and libraries from the xpk-config script
dnl
AC_ARG_WITH(xpk-prefix,[  --with-xpk-prefix=PFX   Prefix where XPK is installed (optional)],
            xpk_prefix="$withval", xpk_prefix="")
AC_ARG_WITH(xpk-exec-prefix,[  --with-xpk-exec-prefix=PFX Exec prefix where XPK is installed (optional)],
            xpk_exec_prefix="$withval", xpk_exec_prefix="")
AC_ARG_ENABLE(xpktest, [  --disable-xpktest       Do not try to compile and run a test XPK program],
		    , enable_xpktest=yes)

  if test x$xpk_exec_prefix != x ; then
     xpk_args="$xpk_args --exec-prefix=$xpk_exec_prefix"
     if test x${XPK_CONFIG+set} != xset ; then
        XPK_CONFIG=$xpk_exec_prefix/bin/xpk-config
     fi
  fi
  if test x$xpk_prefix != x ; then
     xpk_args="$xpk_args --prefix=$xpk_prefix"
     if test x${XPK_CONFIG+set} != xset ; then
        XPK_CONFIG=$xpk_prefix/bin/xpk-config
     fi
  fi

  AC_PATH_PROG(XPK_CONFIG, xpk-config, no)
  min_xpk_version=ifelse([$1], ,0.2.5,$1)
  AC_MSG_CHECKING(for XPK - version >= $min_xpk_version)
  no_xpk=""
  if test "$XPK_CONFIG" = "no" ; then
    no_xpk=yes
  else
    XPK_LIBS=`$XPK_CONFIG $xpkconf_args --libs`
    XPK_CFLAGS=`$XPK_CONFIG $xpkconf_args --cflags`
    xpk_major_version=`$XPK_CONFIG $xpk_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    xpk_minor_version=`$XPK_CONFIG $xpk_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    xpk_micro_version=`$XPK_CONFIG $xpk_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_xpktest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $XPK_CFLAGS"
      LIBS="$LIBS $XPK_LIBS"
dnl
dnl Now check if the installed XPK is sufficiently new. (Also sanity
dnl checks the results of xpk-config to some extent
dnl
      rm -f conf.xpktest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <xpk.h>

char*
my_strdup (char *str)
{
  char *new_str;
  
  if (str)
    {
      new_str = malloc ((strlen (str) + 1) * sizeof(char));
      strcpy (new_str, str);
    }
  else
    new_str = NULL;
  
  return new_str;
}

int main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.xpktest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_xpk_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_xpk_version");
     exit(1);
   }

   if (($xpk_major_version > major) ||
      (($xpk_major_version == major) && ($xpk_minor_version > minor)) ||
      (($xpk_major_version == major) && ($xpk_minor_version == minor) && ($xpk_micro_version >= micro)))
    {
      return 0;
    }
  else
    {
      printf("\n*** 'xpk-config --version' returned %d.%d.%d, but the minimum version\n", $xpk_major_version, $xpk_minor_version, $xpk_micro_version);
      printf("*** of XPK required is %d.%d.%d. If xpk-config is correct, then it is\n", major, minor, micro);
      printf("*** best to upgrade to the required version.\n");
      printf("*** If xpk-config was wrong, set the environment variable XPK_CONFIG\n");
      printf("*** to point to the correct copy of xpk-config, and remove the file\n");
      printf("*** config.cache before re-running configure\n");
      return 1;
    }
}

],, no_xpk=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_xpk" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$XPK_CONFIG" = "no" ; then
       echo "*** The xpk-config script installed by XPK could not be found"
       echo "*** If XPK was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the XPK_CONFIG environment variable to the"
       echo "*** full path to xpk-config."
     else
       if test -f conf.xpktest ; then
        :
       else
          echo "*** Could not run XPK test program, checking why..."
          CFLAGS="$CFLAGS $XPK_CFLAGS"
          LIBS="$LIBS $XPK_LIBS"
          AC_TRY_LINK([
#include <stdio.h>
#include <xpk.h>
],      [ return 0; ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding XPK or finding the wrong"
          echo "*** version of XPK. If it is not finding XPK, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means XPK was incorrectly installed"
          echo "*** or that you have moved XPK since it was installed. In the latter case, you"
          echo "*** may want to edit the xpk-config script: $XPK_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     XPK_CFLAGS=""
     XPK_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(XPK_CFLAGS)
  AC_SUBST(XPK_LIBS)
  rm -f conf.xpktest
])
