.\"$Header: /home/vikas/netmgt/nocol/src/doc/RCS/tpmon.8,v 1.4 1994/11/29 20:12:56 vikas Exp $"
.\"
.TH TPMON 8 "May 1994"
.SH NAME
tpmon \- TCP/IP network throughput measuring program
.SH SYNOPSIS
.B tpmon
[
.B \-d
] [
.B \-o
.I output-file
]
.I config-file
.SH DESCRIPTION
.LP
.B tpmon
is part of the NOCOL network monitoring package, used for
measuring the throughput (bits per second) to a remote networked host.

The program reads in the list of sites to test from a config file at startup
and then tests the throughput by dumping data to the 
.I discard
port (TCP port 9) on the remote hosts. It keeps track of the amount of data
sent and the time to send it, and calculates the throughput in bits
per second.  If the measured throughput drops below the set threshold value
(in the configuration file), then the
.I severity
for that site is incremented. However, the severity is not incremented beyond
WARNING (this is because the intent of the program is more towards providing
information than realtime monitoring. Furthermore, the thruput is a function
of the network load, system load, etc. and can only be considered a rough
estimate).

The program sleeps for POLLINTERVAL seconds between each run through the
list of hosts. This should be set to about 2 hours or more (7200) to avoid
loading the system and the network.

The program is useful for 
.I comparing
the throughputs to various sites. The output indicates the throughput rate in
Kbits per second.

.SH OPTIONS
.TP 16
.B \-d
selects verbose debugging output mode
.TP
.BI "\-o" " output file"
Name of the file to which to write the output.  This file is 
.I not
in human-readable format, and is intended to be processed by the 
.BR nocol (1)
display program.
.TP
.I config-file
This file lists the hosts to be tested for throughput and the threshold
levels. It also has the sleep interval between tests.

The format of this file is:
.RS
.sp
.DS
POLLINTERVAL   secs
.br
<SiteName>  <IPaddress> <Threshold in Kbps> [TEST]
.DE
.RE
.sp
.IP
The 
.I sitename
is there only for the operator's benefit and thus does not have to be a full
name.  The second column is the site's IP address.  The third column
is the lower threshold for throughput in Kbits per second (i.e.
1000 is 1 megabit per second)- if the throughput drops below this, the site
will be elevated to the WARNING level. The TEST keyword sets the n_TEST flag
in the 
.I nocop
field for the event which is then used by the post-processors (nocol, etc.).
.\"------------------------------------
.SH AUTHOR
S. Spencer Sun (spencer@phoenix.princeton.edu).
.SH CAVEATS
.LP
The measured throughput is a function of the network load, the end system
load and the intermediate hops. Hence, it can only be used as a rough
estimate.

The program should
.I not
be used for connecting to routers because of the additional CPU load on the
router (typically, router CPU's don't need to process every packet since the
packet can be switched by the I/O card directly).
Furthermore, the router might give lower priority to discard port
connections. 
.\"------------------------------------
.SH SEE ALSO
netconsole(1) nocol-prog(3) perlnocol(3)
eventselect(8) genmon(8) noclogd(8) nocol-overview(8)
nocol-utility(8) nsmon(8) pingmon(8) portmon(8) 
tpmon(8) trapmon(8)

