require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NET80211_IEEE80211_VAR_H_)) {
    eval 'sub _NET80211_IEEE80211_VAR_H_ () {1;}' unless defined(&_NET80211_IEEE80211_VAR_H_);
    eval 'sub IEEE80211_DEBUG () {1;}' unless defined(&IEEE80211_DEBUG);
    undef(&IEEE80211_DEBUG_REFCNT) if defined(&IEEE80211_DEBUG_REFCNT);
    if(defined(&__NetBSD__)) {
	require 'net80211/ieee80211_netbsd.ph';
    }
 elsif((defined(&__FreeBSD__) ? &__FreeBSD__ : undef)) {
	require 'net80211/ieee80211_freebsd.ph';
    }
 elsif((defined(&__linux__) ? &__linux__ : undef)) {
	require 'net80211/ieee80211_linux.ph';
    } else {
	die("No support for your operating system!");
    }
    require 'sys/queue.ph';
    require 'net80211/_ieee80211.ph';
    require 'net80211/ieee80211.ph';
    require 'net80211/ieee80211_crypto.ph';
    require 'net80211/ieee80211_ioctl.ph';
    require 'net80211/ieee80211_node.ph';
    require 'net80211/ieee80211_proto.ph';
    eval 'sub IEEE80211_TXPOWER_MAX () {100;}' unless defined(&IEEE80211_TXPOWER_MAX);
    eval 'sub IEEE80211_TXPOWER_MIN () {0;}' unless defined(&IEEE80211_TXPOWER_MIN);
    eval 'sub IEEE80211_DTIM_MAX () {15;}' unless defined(&IEEE80211_DTIM_MAX);
    eval 'sub IEEE80211_DTIM_MIN () {1;}' unless defined(&IEEE80211_DTIM_MIN);
    eval 'sub IEEE80211_DTIM_DEFAULT () {1;}' unless defined(&IEEE80211_DTIM_DEFAULT);
    eval 'sub IEEE80211_BINTVAL_MAX () {1000;}' unless defined(&IEEE80211_BINTVAL_MAX);
    eval 'sub IEEE80211_BINTVAL_MIN () {25;}' unless defined(&IEEE80211_BINTVAL_MIN);
    eval 'sub IEEE80211_BINTVAL_DEFAULT () {100;}' unless defined(&IEEE80211_BINTVAL_DEFAULT);
    eval 'sub IEEE80211_BMISS_MAX () {2;}' unless defined(&IEEE80211_BMISS_MAX);
    eval 'sub IEEE80211_PS_SLEEP () {0x1;}' unless defined(&IEEE80211_PS_SLEEP);
    eval 'sub IEEE80211_PS_MAX_QUEUE () {50;}' unless defined(&IEEE80211_PS_MAX_QUEUE);
    eval 'sub IEEE80211_FIXED_RATE_NONE () {-1;}' unless defined(&IEEE80211_FIXED_RATE_NONE);
    eval 'sub IEEE80211_MCAST_RATE_DEFAULT () {(2*1);}' unless defined(&IEEE80211_MCAST_RATE_DEFAULT);
    eval 'sub IEEE80211_RTS_DEFAULT () { &IEEE80211_RTS_MAX;}' unless defined(&IEEE80211_RTS_DEFAULT);
    eval 'sub IEEE80211_FRAG_DEFAULT () { &IEEE80211_FRAG_MAX;}' unless defined(&IEEE80211_FRAG_DEFAULT);
    eval 'sub IEEE80211_MS_TO_TU {
        my($x) = @_;
	    eval q(((($x) * 1000) / 1024));
    }' unless defined(&IEEE80211_MS_TO_TU);
    eval 'sub IEEE80211_TU_TO_MS {
        my($x) = @_;
	    eval q(((($x) * 1024) / 1000));
    }' unless defined(&IEEE80211_TU_TO_MS);
    eval 'sub IEEE80211_PS_SLEEP () {0x1;}' unless defined(&IEEE80211_PS_SLEEP);
    eval 'sub IEEE80211_PS_MAX_QUEUE () {50;}' unless defined(&IEEE80211_PS_MAX_QUEUE);
    eval 'sub ic_nw_keys () { ($ic_crypto->{cs_nw_keys});}' unless defined(&ic_nw_keys);
    eval 'sub ic_def_txkey () { ($ic_crypto->{cs_def_txkey});}' unless defined(&ic_def_txkey);
    eval 'sub IEEE80211_ADDR_EQ {
        my($a1,$a2) = @_;
	    eval q(( &memcmp($a1,$a2, &IEEE80211_ADDR_LEN) == 0));
    }' unless defined(&IEEE80211_ADDR_EQ);
    eval 'sub IEEE80211_ADDR_COPY {
        my($dst,$src) = @_;
	    eval q( &memcpy($dst,$src, &IEEE80211_ADDR_LEN));
    }' unless defined(&IEEE80211_ADDR_COPY);
    eval 'sub IEEE80211_F_FF () {0x1;}' unless defined(&IEEE80211_F_FF);
    eval 'sub IEEE80211_F_TURBOP () {0x2;}' unless defined(&IEEE80211_F_TURBOP);
    eval 'sub IEEE80211_F_PRIVACY () {0x10;}' unless defined(&IEEE80211_F_PRIVACY);
    eval 'sub IEEE80211_F_PUREG () {0x20;}' unless defined(&IEEE80211_F_PUREG);
    eval 'sub IEEE80211_F_SCAN () {0x80;}' unless defined(&IEEE80211_F_SCAN);
    eval 'sub IEEE80211_F_ASCAN () {0x100;}' unless defined(&IEEE80211_F_ASCAN);
    eval 'sub IEEE80211_F_SIBSS () {0x200;}' unless defined(&IEEE80211_F_SIBSS);
    eval 'sub IEEE80211_F_SHSLOT () {0x400;}' unless defined(&IEEE80211_F_SHSLOT);
    eval 'sub IEEE80211_F_PMGTON () {0x800;}' unless defined(&IEEE80211_F_PMGTON);
    eval 'sub IEEE80211_F_DESBSSID () {0x1000;}' unless defined(&IEEE80211_F_DESBSSID);
    eval 'sub IEEE80211_F_WME () {0x2000;}' unless defined(&IEEE80211_F_WME);
    eval 'sub IEEE80211_F_BGSCAN () {0x4000;}' unless defined(&IEEE80211_F_BGSCAN);
    eval 'sub IEEE80211_F_SWRETRY () {0x8000;}' unless defined(&IEEE80211_F_SWRETRY);
    eval 'sub IEEE80211_F_TXPOW_FIXED () {0x10000;}' unless defined(&IEEE80211_F_TXPOW_FIXED);
    eval 'sub IEEE80211_F_IBSSON () {0x20000;}' unless defined(&IEEE80211_F_IBSSON);
    eval 'sub IEEE80211_F_SHPREAMBLE () {0x40000;}' unless defined(&IEEE80211_F_SHPREAMBLE);
    eval 'sub IEEE80211_F_DATAPAD () {0x80000;}' unless defined(&IEEE80211_F_DATAPAD);
    eval 'sub IEEE80211_F_USEPROT () {0x100000;}' unless defined(&IEEE80211_F_USEPROT);
    eval 'sub IEEE80211_F_USEBARKER () {0x200000;}' unless defined(&IEEE80211_F_USEBARKER);
    eval 'sub IEEE80211_F_TIMUPDATE () {0x400000;}' unless defined(&IEEE80211_F_TIMUPDATE);
    eval 'sub IEEE80211_F_WPA1 () {0x800000;}' unless defined(&IEEE80211_F_WPA1);
    eval 'sub IEEE80211_F_WPA2 () {0x1000000;}' unless defined(&IEEE80211_F_WPA2);
    eval 'sub IEEE80211_F_WPA () {0x1800000;}' unless defined(&IEEE80211_F_WPA);
    eval 'sub IEEE80211_F_DROPUNENC () {0x2000000;}' unless defined(&IEEE80211_F_DROPUNENC);
    eval 'sub IEEE80211_F_COUNTERM () {0x4000000;}' unless defined(&IEEE80211_F_COUNTERM);
    eval 'sub IEEE80211_F_HIDESSID () {0x8000000;}' unless defined(&IEEE80211_F_HIDESSID);
    eval 'sub IEEE80211_F_NOBRIDGE () {0x10000000;}' unless defined(&IEEE80211_F_NOBRIDGE);
    eval 'sub IEEE80211_F_WMEUPDATE () {0x20000000;}' unless defined(&IEEE80211_F_WMEUPDATE);
    eval 'sub IEEE80211_FEXT_WDS () {0x1;}' unless defined(&IEEE80211_FEXT_WDS);
    eval 'sub IEEE80211_FEXT_BGSCAN () {0x8;}' unless defined(&IEEE80211_FEXT_BGSCAN);
    eval 'sub IEEE80211_FEXT_PROBECHAN () {0x20000;}' unless defined(&IEEE80211_FEXT_PROBECHAN);
    eval 'sub IEEE80211_C_WEP () {0x1;}' unless defined(&IEEE80211_C_WEP);
    eval 'sub IEEE80211_C_TKIP () {0x2;}' unless defined(&IEEE80211_C_TKIP);
    eval 'sub IEEE80211_C_AES () {0x4;}' unless defined(&IEEE80211_C_AES);
    eval 'sub IEEE80211_C_AES_CCM () {0x8;}' unless defined(&IEEE80211_C_AES_CCM);
    eval 'sub IEEE80211_C_CKIP () {0x20;}' unless defined(&IEEE80211_C_CKIP);
    eval 'sub IEEE80211_C_FF () {0x40;}' unless defined(&IEEE80211_C_FF);
    eval 'sub IEEE80211_C_TURBOP () {0x80;}' unless defined(&IEEE80211_C_TURBOP);
    eval 'sub IEEE80211_C_IBSS () {0x100;}' unless defined(&IEEE80211_C_IBSS);
    eval 'sub IEEE80211_C_PMGT () {0x200;}' unless defined(&IEEE80211_C_PMGT);
    eval 'sub IEEE80211_C_HOSTAP () {0x400;}' unless defined(&IEEE80211_C_HOSTAP);
    eval 'sub IEEE80211_C_AHDEMO () {0x800;}' unless defined(&IEEE80211_C_AHDEMO);
    eval 'sub IEEE80211_C_SWRETRY () {0x1000;}' unless defined(&IEEE80211_C_SWRETRY);
    eval 'sub IEEE80211_C_TXPMGT () {0x2000;}' unless defined(&IEEE80211_C_TXPMGT);
    eval 'sub IEEE80211_C_SHSLOT () {0x4000;}' unless defined(&IEEE80211_C_SHSLOT);
    eval 'sub IEEE80211_C_SHPREAMBLE () {0x8000;}' unless defined(&IEEE80211_C_SHPREAMBLE);
    eval 'sub IEEE80211_C_MONITOR () {0x10000;}' unless defined(&IEEE80211_C_MONITOR);
    eval 'sub IEEE80211_C_TKIPMIC () {0x20000;}' unless defined(&IEEE80211_C_TKIPMIC);
    eval 'sub IEEE80211_C_WME_TKIPMIC () {0x40000;}' unless defined(&IEEE80211_C_WME_TKIPMIC);
    eval 'sub IEEE80211_C_WPA1 () {0x800000;}' unless defined(&IEEE80211_C_WPA1);
    eval 'sub IEEE80211_C_WPA2 () {0x1000000;}' unless defined(&IEEE80211_C_WPA2);
    eval 'sub IEEE80211_C_WPA () {0x1800000;}' unless defined(&IEEE80211_C_WPA);
    eval 'sub IEEE80211_C_BURST () {0x2000000;}' unless defined(&IEEE80211_C_BURST);
    eval 'sub IEEE80211_C_WME () {0x4000000;}' unless defined(&IEEE80211_C_WME);
    eval 'sub IEEE80211_C_WDS () {0x8000000;}' unless defined(&IEEE80211_C_WDS);
    eval 'sub IEEE80211_C_BGSCAN () {0x20000000;}' unless defined(&IEEE80211_C_BGSCAN);
    eval 'sub IEEE80211_C_TXFRAG () {0x40000000;}' unless defined(&IEEE80211_C_TXFRAG);
    eval 'sub IEEE80211_C_CRYPTO () {0x2f;}' unless defined(&IEEE80211_C_CRYPTO);
    eval 'sub ieee80211_key_update_end {
        my($ic) = @_;
	    eval q({  ($ic->{ic_crypto}->{cs_key_update_end})($ic); });
    }' unless defined(&ieee80211_key_update_end);
    eval 'sub IEEE80211_MSG_DEBUG () {0x40000000;}' unless defined(&IEEE80211_MSG_DEBUG);
    eval 'sub IEEE80211_MSG_DUMPPKTS () {0x20000000;}' unless defined(&IEEE80211_MSG_DUMPPKTS);
    eval 'sub IEEE80211_MSG_CRYPTO () {0x10000000;}' unless defined(&IEEE80211_MSG_CRYPTO);
    eval 'sub IEEE80211_MSG_INPUT () {0x8000000;}' unless defined(&IEEE80211_MSG_INPUT);
    eval 'sub IEEE80211_MSG_XRATE () {0x4000000;}' unless defined(&IEEE80211_MSG_XRATE);
    eval 'sub IEEE80211_MSG_ELEMID () {0x2000000;}' unless defined(&IEEE80211_MSG_ELEMID);
    eval 'sub IEEE80211_MSG_NODE () {0x1000000;}' unless defined(&IEEE80211_MSG_NODE);
    eval 'sub IEEE80211_MSG_ASSOC () {0x800000;}' unless defined(&IEEE80211_MSG_ASSOC);
    eval 'sub IEEE80211_MSG_AUTH () {0x400000;}' unless defined(&IEEE80211_MSG_AUTH);
    eval 'sub IEEE80211_MSG_SCAN () {0x200000;}' unless defined(&IEEE80211_MSG_SCAN);
    eval 'sub IEEE80211_MSG_OUTPUT () {0x100000;}' unless defined(&IEEE80211_MSG_OUTPUT);
    eval 'sub IEEE80211_MSG_STATE () {0x80000;}' unless defined(&IEEE80211_MSG_STATE);
    eval 'sub IEEE80211_MSG_POWER () {0x40000;}' unless defined(&IEEE80211_MSG_POWER);
    eval 'sub IEEE80211_MSG_DOT1X () {0x20000;}' unless defined(&IEEE80211_MSG_DOT1X);
    eval 'sub IEEE80211_MSG_DOT1XSM () {0x10000;}' unless defined(&IEEE80211_MSG_DOT1XSM);
    eval 'sub IEEE80211_MSG_RADIUS () {0x8000;}' unless defined(&IEEE80211_MSG_RADIUS);
    eval 'sub IEEE80211_MSG_RADDUMP () {0x4000;}' unless defined(&IEEE80211_MSG_RADDUMP);
    eval 'sub IEEE80211_MSG_RADKEYS () {0x2000;}' unless defined(&IEEE80211_MSG_RADKEYS);
    eval 'sub IEEE80211_MSG_WPA () {0x1000;}' unless defined(&IEEE80211_MSG_WPA);
    eval 'sub IEEE80211_MSG_ACL () {0x800;}' unless defined(&IEEE80211_MSG_ACL);
    eval 'sub IEEE80211_MSG_WME () {0x400;}' unless defined(&IEEE80211_MSG_WME);
    eval 'sub IEEE80211_MSG_SUPERG () {0x200;}' unless defined(&IEEE80211_MSG_SUPERG);
    eval 'sub IEEE80211_MSG_DOTH () {0x100;}' unless defined(&IEEE80211_MSG_DOTH);
    eval 'sub IEEE80211_MSG_INACT () {0x80;}' unless defined(&IEEE80211_MSG_INACT);
    eval 'sub IEEE80211_MSG_ROAM () {0x40;}' unless defined(&IEEE80211_MSG_ROAM);
    eval 'sub IEEE80211_MSG_ANY () {0xffffffff;}' unless defined(&IEEE80211_MSG_ANY);
    if(defined(&IEEE80211_DEBUG)) {
	eval 'sub ieee80211_msg {
	    my($_ic, $_m) = @_;
    	    eval q((($_ic)-> &ic_debug & ($_m)));
	}' unless defined(&ieee80211_msg);
	eval 'sub IEEE80211_DPRINTF () {( &_ic,  &_m,  &_fmt, ...)  &do {  &if ( &ieee80211_msg( &_ic,  &_m))  &ieee80211_note( &_ic,  &_fmt,  &__VA_ARGS__); }  &while (0);}' unless defined(&IEEE80211_DPRINTF);
	eval 'sub IEEE80211_NOTE () {( &_ic,  &_m,  &_ni,  &_fmt, ...)  &do {  &if ( &ieee80211_msg( &_ic,  &_m))  &ieee80211_note_mac( &_ic, ( &_ni)-> &ni_macaddr,  &_fmt,  &__VA_ARGS__);}  &while (0);}' unless defined(&IEEE80211_NOTE);
	eval 'sub IEEE80211_NOTE_MAC () {( &_ic,  &_m,  &_mac,  &_fmt, ...)  &do {  &if ( &ieee80211_msg( &_ic,  &_m))  &ieee80211_note_mac( &_ic,  &_mac,  &_fmt,  &__VA_ARGS__); }  &while (0);}' unless defined(&IEEE80211_NOTE_MAC);
	eval 'sub ieee80211_msg_debug {
	    my($_ic) = @_;
    	    eval q((($_ic)-> &ic_debug &  &IEEE80211_MSG_DEBUG));
	}' unless defined(&ieee80211_msg_debug);
	eval 'sub ieee80211_msg_dumppkts {
	    my($_ic) = @_;
    	    eval q((($_ic)-> &ic_debug &  &IEEE80211_MSG_DUMPPKTS));
	}' unless defined(&ieee80211_msg_dumppkts);
	eval 'sub ieee80211_msg_input {
	    my($_ic) = @_;
    	    eval q((($_ic)-> &ic_debug &  &IEEE80211_MSG_INPUT));
	}' unless defined(&ieee80211_msg_input);
	eval 'sub ieee80211_msg_radius {
	    my($_ic) = @_;
    	    eval q((($_ic)-> &ic_debug &  &IEEE80211_MSG_RADIUS));
	}' unless defined(&ieee80211_msg_radius);
	eval 'sub ieee80211_msg_dumpradius {
	    my($_ic) = @_;
    	    eval q((($_ic)-> &ic_debug &  &IEEE80211_MSG_RADDUMP));
	}' unless defined(&ieee80211_msg_dumpradius);
	eval 'sub ieee80211_msg_dumpradkeys {
	    my($_ic) = @_;
    	    eval q((($_ic)-> &ic_debug &  &IEEE80211_MSG_RADKEYS));
	}' unless defined(&ieee80211_msg_dumpradkeys);
	eval 'sub ieee80211_msg_scan {
	    my($_ic) = @_;
    	    eval q((($_ic)-> &ic_debug &  &IEEE80211_MSG_SCAN));
	}' unless defined(&ieee80211_msg_scan);
	eval 'sub ieee80211_msg_assoc {
	    my($_ic) = @_;
    	    eval q((($_ic)-> &ic_debug &  &IEEE80211_MSG_ASSOC));
	}' unless defined(&ieee80211_msg_assoc);
    } else {
	eval 'sub IEEE80211_DPRINTF () {( &_ic,  &_m,  &_fmt, ...);}' unless defined(&IEEE80211_DPRINTF);
	eval 'sub IEEE80211_NOTE () {( &_ic,  &_m,  &_ni,  &_fmt, ...);}' unless defined(&IEEE80211_NOTE);
	eval 'sub IEEE80211_NOTE_MAC () {( &_ic,  &_m,  &_mac,  &_fmt, ...);}' unless defined(&IEEE80211_NOTE_MAC);
	eval 'sub ieee80211_msg_dumppkts {
	    my($_ic) = @_;
    	    eval q(0);
	}' unless defined(&ieee80211_msg_dumppkts);
	eval 'sub ieee80211_msg {
	    my($_ic, $_m) = @_;
    	    eval q(0);
	}' unless defined(&ieee80211_msg);
    }
}
1;
