require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NETINET_IP_COMPAT_H_)) {
    eval 'sub _NETINET_IP_COMPAT_H_ () {1;}' unless defined(&_NETINET_IP_COMPAT_H_);
    unless(defined(&__STDC__)) {
	undef(&const) if defined(&const);
	eval 'sub const () {1;}' unless defined(&const);
    }
    if(defined(&_KERNEL) || defined(&KERNEL) || defined(&__KERNEL__)) {
	undef(&KERNEL) if defined(&KERNEL);
	undef(&_KERNEL) if defined(&_KERNEL);
	undef(&__KERNEL__) if defined(&__KERNEL__);
	eval 'sub KERNEL () {1;}' unless defined(&KERNEL);
	eval 'sub _KERNEL () {1;}' unless defined(&_KERNEL);
	eval 'sub __KERNEL__ () {1;}' unless defined(&__KERNEL__);
    }
    if((defined(&sun)  && (defined(&__svr4__) || defined(&__SVR4)))) {
	eval 'sub SOLARIS () {1;}' unless defined(&SOLARIS);
    } else {
	eval 'sub SOLARIS () {0;}' unless defined(&SOLARIS);
    }
    if((defined(&SOLARIS2)  && ((defined(&SOLARIS2) ? &SOLARIS2 : undef) >= 8))) {
	unless(defined(&USE_INET6)) {
	    eval 'sub USE_INET6 () {1;}' unless defined(&USE_INET6);
	}
    }
    if(defined(&__FreeBSD_version)  && ((defined(&__FreeBSD_version) ? &__FreeBSD_version : undef) >= 400000)  && !defined(&_KERNEL)  && !defined(&USE_INET6)  && !defined(&NOINET6)) {
	eval 'sub USE_INET6 () {1;}' unless defined(&USE_INET6);
    }
    if(defined(&__NetBSD_Version__)  && ((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) >= 105000000)  && !defined(&_KERNEL)  && !defined(&USE_INET6)  && !defined(&NOINET6)) {
	eval 'sub USE_INET6 () {1;}' unless defined(&USE_INET6);
    }
    if(defined(&__NetBSD_Version__)  && ((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) >= 106140000)  && defined(&_KERNEL)  && (!defined(&IPFILTER_LKM) || ((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) >= 399000100))) {
	eval 'sub IPFILTER_M_IPFILTER () {1;}' unless defined(&IPFILTER_M_IPFILTER);
    }
    if(!defined(&USE_INET6)) {
	if(defined(&OpenBSD)  && ((defined(&OpenBSD) ? &OpenBSD : undef) >= 200206)  && !defined(&_KERNEL)  && !defined(&USE_INET6)) {
	    eval 'sub USE_INET6 () {1;}' unless defined(&USE_INET6);
	}
	if(defined(&__osf__)) {
	    eval 'sub USE_INET6 () {1;}' unless defined(&USE_INET6);
	}
	if(defined(&linux)  && (!defined(&_KERNEL) || defined(&CONFIG_IPV6))) {
	    eval 'sub USE_INET6 () {1;}' unless defined(&USE_INET6);
	}
	if(defined(&HPUXREV)  && ((defined(&HPUXREV) ? &HPUXREV : undef) >= 1111)) {
	    eval 'sub USE_INET6 () {1;}' unless defined(&USE_INET6);
	}
    }
    if(defined(&BSD)  && ((defined(&BSD) ? &BSD : undef) < 199103)  && defined(&__osf__)) {
	undef(&BSD) if defined(&BSD);
	eval 'sub BSD () {199103;}' unless defined(&BSD);
    }
    if(defined(&__SVR4) || defined(&__svr4__) || defined(&__sgi)) {
	eval 'sub index () { &strchr;}' unless defined(&index);
	if(!defined(&_KERNEL)) {
	    eval 'sub bzero {
	        my($a,$b) = @_;
    		eval q( &memset($a,0,$b));
	    }' unless defined(&bzero);
	    eval 'sub bcmp () { &memcmp;}' unless defined(&bcmp);
	    eval 'sub bcopy {
	        my($a,$b,$c) = @_;
    		eval q( &memmove($b,$a,$c));
	    }' unless defined(&bcopy);
	}
    }
    unless(defined(&LIFNAMSIZ)) {
	if(defined(&IF_NAMESIZE)) {
	    eval 'sub LIFNAMSIZ () { &IF_NAMESIZE;}' unless defined(&LIFNAMSIZ);
	} else {
	    if(defined(&IFNAMSIZ)) {
		eval 'sub LIFNAMSIZ () { &IFNAMSIZ;}' unless defined(&LIFNAMSIZ);
	    } else {
		eval 'sub LIFNAMSIZ () {16;}' unless defined(&LIFNAMSIZ);
	    }
	}
    }
    if(defined(&__sgi) || defined(&bsdi) || defined(&__hpux) || defined(&hpux)) {
    }
    if(defined(&__sgi)  && !defined(&IPFILTER_LKM)) {
	if(defined(&__STDC__)) {
	    eval 'sub IPL_EXTERN {
	        my($ep) = @_;
    		eval q( &ipfilter$ep);
	    }' unless defined(&IPL_EXTERN);
	} else {
	    eval 'sub IPL_EXTERN {
	        my($ep) = @_;
    		eval q( &ipfilter $ep);
	    }' unless defined(&IPL_EXTERN);
	}
    } else {
	if(defined(&__STDC__)) {
	    eval 'sub IPL_EXTERN {
	        my($ep) = @_;
    		eval q( &ipl$ep);
	    }' unless defined(&IPL_EXTERN);
	} else {
	    eval 'sub IPL_EXTERN {
	        my($ep) = @_;
    		eval q( &ipl $ep);
	    }' unless defined(&IPL_EXTERN);
	}
    }
    unless(defined(&linux)) {
	unless(defined(&_KERNEL)) {
	    eval 'sub ADD_KERNEL () {1;}' unless defined(&ADD_KERNEL);
	    eval 'sub _KERNEL () {1;}' unless defined(&_KERNEL);
	    eval 'sub KERNEL () {1;}' unless defined(&KERNEL);
	}
	if(defined(&__OpenBSD__)) {
	}
	require 'sys/uio.ph';
	if(defined(&ADD_KERNEL)) {
	    undef(&_KERNEL) if defined(&_KERNEL);
	    undef(&KERNEL) if defined(&KERNEL);
	}
    }
    eval 'sub NETBSD_GE_REV {
        my($x) = @_;
	    eval q(( &__NetBSD_Version__ >= ($x)));
    }' unless defined(&NETBSD_GE_REV);
    eval 'sub NETBSD_GT_REV {
        my($x) = @_;
	    eval q(( &__NetBSD_Version__ > ($x)));
    }' unless defined(&NETBSD_GT_REV);
    eval 'sub NETBSD_LT_REV {
        my($x) = @_;
	    eval q(( &__NetBSD_Version__ < ($x)));
    }' unless defined(&NETBSD_LT_REV);
    eval 'sub FREEBSD_GE_REV {
        my($x) = @_;
	    eval q(0);
    }' unless defined(&FREEBSD_GE_REV);
    eval 'sub FREEBSD_GT_REV {
        my($x) = @_;
	    eval q(0);
    }' unless defined(&FREEBSD_GT_REV);
    eval 'sub FREEBSD_LT_REV {
        my($x) = @_;
	    eval q(0);
    }' unless defined(&FREEBSD_LT_REV);
    eval 'sub BSDOS_GE_REV {
        my($x) = @_;
	    eval q(0);
    }' unless defined(&BSDOS_GE_REV);
    eval 'sub BSDOS_GT_REV {
        my($x) = @_;
	    eval q(0);
    }' unless defined(&BSDOS_GT_REV);
    eval 'sub BSDOS_LT_REV {
        my($x) = @_;
	    eval q(0);
    }' unless defined(&BSDOS_LT_REV);
    eval 'sub OPENBSD_GE_REV {
        my($x) = @_;
	    eval q(0);
    }' unless defined(&OPENBSD_GE_REV);
    eval 'sub OPENBSD_GT_REV {
        my($x) = @_;
	    eval q(0);
    }' unless defined(&OPENBSD_GT_REV);
    eval 'sub OPENBSD_LT_REV {
        my($x) = @_;
	    eval q(0);
    }' unless defined(&OPENBSD_LT_REV);
    eval 'sub BSD_GE_YEAR {
        my($x) = @_;
	    eval q(( &BSD >= ($x)));
    }' unless defined(&BSD_GE_YEAR);
    eval 'sub BSD_GT_YEAR {
        my($x) = @_;
	    eval q(( &BSD > ($x)));
    }' unless defined(&BSD_GT_YEAR);
    eval 'sub BSD_LT_YEAR {
        my($x) = @_;
	    eval q(( &BSD < ($x)));
    }' unless defined(&BSD_LT_YEAR);
    if(defined(&__NetBSD__)) {
	eval 'sub HAS_SYS_MD5_H () {1;}' unless defined(&HAS_SYS_MD5_H);
	if(((defined(&NetBSD) ? &NetBSD : undef) >= 199905)  && !defined(&IPFILTER_LKM)  && defined(&_KERNEL)) {
	    if(((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) < 399001400)) {
		require './netinet/opt_ipfilter_log.ph';
	    } else {
		if(((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) >= 799003000)) {
		    if(defined(&_KERNEL_OPT)) {
			require './netinet/opt_ipfilter.ph';
		    }
		} else {
		    require './netinet/opt_ipfilter.ph';
		}
	    }
	}
	if(defined(&_KERNEL)) {
	    require 'sys/systm.ph';
	    require 'sys/malloc.ph';
	    if(((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) > 500000000)) {
		require 'sys/kauth.ph';
	    }
	} else {
	    require 'stddef.ph';
	    require 'stdbool.ph';
	}
	if(defined(&_KERNEL)  && !defined(&IPFILTER_LKM)) {
	    if(defined(&__NetBSD_Version__)  && ((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) >= 599002300)) {
		eval 'sub NBPFILTER () {1;}' unless defined(&NBPFILTER);
	    } else {
		require './netinet/bpfilter.ph';
	    }
	    if(defined(&__NetBSD_Version__)  && ((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) >= 104110000)) {
		if(((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) >= 799003000)) {
		    if(defined(&_KERNEL_OPT)) {
			require './netinet/opt_inet.ph';
		    }
		} else {
		    require './netinet/opt_inet.ph';
		}
	    }
	    if(defined(&INET6)) {
		eval 'sub USE_INET6 () {1;}' unless defined(&USE_INET6);
	    }
	    if(((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) >= 105000000)) {
		eval 'sub HAVE_M_PULLDOWN () {1;}' unless defined(&HAVE_M_PULLDOWN);
	    }
	}
	unless(defined(&_KERNEL)) {
	    eval 'sub ipf_random () { &arc4random;}' unless defined(&ipf_random);
	}
	if(((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) >= 499000000)) {
	    if(defined(&_KERNEL)) {
		require 'sys/rwlock.ph';
		eval 'sub USE_MUTEXES () {1;}' unless defined(&USE_MUTEXES);
		eval 'sub KMUTEX_T () { &kmutex_t;}' unless defined(&KMUTEX_T);
		eval 'sub KRWLOCK_T () { &krwlock_t;}' unless defined(&KRWLOCK_T);
		eval 'sub MUTEX_DESTROY {
		    my($x) = @_;
    		    eval q( &mutex_destroy(($x)-> &ipf_lk));
		}' unless defined(&MUTEX_DESTROY);
		eval 'sub MUTEX_DOWNGRADE {
		    my($x) = @_;
    		    eval q( &rw_downgrade(($x)-> &ipf_lk));
		}' unless defined(&MUTEX_DOWNGRADE);
		eval 'sub MUTEX_ENTER {
		    my($x) = @_;
    		    eval q( &mutex_enter(($x)-> &ipf_lk));
		}' unless defined(&MUTEX_ENTER);
		eval 'sub MUTEX_EXIT {
		    my($x) = @_;
    		    eval q( &mutex_exit(($x)-> &ipf_lk));
		}' unless defined(&MUTEX_EXIT);
		eval 'sub MUTEX_INIT {
		    my($x,$y) = @_;
    		    eval q( &mutex_init(($x)-> &ipf_lk,  &MUTEX_DRIVER,  &IPL_SOFTNET));
		}' unless defined(&MUTEX_INIT);
		eval 'sub MUTEX_NUKE {
		    my($x) = @_;
    		    eval q( &bzero(($x), $sizeof{($x)}));
		}' unless defined(&MUTEX_NUKE);
		eval 'sub READ_ENTER {
		    my($x) = @_;
    		    eval q( &rw_enter(($x)-> &ipf_lk,  &RW_READER));
		}' unless defined(&READ_ENTER);
		eval 'sub RWLOCK_INIT {
		    my($x, $y) = @_;
    		    eval q( &rw_init(($x)-> &ipf_lk));
		}' unless defined(&RWLOCK_INIT);
		eval 'sub RWLOCK_EXIT {
		    my($x) = @_;
    		    eval q( &rw_exit(($x)-> &ipf_lk));
		}' unless defined(&RWLOCK_EXIT);
		eval 'sub RW_DESTROY {
		    my($x) = @_;
    		    eval q( &rw_destroy(($x)-> &ipf_lk));
		}' unless defined(&RW_DESTROY);
		eval 'sub WRITE_ENTER {
		    my($x) = @_;
    		    eval q( &rw_enter(($x)-> &ipf_lk,  &RW_WRITER));
		}' unless defined(&WRITE_ENTER);
		eval 'sub SPL_SCHED {
		    my($x) = @_;
    		    eval q(;);
		}' unless defined(&SPL_SCHED);
		eval 'sub SPL_NET {
		    my($x) = @_;
    		    eval q(;);
		}' unless defined(&SPL_NET);
		eval 'sub SPL_IMP {
		    my($x) = @_;
    		    eval q(;);
		}' unless defined(&SPL_IMP);
		eval 'sub SPL_X {
		    my($x) = @_;
    		    eval q(;);
		}' unless defined(&SPL_X);
	    }
	}
	if(((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) >= 699000000)) {
	    eval 'sub HAVE_RBTREE () {1;}' unless defined(&HAVE_RBTREE);
	}
	if(defined(&_KERNEL)) {
	    require 'sys/cprng.ph';
	    if(((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) >= 399001400)) {
		require 'sys/selinfo.ph';
		eval 'sub PROC_T () {\'struct lwp\';}' unless defined(&PROC_T);
		eval 'sub KFREE {
		    my($a) = @_;
    		    eval q( &free(($a),  &_M_IPF));
		}' unless defined(&KFREE);
		eval 'sub KFREES {
		    my($a, $b) = @_;
    		    eval q( &free(($a),  &_M_IPF));
		}' unless defined(&KFREES);
		eval 'sub KMALLOC {
		    my($a, $b) = @_;
    		    eval q(($a) = ($b) &malloc($sizeof{($a)},  &_M_IPF,  &M_NOWAIT));
		}' unless defined(&KMALLOC);
		eval 'sub KMALLOCS {
		    my($a, $b, $c) = @_;
    		    eval q(($a) = ($b) &malloc(($c),  &_M_IPF,  &M_NOWAIT));
		}' unless defined(&KMALLOCS);
	    } else {
		eval 'sub PROC_T () {\'struct proc\';}' unless defined(&PROC_T);
	    }
	    eval 'sub MSGDSIZE {
	        my($m) = @_;
    		eval q( &mbufchainlen($m));
	    }' unless defined(&MSGDSIZE);
	    eval 'sub M_LEN {
	        my($m) = @_;
    		eval q(($m)-> &m_len);
	    }' unless defined(&M_LEN);
	    eval 'sub M_ADJ {
	        my($m,$x) = @_;
    		eval q( &m_adj($m, $x));
	    }' unless defined(&M_ADJ);
	    eval 'sub M_COPY {
	        my($x) = @_;
    		eval q( &m_copym(($x), 0,  &M_COPYALL,  &M_DONTWAIT));
	    }' unless defined(&M_COPY);
	    eval 'sub GETKTIME {
	        my($x) = @_;
    		eval q( &microtime($x));
	    }' unless defined(&GETKTIME);
	    eval 'sub IPF_PANIC {
	        my($x,$y) = @_;
    		eval q( &if ($x) {  &printf $y;  &panic(\\"ipf_panic\\"); });
	    }' unless defined(&IPF_PANIC);
	    eval 'sub COPYIN {
	        my($a,$b,$c) = @_;
    		eval q( &copyin(( &void *)($a), ( &void *)($b), ($c)));
	    }' unless defined(&COPYIN);
	    eval 'sub COPYOUT {
	        my($a,$b,$c) = @_;
    		eval q( &copyout(( &void *)($a), ( &void *)($b), ($c)));
	    }' unless defined(&COPYOUT);
	    eval 'sub BCOPYIN {
	        my($a,$b,$c) = @_;
    		eval q(( &bcopy(( &void *)($a), ( &void *)($b), ($c)), 0));
	    }' unless defined(&BCOPYIN);
	    eval 'sub BCOPYOUT {
	        my($a,$b,$c) = @_;
    		eval q(( &bcopy(( &void *)($a), ( &void *)($b), ($c)), 0));
	    }' unless defined(&BCOPYOUT);
	    if((defined(&__NetBSD_Version__)  && ((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) >= 499004900))) {
		eval 'sub POLLWAKEUP {
		    my($x) = @_;
    		    eval q( &selnotify( ($softc->{ipf_selwait})+$x, 0, 0));
		}' unless defined(&POLLWAKEUP);
	    }
	    eval 'sub ASSERT {
	        my($x) = @_;
    		eval q( &KASSERT($x));
	    }' unless defined(&ASSERT);
	}
	if(((defined(&NetBSD) ? &NetBSD : undef) <= 1991011)  && ((defined(&NetBSD) ? &NetBSD : undef) >= 199606)) {
	    eval 'sub IFNAME {
	        my($x) = @_;
    		eval q(($x)-> &if_xname);
	    }' unless defined(&IFNAME);
	    eval 'sub COPYIFNAME {
	        my($v, $x, $b) = @_;
    		eval q(( &void)  &strncpy($b, ($x)-> &if_xname,  &LIFNAMSIZ));
	    }' unless defined(&COPYIFNAME);
	} else {
	    eval 'sub IFNAME {
	        my($x) = @_;
    		eval q(($x)-> &if_name);
	    }' unless defined(&IFNAME);
	}
	eval 'sub U_32_T () {1;}' unless defined(&U_32_T);
	eval 'sub OS_RECOGNISED () {1;}' unless defined(&OS_RECOGNISED);
    }
    if(!defined(&IPFILTER_BPF)) {
	if((defined(&NBPF)  && ((defined(&NBPF) ? &NBPF : undef) > 0)) || (defined(&DEV_BPF)  && ((defined(&DEV_BPF) ? &DEV_BPF : undef) > 0)) || (defined(&NBPFILTER)  && ((defined(&NBPFILTER) ? &NBPFILTER : undef) > 0))) {
	    eval 'sub IPFILTER_BPF () {1;}' unless defined(&IPFILTER_BPF);
	}
    }
    if(!defined(&KMUTEX_FILL_SZ)) {
	eval 'sub KMUTEX_FILL_SZ () {1;}' unless defined(&KMUTEX_FILL_SZ);
    }
    if(!defined(&KRWLOCK_FILL_SZ)) {
	eval 'sub KRWLOCK_FILL_SZ () {1;}' unless defined(&KRWLOCK_FILL_SZ);
    }
    if(defined(&KMUTEX_T)) {
    }
    if(defined(&KRWLOCK_T)) {
    }
    eval 'sub ipf_lk () { ($ipf_lkun_s->{ipf_slk});}' unless defined(&ipf_lk);
    eval 'sub ipf_lname () { ($ipf_lkun_s->{ipf_lname});}' unless defined(&ipf_lname);
    eval 'sub ipf_isr () { ($ipf_lkun_s->{ipf_sr});}' unless defined(&ipf_isr);
    eval 'sub ipf_isw () { ($ipf_lkun_s->{ipf_sw});}' unless defined(&ipf_isw);
    eval 'sub ipf_magic () { ($ipf_lkun_s->{ipf_magic});}' unless defined(&ipf_magic);
    if(!defined(&__GNUC__) || (defined(&__FreeBSD_version)  && ((defined(&__FreeBSD_version) ? &__FreeBSD_version : undef) >= 503000))) {
	unless(defined(&INLINE)) {
	    eval 'sub INLINE () {1;}' unless defined(&INLINE);
	}
    } else {
	eval 'sub INLINE () { &__inline__;}' unless defined(&INLINE);
    }
    unless(defined(&EXTERN_INLINE)) {
	if(defined(&__GNUC__)  && !defined(&__GNUC_STDC_INLINE__)) {
	    eval 'sub EXTERN_INLINE () { &inline;}' unless defined(&EXTERN_INLINE);
	} else {
	    eval 'sub EXTERN_INLINE () { &extern  &inline;}' unless defined(&EXTERN_INLINE);
	}
    }
    if(defined(&linux)  && defined(&_KERNEL)) {
    }
    unless(defined(&_KERNEL)) {
	undef(&m_next) if defined(&m_next);
	eval 'sub m_next () { &mb_next;}' unless defined(&m_next);
	undef(&m_len) if defined(&m_len);
	eval 'sub m_len () { &mb_len;}' unless defined(&m_len);
	undef(&m_flags) if defined(&m_flags);
	eval 'sub m_flags () { &mb_flags;}' unless defined(&m_flags);
	undef(&m_data) if defined(&m_data);
	eval 'sub m_data () { &mb_data;}' unless defined(&m_data);
	undef(&M_MCAST) if defined(&M_MCAST);
	eval 'sub M_MCAST () {0x1;}' unless defined(&M_MCAST);
	undef(&M_BCAST) if defined(&M_BCAST);
	eval 'sub M_BCAST () {0x2;}' unless defined(&M_BCAST);
	undef(&M_MBCAST) if defined(&M_MBCAST);
	eval 'sub M_MBCAST () {0x4;}' unless defined(&M_MBCAST);
	eval 'sub MSGDSIZE {
	    my($m) = @_;
    	    eval q( &msgdsize($m));
	}' unless defined(&MSGDSIZE);
	eval 'sub M_LEN {
	    my($m) = @_;
    	    eval q(($m)-> &mb_len);
	}' unless defined(&M_LEN);
	eval 'sub M_ADJ {
	    my($m,$x) = @_;
    	    eval q(($m)-> &mb_len += $x);
	}' unless defined(&M_ADJ);
	eval 'sub M_COPY {
	    my($m) = @_;
    	    eval q( &dupmbt($m));
	}' unless defined(&M_COPY);
	eval 'sub M_DUP {
	    my($m) = @_;
    	    eval q( &dupmbt($m));
	}' unless defined(&M_DUP);
	eval 'sub GETKTIME {
	    my($x) = @_;
    	    eval q( &gettimeofday(($x),  &NULL));
	}' unless defined(&GETKTIME);
	eval 'sub MTOD {
	    my($m, $t) = @_;
    	    eval q((($t)($m)-> &mb_data));
	}' unless defined(&MTOD);
	eval 'sub FREE_MB_T {
	    my($m) = @_;
    	    eval q( &freembt($m));
	}' unless defined(&FREE_MB_T);
	eval 'sub ALLOC_MB_T {
	    my($m,$l) = @_;
    	    eval q(($m) =  &allocmbt($l));
	}' unless defined(&ALLOC_MB_T);
	eval 'sub PREP_MB_T {
	    my($f, $m) = @_;
    	    eval q( &do { ($m)-> &mb_next = *($f)-> &fin_mp; *( &fin)-> &fin_mp = ($m); ($f)-> &fin_m = ($m); }  &while (0));
	}' unless defined(&PREP_MB_T);
	eval 'sub SLEEP {
	    my($x,$y) = @_;
    	    eval q(1;);
	}' unless defined(&SLEEP);
	eval 'sub WAKEUP {
	    my($x,$y) = @_;
    	    eval q(;);
	}' unless defined(&WAKEUP);
	eval 'sub POLLWAKEUP {
	    my($y) = @_;
    	    eval q(;);
	}' unless defined(&POLLWAKEUP);
	eval 'sub IPF_PANIC {
	    my($x,$y) = @_;
    	    eval q(;);
	}' unless defined(&IPF_PANIC);
	eval 'sub PANIC {
	    my($x,$y) = @_;
    	    eval q(;);
	}' unless defined(&PANIC);
	eval 'sub SPL_SCHED {
	    my($x) = @_;
    	    eval q(;);
	}' unless defined(&SPL_SCHED);
	eval 'sub SPL_NET {
	    my($x) = @_;
    	    eval q(;);
	}' unless defined(&SPL_NET);
	eval 'sub SPL_IMP {
	    my($x) = @_;
    	    eval q(;);
	}' unless defined(&SPL_IMP);
	eval 'sub SPL_X {
	    my($x) = @_;
    	    eval q(;);
	}' unless defined(&SPL_X);
	eval 'sub KMALLOC {
	    my($a,$b) = @_;
    	    eval q(($a) = ($b) &malloc($sizeof{$a}));
	}' unless defined(&KMALLOC);
	eval 'sub KMALLOCS {
	    my($a,$b,$c) = @_;
    	    eval q(($a) = ($b) &malloc($c));
	}' unless defined(&KMALLOCS);
	eval 'sub KFREE {
	    my($x) = @_;
    	    eval q( &free($x));
	}' unless defined(&KFREE);
	eval 'sub KFREES {
	    my($x,$s) = @_;
    	    eval q( &free($x));
	}' unless defined(&KFREES);
	eval 'sub GETIFP {
	    my($x, $v) = @_;
    	    eval q( &get_unit($x,$v));
	}' unless defined(&GETIFP);
	eval 'sub GETIFMTU_4 {
	    my($x) = @_;
    	    eval q(2048);
	}' unless defined(&GETIFMTU_4);
	eval 'sub GETIFMTU_6 {
	    my($x) = @_;
    	    eval q(2048);
	}' unless defined(&GETIFMTU_6);
	eval 'sub COPYIN {
	    my($a,$b,$c) = @_;
    	    eval q( &bcopywrap(($a), ($b), ($c)));
	}' unless defined(&COPYIN);
	eval 'sub COPYOUT {
	    my($a,$b,$c) = @_;
    	    eval q( &bcopywrap(($a), ($b), ($c)));
	}' unless defined(&COPYOUT);
	eval 'sub COPYDATA {
	    my($m, $o, $l, $b) = @_;
    	    eval q( &bcopy( &MTOD(( &mb_t *)$m, \'char\' *) + ($o), ($b), ($l)));
	}' unless defined(&COPYDATA);
	eval 'sub COPYBACK {
	    my($m, $o, $l, $b) = @_;
    	    eval q( &bcopy(($b),  &MTOD(( &mb_t *)$m, \'char\' *) + ($o), ($l)));
	}' unless defined(&COPYBACK);
	eval 'sub UIOMOVE {
	    my($a,$b,$c,$d) = @_;
    	    eval q( &ipfuiomove($a,$b,$c,$d));
	}' unless defined(&UIOMOVE);
	eval 'sub MUTEX_DESTROY {
	    my($x) = @_;
    	    eval q( &eMmutex_destroy(($x)-> &ipf_emu,  &__FILE__,  &__LINE__));
	}' unless defined(&MUTEX_DESTROY);
	eval 'sub MUTEX_ENTER {
	    my($x) = @_;
    	    eval q( &eMmutex_enter(($x)-> &ipf_emu,  &__FILE__,  &__LINE__));
	}' unless defined(&MUTEX_ENTER);
	eval 'sub MUTEX_EXIT {
	    my($x) = @_;
    	    eval q( &eMmutex_exit(($x)-> &ipf_emu,  &__FILE__,  &__LINE__));
	}' unless defined(&MUTEX_EXIT);
	eval 'sub MUTEX_INIT {
	    my($x,$y) = @_;
    	    eval q( &eMmutex_init(($x)-> &ipf_emu, $y,  &__FILE__,  &__LINE__));
	}' unless defined(&MUTEX_INIT);
	eval 'sub MUTEX_NUKE {
	    my($x) = @_;
    	    eval q( &bzero(($x), $sizeof{($x)}));
	}' unless defined(&MUTEX_NUKE);
	eval 'sub MUTEX_DOWNGRADE {
	    my($x) = @_;
    	    eval q( &eMrwlock_downgrade(($x)-> &ipf_emu,  &__FILE__,  &__LINE__));
	}' unless defined(&MUTEX_DOWNGRADE);
	eval 'sub READ_ENTER {
	    my($x) = @_;
    	    eval q( &eMrwlock_read_enter(($x)-> &ipf_emu,  &__FILE__,  &__LINE__));
	}' unless defined(&READ_ENTER);
	eval 'sub RWLOCK_INIT {
	    my($x, $y) = @_;
    	    eval q( &eMrwlock_init(($x)-> &ipf_emu, $y));
	}' unless defined(&RWLOCK_INIT);
	eval 'sub RWLOCK_EXIT {
	    my($x) = @_;
    	    eval q( &eMrwlock_exit(($x)-> &ipf_emu));
	}' unless defined(&RWLOCK_EXIT);
	eval 'sub RW_DESTROY {
	    my($x) = @_;
    	    eval q( &eMrwlock_destroy(($x)-> &ipf_emu));
	}' unless defined(&RW_DESTROY);
	eval 'sub WRITE_ENTER {
	    my($x) = @_;
    	    eval q( &eMrwlock_write_enter(($x)-> &ipf_emu,  &__FILE__,  &__LINE__));
	}' unless defined(&WRITE_ENTER);
	eval 'sub USE_MUTEXES () {1;}' unless defined(&USE_MUTEXES);
    }
    eval 'sub MAX_IPV4HDR () {((0xf << 2) + $sizeof{\'struct icmp\'} + $sizeof{ &ip_t} + 8);}' unless defined(&MAX_IPV4HDR);
    unless(defined(&IP_OFFMASK)) {
	eval 'sub IP_OFFMASK () {0x1fff;}' unless defined(&IP_OFFMASK);
    }
    if(!defined(&__amd64__)  &&  &BSD_GT_YEAR(199306)) {
	eval 'sub USE_QUAD_T () {1;}' unless defined(&USE_QUAD_T);
	eval 'sub U_QUAD_T () { &u_quad_t;}' unless defined(&U_QUAD_T);
	eval 'sub QUAD_T () { &quad_t;}' unless defined(&QUAD_T);
    } else {
	if(!defined(&U_QUAD_T)) {
	    eval 'sub U_QUAD_T () {\'u_long\';}' unless defined(&U_QUAD_T);
	    eval 'sub QUAD_T () {\'long\';}' unless defined(&QUAD_T);
	}
    }
    if(defined(&USE_INET6)) {
	if(defined(&__NetBSD__) || defined(&__OpenBSD__) || defined(&__FreeBSD__) || defined(&__osf__) || defined(&linux)) {
	    require 'netinet/ip6.ph';
	    require 'netinet/icmp6.ph';
	    if(!defined(&linux)) {
		if(defined(&_KERNEL)  && !defined(&__osf__)) {
		    require 'netinet6/ip6_var.ph';
		}
	    }
	}
    }
    unless(defined(&MAX)) {
	eval 'sub MAX {
	    my($a,$b) = @_;
    	    eval q(((($a) > ($b)) ? ($a) : ($b)));
	}' unless defined(&MAX);
    }
    if(defined(&_KERNEL)) {
	if(defined(&MENTAT)  && !defined(&INSTANCES)) {
	    eval 'sub COPYDATA () { &mb_copydata;}' unless defined(&COPYDATA);
	    eval 'sub COPYBACK () { &mb_copyback;}' unless defined(&COPYBACK);
	} else {
	    eval 'sub COPYDATA () { &m_copydata;}' unless defined(&COPYDATA);
	    eval 'sub COPYBACK () { &m_copyback;}' unless defined(&COPYBACK);
	}
	if( &BSD_GE_YEAR(199306) || defined(&__FreeBSD__)) {
	    if((defined(&__NetBSD_Version__)  && ((defined(&__NetBSD_Version__) ? &__NetBSD_Version__ : undef) < 105180000)) || defined(&__FreeBSD__) || (defined(&OpenBSD)  && ((defined(&OpenBSD) ? &OpenBSD : undef) < 200206)) || defined(&_BSDI_VERSION)) {
		require 'vm/vm.ph';
	    }
	    if(!defined(&__FreeBSD__) ||  &FREEBSD_GE_REV(300000)) {
		if( &NETBSD_GE_REV(105180000) ||  &OPENBSD_GE_REV(200111)) {
		} else {
		    require 'vm/vm_extern.ph';
		}
		require 'sys/proc.ph';
	    } else {
		require 'vm/vm_kern.ph';
	    }
	    if(defined(&IPFILTER_M_IPFILTER)) {
		require 'sys/malloc.ph';
		eval 'sub _M_IPF () { &M_IPFILTER;}' unless defined(&_M_IPF);
	    } else {
		if(defined(&M_PFIL)) {
		    eval 'sub _M_IPF () { &M_PFIL;}' unless defined(&_M_IPF);
		} else {
		    if(defined(&M_IPFILTER)) {
			eval 'sub _M_IPF () { &M_IPFILTER;}' unless defined(&_M_IPF);
		    } else {
			eval 'sub _M_IPF () { &M_TEMP;}' unless defined(&_M_IPF);
		    }
		}
	    }
	    if(!defined(&KMALLOC)) {
		eval 'sub KMALLOC {
		    my($a, $b) = @_;
    		    eval q(($a) = ($b) &malloc($sizeof{($a)},  &_M_IPF,  &M_NOWAIT));
		}' unless defined(&KMALLOC);
	    }
	    if(!defined(&KMALLOCS)) {
		eval 'sub KMALLOCS {
		    my($a, $b, $c) = @_;
    		    eval q(($a) = ($b) &malloc(($c),  &_M_IPF,  &M_NOWAIT));
		}' unless defined(&KMALLOCS);
	    }
	    if(!defined(&KFREE)) {
		eval 'sub KFREE {
		    my($x) = @_;
    		    eval q( &free(($x),  &_M_IPF));
		}' unless defined(&KFREE);
	    }
	    if(!defined(&KFREES)) {
		eval 'sub KFREES {
		    my($x,$s) = @_;
    		    eval q( &free(($x),  &_M_IPF));
		}' unless defined(&KFREES);
	    }
	    eval 'sub UIOMOVE {
	        my($a,$b,$c,$d) = @_;
    		eval q( &uiomove(( &void *)$a,$b,$d));
	    }' unless defined(&UIOMOVE);
	    eval 'sub SLEEP {
	        my($id, $n) = @_;
    		eval q( &tsleep(($id),  &PPAUSE| &PCATCH, $n, 0));
	    }' unless defined(&SLEEP);
	    eval 'sub WAKEUP {
	        my($id,$x) = @_;
    		eval q( &wakeup($id+$x));
	    }' unless defined(&WAKEUP);
	    if(!defined(&POLLWAKEUP)) {
		eval 'sub POLLWAKEUP {
		    my($x) = @_;
    		    eval q( &selwakeup( ($softc->{ipf_selwait})+$x));
		}' unless defined(&POLLWAKEUP);
	    }
	    eval 'sub GETIFP {
	        my($n, $v) = @_;
    		eval q( &ifunit($n));
	    }' unless defined(&GETIFP);
	    eval 'sub GETIFMTU_4 {
	        my($x) = @_;
    		eval q(($x)-> &if_mtu);
	    }' unless defined(&GETIFMTU_4);
	    eval 'sub GETIFMTU_6 {
	        my($x) = @_;
    		eval q(($x)-> &if_mtu);
	    }' unless defined(&GETIFMTU_6);
	}
	if(!defined(&USE_MUTEXES)  && !defined(&SPL_NET)) {
	    if((defined(&NetBSD)  && ((defined(&NetBSD) ? &NetBSD : undef) <= 1991011)  && ((defined(&NetBSD) ? &NetBSD : undef) >= 199407)) ||  &OPENBSD_GE_REV(200006)) {
		eval 'sub SPL_NET {
		    my($x) = @_;
    		    eval q($x =  &splsoftnet());
		}' unless defined(&SPL_NET);
	    } else {
		eval 'sub SPL_IMP {
		    my($x) = @_;
    		    eval q($x =  &splimp());
		}' unless defined(&SPL_IMP);
		eval 'sub SPL_NET {
		    my($x) = @_;
    		    eval q($x =  &splnet());
		}' unless defined(&SPL_NET);
	    }
	    if(!defined(&SPL_SCHED)) {
		eval 'sub SPL_SCHED {
		    my($x) = @_;
    		    eval q($x =  &splsched());
		}' unless defined(&SPL_SCHED);
	    }
	    eval 'sub SPL_X {
	        my($x) = @_;
    		eval q(( &void)  &splx($x));
	    }' unless defined(&SPL_X);
	}
	unless(defined(&FREE_MB_T)) {
	    eval 'sub FREE_MB_T {
	        my($m) = @_;
    		eval q( &m_freem($m));
	    }' unless defined(&FREE_MB_T);
	}
	unless(defined(&ALLOC_MB_T)) {
	    if(defined(&MGETHDR)) {
		eval 'sub ALLOC_MB_T {
		    my($m,$l) = @_;
    		    eval q( &do {  &MGETHDR(($m),  &M_DONTWAIT,  &MT_HEADER);  &if (($m) !=  &NULL) { ($m)-> &m_len = ($l); ($m)-> ($m_pkthdr->{len}) = ($l); } }  &while (0));
		}' unless defined(&ALLOC_MB_T);
	    } else {
		eval 'sub ALLOC_MB_T {
		    my($m,$l) = @_;
    		    eval q( &do {  &MGET(($m),  &M_DONTWAIT,  &MT_HEADER);  &if (($m) !=  &NULL) { ($m)-> &m_len = ($l); ($m)-> ($m_pkthdr->{len}) = ($l); } }  &while (0));
		}' unless defined(&ALLOC_MB_T);
	    }
	}
	unless(defined(&PREP_MB_T)) {
	    eval 'sub PREP_MB_T {
	        my($f, $m) = @_;
    		eval q( &do {  &mb_t * &_o = *($f)-> &fin_mp; ($m)-> &m_next =  &_o; *( &fin)-> &fin_mp = ($m);  &if ( ($_o->{m_flags}) &  &M_PKTHDR) { ($m)-> ($m_pkthdr->{len}) +=  ($_o->{m_pkthdr}->{len});  &m_copy_rcvif(($m),  &_o); } }  &while (0));
	    }' unless defined(&PREP_MB_T);
	}
	unless(defined(&M_DUP)) {
	    if(defined(&M_COPYALL)) {
		eval 'sub M_DUP {
		    my($m) = @_;
    		    eval q( &m_dup($m, 0,  &M_COPYALL, 0));
		}' unless defined(&M_DUP);
	    } else {
		eval 'sub M_DUP {
		    my($m) = @_;
    		    eval q( &m_dup($m));
		}' unless defined(&M_DUP);
	    }
	}
	unless(defined(&MTOD)) {
	    eval 'sub MTOD {
	        my($m,$t) = @_;
    		eval q( &mtod($m,$t));
	    }' unless defined(&MTOD);
	}
	unless(defined(&COPYIN)) {
	    eval 'sub COPYIN {
	        my($a,$b,$c) = @_;
    		eval q(( &bcopy(, ($b), ($c)), 0));
	    }' unless defined(&COPYIN);
	    eval 'sub COPYOUT {
	        my($a,$b,$c) = @_;
    		eval q(( &bcopy(, ($b), ($c)), 0));
	    }' unless defined(&COPYOUT);
	}
	unless(defined(&KMALLOC)) {
	    eval 'sub KMALLOC {
	        my($a,$b) = @_;
    		eval q(($a) = ($b) &new_kmem_alloc($sizeof{($a)},  &KMEM_NOSLEEP));
	    }' unless defined(&KMALLOC);
	    eval 'sub KMALLOCS {
	        my($a,$b,$c) = @_;
    		eval q(($a) = ($b) &new_kmem_alloc(($c),  &KMEM_NOSLEEP));
	    }' unless defined(&KMALLOCS);
	}
	unless(defined(&GET_MINOR)) {
	    eval 'sub GET_MINOR {
	        my($x) = @_;
    		eval q( &minor($x));
	    }' unless defined(&GET_MINOR);
	}
	eval 'sub PANIC {
	    my($x,$y) = @_;
    	    eval q( &if ($x)  &panic $y);
	}' unless defined(&PANIC);
    }
    if(!defined(&IFNAME)  && !defined(&_KERNEL)) {
	eval 'sub IFNAME {
	    my($x) = @_;
    	    eval q( &get_ifname($x));
	}' unless defined(&IFNAME);
    }
    unless(defined(&COPYIFNAME)) {
	eval 'sub NEED_FRGETIFNAME () {1;}' unless defined(&NEED_FRGETIFNAME);
	eval 'sub COPYIFNAME {
	    my($v, $x, $b) = @_;
    	    eval q( &ipf_getifname($x, $b));
	}' unless defined(&COPYIFNAME);
    }
    unless(defined(&ASSERT)) {
	if(defined(&_KERNEL)) {
	    eval 'sub ASSERT {
	        my($x) = @_;
    		eval q();
	    }' unless defined(&ASSERT);
	} else {
	    eval 'sub ASSERT {
	        my($x) = @_;
    		eval q( &do {  &if (!($x))  &abort(); }  &while (0));
	    }' unless defined(&ASSERT);
	}
    }
    unless(defined(&BCOPYIN)) {
	eval 'sub BCOPYIN {
	    my($a,$b,$c) = @_;
    	    eval q(( &bcopy(, ($b), ($c)), 0));
	}' unless defined(&BCOPYIN);
	eval 'sub BCOPYOUT {
	    my($a,$b,$c) = @_;
    	    eval q(( &bcopy(, ($b), ($c)), 0));
	}' unless defined(&BCOPYOUT);
    }
    eval 'sub ISALNUM {
        my($x) = @_;
	    eval q( &isalnum(($x)));
    }' unless defined(&ISALNUM);
    eval 'sub ISALPHA {
        my($x) = @_;
	    eval q( &isalpha(($x)));
    }' unless defined(&ISALPHA);
    eval 'sub ISDIGIT {
        my($x) = @_;
	    eval q( &isdigit(($x)));
    }' unless defined(&ISDIGIT);
    eval 'sub ISSPACE {
        my($x) = @_;
	    eval q( &isspace(($x)));
    }' unless defined(&ISSPACE);
    eval 'sub ISUPPER {
        my($x) = @_;
	    eval q( &isupper(($x)));
    }' unless defined(&ISUPPER);
    eval 'sub ISXDIGIT {
        my($x) = @_;
	    eval q( &isxdigit(($x)));
    }' unless defined(&ISXDIGIT);
    eval 'sub ISLOWER {
        my($x) = @_;
	    eval q( &islower(($x)));
    }' unless defined(&ISLOWER);
    eval 'sub TOUPPER {
        my($x) = @_;
	    eval q( &toupper(($x)));
    }' unless defined(&TOUPPER);
    eval 'sub TOLOWER {
        my($x) = @_;
	    eval q( &tolower(($x)));
    }' unless defined(&TOLOWER);
    if(!defined(&USE_MUTEXES)) {
	eval 'sub USE_SPL () {1;}' unless defined(&USE_SPL);
	undef(&RW_DESTROY) if defined(&RW_DESTROY);
	undef(&MUTEX_INIT) if defined(&MUTEX_INIT);
	undef(&MUTEX_NUKE) if defined(&MUTEX_NUKE);
	undef(&MUTEX_DESTROY) if defined(&MUTEX_DESTROY);
	eval 'sub MUTEX_ENTER {
	    my($x) = @_;
    	    eval q(;);
	}' unless defined(&MUTEX_ENTER);
	eval 'sub READ_ENTER {
	    my($x) = @_;
    	    eval q(;);
	}' unless defined(&READ_ENTER);
	eval 'sub WRITE_ENTER {
	    my($x) = @_;
    	    eval q(;);
	}' unless defined(&WRITE_ENTER);
	eval 'sub MUTEX_DOWNGRADE {
	    my($x) = @_;
    	    eval q(;);
	}' unless defined(&MUTEX_DOWNGRADE);
	eval 'sub RWLOCK_INIT {
	    my($x, $y) = @_;
    	    eval q(;);
	}' unless defined(&RWLOCK_INIT);
	eval 'sub RWLOCK_EXIT {
	    my($x) = @_;
    	    eval q(;);
	}' unless defined(&RWLOCK_EXIT);
	eval 'sub RW_DESTROY {
	    my($x) = @_;
    	    eval q(;);
	}' unless defined(&RW_DESTROY);
	eval 'sub MUTEX_EXIT {
	    my($x) = @_;
    	    eval q(;);
	}' unless defined(&MUTEX_EXIT);
	eval 'sub MUTEX_INIT {
	    my($x,$y) = @_;
    	    eval q(;);
	}' unless defined(&MUTEX_INIT);
	eval 'sub MUTEX_DESTROY {
	    my($x) = @_;
    	    eval q(;);
	}' unless defined(&MUTEX_DESTROY);
	eval 'sub MUTEX_NUKE {
	    my($x) = @_;
    	    eval q(;);
	}' unless defined(&MUTEX_NUKE);
    }
    unless(defined(&ATOMIC_INC)) {
	eval 'sub ATOMIC_INC {
	    my($x) = @_;
    	    eval q(($x)++);
	}' unless defined(&ATOMIC_INC);
	eval 'sub ATOMIC_DEC {
	    my($x) = @_;
    	    eval q(($x)--);
	}' unless defined(&ATOMIC_DEC);
    }
    if(defined(&USE_SPL)  && defined(&_KERNEL)) {
	eval 'sub SPL_INT {
	    my($x) = @_;
    	    eval q(\'int\' $x);
	}' unless defined(&SPL_INT);
    } else {
	eval 'sub SPL_INT {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&SPL_INT);
    }
    unless(defined(&ATOMIC_INCL)) {
	eval 'sub ATOMIC_INCL () { &ATOMIC_INC;}' unless defined(&ATOMIC_INCL);
	eval 'sub ATOMIC_INC64 () { &ATOMIC_INC;}' unless defined(&ATOMIC_INC64);
	eval 'sub ATOMIC_INC32 () { &ATOMIC_INC;}' unless defined(&ATOMIC_INC32);
	eval 'sub ATOMIC_DECL () { &ATOMIC_DEC;}' unless defined(&ATOMIC_DECL);
	eval 'sub ATOMIC_DEC64 () { &ATOMIC_DEC;}' unless defined(&ATOMIC_DEC64);
	eval 'sub ATOMIC_DEC32 () { &ATOMIC_DEC;}' unless defined(&ATOMIC_DEC32);
    }
    unless(defined(&HDR_T_PRIVATE)) {
    }
    unless(defined(&FR_GROUPLEN)) {
	eval 'sub FR_GROUPLEN () {16;}' unless defined(&FR_GROUPLEN);
    }
    unless(defined(&offsetof)) {
	eval 'sub offsetof {
	    my($t,$m) = @_;
    	    eval q((((($t *)0)->$m)));
	}' unless defined(&offsetof);
    }
    unless(defined(&stsizeof)) {
	eval 'sub stsizeof {
	    my($t,$m) = @_;
    	    eval q($sizeof{(($t )0)->$m});
	}' unless defined(&stsizeof);
    }
    unless(defined(&IP_V)) {
	eval 'sub IP_V {
	    my($x) = @_;
    	    eval q(($x)-> &ip_v);
	}' unless defined(&IP_V);
    }
    unless(defined(&IP_V_A)) {
	eval 'sub IP_V_A {
	    my($x,$y) = @_;
    	    eval q(($x)-> &ip_v = ($y));
	}' unless defined(&IP_V_A);
    }
    unless(defined(&IP_HL)) {
	eval 'sub IP_HL {
	    my($x) = @_;
    	    eval q(($x)-> &ip_hl);
	}' unless defined(&IP_HL);
    }
    unless(defined(&IP_HL_A)) {
	eval 'sub IP_HL_A {
	    my($x,$y) = @_;
    	    eval q(($x)-> &ip_hl = (($y) & 0xf));
	}' unless defined(&IP_HL_A);
    }
    unless(defined(&TCP_X2)) {
	eval 'sub TCP_X2 {
	    my($x) = @_;
    	    eval q(($x)-> &th_x2);
	}' unless defined(&TCP_X2);
    }
    unless(defined(&TCP_X2_A)) {
	eval 'sub TCP_X2_A {
	    my($x,$y) = @_;
    	    eval q(($x)-> &th_x2 = ($y));
	}' unless defined(&TCP_X2_A);
    }
    unless(defined(&TCP_OFF)) {
	eval 'sub TCP_OFF {
	    my($x) = @_;
    	    eval q(($x)-> &th_off);
	}' unless defined(&TCP_OFF);
    }
    unless(defined(&TCP_OFF_A)) {
	eval 'sub TCP_OFF_A {
	    my($x,$y) = @_;
    	    eval q(($x)-> &th_off = ($y));
	}' unless defined(&TCP_OFF_A);
    }
    eval 'sub IPMINLEN {
        my($i, $h) = @_;
	    eval q((($i)-> &ip_len >= ( &IP_HL($i) * 4+ $sizeof{\'struct h\'})));
    }' unless defined(&IPMINLEN);
    if(defined(&ultrix)) {
	eval 'sub A_A () {1;}' unless defined(&A_A);
    } else {
	eval 'sub A_A () {&;}' unless defined(&A_A);
    }
    eval 'sub TCPF_ALL () {( &TH_FIN| &TH_SYN| &TH_RST| &TH_PUSH| &TH_ACK| &TH_URG|  &TH_ECN| &TH_CWR);}' unless defined(&TCPF_ALL);
    if( &BSD_GE_YEAR(199306)  && !defined(&m_act)) {
	eval 'sub m_act () { &m_nextpkt;}' unless defined(&m_act);
    }
    eval 'sub IPSO_CLASS_RES4 () {0x1;}' unless defined(&IPSO_CLASS_RES4);
    eval 'sub IPSO_CLASS_TOPS () {0x3d;}' unless defined(&IPSO_CLASS_TOPS);
    eval 'sub IPSO_CLASS_SECR () {0x5a;}' unless defined(&IPSO_CLASS_SECR);
    eval 'sub IPSO_CLASS_CONF () {0x96;}' unless defined(&IPSO_CLASS_CONF);
    eval 'sub IPSO_CLASS_RES3 () {0x66;}' unless defined(&IPSO_CLASS_RES3);
    eval 'sub IPSO_CLASS_RES2 () {0xcc;}' unless defined(&IPSO_CLASS_RES2);
    eval 'sub IPSO_CLASS_UNCL () {0xab;}' unless defined(&IPSO_CLASS_UNCL);
    eval 'sub IPSO_CLASS_RES1 () {0xf1;}' unless defined(&IPSO_CLASS_RES1);
    eval 'sub IPSO_AUTH_GENSER () {0x80;}' unless defined(&IPSO_AUTH_GENSER);
    eval 'sub IPSO_AUTH_ESI () {0x40;}' unless defined(&IPSO_AUTH_ESI);
    eval 'sub IPSO_AUTH_SCI () {0x20;}' unless defined(&IPSO_AUTH_SCI);
    eval 'sub IPSO_AUTH_NSA () {0x10;}' unless defined(&IPSO_AUTH_NSA);
    eval 'sub IPSO_AUTH_DOE () {0x8;}' unless defined(&IPSO_AUTH_DOE);
    eval 'sub IPSO_AUTH_UN () {0x6;}' unless defined(&IPSO_AUTH_UN);
    eval 'sub IPSO_AUTH_FTE () {0x1;}' unless defined(&IPSO_AUTH_FTE);
    undef(&IPOPT_RR) if defined(&IPOPT_RR);
    eval 'sub IPOPT_RR () {7;}' unless defined(&IPOPT_RR);
    undef(&IPOPT_ZSU) if defined(&IPOPT_ZSU);
    eval 'sub IPOPT_ZSU () {10;}' unless defined(&IPOPT_ZSU);
    undef(&IPOPT_MTUP) if defined(&IPOPT_MTUP);
    eval 'sub IPOPT_MTUP () {11;}' unless defined(&IPOPT_MTUP);
    undef(&IPOPT_MTUR) if defined(&IPOPT_MTUR);
    eval 'sub IPOPT_MTUR () {12;}' unless defined(&IPOPT_MTUR);
    undef(&IPOPT_ENCODE) if defined(&IPOPT_ENCODE);
    eval 'sub IPOPT_ENCODE () {15;}' unless defined(&IPOPT_ENCODE);
    undef(&IPOPT_TS) if defined(&IPOPT_TS);
    eval 'sub IPOPT_TS () {68;}' unless defined(&IPOPT_TS);
    undef(&IPOPT_TR) if defined(&IPOPT_TR);
    eval 'sub IPOPT_TR () {82;}' unless defined(&IPOPT_TR);
    undef(&IPOPT_SECURITY) if defined(&IPOPT_SECURITY);
    eval 'sub IPOPT_SECURITY () {130;}' unless defined(&IPOPT_SECURITY);
    undef(&IPOPT_LSRR) if defined(&IPOPT_LSRR);
    eval 'sub IPOPT_LSRR () {131;}' unless defined(&IPOPT_LSRR);
    undef(&IPOPT_E_SEC) if defined(&IPOPT_E_SEC);
    eval 'sub IPOPT_E_SEC () {133;}' unless defined(&IPOPT_E_SEC);
    undef(&IPOPT_CIPSO) if defined(&IPOPT_CIPSO);
    eval 'sub IPOPT_CIPSO () {134;}' unless defined(&IPOPT_CIPSO);
    undef(&IPOPT_SATID) if defined(&IPOPT_SATID);
    eval 'sub IPOPT_SATID () {136;}' unless defined(&IPOPT_SATID);
    unless(defined(&IPOPT_SID)) {
	eval 'sub IPOPT_SID () { &IPOPT_SATID;}' unless defined(&IPOPT_SID);
    }
    undef(&IPOPT_SSRR) if defined(&IPOPT_SSRR);
    eval 'sub IPOPT_SSRR () {137;}' unless defined(&IPOPT_SSRR);
    undef(&IPOPT_ADDEXT) if defined(&IPOPT_ADDEXT);
    eval 'sub IPOPT_ADDEXT () {147;}' unless defined(&IPOPT_ADDEXT);
    undef(&IPOPT_VISA) if defined(&IPOPT_VISA);
    eval 'sub IPOPT_VISA () {142;}' unless defined(&IPOPT_VISA);
    undef(&IPOPT_IMITD) if defined(&IPOPT_IMITD);
    eval 'sub IPOPT_IMITD () {144;}' unless defined(&IPOPT_IMITD);
    undef(&IPOPT_EIP) if defined(&IPOPT_EIP);
    eval 'sub IPOPT_EIP () {145;}' unless defined(&IPOPT_EIP);
    undef(&IPOPT_RTRALRT) if defined(&IPOPT_RTRALRT);
    eval 'sub IPOPT_RTRALRT () {148;}' unless defined(&IPOPT_RTRALRT);
    undef(&IPOPT_SDB) if defined(&IPOPT_SDB);
    eval 'sub IPOPT_SDB () {149;}' unless defined(&IPOPT_SDB);
    undef(&IPOPT_NSAPA) if defined(&IPOPT_NSAPA);
    eval 'sub IPOPT_NSAPA () {150;}' unless defined(&IPOPT_NSAPA);
    undef(&IPOPT_DPS) if defined(&IPOPT_DPS);
    eval 'sub IPOPT_DPS () {151;}' unless defined(&IPOPT_DPS);
    undef(&IPOPT_UMP) if defined(&IPOPT_UMP);
    eval 'sub IPOPT_UMP () {152;}' unless defined(&IPOPT_UMP);
    undef(&IPOPT_FINN) if defined(&IPOPT_FINN);
    eval 'sub IPOPT_FINN () {205;}' unless defined(&IPOPT_FINN);
    undef(&IPOPT_AH) if defined(&IPOPT_AH);
    eval 'sub IPOPT_AH () {256+ &IPPROTO_AH;}' unless defined(&IPOPT_AH);
    unless(defined(&TCPOPT_EOL)) {
	eval 'sub TCPOPT_EOL () {0;}' unless defined(&TCPOPT_EOL);
    }
    unless(defined(&TCPOPT_NOP)) {
	eval 'sub TCPOPT_NOP () {1;}' unless defined(&TCPOPT_NOP);
    }
    unless(defined(&TCPOPT_MAXSEG)) {
	eval 'sub TCPOPT_MAXSEG () {2;}' unless defined(&TCPOPT_MAXSEG);
    }
    unless(defined(&TCPOLEN_MAXSEG)) {
	eval 'sub TCPOLEN_MAXSEG () {4;}' unless defined(&TCPOLEN_MAXSEG);
    }
    unless(defined(&TCPOPT_WINDOW)) {
	eval 'sub TCPOPT_WINDOW () {3;}' unless defined(&TCPOPT_WINDOW);
    }
    unless(defined(&TCPOLEN_WINDOW)) {
	eval 'sub TCPOLEN_WINDOW () {3;}' unless defined(&TCPOLEN_WINDOW);
    }
    unless(defined(&TCPOPT_SACK_PERMITTED)) {
	eval 'sub TCPOPT_SACK_PERMITTED () {4;}' unless defined(&TCPOPT_SACK_PERMITTED);
    }
    unless(defined(&TCPOLEN_SACK_PERMITTED)) {
	eval 'sub TCPOLEN_SACK_PERMITTED () {2;}' unless defined(&TCPOLEN_SACK_PERMITTED);
    }
    unless(defined(&TCPOPT_SACK)) {
	eval 'sub TCPOPT_SACK () {5;}' unless defined(&TCPOPT_SACK);
    }
    unless(defined(&TCPOPT_TIMESTAMP)) {
	eval 'sub TCPOPT_TIMESTAMP () {8;}' unless defined(&TCPOPT_TIMESTAMP);
    }
    unless(defined(&ICMP_MINLEN)) {
	eval 'sub ICMP_MINLEN () {8;}' unless defined(&ICMP_MINLEN);
    }
    unless(defined(&ICMP_ECHOREPLY)) {
	eval 'sub ICMP_ECHOREPLY () {0;}' unless defined(&ICMP_ECHOREPLY);
    }
    unless(defined(&ICMP_UNREACH)) {
	eval 'sub ICMP_UNREACH () {3;}' unless defined(&ICMP_UNREACH);
    }
    unless(defined(&ICMP_UNREACH_NET)) {
	eval 'sub ICMP_UNREACH_NET () {0;}' unless defined(&ICMP_UNREACH_NET);
    }
    unless(defined(&ICMP_UNREACH_HOST)) {
	eval 'sub ICMP_UNREACH_HOST () {1;}' unless defined(&ICMP_UNREACH_HOST);
    }
    unless(defined(&ICMP_UNREACH_PROTOCOL)) {
	eval 'sub ICMP_UNREACH_PROTOCOL () {2;}' unless defined(&ICMP_UNREACH_PROTOCOL);
    }
    unless(defined(&ICMP_UNREACH_PORT)) {
	eval 'sub ICMP_UNREACH_PORT () {3;}' unless defined(&ICMP_UNREACH_PORT);
    }
    unless(defined(&ICMP_UNREACH_NEEDFRAG)) {
	eval 'sub ICMP_UNREACH_NEEDFRAG () {4;}' unless defined(&ICMP_UNREACH_NEEDFRAG);
    }
    unless(defined(&ICMP_UNREACH_SRCFAIL)) {
	eval 'sub ICMP_UNREACH_SRCFAIL () {5;}' unless defined(&ICMP_UNREACH_SRCFAIL);
    }
    unless(defined(&ICMP_UNREACH_NET_UNKNOWN)) {
	eval 'sub ICMP_UNREACH_NET_UNKNOWN () {6;}' unless defined(&ICMP_UNREACH_NET_UNKNOWN);
    }
    unless(defined(&ICMP_UNREACH_HOST_UNKNOWN)) {
	eval 'sub ICMP_UNREACH_HOST_UNKNOWN () {7;}' unless defined(&ICMP_UNREACH_HOST_UNKNOWN);
    }
    unless(defined(&ICMP_UNREACH_ISOLATED)) {
	eval 'sub ICMP_UNREACH_ISOLATED () {8;}' unless defined(&ICMP_UNREACH_ISOLATED);
    }
    unless(defined(&ICMP_UNREACH_NET_PROHIB)) {
	eval 'sub ICMP_UNREACH_NET_PROHIB () {9;}' unless defined(&ICMP_UNREACH_NET_PROHIB);
    }
    unless(defined(&ICMP_UNREACH_HOST_PROHIB)) {
	eval 'sub ICMP_UNREACH_HOST_PROHIB () {10;}' unless defined(&ICMP_UNREACH_HOST_PROHIB);
    }
    unless(defined(&ICMP_UNREACH_TOSNET)) {
	eval 'sub ICMP_UNREACH_TOSNET () {11;}' unless defined(&ICMP_UNREACH_TOSNET);
    }
    unless(defined(&ICMP_UNREACH_TOSHOST)) {
	eval 'sub ICMP_UNREACH_TOSHOST () {12;}' unless defined(&ICMP_UNREACH_TOSHOST);
    }
    unless(defined(&ICMP_UNREACH_ADMIN_PROHIBIT)) {
	eval 'sub ICMP_UNREACH_ADMIN_PROHIBIT () {13;}' unless defined(&ICMP_UNREACH_ADMIN_PROHIBIT);
    }
    unless(defined(&ICMP_UNREACH_FILTER)) {
	eval 'sub ICMP_UNREACH_FILTER () {13;}' unless defined(&ICMP_UNREACH_FILTER);
    }
    unless(defined(&ICMP_UNREACH_HOST_PRECEDENCE)) {
	eval 'sub ICMP_UNREACH_HOST_PRECEDENCE () {14;}' unless defined(&ICMP_UNREACH_HOST_PRECEDENCE);
    }
    unless(defined(&ICMP_UNREACH_PRECEDENCE_CUTOFF)) {
	eval 'sub ICMP_UNREACH_PRECEDENCE_CUTOFF () {15;}' unless defined(&ICMP_UNREACH_PRECEDENCE_CUTOFF);
    }
    unless(defined(&ICMP_SOURCEQUENCH)) {
	eval 'sub ICMP_SOURCEQUENCH () {4;}' unless defined(&ICMP_SOURCEQUENCH);
    }
    unless(defined(&ICMP_REDIRECT_NET)) {
	eval 'sub ICMP_REDIRECT_NET () {0;}' unless defined(&ICMP_REDIRECT_NET);
    }
    unless(defined(&ICMP_REDIRECT_HOST)) {
	eval 'sub ICMP_REDIRECT_HOST () {1;}' unless defined(&ICMP_REDIRECT_HOST);
    }
    unless(defined(&ICMP_REDIRECT_TOSNET)) {
	eval 'sub ICMP_REDIRECT_TOSNET () {2;}' unless defined(&ICMP_REDIRECT_TOSNET);
    }
    unless(defined(&ICMP_REDIRECT_TOSHOST)) {
	eval 'sub ICMP_REDIRECT_TOSHOST () {3;}' unless defined(&ICMP_REDIRECT_TOSHOST);
    }
    unless(defined(&ICMP_ALTHOSTADDR)) {
	eval 'sub ICMP_ALTHOSTADDR () {6;}' unless defined(&ICMP_ALTHOSTADDR);
    }
    unless(defined(&ICMP_TIMXCEED)) {
	eval 'sub ICMP_TIMXCEED () {11;}' unless defined(&ICMP_TIMXCEED);
    }
    unless(defined(&ICMP_TIMXCEED_INTRANS)) {
	eval 'sub ICMP_TIMXCEED_INTRANS () {0;}' unless defined(&ICMP_TIMXCEED_INTRANS);
    }
    unless(defined(&ICMP_TIMXCEED_REASS)) {
	eval 'sub ICMP_TIMXCEED_REASS () {1;}' unless defined(&ICMP_TIMXCEED_REASS);
    }
    unless(defined(&ICMP_PARAMPROB)) {
	eval 'sub ICMP_PARAMPROB () {12;}' unless defined(&ICMP_PARAMPROB);
    }
    unless(defined(&ICMP_PARAMPROB_ERRATPTR)) {
	eval 'sub ICMP_PARAMPROB_ERRATPTR () {0;}' unless defined(&ICMP_PARAMPROB_ERRATPTR);
    }
    unless(defined(&ICMP_PARAMPROB_OPTABSENT)) {
	eval 'sub ICMP_PARAMPROB_OPTABSENT () {1;}' unless defined(&ICMP_PARAMPROB_OPTABSENT);
    }
    unless(defined(&ICMP_PARAMPROB_LENGTH)) {
	eval 'sub ICMP_PARAMPROB_LENGTH () {2;}' unless defined(&ICMP_PARAMPROB_LENGTH);
    }
    unless(defined(&ICMP_TSTAMP)) {
	eval 'sub ICMP_TSTAMP () {13;}' unless defined(&ICMP_TSTAMP);
    }
    unless(defined(&ICMP_TSTAMPREPLY)) {
	eval 'sub ICMP_TSTAMPREPLY () {14;}' unless defined(&ICMP_TSTAMPREPLY);
    }
    unless(defined(&ICMP_IREQ)) {
	eval 'sub ICMP_IREQ () {15;}' unless defined(&ICMP_IREQ);
    }
    unless(defined(&ICMP_IREQREPLY)) {
	eval 'sub ICMP_IREQREPLY () {16;}' unless defined(&ICMP_IREQREPLY);
    }
    unless(defined(&ICMP_MASKREQ)) {
	eval 'sub ICMP_MASKREQ () {17;}' unless defined(&ICMP_MASKREQ);
    }
    unless(defined(&ICMP_MASKREPLY)) {
	eval 'sub ICMP_MASKREPLY () {18;}' unless defined(&ICMP_MASKREPLY);
    }
    unless(defined(&ICMP_TRACEROUTE)) {
	eval 'sub ICMP_TRACEROUTE () {30;}' unless defined(&ICMP_TRACEROUTE);
    }
    unless(defined(&ICMP_DATACONVERR)) {
	eval 'sub ICMP_DATACONVERR () {31;}' unless defined(&ICMP_DATACONVERR);
    }
    unless(defined(&ICMP_MOBILE_REDIRECT)) {
	eval 'sub ICMP_MOBILE_REDIRECT () {32;}' unless defined(&ICMP_MOBILE_REDIRECT);
    }
    unless(defined(&ICMP_IPV6_WHEREAREYOU)) {
	eval 'sub ICMP_IPV6_WHEREAREYOU () {33;}' unless defined(&ICMP_IPV6_WHEREAREYOU);
    }
    unless(defined(&ICMP_IPV6_IAMHERE)) {
	eval 'sub ICMP_IPV6_IAMHERE () {34;}' unless defined(&ICMP_IPV6_IAMHERE);
    }
    unless(defined(&ICMP_MOBILE_REGREQUEST)) {
	eval 'sub ICMP_MOBILE_REGREQUEST () {35;}' unless defined(&ICMP_MOBILE_REGREQUEST);
    }
    unless(defined(&ICMP_MOBILE_REGREPLY)) {
	eval 'sub ICMP_MOBILE_REGREPLY () {36;}' unless defined(&ICMP_MOBILE_REGREPLY);
    }
    unless(defined(&ICMP_SKIP)) {
	eval 'sub ICMP_SKIP () {39;}' unless defined(&ICMP_SKIP);
    }
    unless(defined(&ICMP_PHOTURIS)) {
	eval 'sub ICMP_PHOTURIS () {40;}' unless defined(&ICMP_PHOTURIS);
    }
    unless(defined(&ICMP_PHOTURIS_UNKNOWN_INDEX)) {
	eval 'sub ICMP_PHOTURIS_UNKNOWN_INDEX () {1;}' unless defined(&ICMP_PHOTURIS_UNKNOWN_INDEX);
    }
    unless(defined(&ICMP_PHOTURIS_AUTH_FAILED)) {
	eval 'sub ICMP_PHOTURIS_AUTH_FAILED () {2;}' unless defined(&ICMP_PHOTURIS_AUTH_FAILED);
    }
    unless(defined(&ICMP_PHOTURIS_DECRYPT_FAILED)) {
	eval 'sub ICMP_PHOTURIS_DECRYPT_FAILED () {3;}' unless defined(&ICMP_PHOTURIS_DECRYPT_FAILED);
    }
    unless(defined(&IPVERSION)) {
	eval 'sub IPVERSION () {4;}' unless defined(&IPVERSION);
    }
    unless(defined(&IPOPT_MINOFF)) {
	eval 'sub IPOPT_MINOFF () {4;}' unless defined(&IPOPT_MINOFF);
    }
    unless(defined(&IPOPT_COPIED)) {
	eval 'sub IPOPT_COPIED {
	    my($x) = @_;
    	    eval q((($x)&0x80));
	}' unless defined(&IPOPT_COPIED);
    }
    unless(defined(&IPOPT_EOL)) {
	eval 'sub IPOPT_EOL () {0;}' unless defined(&IPOPT_EOL);
    }
    unless(defined(&IPOPT_NOP)) {
	eval 'sub IPOPT_NOP () {1;}' unless defined(&IPOPT_NOP);
    }
    unless(defined(&IP_MF)) {
	eval 'sub IP_MF () {(0x2000);}' unless defined(&IP_MF);
    }
    unless(defined(&ETHERTYPE_IP)) {
	eval 'sub ETHERTYPE_IP () {(0x800);}' unless defined(&ETHERTYPE_IP);
    }
    unless(defined(&TH_FIN)) {
	eval 'sub TH_FIN () {0x1;}' unless defined(&TH_FIN);
    }
    unless(defined(&TH_SYN)) {
	eval 'sub TH_SYN () {0x2;}' unless defined(&TH_SYN);
    }
    unless(defined(&TH_RST)) {
	eval 'sub TH_RST () {0x4;}' unless defined(&TH_RST);
    }
    unless(defined(&TH_PUSH)) {
	eval 'sub TH_PUSH () {0x8;}' unless defined(&TH_PUSH);
    }
    unless(defined(&TH_ACK)) {
	eval 'sub TH_ACK () {0x10;}' unless defined(&TH_ACK);
    }
    unless(defined(&TH_URG)) {
	eval 'sub TH_URG () {0x20;}' unless defined(&TH_URG);
    }
    undef(&TH_ACKMASK) if defined(&TH_ACKMASK);
    eval 'sub TH_ACKMASK () {( &TH_FIN| &TH_SYN| &TH_RST| &TH_ACK);}' unless defined(&TH_ACKMASK);
    unless(defined(&IPOPT_EOL)) {
	eval 'sub IPOPT_EOL () {0;}' unless defined(&IPOPT_EOL);
    }
    unless(defined(&IPOPT_NOP)) {
	eval 'sub IPOPT_NOP () {1;}' unless defined(&IPOPT_NOP);
    }
    unless(defined(&IPOPT_RR)) {
	eval 'sub IPOPT_RR () {7;}' unless defined(&IPOPT_RR);
    }
    unless(defined(&IPOPT_TS)) {
	eval 'sub IPOPT_TS () {68;}' unless defined(&IPOPT_TS);
    }
    unless(defined(&IPOPT_SECURITY)) {
	eval 'sub IPOPT_SECURITY () {130;}' unless defined(&IPOPT_SECURITY);
    }
    unless(defined(&IPOPT_LSRR)) {
	eval 'sub IPOPT_LSRR () {131;}' unless defined(&IPOPT_LSRR);
    }
    unless(defined(&IPOPT_SATID)) {
	eval 'sub IPOPT_SATID () {136;}' unless defined(&IPOPT_SATID);
    }
    unless(defined(&IPOPT_SSRR)) {
	eval 'sub IPOPT_SSRR () {137;}' unless defined(&IPOPT_SSRR);
    }
    unless(defined(&IPOPT_SECUR_UNCLASS)) {
	eval 'sub IPOPT_SECUR_UNCLASS () {(0x);}' unless defined(&IPOPT_SECUR_UNCLASS);
    }
    unless(defined(&IPOPT_SECUR_CONFID)) {
	eval 'sub IPOPT_SECUR_CONFID () {(0xf135);}' unless defined(&IPOPT_SECUR_CONFID);
    }
    unless(defined(&IPOPT_SECUR_EFTO)) {
	eval 'sub IPOPT_SECUR_EFTO () {(0x789a);}' unless defined(&IPOPT_SECUR_EFTO);
    }
    unless(defined(&IPOPT_SECUR_MMMM)) {
	eval 'sub IPOPT_SECUR_MMMM () {(0xbc4d);}' unless defined(&IPOPT_SECUR_MMMM);
    }
    unless(defined(&IPOPT_SECUR_RESTR)) {
	eval 'sub IPOPT_SECUR_RESTR () {(0xaf13);}' unless defined(&IPOPT_SECUR_RESTR);
    }
    unless(defined(&IPOPT_SECUR_SECRET)) {
	eval 'sub IPOPT_SECUR_SECRET () {(0xd788);}' unless defined(&IPOPT_SECUR_SECRET);
    }
    unless(defined(&IPOPT_SECUR_TOPSECRET)) {
	eval 'sub IPOPT_SECUR_TOPSECRET () {(0x6bc5);}' unless defined(&IPOPT_SECUR_TOPSECRET);
    }
    unless(defined(&IPOPT_OLEN)) {
	eval 'sub IPOPT_OLEN () {1;}' unless defined(&IPOPT_OLEN);
    }
    unless(defined(&IPPROTO_HOPOPTS)) {
	eval 'sub IPPROTO_HOPOPTS () {0;}' unless defined(&IPPROTO_HOPOPTS);
    }
    unless(defined(&IPPROTO_IPIP)) {
	eval 'sub IPPROTO_IPIP () {4;}' unless defined(&IPPROTO_IPIP);
    }
    unless(defined(&IPPROTO_ENCAP)) {
	eval 'sub IPPROTO_ENCAP () {98;}' unless defined(&IPPROTO_ENCAP);
    }
    unless(defined(&IPPROTO_IPV6)) {
	eval 'sub IPPROTO_IPV6 () {41;}' unless defined(&IPPROTO_IPV6);
    }
    unless(defined(&IPPROTO_ROUTING)) {
	eval 'sub IPPROTO_ROUTING () {43;}' unless defined(&IPPROTO_ROUTING);
    }
    unless(defined(&IPPROTO_FRAGMENT)) {
	eval 'sub IPPROTO_FRAGMENT () {44;}' unless defined(&IPPROTO_FRAGMENT);
    }
    unless(defined(&IPPROTO_GRE)) {
	eval 'sub IPPROTO_GRE () {47;}' unless defined(&IPPROTO_GRE);
    }
    unless(defined(&IPPROTO_ESP)) {
	eval 'sub IPPROTO_ESP () {50;}' unless defined(&IPPROTO_ESP);
    }
    unless(defined(&IPPROTO_AH)) {
	eval 'sub IPPROTO_AH () {51;}' unless defined(&IPPROTO_AH);
    }
    unless(defined(&IPPROTO_ICMPV6)) {
	eval 'sub IPPROTO_ICMPV6 () {58;}' unless defined(&IPPROTO_ICMPV6);
    }
    unless(defined(&IPPROTO_NONE)) {
	eval 'sub IPPROTO_NONE () {59;}' unless defined(&IPPROTO_NONE);
    }
    unless(defined(&IPPROTO_DSTOPTS)) {
	eval 'sub IPPROTO_DSTOPTS () {60;}' unless defined(&IPPROTO_DSTOPTS);
    }
    unless(defined(&IPPROTO_MOBILITY)) {
	eval 'sub IPPROTO_MOBILITY () {135;}' unless defined(&IPPROTO_MOBILITY);
    }
    unless(defined(&ICMP_ROUTERADVERT)) {
	eval 'sub ICMP_ROUTERADVERT () {9;}' unless defined(&ICMP_ROUTERADVERT);
    }
    unless(defined(&ICMP_ROUTERSOLICIT)) {
	eval 'sub ICMP_ROUTERSOLICIT () {10;}' unless defined(&ICMP_ROUTERSOLICIT);
    }
    unless(defined(&ICMP6_DST_UNREACH)) {
	eval 'sub ICMP6_DST_UNREACH () {1;}' unless defined(&ICMP6_DST_UNREACH);
    }
    unless(defined(&ICMP6_PACKET_TOO_BIG)) {
	eval 'sub ICMP6_PACKET_TOO_BIG () {2;}' unless defined(&ICMP6_PACKET_TOO_BIG);
    }
    unless(defined(&ICMP6_TIME_EXCEEDED)) {
	eval 'sub ICMP6_TIME_EXCEEDED () {3;}' unless defined(&ICMP6_TIME_EXCEEDED);
    }
    unless(defined(&ICMP6_PARAM_PROB)) {
	eval 'sub ICMP6_PARAM_PROB () {4;}' unless defined(&ICMP6_PARAM_PROB);
    }
    unless(defined(&ICMP6_ECHO_REQUEST)) {
	eval 'sub ICMP6_ECHO_REQUEST () {128;}' unless defined(&ICMP6_ECHO_REQUEST);
    }
    unless(defined(&ICMP6_ECHO_REPLY)) {
	eval 'sub ICMP6_ECHO_REPLY () {129;}' unless defined(&ICMP6_ECHO_REPLY);
    }
    unless(defined(&ICMP6_MEMBERSHIP_QUERY)) {
	eval 'sub ICMP6_MEMBERSHIP_QUERY () {130;}' unless defined(&ICMP6_MEMBERSHIP_QUERY);
    }
    unless(defined(&MLD6_LISTENER_QUERY)) {
	eval 'sub MLD6_LISTENER_QUERY () {130;}' unless defined(&MLD6_LISTENER_QUERY);
    }
    unless(defined(&ICMP6_MEMBERSHIP_REPORT)) {
	eval 'sub ICMP6_MEMBERSHIP_REPORT () {131;}' unless defined(&ICMP6_MEMBERSHIP_REPORT);
    }
    unless(defined(&MLD6_LISTENER_REPORT)) {
	eval 'sub MLD6_LISTENER_REPORT () {131;}' unless defined(&MLD6_LISTENER_REPORT);
    }
    unless(defined(&ICMP6_MEMBERSHIP_REDUCTION)) {
	eval 'sub ICMP6_MEMBERSHIP_REDUCTION () {132;}' unless defined(&ICMP6_MEMBERSHIP_REDUCTION);
    }
    unless(defined(&MLD6_LISTENER_DONE)) {
	eval 'sub MLD6_LISTENER_DONE () {132;}' unless defined(&MLD6_LISTENER_DONE);
    }
    unless(defined(&ND_ROUTER_SOLICIT)) {
	eval 'sub ND_ROUTER_SOLICIT () {133;}' unless defined(&ND_ROUTER_SOLICIT);
    }
    unless(defined(&ND_ROUTER_ADVERT)) {
	eval 'sub ND_ROUTER_ADVERT () {134;}' unless defined(&ND_ROUTER_ADVERT);
    }
    unless(defined(&ND_NEIGHBOR_SOLICIT)) {
	eval 'sub ND_NEIGHBOR_SOLICIT () {135;}' unless defined(&ND_NEIGHBOR_SOLICIT);
    }
    unless(defined(&ND_NEIGHBOR_ADVERT)) {
	eval 'sub ND_NEIGHBOR_ADVERT () {136;}' unless defined(&ND_NEIGHBOR_ADVERT);
    }
    unless(defined(&ND_REDIRECT)) {
	eval 'sub ND_REDIRECT () {137;}' unless defined(&ND_REDIRECT);
    }
    unless(defined(&ICMP6_ROUTER_RENUMBERING)) {
	eval 'sub ICMP6_ROUTER_RENUMBERING () {138;}' unless defined(&ICMP6_ROUTER_RENUMBERING);
    }
    unless(defined(&ICMP6_WRUREQUEST)) {
	eval 'sub ICMP6_WRUREQUEST () {139;}' unless defined(&ICMP6_WRUREQUEST);
    }
    unless(defined(&ICMP6_WRUREPLY)) {
	eval 'sub ICMP6_WRUREPLY () {140;}' unless defined(&ICMP6_WRUREPLY);
    }
    unless(defined(&ICMP6_FQDN_QUERY)) {
	eval 'sub ICMP6_FQDN_QUERY () {139;}' unless defined(&ICMP6_FQDN_QUERY);
    }
    unless(defined(&ICMP6_FQDN_REPLY)) {
	eval 'sub ICMP6_FQDN_REPLY () {140;}' unless defined(&ICMP6_FQDN_REPLY);
    }
    unless(defined(&ICMP6_NI_QUERY)) {
	eval 'sub ICMP6_NI_QUERY () {139;}' unless defined(&ICMP6_NI_QUERY);
    }
    unless(defined(&ICMP6_NI_REPLY)) {
	eval 'sub ICMP6_NI_REPLY () {140;}' unless defined(&ICMP6_NI_REPLY);
    }
    unless(defined(&MLD6_MTRACE_RESP)) {
	eval 'sub MLD6_MTRACE_RESP () {200;}' unless defined(&MLD6_MTRACE_RESP);
    }
    unless(defined(&MLD6_MTRACE)) {
	eval 'sub MLD6_MTRACE () {201;}' unless defined(&MLD6_MTRACE);
    }
    unless(defined(&ICMP6_HADISCOV_REQUEST)) {
	eval 'sub ICMP6_HADISCOV_REQUEST () {202;}' unless defined(&ICMP6_HADISCOV_REQUEST);
    }
    unless(defined(&ICMP6_HADISCOV_REPLY)) {
	eval 'sub ICMP6_HADISCOV_REPLY () {203;}' unless defined(&ICMP6_HADISCOV_REPLY);
    }
    unless(defined(&ICMP6_MOBILEPREFIX_SOLICIT)) {
	eval 'sub ICMP6_MOBILEPREFIX_SOLICIT () {204;}' unless defined(&ICMP6_MOBILEPREFIX_SOLICIT);
    }
    unless(defined(&ICMP6_MOBILEPREFIX_ADVERT)) {
	eval 'sub ICMP6_MOBILEPREFIX_ADVERT () {205;}' unless defined(&ICMP6_MOBILEPREFIX_ADVERT);
    }
    unless(defined(&ICMP6_MAXTYPE)) {
	eval 'sub ICMP6_MAXTYPE () {205;}' unless defined(&ICMP6_MAXTYPE);
    }
    unless(defined(&ICMP6_DST_UNREACH_NOROUTE)) {
	eval 'sub ICMP6_DST_UNREACH_NOROUTE () {0;}' unless defined(&ICMP6_DST_UNREACH_NOROUTE);
    }
    unless(defined(&ICMP6_DST_UNREACH_ADMIN)) {
	eval 'sub ICMP6_DST_UNREACH_ADMIN () {1;}' unless defined(&ICMP6_DST_UNREACH_ADMIN);
    }
    unless(defined(&ICMP6_DST_UNREACH_NOTNEIGHBOR)) {
	eval 'sub ICMP6_DST_UNREACH_NOTNEIGHBOR () {2;}' unless defined(&ICMP6_DST_UNREACH_NOTNEIGHBOR);
    }
    unless(defined(&ICMP6_DST_UNREACH_BEYONDSCOPE)) {
	eval 'sub ICMP6_DST_UNREACH_BEYONDSCOPE () {2;}' unless defined(&ICMP6_DST_UNREACH_BEYONDSCOPE);
    }
    unless(defined(&ICMP6_DST_UNREACH_ADDR)) {
	eval 'sub ICMP6_DST_UNREACH_ADDR () {3;}' unless defined(&ICMP6_DST_UNREACH_ADDR);
    }
    unless(defined(&ICMP6_DST_UNREACH_NOPORT)) {
	eval 'sub ICMP6_DST_UNREACH_NOPORT () {4;}' unless defined(&ICMP6_DST_UNREACH_NOPORT);
    }
    unless(defined(&ICMP6_TIME_EXCEED_TRANSIT)) {
	eval 'sub ICMP6_TIME_EXCEED_TRANSIT () {0;}' unless defined(&ICMP6_TIME_EXCEED_TRANSIT);
    }
    unless(defined(&ICMP6_TIME_EXCEED_REASSEMBLY)) {
	eval 'sub ICMP6_TIME_EXCEED_REASSEMBLY () {1;}' unless defined(&ICMP6_TIME_EXCEED_REASSEMBLY);
    }
    unless(defined(&ICMP6_NI_SUCCESS)) {
	eval 'sub ICMP6_NI_SUCCESS () {0;}' unless defined(&ICMP6_NI_SUCCESS);
    }
    unless(defined(&ICMP6_NI_REFUSED)) {
	eval 'sub ICMP6_NI_REFUSED () {1;}' unless defined(&ICMP6_NI_REFUSED);
    }
    unless(defined(&ICMP6_NI_UNKNOWN)) {
	eval 'sub ICMP6_NI_UNKNOWN () {2;}' unless defined(&ICMP6_NI_UNKNOWN);
    }
    unless(defined(&ICMP6_ROUTER_RENUMBERING_COMMAND)) {
	eval 'sub ICMP6_ROUTER_RENUMBERING_COMMAND () {0;}' unless defined(&ICMP6_ROUTER_RENUMBERING_COMMAND);
    }
    unless(defined(&ICMP6_ROUTER_RENUMBERING_RESULT)) {
	eval 'sub ICMP6_ROUTER_RENUMBERING_RESULT () {1;}' unless defined(&ICMP6_ROUTER_RENUMBERING_RESULT);
    }
    unless(defined(&ICMP6_ROUTER_RENUMBERING_SEQNUM_RESET)) {
	eval 'sub ICMP6_ROUTER_RENUMBERING_SEQNUM_RESET () {255;}' unless defined(&ICMP6_ROUTER_RENUMBERING_SEQNUM_RESET);
    }
    unless(defined(&ICMP6_PARAMPROB_HEADER)) {
	eval 'sub ICMP6_PARAMPROB_HEADER () {0;}' unless defined(&ICMP6_PARAMPROB_HEADER);
    }
    unless(defined(&ICMP6_PARAMPROB_NEXTHEADER)) {
	eval 'sub ICMP6_PARAMPROB_NEXTHEADER () {1;}' unless defined(&ICMP6_PARAMPROB_NEXTHEADER);
    }
    unless(defined(&ICMP6_PARAMPROB_OPTION)) {
	eval 'sub ICMP6_PARAMPROB_OPTION () {2;}' unless defined(&ICMP6_PARAMPROB_OPTION);
    }
    unless(defined(&ICMP6_NI_SUBJ_IPV6)) {
	eval 'sub ICMP6_NI_SUBJ_IPV6 () {0;}' unless defined(&ICMP6_NI_SUBJ_IPV6);
    }
    unless(defined(&ICMP6_NI_SUBJ_FQDN)) {
	eval 'sub ICMP6_NI_SUBJ_FQDN () {1;}' unless defined(&ICMP6_NI_SUBJ_FQDN);
    }
    unless(defined(&ICMP6_NI_SUBJ_IPV4)) {
	eval 'sub ICMP6_NI_SUBJ_IPV4 () {2;}' unless defined(&ICMP6_NI_SUBJ_IPV4);
    }
    unless(defined(&MLD_MTRACE_RESP)) {
	eval 'sub MLD_MTRACE_RESP () {200;}' unless defined(&MLD_MTRACE_RESP);
    }
    unless(defined(&MLD_MTRACE)) {
	eval 'sub MLD_MTRACE () {201;}' unless defined(&MLD_MTRACE);
    }
    unless(defined(&MLD6_MTRACE_RESP)) {
	eval 'sub MLD6_MTRACE_RESP () { &MLD_MTRACE_RESP;}' unless defined(&MLD6_MTRACE_RESP);
    }
    unless(defined(&MLD6_MTRACE)) {
	eval 'sub MLD6_MTRACE () { &MLD_MTRACE;}' unless defined(&MLD6_MTRACE);
    }
    if(!defined(&IPV6_FLOWINFO_MASK)) {
	if(((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) || defined(&_BIG_ENDIAN)) {
	    eval 'sub IPV6_FLOWINFO_MASK () {0xfffffff;}' unless defined(&IPV6_FLOWINFO_MASK);
	} else {
	    eval 'sub IPV6_FLOWINFO_MASK () {0xffffff0f;}' unless defined(&IPV6_FLOWINFO_MASK);
	}
    }
}
if(!defined(&IPV6_FLOWLABEL_MASK)) {
    if(((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) || defined(&_BIG_ENDIAN)) {
	eval 'sub IPV6_FLOWLABEL_MASK () {0xfffff;}' unless defined(&IPV6_FLOWLABEL_MASK);
    } else {
	if(((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) || !defined(&_BIG_ENDIAN)) {
	    eval 'sub IPV6_FLOWLABEL_MASK () {0xffff0f00;}' unless defined(&IPV6_FLOWLABEL_MASK);
	}
    }
}
unless(defined(&TH_ECN)) {
    eval 'sub TH_ECN () {0x40;}' unless defined(&TH_ECN);
}
unless(defined(&TH_CWR)) {
    eval 'sub TH_CWR () {0x80;}' unless defined(&TH_CWR);
}
eval 'sub TH_ECNALL () {( &TH_ECN| &TH_CWR);}' unless defined(&TH_ECNALL);
eval 'sub IPF_TCPS_LISTEN () {0;}' unless defined(&IPF_TCPS_LISTEN);
eval 'sub IPF_TCPS_SYN_SENT () {1;}' unless defined(&IPF_TCPS_SYN_SENT);
eval 'sub IPF_TCPS_SYN_RECEIVED () {2;}' unless defined(&IPF_TCPS_SYN_RECEIVED);
eval 'sub IPF_TCPS_HALF_ESTAB () {3;}' unless defined(&IPF_TCPS_HALF_ESTAB);
eval 'sub IPF_TCPS_ESTABLISHED () {4;}' unless defined(&IPF_TCPS_ESTABLISHED);
eval 'sub IPF_TCPS_CLOSE_WAIT () {5;}' unless defined(&IPF_TCPS_CLOSE_WAIT);
eval 'sub IPF_TCPS_FIN_WAIT_1 () {6;}' unless defined(&IPF_TCPS_FIN_WAIT_1);
eval 'sub IPF_TCPS_CLOSING () {7;}' unless defined(&IPF_TCPS_CLOSING);
eval 'sub IPF_TCPS_LAST_ACK () {8;}' unless defined(&IPF_TCPS_LAST_ACK);
eval 'sub IPF_TCPS_FIN_WAIT_2 () {9;}' unless defined(&IPF_TCPS_FIN_WAIT_2);
eval 'sub IPF_TCPS_TIME_WAIT () {10;}' unless defined(&IPF_TCPS_TIME_WAIT);
eval 'sub IPF_TCPS_CLOSED () {11;}' unless defined(&IPF_TCPS_CLOSED);
eval 'sub IPF_TCP_NSTATES () {12;}' unless defined(&IPF_TCP_NSTATES);
eval 'sub TCP_MSL () {120;}' unless defined(&TCP_MSL);
undef(&ICMP_MAX_UNREACH) if defined(&ICMP_MAX_UNREACH);
eval 'sub ICMP_MAX_UNREACH () {14;}' unless defined(&ICMP_MAX_UNREACH);
undef(&ICMP_MAXTYPE) if defined(&ICMP_MAXTYPE);
eval 'sub ICMP_MAXTYPE () {18;}' unless defined(&ICMP_MAXTYPE);
unless(defined(&IFNAMSIZ)) {
    eval 'sub IFNAMSIZ () {16;}' unless defined(&IFNAMSIZ);
}
unless(defined(&LOG_FTP)) {
    eval 'sub LOG_FTP () {(11<<3);}' unless defined(&LOG_FTP);
}
unless(defined(&LOG_AUTHPRIV)) {
    eval 'sub LOG_AUTHPRIV () {(10<<3);}' unless defined(&LOG_AUTHPRIV);
}
unless(defined(&LOG_AUDIT)) {
    eval 'sub LOG_AUDIT () {(13<<3);}' unless defined(&LOG_AUDIT);
}
unless(defined(&LOG_NTP)) {
    eval 'sub LOG_NTP () {(12<<3);}' unless defined(&LOG_NTP);
}
unless(defined(&LOG_SECURITY)) {
    eval 'sub LOG_SECURITY () {(13<<3);}' unless defined(&LOG_SECURITY);
}
unless(defined(&LOG_LFMT)) {
    eval 'sub LOG_LFMT () {(14<<3);}' unless defined(&LOG_LFMT);
}
unless(defined(&LOG_CONSOLE)) {
    eval 'sub LOG_CONSOLE () {(14<<3);}' unless defined(&LOG_CONSOLE);
}
eval 'sub ICMPERR_ICMPHLEN () {8;}' unless defined(&ICMPERR_ICMPHLEN);
eval 'sub ICMPERR_IPICMPHLEN () {(20+ 8);}' unless defined(&ICMPERR_IPICMPHLEN);
eval 'sub ICMPERR_MINPKTLEN () {(20+ 8+ 20);}' unless defined(&ICMPERR_MINPKTLEN);
eval 'sub ICMPERR_MAXPKTLEN () {(20+ 8+ 20+ 8);}' unless defined(&ICMPERR_MAXPKTLEN);
eval 'sub ICMP6ERR_MINPKTLEN () {(40+ 8);}' unless defined(&ICMP6ERR_MINPKTLEN);
eval 'sub ICMP6ERR_IPICMPHLEN () {(40+ 8+ 40);}' unless defined(&ICMP6ERR_IPICMPHLEN);
unless(defined(&MIN)) {
    eval 'sub MIN {
        my($a,$b) = @_;
	    eval q(((($a)<($b))?($a):($b)));
    }' unless defined(&MIN);
}
if(defined(&RESCUE)) {
    undef(&IPFILTER_BPF) if defined(&IPFILTER_BPF);
}
if(defined(&IPF_DEBUG)) {
    eval 'sub DPRINT {
        my($x) = @_;
	    eval q( &printf $x);
    }' unless defined(&DPRINT);
} else {
    eval 'sub DPRINT {
        my($x) = @_;
	    eval q();
    }' unless defined(&DPRINT);
}
unless(defined(&AF_INET6)) {
    eval 'sub AF_INET6 () {26;}' unless defined(&AF_INET6);
}
if(defined(&DTRACE_PROBE)) {
    if(defined(&_KERNEL)) {
	eval 'sub DT {
	    my($_n) = @_;
    	    eval q( &DTRACE_PROBE($_n));
	}' unless defined(&DT);
	eval 'sub DT1 {
	    my($_n,$_a,$_b) = @_;
    	    eval q( &DTRACE_PROBE1($_n,$_a,$_b));
	}' unless defined(&DT1);
	eval 'sub DT2 {
	    my($_n,$_a,$_b,$_c,$_d) = @_;
    	    eval q( &DTRACE_PROBE2($_n,$_a,$_b,$_c,$_d));
	}' unless defined(&DT2);
	eval 'sub DT3 {
	    my($_n,$_a,$_b,$_c,$_d,$_e,$_f) = @_;
    	    eval q( &DTRACE_PROBE3($_n,$_a,$_b,$_c,$_d,$_e,$_f));
	}' unless defined(&DT3);
	eval 'sub DT4 {
	    my($_n,$_a,$_b,$_c,$_d,$_e,$_f,$_g,$_h) = @_;
    	    eval q( &DTRACE_PROBE4($_n,$_a,$_b,$_c,$_d,$_e,$_f,$_g,$_h));
	}' unless defined(&DT4);
    } else {
	eval 'sub DT {
	    my($_n) = @_;
    	    eval q();
	}' unless defined(&DT);
	eval 'sub DT1 {
	    my($_n,$_a,$_b) = @_;
    	    eval q();
	}' unless defined(&DT1);
	eval 'sub DT2 {
	    my($_n,$_a,$_b,$_c,$_d) = @_;
    	    eval q();
	}' unless defined(&DT2);
	eval 'sub DT3 {
	    my($_n,$_a,$_b,$_c,$_d,$_e,$_f) = @_;
    	    eval q();
	}' unless defined(&DT3);
	eval 'sub DT4 {
	    my($_n,$_a,$_b,$_c,$_d,$_e,$_f,$_g,$_h) = @_;
    	    eval q();
	}' unless defined(&DT4);
    }
} else {
    eval 'sub DT {
        my($_n) = @_;
	    eval q();
    }' unless defined(&DT);
    eval 'sub DT1 {
        my($_n,$_a,$_b) = @_;
	    eval q();
    }' unless defined(&DT1);
    eval 'sub DT2 {
        my($_n,$_a,$_b,$_c,$_d) = @_;
	    eval q();
    }' unless defined(&DT2);
    eval 'sub DT3 {
        my($_n,$_a,$_b,$_c,$_d,$_e,$_f) = @_;
	    eval q();
    }' unless defined(&DT3);
    eval 'sub DT4 {
        my($_n,$_a,$_b,$_c,$_d,$_e,$_f,$_g,$_h) = @_;
	    eval q();
    }' unless defined(&DT4);
}
    }
1;
