require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_OCSP_H)) {
    eval 'sub OPENSSL_OCSP_H () {1;}' unless defined(&OPENSSL_OCSP_H);
    require 'openssl/macros.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub HEADER_OCSP_H () {1;}' unless defined(&HEADER_OCSP_H);
    }
    require 'openssl/opensslconf.ph';
    require 'openssl/http.ph';
    require 'openssl/asn1.ph';
    eval 'sub OCSP_REVOKED_STATUS_NOSTATUS () {-1;}' unless defined(&OCSP_REVOKED_STATUS_NOSTATUS);
    eval 'sub OCSP_REVOKED_STATUS_UNSPECIFIED () {0;}' unless defined(&OCSP_REVOKED_STATUS_UNSPECIFIED);
    eval 'sub OCSP_REVOKED_STATUS_KEYCOMPROMISE () {1;}' unless defined(&OCSP_REVOKED_STATUS_KEYCOMPROMISE);
    eval 'sub OCSP_REVOKED_STATUS_CACOMPROMISE () {2;}' unless defined(&OCSP_REVOKED_STATUS_CACOMPROMISE);
    eval 'sub OCSP_REVOKED_STATUS_AFFILIATIONCHANGED () {3;}' unless defined(&OCSP_REVOKED_STATUS_AFFILIATIONCHANGED);
    eval 'sub OCSP_REVOKED_STATUS_SUPERSEDED () {4;}' unless defined(&OCSP_REVOKED_STATUS_SUPERSEDED);
    eval 'sub OCSP_REVOKED_STATUS_CESSATIONOFOPERATION () {5;}' unless defined(&OCSP_REVOKED_STATUS_CESSATIONOFOPERATION);
    eval 'sub OCSP_REVOKED_STATUS_CERTIFICATEHOLD () {6;}' unless defined(&OCSP_REVOKED_STATUS_CERTIFICATEHOLD);
    eval 'sub OCSP_REVOKED_STATUS_REMOVEFROMCRL () {8;}' unless defined(&OCSP_REVOKED_STATUS_REMOVEFROMCRL);
    eval 'sub OCSP_REVOKED_STATUS_PRIVILEGEWITHDRAWN () {9;}' unless defined(&OCSP_REVOKED_STATUS_PRIVILEGEWITHDRAWN);
    eval 'sub OCSP_REVOKED_STATUS_AACOMPROMISE () {10;}' unless defined(&OCSP_REVOKED_STATUS_AACOMPROMISE);
    unless(defined(&OPENSSL_NO_OCSP)) {
	require 'openssl/x509.ph';
	require 'openssl/x509v3.ph';
	require 'openssl/safestack.ph';
	require 'openssl/ocsperr.ph';
	if(defined(&__cplusplus)) {
	}
	eval 'sub OCSP_DEFAULT_NONCE_LENGTH () {16;}' unless defined(&OCSP_DEFAULT_NONCE_LENGTH);
	eval 'sub OCSP_NOCERTS () {0x1;}' unless defined(&OCSP_NOCERTS);
	eval 'sub OCSP_NOINTERN () {0x2;}' unless defined(&OCSP_NOINTERN);
	eval 'sub OCSP_NOSIGS () {0x4;}' unless defined(&OCSP_NOSIGS);
	eval 'sub OCSP_NOCHAIN () {0x8;}' unless defined(&OCSP_NOCHAIN);
	eval 'sub OCSP_NOVERIFY () {0x10;}' unless defined(&OCSP_NOVERIFY);
	eval 'sub OCSP_NOEXPLICIT () {0x20;}' unless defined(&OCSP_NOEXPLICIT);
	eval 'sub OCSP_NOCASIGN () {0x40;}' unless defined(&OCSP_NOCASIGN);
	eval 'sub OCSP_NODELEGATED () {0x80;}' unless defined(&OCSP_NODELEGATED);
	eval 'sub OCSP_NOCHECKS () {0x100;}' unless defined(&OCSP_NOCHECKS);
	eval 'sub OCSP_TRUSTOTHER () {0x200;}' unless defined(&OCSP_TRUSTOTHER);
	eval 'sub OCSP_RESPID_KEY () {0x400;}' unless defined(&OCSP_RESPID_KEY);
	eval 'sub OCSP_NOTIME () {0x800;}' unless defined(&OCSP_NOTIME);
	eval 'sub OCSP_PARTIAL_CHAIN () {0x1000;}' unless defined(&OCSP_PARTIAL_CHAIN);
	eval 'sub sk_OCSP_CERTID_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_OCSP_CERTID_sk_type($sk)));
	}' unless defined(&sk_OCSP_CERTID_num);
	eval 'sub sk_OCSP_CERTID_value {
	    my($sk, $idx) = @_;
    	    eval q((( &OCSP_CERTID *) &OPENSSL_sk_value( &ossl_check_const_OCSP_CERTID_sk_type($sk), ($idx))));
	}' unless defined(&sk_OCSP_CERTID_value);
	eval 'sub sk_OCSP_CERTID_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &OCSP_CERTID) *) &OPENSSL_sk_new( &ossl_check_OCSP_CERTID_compfunc_type($cmp))));
	}' unless defined(&sk_OCSP_CERTID_new);
	eval 'sub sk_OCSP_CERTID_new_null () {
	    eval q((( &STACK_OF( &OCSP_CERTID) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_OCSP_CERTID_new_null);
	eval 'sub sk_OCSP_CERTID_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &OCSP_CERTID) *) &OPENSSL_sk_new_reserve( &ossl_check_OCSP_CERTID_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_OCSP_CERTID_new_reserve);
	eval 'sub sk_OCSP_CERTID_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_OCSP_CERTID_sk_type($sk), ($n)));
	}' unless defined(&sk_OCSP_CERTID_reserve);
	eval 'sub sk_OCSP_CERTID_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_OCSP_CERTID_sk_type($sk)));
	}' unless defined(&sk_OCSP_CERTID_free);
	eval 'sub sk_OCSP_CERTID_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_OCSP_CERTID_sk_type($sk)));
	}' unless defined(&sk_OCSP_CERTID_zero);
	eval 'sub sk_OCSP_CERTID_delete {
	    my($sk, $i) = @_;
    	    eval q((( &OCSP_CERTID *) &OPENSSL_sk_delete( &ossl_check_OCSP_CERTID_sk_type($sk), ($i))));
	}' unless defined(&sk_OCSP_CERTID_delete);
	eval 'sub sk_OCSP_CERTID_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &OCSP_CERTID *) &OPENSSL_sk_delete_ptr( &ossl_check_OCSP_CERTID_sk_type($sk),  &ossl_check_OCSP_CERTID_type($ptr))));
	}' unless defined(&sk_OCSP_CERTID_delete_ptr);
	eval 'sub sk_OCSP_CERTID_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_OCSP_CERTID_sk_type($sk),  &ossl_check_OCSP_CERTID_type($ptr)));
	}' unless defined(&sk_OCSP_CERTID_push);
	eval 'sub sk_OCSP_CERTID_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_OCSP_CERTID_sk_type($sk),  &ossl_check_OCSP_CERTID_type($ptr)));
	}' unless defined(&sk_OCSP_CERTID_unshift);
	eval 'sub sk_OCSP_CERTID_pop {
	    my($sk) = @_;
    	    eval q((( &OCSP_CERTID *) &OPENSSL_sk_pop( &ossl_check_OCSP_CERTID_sk_type($sk))));
	}' unless defined(&sk_OCSP_CERTID_pop);
	eval 'sub sk_OCSP_CERTID_shift {
	    my($sk) = @_;
    	    eval q((( &OCSP_CERTID *) &OPENSSL_sk_shift( &ossl_check_OCSP_CERTID_sk_type($sk))));
	}' unless defined(&sk_OCSP_CERTID_shift);
	eval 'sub sk_OCSP_CERTID_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_OCSP_CERTID_sk_type($sk), &ossl_check_OCSP_CERTID_freefunc_type($freefunc)));
	}' unless defined(&sk_OCSP_CERTID_pop_free);
	eval 'sub sk_OCSP_CERTID_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_OCSP_CERTID_sk_type($sk),  &ossl_check_OCSP_CERTID_type($ptr), ($idx)));
	}' unless defined(&sk_OCSP_CERTID_insert);
	eval 'sub sk_OCSP_CERTID_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &OCSP_CERTID *) &OPENSSL_sk_set( &ossl_check_OCSP_CERTID_sk_type($sk), ($idx),  &ossl_check_OCSP_CERTID_type($ptr))));
	}' unless defined(&sk_OCSP_CERTID_set);
	eval 'sub sk_OCSP_CERTID_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_OCSP_CERTID_sk_type($sk),  &ossl_check_OCSP_CERTID_type($ptr)));
	}' unless defined(&sk_OCSP_CERTID_find);
	eval 'sub sk_OCSP_CERTID_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_OCSP_CERTID_sk_type($sk),  &ossl_check_OCSP_CERTID_type($ptr)));
	}' unless defined(&sk_OCSP_CERTID_find_ex);
	eval 'sub sk_OCSP_CERTID_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_OCSP_CERTID_sk_type($sk),  &ossl_check_OCSP_CERTID_type($ptr), $pnum));
	}' unless defined(&sk_OCSP_CERTID_find_all);
	eval 'sub sk_OCSP_CERTID_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_OCSP_CERTID_sk_type($sk)));
	}' unless defined(&sk_OCSP_CERTID_sort);
	eval 'sub sk_OCSP_CERTID_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_OCSP_CERTID_sk_type($sk)));
	}' unless defined(&sk_OCSP_CERTID_is_sorted);
	eval 'sub sk_OCSP_CERTID_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &OCSP_CERTID) *) &OPENSSL_sk_dup( &ossl_check_const_OCSP_CERTID_sk_type($sk))));
	}' unless defined(&sk_OCSP_CERTID_dup);
	eval 'sub sk_OCSP_CERTID_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &OCSP_CERTID) *) &OPENSSL_sk_deep_copy( &ossl_check_const_OCSP_CERTID_sk_type($sk),  &ossl_check_OCSP_CERTID_copyfunc_type($copyfunc),  &ossl_check_OCSP_CERTID_freefunc_type($freefunc))));
	}' unless defined(&sk_OCSP_CERTID_deep_copy);
	eval 'sub sk_OCSP_CERTID_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_OCSP_CERTID_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_OCSP_CERTID_sk_type($sk),  &ossl_check_OCSP_CERTID_compfunc_type($cmp))));
	}' unless defined(&sk_OCSP_CERTID_set_cmp_func);
	eval 'sub sk_OCSP_ONEREQ_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_OCSP_ONEREQ_sk_type($sk)));
	}' unless defined(&sk_OCSP_ONEREQ_num);
	eval 'sub sk_OCSP_ONEREQ_value {
	    my($sk, $idx) = @_;
    	    eval q((( &OCSP_ONEREQ *) &OPENSSL_sk_value( &ossl_check_const_OCSP_ONEREQ_sk_type($sk), ($idx))));
	}' unless defined(&sk_OCSP_ONEREQ_value);
	eval 'sub sk_OCSP_ONEREQ_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &OCSP_ONEREQ) *) &OPENSSL_sk_new( &ossl_check_OCSP_ONEREQ_compfunc_type($cmp))));
	}' unless defined(&sk_OCSP_ONEREQ_new);
	eval 'sub sk_OCSP_ONEREQ_new_null () {
	    eval q((( &STACK_OF( &OCSP_ONEREQ) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_OCSP_ONEREQ_new_null);
	eval 'sub sk_OCSP_ONEREQ_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &OCSP_ONEREQ) *) &OPENSSL_sk_new_reserve( &ossl_check_OCSP_ONEREQ_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_OCSP_ONEREQ_new_reserve);
	eval 'sub sk_OCSP_ONEREQ_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_OCSP_ONEREQ_sk_type($sk), ($n)));
	}' unless defined(&sk_OCSP_ONEREQ_reserve);
	eval 'sub sk_OCSP_ONEREQ_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_OCSP_ONEREQ_sk_type($sk)));
	}' unless defined(&sk_OCSP_ONEREQ_free);
	eval 'sub sk_OCSP_ONEREQ_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_OCSP_ONEREQ_sk_type($sk)));
	}' unless defined(&sk_OCSP_ONEREQ_zero);
	eval 'sub sk_OCSP_ONEREQ_delete {
	    my($sk, $i) = @_;
    	    eval q((( &OCSP_ONEREQ *) &OPENSSL_sk_delete( &ossl_check_OCSP_ONEREQ_sk_type($sk), ($i))));
	}' unless defined(&sk_OCSP_ONEREQ_delete);
	eval 'sub sk_OCSP_ONEREQ_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &OCSP_ONEREQ *) &OPENSSL_sk_delete_ptr( &ossl_check_OCSP_ONEREQ_sk_type($sk),  &ossl_check_OCSP_ONEREQ_type($ptr))));
	}' unless defined(&sk_OCSP_ONEREQ_delete_ptr);
	eval 'sub sk_OCSP_ONEREQ_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_OCSP_ONEREQ_sk_type($sk),  &ossl_check_OCSP_ONEREQ_type($ptr)));
	}' unless defined(&sk_OCSP_ONEREQ_push);
	eval 'sub sk_OCSP_ONEREQ_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_OCSP_ONEREQ_sk_type($sk),  &ossl_check_OCSP_ONEREQ_type($ptr)));
	}' unless defined(&sk_OCSP_ONEREQ_unshift);
	eval 'sub sk_OCSP_ONEREQ_pop {
	    my($sk) = @_;
    	    eval q((( &OCSP_ONEREQ *) &OPENSSL_sk_pop( &ossl_check_OCSP_ONEREQ_sk_type($sk))));
	}' unless defined(&sk_OCSP_ONEREQ_pop);
	eval 'sub sk_OCSP_ONEREQ_shift {
	    my($sk) = @_;
    	    eval q((( &OCSP_ONEREQ *) &OPENSSL_sk_shift( &ossl_check_OCSP_ONEREQ_sk_type($sk))));
	}' unless defined(&sk_OCSP_ONEREQ_shift);
	eval 'sub sk_OCSP_ONEREQ_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_OCSP_ONEREQ_sk_type($sk), &ossl_check_OCSP_ONEREQ_freefunc_type($freefunc)));
	}' unless defined(&sk_OCSP_ONEREQ_pop_free);
	eval 'sub sk_OCSP_ONEREQ_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_OCSP_ONEREQ_sk_type($sk),  &ossl_check_OCSP_ONEREQ_type($ptr), ($idx)));
	}' unless defined(&sk_OCSP_ONEREQ_insert);
	eval 'sub sk_OCSP_ONEREQ_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &OCSP_ONEREQ *) &OPENSSL_sk_set( &ossl_check_OCSP_ONEREQ_sk_type($sk), ($idx),  &ossl_check_OCSP_ONEREQ_type($ptr))));
	}' unless defined(&sk_OCSP_ONEREQ_set);
	eval 'sub sk_OCSP_ONEREQ_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_OCSP_ONEREQ_sk_type($sk),  &ossl_check_OCSP_ONEREQ_type($ptr)));
	}' unless defined(&sk_OCSP_ONEREQ_find);
	eval 'sub sk_OCSP_ONEREQ_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_OCSP_ONEREQ_sk_type($sk),  &ossl_check_OCSP_ONEREQ_type($ptr)));
	}' unless defined(&sk_OCSP_ONEREQ_find_ex);
	eval 'sub sk_OCSP_ONEREQ_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_OCSP_ONEREQ_sk_type($sk),  &ossl_check_OCSP_ONEREQ_type($ptr), $pnum));
	}' unless defined(&sk_OCSP_ONEREQ_find_all);
	eval 'sub sk_OCSP_ONEREQ_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_OCSP_ONEREQ_sk_type($sk)));
	}' unless defined(&sk_OCSP_ONEREQ_sort);
	eval 'sub sk_OCSP_ONEREQ_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_OCSP_ONEREQ_sk_type($sk)));
	}' unless defined(&sk_OCSP_ONEREQ_is_sorted);
	eval 'sub sk_OCSP_ONEREQ_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &OCSP_ONEREQ) *) &OPENSSL_sk_dup( &ossl_check_const_OCSP_ONEREQ_sk_type($sk))));
	}' unless defined(&sk_OCSP_ONEREQ_dup);
	eval 'sub sk_OCSP_ONEREQ_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &OCSP_ONEREQ) *) &OPENSSL_sk_deep_copy( &ossl_check_const_OCSP_ONEREQ_sk_type($sk),  &ossl_check_OCSP_ONEREQ_copyfunc_type($copyfunc),  &ossl_check_OCSP_ONEREQ_freefunc_type($freefunc))));
	}' unless defined(&sk_OCSP_ONEREQ_deep_copy);
	eval 'sub sk_OCSP_ONEREQ_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_OCSP_ONEREQ_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_OCSP_ONEREQ_sk_type($sk),  &ossl_check_OCSP_ONEREQ_compfunc_type($cmp))));
	}' unless defined(&sk_OCSP_ONEREQ_set_cmp_func);
	eval 'sub OCSP_RESPONSE_STATUS_SUCCESSFUL () {0;}' unless defined(&OCSP_RESPONSE_STATUS_SUCCESSFUL);
	eval 'sub OCSP_RESPONSE_STATUS_MALFORMEDREQUEST () {1;}' unless defined(&OCSP_RESPONSE_STATUS_MALFORMEDREQUEST);
	eval 'sub OCSP_RESPONSE_STATUS_INTERNALERROR () {2;}' unless defined(&OCSP_RESPONSE_STATUS_INTERNALERROR);
	eval 'sub OCSP_RESPONSE_STATUS_TRYLATER () {3;}' unless defined(&OCSP_RESPONSE_STATUS_TRYLATER);
	eval 'sub OCSP_RESPONSE_STATUS_SIGREQUIRED () {5;}' unless defined(&OCSP_RESPONSE_STATUS_SIGREQUIRED);
	eval 'sub OCSP_RESPONSE_STATUS_UNAUTHORIZED () {6;}' unless defined(&OCSP_RESPONSE_STATUS_UNAUTHORIZED);
	eval 'sub V_OCSP_RESPID_NAME () {0;}' unless defined(&V_OCSP_RESPID_NAME);
	eval 'sub V_OCSP_RESPID_KEY () {1;}' unless defined(&V_OCSP_RESPID_KEY);
	eval 'sub sk_OCSP_RESPID_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_OCSP_RESPID_sk_type($sk)));
	}' unless defined(&sk_OCSP_RESPID_num);
	eval 'sub sk_OCSP_RESPID_value {
	    my($sk, $idx) = @_;
    	    eval q((( &OCSP_RESPID *) &OPENSSL_sk_value( &ossl_check_const_OCSP_RESPID_sk_type($sk), ($idx))));
	}' unless defined(&sk_OCSP_RESPID_value);
	eval 'sub sk_OCSP_RESPID_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &OCSP_RESPID) *) &OPENSSL_sk_new( &ossl_check_OCSP_RESPID_compfunc_type($cmp))));
	}' unless defined(&sk_OCSP_RESPID_new);
	eval 'sub sk_OCSP_RESPID_new_null () {
	    eval q((( &STACK_OF( &OCSP_RESPID) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_OCSP_RESPID_new_null);
	eval 'sub sk_OCSP_RESPID_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &OCSP_RESPID) *) &OPENSSL_sk_new_reserve( &ossl_check_OCSP_RESPID_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_OCSP_RESPID_new_reserve);
	eval 'sub sk_OCSP_RESPID_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_OCSP_RESPID_sk_type($sk), ($n)));
	}' unless defined(&sk_OCSP_RESPID_reserve);
	eval 'sub sk_OCSP_RESPID_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_OCSP_RESPID_sk_type($sk)));
	}' unless defined(&sk_OCSP_RESPID_free);
	eval 'sub sk_OCSP_RESPID_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_OCSP_RESPID_sk_type($sk)));
	}' unless defined(&sk_OCSP_RESPID_zero);
	eval 'sub sk_OCSP_RESPID_delete {
	    my($sk, $i) = @_;
    	    eval q((( &OCSP_RESPID *) &OPENSSL_sk_delete( &ossl_check_OCSP_RESPID_sk_type($sk), ($i))));
	}' unless defined(&sk_OCSP_RESPID_delete);
	eval 'sub sk_OCSP_RESPID_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &OCSP_RESPID *) &OPENSSL_sk_delete_ptr( &ossl_check_OCSP_RESPID_sk_type($sk),  &ossl_check_OCSP_RESPID_type($ptr))));
	}' unless defined(&sk_OCSP_RESPID_delete_ptr);
	eval 'sub sk_OCSP_RESPID_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_OCSP_RESPID_sk_type($sk),  &ossl_check_OCSP_RESPID_type($ptr)));
	}' unless defined(&sk_OCSP_RESPID_push);
	eval 'sub sk_OCSP_RESPID_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_OCSP_RESPID_sk_type($sk),  &ossl_check_OCSP_RESPID_type($ptr)));
	}' unless defined(&sk_OCSP_RESPID_unshift);
	eval 'sub sk_OCSP_RESPID_pop {
	    my($sk) = @_;
    	    eval q((( &OCSP_RESPID *) &OPENSSL_sk_pop( &ossl_check_OCSP_RESPID_sk_type($sk))));
	}' unless defined(&sk_OCSP_RESPID_pop);
	eval 'sub sk_OCSP_RESPID_shift {
	    my($sk) = @_;
    	    eval q((( &OCSP_RESPID *) &OPENSSL_sk_shift( &ossl_check_OCSP_RESPID_sk_type($sk))));
	}' unless defined(&sk_OCSP_RESPID_shift);
	eval 'sub sk_OCSP_RESPID_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_OCSP_RESPID_sk_type($sk), &ossl_check_OCSP_RESPID_freefunc_type($freefunc)));
	}' unless defined(&sk_OCSP_RESPID_pop_free);
	eval 'sub sk_OCSP_RESPID_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_OCSP_RESPID_sk_type($sk),  &ossl_check_OCSP_RESPID_type($ptr), ($idx)));
	}' unless defined(&sk_OCSP_RESPID_insert);
	eval 'sub sk_OCSP_RESPID_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &OCSP_RESPID *) &OPENSSL_sk_set( &ossl_check_OCSP_RESPID_sk_type($sk), ($idx),  &ossl_check_OCSP_RESPID_type($ptr))));
	}' unless defined(&sk_OCSP_RESPID_set);
	eval 'sub sk_OCSP_RESPID_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_OCSP_RESPID_sk_type($sk),  &ossl_check_OCSP_RESPID_type($ptr)));
	}' unless defined(&sk_OCSP_RESPID_find);
	eval 'sub sk_OCSP_RESPID_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_OCSP_RESPID_sk_type($sk),  &ossl_check_OCSP_RESPID_type($ptr)));
	}' unless defined(&sk_OCSP_RESPID_find_ex);
	eval 'sub sk_OCSP_RESPID_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_OCSP_RESPID_sk_type($sk),  &ossl_check_OCSP_RESPID_type($ptr), $pnum));
	}' unless defined(&sk_OCSP_RESPID_find_all);
	eval 'sub sk_OCSP_RESPID_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_OCSP_RESPID_sk_type($sk)));
	}' unless defined(&sk_OCSP_RESPID_sort);
	eval 'sub sk_OCSP_RESPID_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_OCSP_RESPID_sk_type($sk)));
	}' unless defined(&sk_OCSP_RESPID_is_sorted);
	eval 'sub sk_OCSP_RESPID_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &OCSP_RESPID) *) &OPENSSL_sk_dup( &ossl_check_const_OCSP_RESPID_sk_type($sk))));
	}' unless defined(&sk_OCSP_RESPID_dup);
	eval 'sub sk_OCSP_RESPID_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &OCSP_RESPID) *) &OPENSSL_sk_deep_copy( &ossl_check_const_OCSP_RESPID_sk_type($sk),  &ossl_check_OCSP_RESPID_copyfunc_type($copyfunc),  &ossl_check_OCSP_RESPID_freefunc_type($freefunc))));
	}' unless defined(&sk_OCSP_RESPID_deep_copy);
	eval 'sub sk_OCSP_RESPID_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_OCSP_RESPID_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_OCSP_RESPID_sk_type($sk),  &ossl_check_OCSP_RESPID_compfunc_type($cmp))));
	}' unless defined(&sk_OCSP_RESPID_set_cmp_func);
	eval 'sub V_OCSP_CERTSTATUS_GOOD () {0;}' unless defined(&V_OCSP_CERTSTATUS_GOOD);
	eval 'sub V_OCSP_CERTSTATUS_REVOKED () {1;}' unless defined(&V_OCSP_CERTSTATUS_REVOKED);
	eval 'sub V_OCSP_CERTSTATUS_UNKNOWN () {2;}' unless defined(&V_OCSP_CERTSTATUS_UNKNOWN);
	eval 'sub sk_OCSP_SINGLERESP_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_OCSP_SINGLERESP_sk_type($sk)));
	}' unless defined(&sk_OCSP_SINGLERESP_num);
	eval 'sub sk_OCSP_SINGLERESP_value {
	    my($sk, $idx) = @_;
    	    eval q((( &OCSP_SINGLERESP *) &OPENSSL_sk_value( &ossl_check_const_OCSP_SINGLERESP_sk_type($sk), ($idx))));
	}' unless defined(&sk_OCSP_SINGLERESP_value);
	eval 'sub sk_OCSP_SINGLERESP_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &OCSP_SINGLERESP) *) &OPENSSL_sk_new( &ossl_check_OCSP_SINGLERESP_compfunc_type($cmp))));
	}' unless defined(&sk_OCSP_SINGLERESP_new);
	eval 'sub sk_OCSP_SINGLERESP_new_null () {
	    eval q((( &STACK_OF( &OCSP_SINGLERESP) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_OCSP_SINGLERESP_new_null);
	eval 'sub sk_OCSP_SINGLERESP_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &OCSP_SINGLERESP) *) &OPENSSL_sk_new_reserve( &ossl_check_OCSP_SINGLERESP_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_OCSP_SINGLERESP_new_reserve);
	eval 'sub sk_OCSP_SINGLERESP_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_OCSP_SINGLERESP_sk_type($sk), ($n)));
	}' unless defined(&sk_OCSP_SINGLERESP_reserve);
	eval 'sub sk_OCSP_SINGLERESP_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_OCSP_SINGLERESP_sk_type($sk)));
	}' unless defined(&sk_OCSP_SINGLERESP_free);
	eval 'sub sk_OCSP_SINGLERESP_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_OCSP_SINGLERESP_sk_type($sk)));
	}' unless defined(&sk_OCSP_SINGLERESP_zero);
	eval 'sub sk_OCSP_SINGLERESP_delete {
	    my($sk, $i) = @_;
    	    eval q((( &OCSP_SINGLERESP *) &OPENSSL_sk_delete( &ossl_check_OCSP_SINGLERESP_sk_type($sk), ($i))));
	}' unless defined(&sk_OCSP_SINGLERESP_delete);
	eval 'sub sk_OCSP_SINGLERESP_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &OCSP_SINGLERESP *) &OPENSSL_sk_delete_ptr( &ossl_check_OCSP_SINGLERESP_sk_type($sk),  &ossl_check_OCSP_SINGLERESP_type($ptr))));
	}' unless defined(&sk_OCSP_SINGLERESP_delete_ptr);
	eval 'sub sk_OCSP_SINGLERESP_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_OCSP_SINGLERESP_sk_type($sk),  &ossl_check_OCSP_SINGLERESP_type($ptr)));
	}' unless defined(&sk_OCSP_SINGLERESP_push);
	eval 'sub sk_OCSP_SINGLERESP_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_OCSP_SINGLERESP_sk_type($sk),  &ossl_check_OCSP_SINGLERESP_type($ptr)));
	}' unless defined(&sk_OCSP_SINGLERESP_unshift);
	eval 'sub sk_OCSP_SINGLERESP_pop {
	    my($sk) = @_;
    	    eval q((( &OCSP_SINGLERESP *) &OPENSSL_sk_pop( &ossl_check_OCSP_SINGLERESP_sk_type($sk))));
	}' unless defined(&sk_OCSP_SINGLERESP_pop);
	eval 'sub sk_OCSP_SINGLERESP_shift {
	    my($sk) = @_;
    	    eval q((( &OCSP_SINGLERESP *) &OPENSSL_sk_shift( &ossl_check_OCSP_SINGLERESP_sk_type($sk))));
	}' unless defined(&sk_OCSP_SINGLERESP_shift);
	eval 'sub sk_OCSP_SINGLERESP_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_OCSP_SINGLERESP_sk_type($sk), &ossl_check_OCSP_SINGLERESP_freefunc_type($freefunc)));
	}' unless defined(&sk_OCSP_SINGLERESP_pop_free);
	eval 'sub sk_OCSP_SINGLERESP_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_OCSP_SINGLERESP_sk_type($sk),  &ossl_check_OCSP_SINGLERESP_type($ptr), ($idx)));
	}' unless defined(&sk_OCSP_SINGLERESP_insert);
	eval 'sub sk_OCSP_SINGLERESP_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &OCSP_SINGLERESP *) &OPENSSL_sk_set( &ossl_check_OCSP_SINGLERESP_sk_type($sk), ($idx),  &ossl_check_OCSP_SINGLERESP_type($ptr))));
	}' unless defined(&sk_OCSP_SINGLERESP_set);
	eval 'sub sk_OCSP_SINGLERESP_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_OCSP_SINGLERESP_sk_type($sk),  &ossl_check_OCSP_SINGLERESP_type($ptr)));
	}' unless defined(&sk_OCSP_SINGLERESP_find);
	eval 'sub sk_OCSP_SINGLERESP_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_OCSP_SINGLERESP_sk_type($sk),  &ossl_check_OCSP_SINGLERESP_type($ptr)));
	}' unless defined(&sk_OCSP_SINGLERESP_find_ex);
	eval 'sub sk_OCSP_SINGLERESP_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_OCSP_SINGLERESP_sk_type($sk),  &ossl_check_OCSP_SINGLERESP_type($ptr), $pnum));
	}' unless defined(&sk_OCSP_SINGLERESP_find_all);
	eval 'sub sk_OCSP_SINGLERESP_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_OCSP_SINGLERESP_sk_type($sk)));
	}' unless defined(&sk_OCSP_SINGLERESP_sort);
	eval 'sub sk_OCSP_SINGLERESP_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_OCSP_SINGLERESP_sk_type($sk)));
	}' unless defined(&sk_OCSP_SINGLERESP_is_sorted);
	eval 'sub sk_OCSP_SINGLERESP_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &OCSP_SINGLERESP) *) &OPENSSL_sk_dup( &ossl_check_const_OCSP_SINGLERESP_sk_type($sk))));
	}' unless defined(&sk_OCSP_SINGLERESP_dup);
	eval 'sub sk_OCSP_SINGLERESP_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &OCSP_SINGLERESP) *) &OPENSSL_sk_deep_copy( &ossl_check_const_OCSP_SINGLERESP_sk_type($sk),  &ossl_check_OCSP_SINGLERESP_copyfunc_type($copyfunc),  &ossl_check_OCSP_SINGLERESP_freefunc_type($freefunc))));
	}' unless defined(&sk_OCSP_SINGLERESP_deep_copy);
	eval 'sub sk_OCSP_SINGLERESP_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_OCSP_SINGLERESP_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_OCSP_SINGLERESP_sk_type($sk),  &ossl_check_OCSP_SINGLERESP_compfunc_type($cmp))));
	}' unless defined(&sk_OCSP_SINGLERESP_set_cmp_func);
	eval 'sub PEM_STRING_OCSP_REQUEST () {"OCSP REQUEST";}' unless defined(&PEM_STRING_OCSP_REQUEST);
	eval 'sub PEM_STRING_OCSP_RESPONSE () {"OCSP RESPONSE";}' unless defined(&PEM_STRING_OCSP_RESPONSE);
	eval 'sub d2i_OCSP_REQUEST_bio {
	    my($bp,$p) = @_;
    	    eval q( &ASN1_d2i_bio_of( &OCSP_REQUEST, &OCSP_REQUEST_new, &d2i_OCSP_REQUEST,$bp,$p));
	}' unless defined(&d2i_OCSP_REQUEST_bio);
	eval 'sub d2i_OCSP_RESPONSE_bio {
	    my($bp,$p) = @_;
    	    eval q( &ASN1_d2i_bio_of( &OCSP_RESPONSE, &OCSP_RESPONSE_new, &d2i_OCSP_RESPONSE,$bp,$p));
	}' unless defined(&d2i_OCSP_RESPONSE_bio);
	eval 'sub PEM_read_bio_OCSP_REQUEST {
	    my($bp,$x,$cb) = @_;
    	    eval q(( &OCSP_REQUEST *) &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_OCSP_REQUEST, &PEM_STRING_OCSP_REQUEST, $bp,($x),$cb, &NULL));
	}' unless defined(&PEM_read_bio_OCSP_REQUEST);
	eval 'sub PEM_read_bio_OCSP_RESPONSE {
	    my($bp,$x,$cb) = @_;
    	    eval q(( &OCSP_RESPONSE *) &PEM_ASN1_read_bio( (\'char\' *(*)()) &d2i_OCSP_RESPONSE, &PEM_STRING_OCSP_RESPONSE, $bp,($x),$cb, &NULL));
	}' unless defined(&PEM_read_bio_OCSP_RESPONSE);
	eval 'sub PEM_write_bio_OCSP_REQUEST {
	    my($bp,$o) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_OCSP_REQUEST, &PEM_STRING_OCSP_REQUEST, $bp,($o),  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_bio_OCSP_REQUEST);
	eval 'sub PEM_write_bio_OCSP_RESPONSE {
	    my($bp,$o) = @_;
    	    eval q( &PEM_ASN1_write_bio(( &int (*)()) &i2d_OCSP_RESPONSE, &PEM_STRING_OCSP_RESPONSE, $bp,($o),  &NULL, &NULL,0, &NULL, &NULL));
	}' unless defined(&PEM_write_bio_OCSP_RESPONSE);
	eval 'sub i2d_OCSP_RESPONSE_bio {
	    my($bp,$o) = @_;
    	    eval q( &ASN1_i2d_bio_of( &OCSP_RESPONSE, &i2d_OCSP_RESPONSE,$bp,$o));
	}' unless defined(&i2d_OCSP_RESPONSE_bio);
	eval 'sub i2d_OCSP_REQUEST_bio {
	    my($bp,$o) = @_;
    	    eval q( &ASN1_i2d_bio_of( &OCSP_REQUEST, &i2d_OCSP_REQUEST,$bp,$o));
	}' unless defined(&i2d_OCSP_REQUEST_bio);
	eval 'sub ASN1_BIT_STRING_digest {
	    my($data,$type,$md,$len) = @_;
    	    eval q( &ASN1_item_digest( &ASN1_ITEM_rptr( &ASN1_BIT_STRING),$type,$data,$md,$len));
	}' unless defined(&ASN1_BIT_STRING_digest);
	eval 'sub OCSP_CERTSTATUS_dup {
	    my($cs) = @_;
    	    eval q(( &OCSP_CERTSTATUS*) &ASN1_dup(( &i2d_of_void *) &i2d_OCSP_CERTSTATUS, ( &d2i_of_void *) &d2i_OCSP_CERTSTATUS,($cs)));
	}' unless defined(&OCSP_CERTSTATUS_dup);
	unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	    eval 'sub OCSP_REQ_CTX_new {
	        my($io, $buf_size) = @_;
    		eval q( &OSSL_HTTP_REQ_CTX_new($io, $io, $buf_size));
	    }' unless defined(&OCSP_REQ_CTX_new);
	    eval 'sub OCSP_REQ_CTX_free () { &OSSL_HTTP_REQ_CTX_free;}' unless defined(&OCSP_REQ_CTX_free);
	    eval 'sub OCSP_REQ_CTX_http {
	        my($rctx, $op, $path) = @_;
    		eval q(( &OSSL_HTTP_REQ_CTX_set_expected($rctx,  &NULL, 1, 0, 0)  &&  &OSSL_HTTP_REQ_CTX_set_request_line($rctx,  &strcmp($op, \\"POST\\") == 0,  &NULL,  &NULL, $path)));
	    }' unless defined(&OCSP_REQ_CTX_http);
	    eval 'sub OCSP_REQ_CTX_add1_header () { &OSSL_HTTP_REQ_CTX_add1_header;}' unless defined(&OCSP_REQ_CTX_add1_header);
	    eval 'sub OCSP_REQ_CTX_i2d {
	        my($r, $it, $req) = @_;
    		eval q( &OSSL_HTTP_REQ_CTX_set1_req($r, \\"application/ocsp-request\\", $it, $req));
	    }' unless defined(&OCSP_REQ_CTX_i2d);
	    eval 'sub OCSP_REQ_CTX_set1_req {
	        my($r, $req) = @_;
    		eval q( &OCSP_REQ_CTX_i2d($r,  &ASN1_ITEM_rptr( &OCSP_REQUEST), ( &ASN1_VALUE *)($req)));
	    }' unless defined(&OCSP_REQ_CTX_set1_req);
	    eval 'sub OCSP_REQ_CTX_nbio () { &OSSL_HTTP_REQ_CTX_nbio;}' unless defined(&OCSP_REQ_CTX_nbio);
	    eval 'sub OCSP_REQ_CTX_nbio_d2i () { &OSSL_HTTP_REQ_CTX_nbio_d2i;}' unless defined(&OCSP_REQ_CTX_nbio_d2i);
	    eval 'sub OCSP_sendreq_nbio {
	        my($p, $r) = @_;
    		eval q( &OSSL_HTTP_REQ_CTX_nbio_d2i($r, ( &ASN1_VALUE **)($p),  &ASN1_ITEM_rptr( &OCSP_RESPONSE)));
	    }' unless defined(&OCSP_sendreq_nbio);
	    eval 'sub OCSP_REQ_CTX_get0_mem_bio () { &OSSL_HTTP_REQ_CTX_get0_mem_bio;}' unless defined(&OCSP_REQ_CTX_get0_mem_bio);
	    eval 'sub OCSP_set_max_response_length () { &OSSL_HTTP_REQ_CTX_set_max_response_length;}' unless defined(&OCSP_set_max_response_length);
	}
	eval 'sub OCSP_parse_url {
	    my($url, $host, $port, $path, $ssl) = @_;
    	    eval q( &OSSL_HTTP_parse_url($url, $ssl,  &NULL, $host, $port,  &NULL, $path,  &NULL,  &NULL));
	}' unless defined(&OCSP_parse_url);
	if(defined(&__cplusplus)) {
	}
    }
}
1;
