require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UFS_LFS_LFS_INODE_H_)) {
    eval 'sub _UFS_LFS_LFS_INODE_H_ () {1;}' unless defined(&_UFS_LFS_LFS_INODE_H_);
    require 'miscfs/genfs/genfs_node.ph';
    require 'ufs/lfs/lfs.ph';
    eval 'sub MIN_FREE_SEGS () {20;}' unless defined(&MIN_FREE_SEGS);
    eval 'sub MIN_RESV_SEGS () {15;}' unless defined(&MIN_RESV_SEGS);
    eval 'sub ULFS_MAXQUOTAS () {2;}' unless defined(&ULFS_MAXQUOTAS);
    eval 'sub ULFS_USRQUOTA () {0;}' unless defined(&ULFS_USRQUOTA);
    eval 'sub ULFS_GRPQUOTA () {1;}' unless defined(&ULFS_GRPQUOTA);
    eval 'sub ULFS_CHECK_CRAPCOUNTER {
        my($dp) = @_;
	    eval q((( &void)($dp)-> &i_crapcounter));
    }' unless defined(&ULFS_CHECK_CRAPCOUNTER);
    eval 'sub IN_ACCESS () {0x1;}' unless defined(&IN_ACCESS);
    eval 'sub IN_CHANGE () {0x2;}' unless defined(&IN_CHANGE);
    eval 'sub IN_UPDATE () {0x4;}' unless defined(&IN_UPDATE);
    eval 'sub IN_MODIFY () {0x2000;}' unless defined(&IN_MODIFY);
    eval 'sub IN_MODIFIED () {0x8;}' unless defined(&IN_MODIFIED);
    eval 'sub IN_ACCESSED () {0x10;}' unless defined(&IN_ACCESSED);
    eval 'sub IN_SHLOCK () {0x40;}' unless defined(&IN_SHLOCK);
    eval 'sub IN_EXLOCK () {0x80;}' unless defined(&IN_EXLOCK);
    eval 'sub IN_CLEANING () {0x100;}' unless defined(&IN_CLEANING);
    eval 'sub IN_ADIROP () {0x200;}' unless defined(&IN_ADIROP);
    eval 'sub IN_PAGING () {0x1000;}' unless defined(&IN_PAGING);
    eval 'sub IN_CDIROP () {0x4000;}' unless defined(&IN_CDIROP);
    eval 'sub IN_MARKER () {0x10000;}' unless defined(&IN_MARKER);
    eval 'sub IN_ALLMOD () {( &IN_MODIFIED| &IN_ACCESS| &IN_CHANGE| &IN_UPDATE| &IN_MODIFY| &IN_ACCESSED| &IN_CLEANING);}' unless defined(&IN_ALLMOD);
    eval 'sub LFSI_NO_GOP_WRITE () {0x1;}' unless defined(&LFSI_NO_GOP_WRITE);
    eval 'sub LFSI_DELETED () {0x2;}' unless defined(&LFSI_DELETED);
    eval 'sub LFSI_WRAPBLOCK () {0x4;}' unless defined(&LFSI_WRAPBLOCK);
    eval 'sub LFSI_WRAPWAIT () {0x8;}' unless defined(&LFSI_WRAPWAIT);
    eval 'sub LFSI_BMAP () {0x10;}' unless defined(&LFSI_BMAP);
    if(defined(&_KERNEL)) {
    }
    eval 'sub i_lfs_osize () { ($inode_ext->{lfs}->{lfs_osize});}' unless defined(&i_lfs_osize);
    eval 'sub i_lfs_effnblks () { ($inode_ext->{lfs}->{lfs_effnblocks});}' unless defined(&i_lfs_effnblks);
    eval 'sub i_lfs_fragsize () { ($inode_ext->{lfs}->{lfs_fragsize});}' unless defined(&i_lfs_fragsize);
    eval 'sub i_lfs_dchain () { ($inode_ext->{lfs}->{lfs_dchain});}' unless defined(&i_lfs_dchain);
    eval 'sub i_lfs_pchain () { ($inode_ext->{lfs}->{lfs_pchain});}' unless defined(&i_lfs_pchain);
    eval 'sub i_lfs_iflags () { ($inode_ext->{lfs}->{lfs_iflags});}' unless defined(&i_lfs_iflags);
    eval 'sub i_lfs_hiblk () { ($inode_ext->{lfs}->{lfs_hiblk});}' unless defined(&i_lfs_hiblk);
    eval 'sub i_lfs_lbtree () { ($inode_ext->{lfs}->{lfs_lbtree});}' unless defined(&i_lfs_lbtree);
    eval 'sub i_lfs_nbtree () { ($inode_ext->{lfs}->{lfs_nbtree});}' unless defined(&i_lfs_nbtree);
    eval 'sub i_lfs_segdhd () { ($inode_ext->{lfs}->{lfs_segdhd});}' unless defined(&i_lfs_segdhd);
    eval 'sub i_lfs_odnlink () { ($inode_ext->{lfs}->{lfs_odnlink});}' unless defined(&i_lfs_odnlink);
    if(defined(&_KERNEL)) {
	eval 'sub LFS_IS_MALLOC_BUF {
	    my($bp) = @_;
    	    eval q((($bp)-> &b_iodone ==  &lfs_free_aiodone));
	}' unless defined(&LFS_IS_MALLOC_BUF);
	if(defined(&DEBUG)) {
	    eval 'sub LFS_BWRITE_LOG {
	        my($bp) = @_;
    		eval q( &lfs_bwrite_log(($bp),  &__FILE__,  &__LINE__));
	    }' unless defined(&LFS_BWRITE_LOG);
	    eval 'sub LFS_ENTER_LOG {
	        my($theop, $thefile, $theline, $lbn, $theflags, $thepid) = @_;
    		eval q( &do {  &mutex_enter( &lfs_lock);  ($lfs_log[&lfs_lognum]->{op}) = $theop;  ($lfs_log[&lfs_lognum]->{file}) = $thefile;  ($lfs_log[&lfs_lognum]->{line}) = ($theline);  ($lfs_log[&lfs_lognum]->{pid}) = ($thepid);  ($lfs_log[&lfs_lognum]->{block}) = ($lbn);  ($lfs_log[&lfs_lognum]->{flags}) = ($theflags);  &lfs_lognum = ( &lfs_lognum + 1) %  &LFS_LOGLENGTH;  &mutex_exit( &lfs_lock); }  &while (0));
	    }' unless defined(&LFS_ENTER_LOG);
	    eval 'sub DLOG_RF () {0;}' unless defined(&DLOG_RF);
	    eval 'sub DLOG_ALLOC () {1;}' unless defined(&DLOG_ALLOC);
	    eval 'sub DLOG_AVAIL () {2;}' unless defined(&DLOG_AVAIL);
	    eval 'sub DLOG_FLUSH () {3;}' unless defined(&DLOG_FLUSH);
	    eval 'sub DLOG_LLIST () {4;}' unless defined(&DLOG_LLIST);
	    eval 'sub DLOG_WVNODE () {5;}' unless defined(&DLOG_WVNODE);
	    eval 'sub DLOG_VNODE () {6;}' unless defined(&DLOG_VNODE);
	    eval 'sub DLOG_SEG () {7;}' unless defined(&DLOG_SEG);
	    eval 'sub DLOG_SU () {8;}' unless defined(&DLOG_SU);
	    eval 'sub DLOG_CLEAN () {9;}' unless defined(&DLOG_CLEAN);
	    eval 'sub DLOG_MOUNT () {10;}' unless defined(&DLOG_MOUNT);
	    eval 'sub DLOG_PAGE () {11;}' unless defined(&DLOG_PAGE);
	    eval 'sub DLOG_DIROP () {12;}' unless defined(&DLOG_DIROP);
	    eval 'sub DLOG_MALLOC () {13;}' unless defined(&DLOG_MALLOC);
	    eval 'sub DLOG_MAX () {14;}' unless defined(&DLOG_MAX);
	    eval 'sub DLOG {
	        my($a) = @_;
    		eval q( &lfs_debug_log $a);
	    }' unless defined(&DLOG);
	} else {
	    eval 'sub LFS_BCLEAN_LOG {
	        my($fs, $bp) = @_;
    		eval q();
	    }' unless defined(&LFS_BCLEAN_LOG);
	    eval 'sub LFS_BWRITE_LOG {
	        my($bp) = @_;
    		eval q( &VOP_BWRITE(($bp)-> &b_vp, ($bp)));
	    }' unless defined(&LFS_BWRITE_LOG);
	    eval 'sub LFS_ENTER_LOG {
	        my($theop, $thefile, $theline, $lbn, $theflags, $thepid) = @_;
    		eval q( &__nothing);
	    }' unless defined(&LFS_ENTER_LOG);
	    eval 'sub DLOG {
	        my($a) = @_;
    		eval q();
	    }' unless defined(&DLOG);
	}
    } else {
	eval 'sub LFS_BWRITE_LOG {
	    my($bp) = @_;
    	    eval q( &VOP_BWRITE(($bp)));
	}' unless defined(&LFS_BWRITE_LOG);
    }
}
1;
