/* example1.c -- This example shows how to use pgraf to make simple plots using
 * different symbol and line types.
 */
#include <stdio.h>
#include <math.h>
#include "pgraf.h"
#define SIZE 15
int i;
float x[SIZE],y[SIZE];

main()
{
/* set up x  values of all points */
  for (i = 0; i < SIZE; i++) {
    x[i] = i + 1;
  }
/* initial calls */
  gopen();
  gclear();   /* both mandatory */
/* set up two windows */
  window(1,0.,15.,0.,8.);   /* where we do the plotting */
  window(2,0.,15.,8.,10.);   /* for labels */
/* make a label in second window */
/* note that default window range is 0-1 on both x and y */
  label(2,.1,.5,"Example of simple graph drawing with pgraf");
/* draw axes in first window */
/* this also sets window space range to 0:16 on x and -2:2 on y */
/* notice that the number of tics includes the invisible ones on the ends */
/* thus, 9 tics on x yields a tic spacing of (16 - 0)/(9 - 1) = 2 */
  axes(1,0.,16.,9,"x-axis",-2.,2.,5,"y-axis");
/* set up sin function */
  for (i = 0; i < SIZE; i++) {
    y[i] = sin(x[i]);
  }
/* plot with a solid line and put crosses */
  line(1,1,SIZE,x,y);
  for (i = 0; i < SIZE; i++) {
    mark(1,1,x[i],y[i],1.);
  }
/* set up polynomial function */
  for (i = 0; i < SIZE; i++) {
    y[i] = x[i]/6. - x[i]*x[i]/150.;
  }
/* plot with a dotted line and smaller squares */
  line(1,3,SIZE,x,y);
  for (i = 0; i < SIZE; i++) {
    mark(1,3,x[i],y[i],.5);
  }
/* finish up */
  gpause();
  gclose();   /* both mandatory */
}
