<?php

/**
 * OrangeHRM is a comprehensive Human Resource Management (HRM) System that captures
 * all the essential functionalities required for any enterprise.
 * Copyright (C) 2006 OrangeHRM Inc., http://www.orangehrm.com
 *
 * OrangeHRM is free software; you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * OrangeHRM is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program;
 * if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA
 */

/**
 * Description of LikedOrSharedEmployeeForm
 *
 * @author nirmal
 */
class LikedOrSharedEmployeeForm extends BaseForm {

    public function configure() {
        $this->setWidgets($this->getWidgets());
        $this->setValidators($this->getValidators());
        $this->widgetSchema->setNameFormat($this->getNameFormat());
    }

    public function getWidgets() {
        $widgets = array(
            'id' => new sfWidgetFormInputHidden(),
            'type' => new sfWidgetFormInputHidden(),
            'event' => new sfWidgetFormInputHidden()
        );
        return $widgets;
    }

    public function getValidators() {
        $validators = array(
            'id' => new sfValidatorString(array('required' => false)),
            'type' => new sfValidatorString(array('required' => false)),
            'event' => new sfValidatorString(array('required' => false))
        );
        return $validators;
    }

    public function getNameFormat() {
        return 'likedOrSharedEmployeeForm[%s]';
    }

}
