# Generated by Django 1.11.12 on 2018-04-11 05:16

from django.db import migrations
import filer.fields.image


def migrate_to_filer(apps, schema_editor):
    from filer.models import Image

    GalleryImage = apps.get_model('cmsplugin_gallery', 'Image')
    images = GalleryImage.objects.all()

    try:
        for image in images:
            if image.src:
                image_src = Image.objects.get_or_create(
                            file=image.src.file,
                            defaults={
                                'name': image.src.name
                            }
                )[0]

                images.filter(pk=image.pk).update(image_src=image_src)
    except Exception as e:
        print(e)

class Migration(migrations.Migration):

    dependencies = [
        ('cmsplugin_gallery', '0005_auto_20180411_1046'),
    ]

    operations = [
            migrations.RunPython(migrate_to_filer)
    ]
