# This script is meant for converting the mirc servers.ini file into QuIRC
# format.  The servers.ini file has a huge list of current servers and can be
# obtained from http://www.mirc.co.uk/servers.ini.  Note that it only uses
# the first port number from the server file.  If you want alternative ports,
# add the servers in yourself.

#-Include port range in description field
#-Check to see if default port (6667) is in port range, if so, do not include
#-port number.
if { [llength $argv]!=1 } {
    puts "usage: tclsh mircservers.tcl mirc_servers.ini"
    exit 1;
}

set infile [open [lindex $argv 0] "RDONLY"]

while { ![eof $infile] } {
    gets $infile theline
    if { [string match "*=*" $theline] } {
	set data [lindex [split $theline "="] 1]
	regexp "(.*)SERVER:(.*)" $data junk desc data
	regexp "(.*)GROUP:(.*)" $data junk servport network
	set server [lindex [split $servport ":"] 0]
	set port [lindex [split $servport ":"] 1]	
	set port [lindex [split $port ","] 0]
	set port [lindex [split $port "-"] 0]
	set network [lindex [split $desc ":"] 0]
	set desc [string trim [lindex [split $desc ":"] 1]]
	if {$desc==""} { set desc $network; set network "-Random" }
	puts "$network/$server:$port ($desc)"
    }
}
