/*****
 NAME
 	pxmlutil.h - protocol definition for the parser of XML classes
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(PXMLUTIL_H_INCLUDED)
#define PXMLUTIL_H_INCLUDED

#include <coconut/pxmltree.h>

@protocol PXMLTable <PObject>

 - (id <PXMLTree>) newXmlDocument: (const char *) fname ;
 - (id <PXMLTree>) newHtmlDocument: (const char *) fname ;

 - (id <PXMLTree>) loadXmlDocument: (const char *) fname validate: 
     (boolean) dovalidate ;
 - (id <PXMLTree>) loadHtmlDocument: (const char *) fname validate:
     (boolean) dovalidate ;

   /* save the xml data which is given the output file names */
 - (id <PError>) saveAll ;

 - (id <PXMLTree>) searchByInputFileName: (const char *) name ;
 - (id <PXMLTree>) searchByOutputFileName: (const char *) name ;

   /* return the file name which contains the "node" data.
      if the node is nil, the NULL pointer is returned. */
 - (id <PBasicStr>) searchInputFileNameByNode: (id <PXMLNode>) node ;
 - (id <PBasicStr>) searchOutputFileNameByNode: (id <PXMLNode>) node ;

@end

#endif /* !defined(PXMLUTIL_H_INCLUDED) */

