define("core/local/process_monitor/processqueue",["exports","core/utils","core/local/process_monitor/loadingprocess","core/log"],(function(_exports,_utils,_loadingprocess,_log){var obj;function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.ProcessQueue=void 0,_log=(obj=_log)&&obj.__esModule?obj:{default:obj};_exports.ProcessQueue=
/**
   * A process queue manager.
   *
   * Adding process to the queue will guarante process are executed in sequence.
   *
   * @module     core/local/process_monitor/processqueue
   * @class      ProcessQueue
   * @copyright  2022 Ferran Recio <ferran@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
class{constructor(manager){_defineProperty(this,"pending",[]),_defineProperty(this,"currentProcess",null),this.manager=manager,this.cleanFinishedProcesses=(0,_utils.debounce)((()=>manager.dispatch("cleanFinishedProcesses")),3e3)}addPending(processName,processor){const process=new _loadingprocess.LoadingProcess(this.manager,{name:processName});process.setExtraData({processor:processor}),process.onFinish((uploadedFile=>{var _this$currentProcess;(null===(_this$currentProcess=this.currentProcess)||void 0===_this$currentProcess?void 0:_this$currentProcess.id)===uploadedFile.id&&this._discardCurrent()})),this.pending.push(process),this._continueProcessing()}addError(processName,errorMessage){new _loadingprocess.LoadingProcess(this.manager,{name:processName}).setError(errorMessage)}_discardCurrent(){this.currentProcess&&(this.currentProcess=null),this.cleanFinishedProcesses(),this._continueProcessing()}_currentProcessor(){return this.currentProcess.data.processor}async _continueProcessing(){if(null===this.currentProcess&&0!==this.pending.length){this.currentProcess=this.pending.shift();try{const processor=this._currentProcessor();await processor(this.currentProcess)}catch(error){this.currentProcess.setError(error.message),_log.default.error(error)}}}}}));

//# sourceMappingURL=processqueue.min.js.map