/* surface -- example of a perspective surface plot */
#include <stdio.h>
#include <math.h>

#define NX 21
#define NY 15
#define DX 0.5
#define DY 0.5
#define I(ix,iy) (NY*(ix) + (iy))

static float field[NX*NY];
static float xx[NX],yy[NY];

main(argc,argv)
int argc;
char *argv[];
{
  int ix,iy;
  float radius,x,y;

  for (ix = 0; ix < NX; ix++) {
    for (iy = 0; iy < NY; iy++) {
      x = ix*DX;
      y = iy*DY;
      xx[ix] = x;
      yy[iy] = y;
      radius = pow(x*x + y*y,0.5);
      field[I(ix,iy)] = cos(radius);
    }
  }

  gopen();
  gclear();
  window(1,0.,15.,0.,10.);
  pview(1,40.,20.,10.,5.,3.5,0.,4.);
  paxes(1,0.,10.,1.,"xxx",0.,7.,1.,"yyy",0.,2.,1.,"zzz");
  psurface(1,NX,NY,5,field,xx,yy);
  gpause();
  gclose();
}
