/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.NIOServerSocket;
import gnu.java.nio.NIOSocket;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;

public final class ServerSocketChannelImpl
extends ServerSocketChannel {
    private NIOServerSocket serverSocket = new NIOServerSocket(this);
    private boolean connected;

    public final void finalizer() {
        if (this.connected) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final void implCloseSelectableChannel() throws IOException {
        this.connected = false;
        this.serverSocket.close();
    }

    protected final void implConfigureBlocking(boolean blocking) throws IOException {
        this.serverSocket.setSoTimeout(blocking ? 0 : 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SocketChannel accept() throws IOException {
        SocketChannel socketChannel;
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.serverSocket.isBound()) {
            throw new NotYetBoundException();
        }
        boolean completed = false;
        try {
            this.begin();
            this.serverSocket.getPlainSocketImpl().setInChannelOperation(true);
            NIOSocket socket = (NIOSocket)this.serverSocket.accept();
            completed = true;
            socketChannel = socket.getChannel();
            Object var3_6 = null;
            this.serverSocket.getPlainSocketImpl().setInChannelOperation(false);
        }
        catch (SocketTimeoutException e) {
            SocketChannel socketChannel2;
            try {
                socketChannel2 = null;
                Object var3_7 = null;
                this.serverSocket.getPlainSocketImpl().setInChannelOperation(false);
            }
            catch (Throwable throwable) {
                Object var3_8 = null;
                this.serverSocket.getPlainSocketImpl().setInChannelOperation(false);
                this.end(completed);
                throw throwable;
            }
            this.end(completed);
            return socketChannel2;
        }
        this.end(completed);
        return socketChannel;
    }

    public final ServerSocket socket() {
        return this.serverSocket;
    }

    protected ServerSocketChannelImpl(SelectorProvider provider) throws IOException {
        super(provider);
        this.configureBlocking(true);
    }
}

