/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

final class UTF_16Decoder
extends CharsetDecoder {
    static final int BIG_ENDIAN = 0;
    static final int LITTLE_ENDIAN = 1;
    static final int UNKNOWN_ENDIAN = 2;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private static final char REVERSED_BYTE_ORDER_MARK = '\ufffe';
    private final int originalByteOrder;
    private int byteOrder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        CoderResult coderResult;
        int inPos;
        block13: {
            CoderResult coderResult2;
            block17: {
                CoderResult coderResult3;
                block16: {
                    CoderResult coderResult4;
                    block15: {
                        CoderResult coderResult5;
                        inPos = in.position();
                        try {
                            while (true) {
                                char c;
                                if (in.remaining() < 2) {
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block13;
                                }
                                byte b1 = in.get();
                                byte b2 = in.get();
                                if (this.byteOrder == 2) {
                                    c = (char)((b1 & 0xFF) << 8 | b2 & 0xFF);
                                    if (c == '\ufeff') {
                                        this.byteOrder = 0;
                                        inPos += 2;
                                        continue;
                                    }
                                    if (c == '\ufffe') {
                                        this.byteOrder = 1;
                                        inPos += 2;
                                        continue;
                                    }
                                    this.byteOrder = 0;
                                }
                                char c2 = c = this.byteOrder == 0 ? (char)((b1 & 0xFF) << 8 | b2 & 0xFF) : (char)((b2 & 0xFF) << 8 | b1 & 0xFF);
                                if ('\ud800' <= c && c <= '\udfff') {
                                    char d;
                                    if (c > '\udbff') {
                                        coderResult5 = CoderResult.malformedForLength(2);
                                        Object var5_15 = null;
                                        break;
                                    }
                                    if (in.remaining() < 2) {
                                        coderResult4 = CoderResult.UNDERFLOW;
                                        break block15;
                                    }
                                    byte b3 = in.get();
                                    byte b4 = in.get();
                                    char c3 = d = this.byteOrder == 0 ? (char)((b3 & 0xFF) << 8 | b4 & 0xFF) : (char)((b4 & 0xFF) << 8 | b3 & 0xFF);
                                    if (d < '\udc00' || d > '\udfff') {
                                        coderResult3 = CoderResult.malformedForLength(2);
                                        break block16;
                                    } else {
                                        out.put(c);
                                        out.put(d);
                                        inPos += 4;
                                        continue;
                                    }
                                }
                                if (!out.hasRemaining()) {
                                    coderResult2 = CoderResult.UNDERFLOW;
                                    break block17;
                                }
                                out.put(c);
                                inPos += 2;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var5_20 = null;
                            in.position(inPos);
                            throw throwable;
                        }
                        in.position(inPos);
                        return coderResult5;
                    }
                    Object var5_16 = null;
                    in.position(inPos);
                    return coderResult4;
                }
                Object var5_17 = null;
                in.position(inPos);
                return coderResult3;
            }
            Object var5_18 = null;
            in.position(inPos);
            return coderResult2;
        }
        Object var5_19 = null;
        in.position(inPos);
        return coderResult;
    }

    protected final void implReset() {
        this.byteOrder = this.originalByteOrder;
    }

    UTF_16Decoder(Charset cs, int byteOrder) {
        super(cs, 0.5f, 1.0f);
        this.originalByteOrder = byteOrder;
        this.byteOrder = byteOrder;
    }
}

