/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.KeyboardFocusManager;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.PaintEvent;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferStrategy;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Component
implements ImageObserver,
MenuContainer,
Serializable {
    private static final long serialVersionUID = -7644114512714619750L;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    static final Object treeLock = new String("AWT_TREE_LOCK");
    private static transient boolean incrementalDraw = Boolean.getBoolean("awt.image.incrementalDraw");
    private static transient Long redrawRate = Long.getLong("awt.image.redrawrate");
    int x;
    int y;
    int width;
    int height;
    Color foreground;
    Color background;
    Font font;
    Font peerFont;
    Cursor cursor;
    Locale locale;
    boolean ignoreRepaint;
    boolean visible;
    boolean enabled;
    boolean valid;
    DropTarget dropTarget;
    Vector popups;
    String name;
    boolean nameExplicitlySet;
    boolean focusable;
    int isFocusTraversableOverridden;
    Set[] focusTraversalKeys;
    boolean focusTraversalKeysEnabled;
    Dimension minSize;
    Dimension prefSize;
    boolean newEventsOnly;
    long eventMask;
    PropertyChangeSupport changeSupport;
    boolean isPacked;
    int componentSerializedDataVersion;
    AccessibleContext accessibleContext;
    transient ComponentListener componentListener;
    transient FocusListener focusListener;
    transient KeyListener keyListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    transient MouseWheelListener mouseWheelListener;
    transient InputMethodListener inputMethodListener;
    transient HierarchyListener hierarchyListener;
    transient HierarchyBoundsListener hierarchyBoundsListener;
    transient Container parent;
    transient ComponentPeer peer;
    transient ComponentOrientation orientation;
    transient GraphicsConfiguration graphicsConfig;
    transient BufferStrategy bufferStrategy;
    private transient FocusEvent pendingFocusRequest;
    static /* synthetic */ Class class$java$awt$event$ComponentListener;
    static /* synthetic */ Class class$java$awt$event$FocusListener;
    static /* synthetic */ Class class$java$awt$event$HierarchyListener;
    static /* synthetic */ Class class$java$awt$event$HierarchyBoundsListener;
    static /* synthetic */ Class class$java$awt$event$KeyListener;
    static /* synthetic */ Class class$java$awt$event$MouseListener;
    static /* synthetic */ Class class$java$awt$event$MouseMotionListener;
    static /* synthetic */ Class class$java$awt$event$MouseWheelListener;
    static /* synthetic */ Class class$java$awt$event$InputMethodListener;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            this.name = this.generateName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.nameExplicitlySet = true;
        this.name = name;
    }

    public Container getParent() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public void setDropTarget(DropTarget dt) {
        this.dropTarget = dt;
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.getGraphicsConfigurationImpl();
    }

    public final Object getTreeLock() {
        return treeLock;
    }

    public Toolkit getToolkit() {
        Toolkit tk;
        if (this.peer != null && (tk = this.peer.getToolkit()) != null) {
            return tk;
        }
        if (this.parent != null) {
            return this.parent.getToolkit();
        }
        return Toolkit.getDefaultToolkit();
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isDisplayable() {
        boolean bl = false;
        if (this.peer != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isShowing() {
        if (!this.visible || this.peer == null) {
            return false;
        }
        boolean bl = false;
        if (this.parent != null) {
            bl = this.parent.isShowing();
        }
        return bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enable(enabled);
    }

    public void enable() {
        this.enabled = true;
        if (this.peer != null) {
            this.peer.setEnabled(true);
        }
    }

    public void enable(boolean enabled) {
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void disable() {
        this.enabled = false;
        if (this.peer != null) {
            this.peer.setEnabled(false);
        }
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public void enableInputMethods(boolean enable) {
        this.eventMask = enable ? (this.eventMask |= 0x1000L) : (this.eventMask &= 0xFFFFFFFFFFFFEFFFL);
    }

    public void setVisible(boolean visible) {
        this.show(visible);
    }

    public void show() {
        if (!this.isVisible()) {
            Container currentParent;
            this.visible = true;
            ComponentPeer currentPeer = this.peer;
            if (currentPeer != null) {
                currentPeer.setVisible(true);
            }
            if (this.isShowing()) {
                this.repaint();
            }
            if ((currentParent = this.parent) != null) {
                currentParent.invalidate();
            }
            ComponentEvent ce = new ComponentEvent(this, 102);
            this.getToolkit().getSystemEventQueue().postEvent(ce);
        }
    }

    public void show(boolean visible) {
        if (visible) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void hide() {
        if (this.isVisible()) {
            Container currentParent;
            ComponentPeer currentPeer = this.peer;
            if (currentPeer != null) {
                currentPeer.setVisible(false);
            }
            boolean wasShowing = this.isShowing();
            this.visible = false;
            if (wasShowing) {
                this.repaint();
            }
            if ((currentParent = this.parent) != null) {
                currentParent.invalidate();
            }
            ComponentEvent ce = new ComponentEvent(this, 103);
            this.getToolkit().getSystemEventQueue().postEvent(ce);
        }
    }

    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.parent == null ? null : this.parent.getForeground();
    }

    public void setForeground(Color c) {
        if (this.peer != null) {
            this.peer.setForeground(c);
        }
        Color previous = this.foreground;
        this.foreground = c;
        this.firePropertyChange("foreground", previous, c);
    }

    public boolean isForegroundSet() {
        boolean bl = false;
        if (this.foreground != null) {
            bl = true;
        }
        return bl;
    }

    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        return this.parent == null ? null : this.parent.getBackground();
    }

    public void setBackground(Color c) {
        if (c != null && c.equals(this.background)) {
            return;
        }
        if (c == null && this.parent != null) {
            c = this.parent.getBackground();
        }
        if (this.peer != null && c != null) {
            this.peer.setBackground(c);
        }
        Color previous = this.background;
        this.background = c;
        this.firePropertyChange("background", previous, c);
    }

    public boolean isBackgroundSet() {
        boolean bl = false;
        if (this.background != null) {
            bl = true;
        }
        return bl;
    }

    public Font getFont() {
        Font f = this.font;
        if (f != null) {
            return f;
        }
        Container p = this.parent;
        if (p != null) {
            return p.getFont();
        }
        if (this.peer != null) {
            return this.peer.getGraphics().getFont();
        }
        return null;
    }

    public void setFont(Font newFont) {
        if (newFont != null && (this.font == null || !this.font.equals(newFont)) || newFont == null) {
            Font oldFont = this.font;
            this.font = newFont;
            if (this.peer != null) {
                this.peer.setFont(this.font);
            }
            this.firePropertyChange("font", oldFont, newFont);
            this.invalidate();
        }
    }

    public boolean isFontSet() {
        boolean bl = false;
        if (this.font != null) {
            bl = true;
        }
        return bl;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        if (this.parent == null) {
            throw new IllegalComponentStateException("Component has no parent: can't determine Locale");
        }
        return this.parent.getLocale();
    }

    public void setLocale(Locale newLocale) {
        if (this.locale == newLocale) {
            return;
        }
        Locale oldLocale = this.locale;
        this.locale = newLocale;
        this.firePropertyChange("locale", oldLocale, newLocale);
        this.invalidate();
    }

    public ColorModel getColorModel() {
        GraphicsConfiguration config = this.getGraphicsConfiguration();
        return config != null ? config.getColorModel() : this.getToolkit().getColorModel();
    }

    public Point getLocation() {
        return this.location();
    }

    public Point getLocationOnScreen() {
        if (!this.isShowing()) {
            throw new IllegalComponentStateException("component " + this.getClass().getName() + " not showing");
        }
        return this.peer.getLocationOnScreen();
    }

    public Point location() {
        return new Point(this.x, this.y);
    }

    public void setLocation(int x, int y) {
        this.move(x, y);
    }

    public void move(int x, int y) {
        this.setBounds(x, y, this.width, this.height);
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public Dimension getSize() {
        return this.size();
    }

    public Dimension size() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int width, int height) {
        this.resize(width, height);
    }

    public void resize(int width, int height) {
        this.setBounds(this.x, this.y, width, height);
    }

    public void setSize(Dimension d) {
        this.resize(d);
    }

    public void resize(Dimension d) {
        this.resize(d.width, d.height);
    }

    public Rectangle getBounds() {
        return this.bounds();
    }

    public Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(int x, int y, int w, int h) {
        this.reshape(x, y, w, h);
    }

    public void reshape(int x, int y, int width, int height) {
        ComponentEvent ce;
        int oldx = this.x;
        int oldy = this.y;
        int oldwidth = this.width;
        int oldheight = this.height;
        if (this.x == x && this.y == y && this.width == width && this.height == height) {
            return;
        }
        this.invalidate();
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        if (this.peer != null) {
            this.peer.setBounds(x, y, width, height);
        }
        if (this.isLightweight() && this.isShowing() && this.parent != null) {
            Rectangle parentBounds = this.parent.getBounds();
            Rectangle oldBounds = new Rectangle(oldx, oldy, oldwidth, oldheight);
            Rectangle newBounds = new Rectangle(x, y, width, height);
            Rectangle destroyed = oldBounds.union(newBounds);
            if (!destroyed.isEmpty()) {
                this.parent.repaint(0L, destroyed.x, destroyed.y, destroyed.width, destroyed.height);
            }
        }
        if (this.isShowing() && (oldx != x || oldy != y)) {
            ce = new ComponentEvent(this, 100);
            this.getToolkit().getSystemEventQueue().postEvent(ce);
        }
        if (this.isShowing() && (oldwidth != width || oldheight != height)) {
            ce = new ComponentEvent(this, 101);
            this.getToolkit().getSystemEventQueue().postEvent(ce);
        }
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds(Rectangle r) {
        if (r == null) {
            r = new Rectangle();
        }
        r.x = this.x;
        r.y = this.y;
        r.width = this.width;
        r.height = this.height;
        return r;
    }

    public Dimension getSize(Dimension d) {
        if (d == null) {
            d = new Dimension();
        }
        d.width = this.width;
        d.height = this.height;
        return d;
    }

    public Point getLocation(Point p) {
        if (p == null) {
            p = new Point();
        }
        p.x = this.x;
        p.y = this.y;
        return p;
    }

    public boolean isOpaque() {
        return this.isLightweight() ^ true;
    }

    public boolean isLightweight() {
        return this.peer instanceof LightweightPeer;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        if (this.prefSize == null) {
            if (this.peer == null) {
                return new Dimension(this.width, this.height);
            }
            this.prefSize = this.peer.getPreferredSize();
        }
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        if (this.minSize == null) {
            this.minSize = this.peer != null ? this.peer.getMinimumSize() : new Dimension(this.width, this.height);
        }
        return this.minSize;
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
    }

    public void validate() {
        this.valid = true;
    }

    public void invalidate() {
        this.valid = false;
        this.prefSize = null;
        this.minSize = null;
        if (this.parent != null && this.parent.valid) {
            this.parent.invalidate();
        }
    }

    public Graphics getGraphics() {
        if (this.peer != null) {
            Graphics gfx = this.peer.getGraphics();
            if (gfx == null && this.parent != null) {
                gfx = this.parent.getGraphics();
                Rectangle bounds = this.getBounds();
                gfx.setClip(bounds);
                gfx.translate(bounds.x, bounds.y);
                return gfx;
            }
            gfx.setFont(this.font);
            return gfx;
        }
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.peer == null ? this.getToolkit().getFontMetrics(font) : this.peer.getFontMetrics(font);
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
        if (this.peer != null) {
            this.peer.setCursor(cursor);
        }
    }

    public Cursor getCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.parent != null ? this.parent.getCursor() : Cursor.getDefaultCursor();
    }

    public boolean isCursorSet() {
        boolean bl = false;
        if (this.cursor != null) {
            bl = true;
        }
        return bl;
    }

    public void paint(Graphics g) {
    }

    public void update(Graphics g) {
        if (this.isLightweight() || this.getParent() == null) {
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                g.clearRect(0, 0, this.width, this.height);
            } else {
                g.clearRect(clip.x, clip.y, clip.width, clip.height);
            }
        }
        this.paint(g);
    }

    public void paintAll(Graphics g) {
        if (!this.visible) {
            return;
        }
        this.paint(g);
    }

    public void repaint() {
        if (!this.isShowing()) {
            Container p = this.parent;
            if (p != null) {
                p.repaint(0L, this.getX(), this.getY(), this.width, this.height);
            }
        } else {
            this.repaint(0L, 0, 0, this.width, this.height);
        }
    }

    public void repaint(long tm) {
        if (!this.isShowing()) {
            Container p = this.parent;
            if (p != null) {
                p.repaint(tm, this.getX(), this.getY(), this.width, this.height);
            }
        } else {
            this.repaint(tm, 0, 0, this.width, this.height);
        }
    }

    public void repaint(int x, int y, int w, int h) {
        if (!this.isShowing()) {
            Container p = this.parent;
            if (p != null) {
                p.repaint(0L, x + this.getX(), y + this.getY(), this.width, this.height);
            }
        } else {
            this.repaint(0L, x, y, w, h);
        }
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        if (!this.isShowing()) {
            Container p = this.parent;
            if (p != null) {
                p.repaint(tm, x + this.getX(), y + this.getY(), width, height);
            }
        } else {
            ComponentPeer p = this.peer;
            if (p != null) {
                p.repaint(tm, x, y, width, height);
            }
        }
    }

    public void print(Graphics g) {
        this.paint(g);
    }

    public void printAll(Graphics g) {
        this.paintAll(g);
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if ((flags & 0x30) != 0) {
            this.repaint();
        } else if ((flags & 8) != 0 && incrementalDraw) {
            if (redrawRate != null) {
                long tm = redrawRate;
                if (tm < 0L) {
                    tm = 0L;
                }
                this.repaint(tm);
            } else {
                this.repaint(100L);
            }
        }
        boolean bl = false;
        if ((flags & 0xE0) == 0) {
            bl = true;
        }
        return bl;
    }

    public Image createImage(ImageProducer producer) {
        if (this.peer != null) {
            return this.peer.createImage(producer);
        }
        return this.getToolkit().createImage(producer);
    }

    public Image createImage(int width, int height) {
        Image returnValue = null;
        if (!GraphicsEnvironment.isHeadless()) {
            if (this.isLightweight() && this.parent != null) {
                returnValue = this.parent.createImage(width, height);
            } else if (this.peer != null) {
                returnValue = this.peer.createImage(width, height);
            }
        }
        return returnValue;
    }

    public VolatileImage createVolatileImage(int width, int height) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        GraphicsConfiguration config = this.getGraphicsConfiguration();
        return config == null ? null : config.createCompatibleVolatileImage(width, height);
    }

    public VolatileImage createVolatileImage(int width, int height, ImageCapabilities caps) throws AWTException {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        GraphicsConfiguration config = this.getGraphicsConfiguration();
        return config == null ? null : config.createCompatibleVolatileImage(width, height, caps);
    }

    public boolean prepareImage(Image image, ImageObserver observer) {
        return this.prepareImage(image, image.getWidth(observer), image.getHeight(observer), observer);
    }

    public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        if (this.peer != null) {
            return this.peer.prepareImage(image, width, height, observer);
        }
        return this.getToolkit().prepareImage(image, width, height, observer);
    }

    public int checkImage(Image image, ImageObserver observer) {
        return this.checkImage(image, -1, -1, observer);
    }

    public int checkImage(Image image, int width, int height, ImageObserver observer) {
        if (this.peer != null) {
            return this.peer.checkImage(image, width, height, observer);
        }
        return this.getToolkit().checkImage(image, width, height, observer);
    }

    public void setIgnoreRepaint(boolean ignoreRepaint) {
        this.ignoreRepaint = ignoreRepaint;
    }

    public boolean getIgnoreRepaint() {
        return this.ignoreRepaint;
    }

    public boolean contains(int x, int y) {
        return this.inside(x, y);
    }

    public boolean inside(int x, int y) {
        boolean bl = false;
        if (x >= 0 && y >= 0 && x < this.width && y < this.height) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public Component getComponentAt(int x, int y) {
        return this.locate(x, y);
    }

    public Component locate(int x, int y) {
        return this.contains(x, y) ? this : null;
    }

    public Component getComponentAt(Point p) {
        return this.getComponentAt(p.x, p.y);
    }

    public void deliverEvent(Event e) {
        this.postEvent(e);
    }

    public final void dispatchEvent(AWTEvent e) {
        this.dispatchEventImpl(e);
    }

    public boolean postEvent(Event e) {
        boolean handled = this.handleEvent(e);
        if (!handled && this.getParent() != null) {
            handled = this.getParent().postEvent(e);
        }
        return handled;
    }

    public synchronized void addComponentListener(ComponentListener listener) {
        this.componentListener = AWTEventMulticaster.add(this.componentListener, listener);
        if (this.componentListener != null) {
            this.enableEvents(1L);
        }
    }

    public synchronized void removeComponentListener(ComponentListener listener) {
        this.componentListener = AWTEventMulticaster.remove(this.componentListener, listener);
    }

    public synchronized ComponentListener[] getComponentListeners() {
        Class clazz = class$java$awt$event$ComponentListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ComponentListener = Component.class("[Ljava.awt.event.ComponentListener;", false);
        }
        return (ComponentListener[])AWTEventMulticaster.getListeners(this.componentListener, clazz);
    }

    public synchronized void addFocusListener(FocusListener listener) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, listener);
        if (this.focusListener != null) {
            this.enableEvents(4);
        }
    }

    public synchronized void removeFocusListener(FocusListener listener) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, listener);
    }

    public synchronized FocusListener[] getFocusListeners() {
        Class clazz = class$java$awt$event$FocusListener;
        if (clazz == null) {
            clazz = class$java$awt$event$FocusListener = Component.class("[Ljava.awt.event.FocusListener;", false);
        }
        return (FocusListener[])AWTEventMulticaster.getListeners(this.focusListener, clazz);
    }

    public synchronized void addHierarchyListener(HierarchyListener listener) {
        this.hierarchyListener = AWTEventMulticaster.add(this.hierarchyListener, listener);
        if (this.hierarchyListener != null) {
            this.enableEvents(32768L);
        }
    }

    public synchronized void removeHierarchyListener(HierarchyListener listener) {
        this.hierarchyListener = AWTEventMulticaster.remove(this.hierarchyListener, listener);
    }

    public synchronized HierarchyListener[] getHierarchyListeners() {
        Class clazz = class$java$awt$event$HierarchyListener;
        if (clazz == null) {
            clazz = class$java$awt$event$HierarchyListener = Component.class("[Ljava.awt.event.HierarchyListener;", false);
        }
        return (HierarchyListener[])AWTEventMulticaster.getListeners(this.hierarchyListener, clazz);
    }

    public synchronized void addHierarchyBoundsListener(HierarchyBoundsListener listener) {
        this.hierarchyBoundsListener = AWTEventMulticaster.add(this.hierarchyBoundsListener, listener);
        if (this.hierarchyBoundsListener != null) {
            this.enableEvents(65536L);
        }
    }

    public synchronized void removeHierarchyBoundsListener(HierarchyBoundsListener listener) {
        this.hierarchyBoundsListener = AWTEventMulticaster.remove(this.hierarchyBoundsListener, listener);
    }

    public synchronized HierarchyBoundsListener[] getHierarchyBoundsListeners() {
        Class clazz = class$java$awt$event$HierarchyBoundsListener;
        if (clazz == null) {
            clazz = class$java$awt$event$HierarchyBoundsListener = Component.class("[Ljava.awt.event.HierarchyBoundsListener;", false);
        }
        return (HierarchyBoundsListener[])AWTEventMulticaster.getListeners(this.hierarchyBoundsListener, clazz);
    }

    public synchronized void addKeyListener(KeyListener listener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, listener);
        if (this.keyListener != null) {
            this.enableEvents(8L);
        }
    }

    public synchronized void removeKeyListener(KeyListener listener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, listener);
    }

    public synchronized KeyListener[] getKeyListeners() {
        Class clazz = class$java$awt$event$KeyListener;
        if (clazz == null) {
            clazz = class$java$awt$event$KeyListener = Component.class("[Ljava.awt.event.KeyListener;", false);
        }
        return (KeyListener[])AWTEventMulticaster.getListeners(this.keyListener, clazz);
    }

    public synchronized void addMouseListener(MouseListener listener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, listener);
        if (this.mouseListener != null) {
            this.enableEvents(16L);
        }
    }

    public synchronized void removeMouseListener(MouseListener listener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, listener);
    }

    public synchronized MouseListener[] getMouseListeners() {
        Class clazz = class$java$awt$event$MouseListener;
        if (clazz == null) {
            clazz = class$java$awt$event$MouseListener = Component.class("[Ljava.awt.event.MouseListener;", false);
        }
        return (MouseListener[])AWTEventMulticaster.getListeners(this.mouseListener, clazz);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, listener);
        if (this.mouseMotionListener != null) {
            this.enableEvents(16L);
        }
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, listener);
    }

    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        Class clazz = class$java$awt$event$MouseMotionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$MouseMotionListener = Component.class("[Ljava.awt.event.MouseMotionListener;", false);
        }
        return (MouseMotionListener[])AWTEventMulticaster.getListeners(this.mouseMotionListener, clazz);
    }

    public synchronized void addMouseWheelListener(MouseWheelListener listener) {
        this.mouseWheelListener = AWTEventMulticaster.add(this.mouseWheelListener, listener);
        if (this.mouseWheelListener != null) {
            this.enableEvents(131072L);
        }
    }

    public synchronized void removeMouseWheelListener(MouseWheelListener listener) {
        this.mouseWheelListener = AWTEventMulticaster.remove(this.mouseWheelListener, listener);
    }

    public synchronized MouseWheelListener[] getMouseWheelListeners() {
        Class clazz = class$java$awt$event$MouseWheelListener;
        if (clazz == null) {
            clazz = class$java$awt$event$MouseWheelListener = Component.class("[Ljava.awt.event.MouseWheelListener;", false);
        }
        return (MouseWheelListener[])AWTEventMulticaster.getListeners(this.mouseWheelListener, clazz);
    }

    public synchronized void addInputMethodListener(InputMethodListener listener) {
        this.inputMethodListener = AWTEventMulticaster.add(this.inputMethodListener, listener);
        if (this.inputMethodListener != null) {
            this.enableEvents(2048L);
        }
    }

    public synchronized void removeInputMethodListener(InputMethodListener listener) {
        this.inputMethodListener = AWTEventMulticaster.remove(this.inputMethodListener, listener);
    }

    public synchronized InputMethodListener[] getInputMethodListeners() {
        Class clazz = class$java$awt$event$InputMethodListener;
        if (clazz == null) {
            clazz = class$java$awt$event$InputMethodListener = Component.class("[Ljava.awt.event.InputMethodListener;", false);
        }
        return (InputMethodListener[])AWTEventMulticaster.getListeners(this.inputMethodListener, clazz);
    }

    public EventListener[] getListeners(Class listenerType) {
        Class clazz = class$java$awt$event$ComponentListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ComponentListener = Component.class("[Ljava.awt.event.ComponentListener;", false);
        }
        if (listenerType == clazz) {
            return this.getComponentListeners();
        }
        Class clazz2 = class$java$awt$event$FocusListener;
        if (clazz2 == null) {
            clazz2 = class$java$awt$event$FocusListener = Component.class("[Ljava.awt.event.FocusListener;", false);
        }
        if (listenerType == clazz2) {
            return this.getFocusListeners();
        }
        Class clazz3 = class$java$awt$event$HierarchyListener;
        if (clazz3 == null) {
            clazz3 = class$java$awt$event$HierarchyListener = Component.class("[Ljava.awt.event.HierarchyListener;", false);
        }
        if (listenerType == clazz3) {
            return this.getHierarchyListeners();
        }
        Class clazz4 = class$java$awt$event$HierarchyBoundsListener;
        if (clazz4 == null) {
            clazz4 = class$java$awt$event$HierarchyBoundsListener = Component.class("[Ljava.awt.event.HierarchyBoundsListener;", false);
        }
        if (listenerType == clazz4) {
            return this.getHierarchyBoundsListeners();
        }
        Class clazz5 = class$java$awt$event$KeyListener;
        if (clazz5 == null) {
            clazz5 = class$java$awt$event$KeyListener = Component.class("[Ljava.awt.event.KeyListener;", false);
        }
        if (listenerType == clazz5) {
            return this.getKeyListeners();
        }
        Class clazz6 = class$java$awt$event$MouseListener;
        if (clazz6 == null) {
            clazz6 = class$java$awt$event$MouseListener = Component.class("[Ljava.awt.event.MouseListener;", false);
        }
        if (listenerType == clazz6) {
            return this.getMouseListeners();
        }
        Class clazz7 = class$java$awt$event$MouseMotionListener;
        if (clazz7 == null) {
            clazz7 = class$java$awt$event$MouseMotionListener = Component.class("[Ljava.awt.event.MouseMotionListener;", false);
        }
        if (listenerType == clazz7) {
            return this.getMouseMotionListeners();
        }
        Class clazz8 = class$java$awt$event$MouseWheelListener;
        if (clazz8 == null) {
            clazz8 = class$java$awt$event$MouseWheelListener = Component.class("[Ljava.awt.event.MouseWheelListener;", false);
        }
        if (listenerType == clazz8) {
            return this.getMouseWheelListeners();
        }
        Class clazz9 = class$java$awt$event$InputMethodListener;
        if (clazz9 == null) {
            clazz9 = class$java$awt$event$InputMethodListener = Component.class("[Ljava.awt.event.InputMethodListener;", false);
        }
        if (listenerType == clazz9) {
            return this.getInputMethodListeners();
        }
        Class clazz10 = class$java$beans$PropertyChangeListener;
        if (clazz10 == null) {
            clazz10 = class$java$beans$PropertyChangeListener = Component.class("[Ljava.beans.PropertyChangeListener;", false);
        }
        if (listenerType == clazz10) {
            return this.getPropertyChangeListeners();
        }
        return (EventListener[])Array.newInstance(listenerType, 0);
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    public InputContext getInputContext() {
        return this.parent == null ? null : this.parent.getInputContext();
    }

    protected final void enableEvents(long eventsToEnable) {
        this.eventMask |= eventsToEnable;
        if (this.isLightweight() && this.parent != null) {
            this.parent.enableEvents(eventsToEnable);
        } else if (this.peer != null) {
            this.peer.setEventMask(this.eventMask);
        }
    }

    protected final void disableEvents(long eventsToDisable) {
        this.eventMask &= eventsToDisable ^ -1L;
    }

    protected AWTEvent coalesceEvents(AWTEvent existingEvent, AWTEvent newEvent) {
        switch (existingEvent.id) {
            case 503: 
            case 506: {
                return newEvent;
            }
            case 800: 
            case 801: {
                return this.coalescePaintEvents((PaintEvent)existingEvent, (PaintEvent)newEvent);
            }
        }
        return null;
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)e);
        } else if (e instanceof MouseWheelEvent) {
            this.processMouseWheelEvent((MouseWheelEvent)e);
        } else if (e instanceof MouseEvent) {
            if (e.id == 503 || e.id == 506) {
                this.processMouseMotionEvent((MouseEvent)e);
            } else {
                this.processMouseEvent((MouseEvent)e);
            }
        } else if (e instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)e);
        } else if (e instanceof InputMethodEvent) {
            this.processInputMethodEvent((InputMethodEvent)e);
        } else if (e instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)e);
        } else if (e instanceof HierarchyEvent) {
            if (e.id == 1400) {
                this.processHierarchyEvent((HierarchyEvent)e);
            } else {
                this.processHierarchyBoundsEvent((HierarchyEvent)e);
            }
        }
    }

    protected void processComponentEvent(ComponentEvent e) {
        if (this.componentListener == null) {
            return;
        }
        switch (e.id) {
            case 103: {
                this.componentListener.componentHidden(e);
                break;
            }
            case 100: {
                this.componentListener.componentMoved(e);
                break;
            }
            case 101: {
                this.componentListener.componentResized(e);
                break;
            }
            case 102: {
                this.componentListener.componentShown(e);
                break;
            }
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        if (this.focusListener == null) {
            return;
        }
        switch (e.id) {
            case 1004: {
                this.focusListener.focusGained(e);
                break;
            }
            case 1005: {
                this.focusListener.focusLost(e);
                break;
            }
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        if (this.keyListener == null) {
            return;
        }
        switch (e.id) {
            case 401: {
                this.keyListener.keyPressed(e);
                break;
            }
            case 402: {
                this.keyListener.keyReleased(e);
                break;
            }
            case 400: {
                this.keyListener.keyTyped(e);
                break;
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        if (this.mouseListener == null) {
            return;
        }
        switch (e.id) {
            case 500: {
                this.mouseListener.mouseClicked(e);
                break;
            }
            case 504: {
                this.mouseListener.mouseEntered(e);
                break;
            }
            case 505: {
                this.mouseListener.mouseExited(e);
                break;
            }
            case 501: {
                this.mouseListener.mousePressed(e);
                break;
            }
            case 502: {
                this.mouseListener.mouseReleased(e);
                break;
            }
        }
        e.consume();
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        if (this.mouseMotionListener == null) {
            return;
        }
        switch (e.id) {
            case 506: {
                this.mouseMotionListener.mouseDragged(e);
                break;
            }
            case 503: {
                this.mouseMotionListener.mouseMoved(e);
                break;
            }
        }
        e.consume();
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        if (this.mouseWheelListener != null && e.id == 507) {
            this.mouseWheelListener.mouseWheelMoved(e);
            e.consume();
        }
    }

    protected void processInputMethodEvent(InputMethodEvent e) {
        if (this.inputMethodListener == null) {
            return;
        }
        switch (e.id) {
            case 1101: {
                this.inputMethodListener.caretPositionChanged(e);
                break;
            }
            case 1100: {
                this.inputMethodListener.inputMethodTextChanged(e);
                break;
            }
        }
    }

    protected void processHierarchyEvent(HierarchyEvent e) {
        if (this.hierarchyListener == null) {
            return;
        }
        if (e.id == 1400) {
            this.hierarchyListener.hierarchyChanged(e);
        }
    }

    protected void processHierarchyBoundsEvent(HierarchyEvent e) {
        if (this.hierarchyBoundsListener == null) {
            return;
        }
        switch (e.id) {
            case 1401: {
                this.hierarchyBoundsListener.ancestorMoved(e);
                break;
            }
            case 1402: {
                this.hierarchyBoundsListener.ancestorResized(e);
                break;
            }
        }
    }

    public boolean handleEvent(Event evt) {
        switch (evt.id) {
            case 401: 
            case 403: {
                return this.keyDown(evt, evt.key);
            }
            case 402: 
            case 404: {
                return this.keyUp(evt, evt.key);
            }
            case 501: {
                return this.mouseDown(evt, evt.x, evt.y);
            }
            case 502: {
                return this.mouseUp(evt, evt.x, evt.y);
            }
            case 503: {
                return this.mouseMove(evt, evt.x, evt.y);
            }
            case 506: {
                return this.mouseDrag(evt, evt.x, evt.y);
            }
            case 504: {
                return this.mouseEnter(evt, evt.x, evt.y);
            }
            case 505: {
                return this.mouseExit(evt, evt.x, evt.y);
            }
            case 1004: {
                return this.gotFocus(evt, evt.arg);
            }
            case 1005: {
                return this.lostFocus(evt, evt.arg);
            }
            case 1001: {
                return this.action(evt, evt.arg);
            }
        }
        return false;
    }

    public boolean mouseDown(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseMove(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseEnter(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseExit(Event evt, int x, int y) {
        return false;
    }

    public boolean keyDown(Event evt, int key) {
        return false;
    }

    public boolean keyUp(Event evt, int key) {
        return false;
    }

    public boolean action(Event evt, Object what) {
        return false;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createComponent(this);
        }
        this.peer.setEventMask(this.eventMask);
    }

    public void removeNotify() {
        ComponentPeer tmp = this.peer;
        this.peer = null;
        if (tmp != null) {
            tmp.hide();
            tmp.dispose();
        }
    }

    public boolean gotFocus(Event evt, Object what) {
        return false;
    }

    public boolean lostFocus(Event evt, Object what) {
        return false;
    }

    public boolean isFocusTraversable() {
        boolean bl = false;
        if (this.enabled && this.visible && (this.peer == null || this.isLightweight() || this.peer.isFocusTraversable())) {
            bl = true;
        }
        return bl;
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public void setFocusable(boolean focusable) {
        this.firePropertyChange("focusable", this.focusable, focusable);
        this.focusable = focusable;
        this.isFocusTraversableOverridden = 1;
    }

    public void setFocusTraversalKeys(int id, Set keystrokes) {
        String name;
        Set sb;
        Set sa;
        if (keystrokes == null) {
            Container parent = this.getParent();
            while (parent != null) {
                if (parent.areFocusTraversalKeysSet(id)) {
                    keystrokes = parent.getFocusTraversalKeys(id);
                    break;
                }
                parent = parent.getParent();
            }
            if (keystrokes == null) {
                keystrokes = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id);
            }
        }
        switch (id) {
            case 0: {
                sa = this.getFocusTraversalKeys(1);
                sb = this.getFocusTraversalKeys(2);
                name = "forwardFocusTraversalKeys";
                break;
            }
            case 1: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(2);
                name = "backwardFocusTraversalKeys";
                break;
            }
            case 2: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(1);
                name = "upCycleFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int i = keystrokes.size();
        Iterator iter = keystrokes.iterator();
        while (--i >= 0) {
            Object o = iter.next();
            if (o instanceof AWTKeyStroke && !sa.contains(o) && !sb.contains(o) && ((AWTKeyStroke)o).keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        if (this.focusTraversalKeys == null) {
            this.focusTraversalKeys = new Set[3];
        }
        keystrokes = Collections.unmodifiableSet(new HashSet(keystrokes));
        this.firePropertyChange(name, this.focusTraversalKeys[id], keystrokes);
        this.focusTraversalKeys[id] = keystrokes;
    }

    public Set getFocusTraversalKeys(int id) {
        if (id != 0 && id != 1 && id != 2) {
            throw new IllegalArgumentException();
        }
        Set s = null;
        if (this.focusTraversalKeys != null) {
            s = this.focusTraversalKeys[id];
        }
        if (s == null && this.parent != null) {
            s = this.parent.getFocusTraversalKeys(id);
        }
        return s == null ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id) : s;
    }

    public boolean areFocusTraversalKeysSet(int id) {
        if (id != 0 && id != 1 && id != 2) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        if (this.focusTraversalKeys != null && this.focusTraversalKeys[id] != null) {
            bl = true;
        }
        return bl;
    }

    public void setFocusTraversalKeysEnabled(boolean focusTraversalKeysEnabled) {
        this.firePropertyChange("focusTraversalKeysEnabled", this.focusTraversalKeysEnabled, focusTraversalKeysEnabled);
        this.focusTraversalKeysEnabled = focusTraversalKeysEnabled;
    }

    public boolean getFocusTraversalKeysEnabled() {
        return this.focusTraversalKeysEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void requestFocus() {
        block12: {
            if (!this.isDisplayable() || !this.isShowing() || !this.isFocusable()) break block12;
            Object object = this.getTreeLock();
            synchronized (object) {
                block13: {
                    block11: {
                        Container container = this instanceof Container ? (Container)this : this.getParent();
                        Container parent = container;
                        while (parent != null && !(parent instanceof Window)) {
                            parent = parent.getParent();
                        }
                        if (parent == null) {
                            return;
                        }
                        Window toplevel = (Window)parent;
                        if (!toplevel.isFocusableWindow()) break block13;
                        if (this.peer != null && !this.isLightweight()) {
                            this.peer.requestFocus();
                        } else {
                            EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
                            EventQueue eventQueue = eq;
                            synchronized (eventQueue) {
                                block10: {
                                    KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                                    Component currentFocusOwner = manager.getGlobalPermanentFocusOwner();
                                    if (currentFocusOwner == null) break block10;
                                    eq.postEvent(new FocusEvent(currentFocusOwner, 1005, false, this));
                                    eq.postEvent(new FocusEvent(this, 1004, false, currentFocusOwner));
                                    break block11;
                                }
                                eq.postEvent(new FocusEvent(this, 1004, false));
                            }
                        }
                    }
                    break block12;
                }
                this.pendingFocusRequest = new FocusEvent(this, 1004);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean requestFocus(boolean temporary) {
        block9: {
            if (!this.isDisplayable() || !this.isShowing() || !this.isFocusable()) break block9;
            Object object = this.getTreeLock();
            synchronized (object) {
                block8: {
                    Container parent = this.getParent();
                    while (true) {
                        if (parent == null || parent instanceof Window) {
                            Window toplevel = (Window)parent;
                            if (!toplevel.isFocusableWindow()) break block8;
                            if (this.peer == null || this.isLightweight()) break;
                            this.peer.requestFocus();
                            break block9;
                        }
                        parent = parent.getParent();
                    }
                    EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    EventQueue eventQueue = eq;
                    synchronized (eventQueue) {
                        block11: {
                            block10: {
                                KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                                Component currentFocusOwner = manager.getGlobalPermanentFocusOwner();
                                if (currentFocusOwner == null) break block10;
                                eq.postEvent(new FocusEvent(currentFocusOwner, 1005, temporary, this));
                                eq.postEvent(new FocusEvent(this, 1004, temporary, currentFocusOwner));
                                break block11;
                            }
                            eq.postEvent(new FocusEvent(this, 1004, temporary));
                        }
                        break block9;
                    }
                }
                this.pendingFocusRequest = new FocusEvent(this, 1004, temporary);
            }
        }
        return true;
    }

    public boolean requestFocusInWindow() {
        return this.requestFocusInWindow(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean requestFocusInWindow(boolean temporary) {
        block10: {
            block11: {
                manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                focusedWindow = manager.getFocusedWindow();
                if (!this.isDisplayable() || !this.isShowing() || !this.isFocusable()) break block11;
                if (focusedWindow == null) break block10;
                var4_4 = this.getTreeLock();
                synchronized (var4_4) {
                    parent = this.getParent();
                    if (true) ** GOTO lbl16
                }
            }
            return false;
            {
                block12: {
                    do {
                        parent = parent.getParent();
lbl16:
                        // 2 sources

                    } while (parent != null && !(parent instanceof Window));
                    toplevel = (Window)parent;
                    if (focusedWindow != toplevel) {
                        return false;
                    }
                    if (this.peer == null || this.isLightweight() || this instanceof Window) break block12;
                    this.peer.requestFocus();
                    break block10;
                }
                eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
                var10_8 = eq;
                synchronized (var10_8) {
                    block9: {
                        currentFocusOwner = manager.getGlobalPermanentFocusOwner();
                        if (currentFocusOwner == null) break block9;
                        eq.postEvent(new FocusEvent(currentFocusOwner, 1005, temporary, this));
                        eq.postEvent(new FocusEvent(this, 1004, temporary, currentFocusOwner));
                        break block10;
                    }
                    eq.postEvent(new FocusEvent(this, 1004, temporary));
                }
            }
        }
        return true;
    }

    public void transferFocus() {
        this.nextFocus();
    }

    public Container getFocusCycleRootAncestor() {
        if (this instanceof Window && ((Container)this).isFocusCycleRoot()) {
            return (Container)this;
        }
        Container parent = this.getParent();
        while (parent != null && !parent.isFocusCycleRoot()) {
            parent = parent.getParent();
        }
        return parent;
    }

    public boolean isFocusCycleRoot(Container c) {
        boolean bl = false;
        if (c == this.getFocusCycleRootAncestor()) {
            bl = true;
        }
        return bl;
    }

    public void nextFocus() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.focusNextComponent(this);
    }

    public void transferFocusBackward() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.focusPreviousComponent(this);
    }

    public void transferFocusUpCycle() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.upFocusCycle(this);
    }

    public boolean hasFocus() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = manager.getFocusOwner();
        boolean bl = false;
        if (this == focusOwner) {
            bl = true;
        }
        return bl;
    }

    public boolean isFocusOwner() {
        return this.hasFocus();
    }

    public synchronized void add(PopupMenu popup) {
        if (this.popups == null) {
            this.popups = new Vector();
        }
        this.popups.add(popup);
        if (popup.parent != null) {
            popup.parent.remove(popup);
        }
        popup.parent = this;
        if (this.peer != null) {
            popup.addNotify();
        }
    }

    public synchronized void remove(MenuComponent popup) {
        if (this.popups != null) {
            this.popups.remove(popup);
        }
    }

    protected String paramString() {
        StringBuffer param = new StringBuffer();
        String name = this.getName();
        if (name != null) {
            param.append(name).append(",");
        }
        param.append(this.x).append(",").append(this.y).append(",").append(this.width).append("x").append(this.height);
        if (!this.isValid()) {
            param.append(",invalid");
        }
        if (!this.isVisible()) {
            param.append(",invisible");
        }
        if (!this.isEnabled()) {
            param.append(",disabled");
        }
        if (!this.isOpaque()) {
            param.append(",translucent");
        }
        if (this.isDoubleBuffered()) {
            param.append(",doublebuffered");
        }
        if (this.parent == null) {
            param.append(",parent=null");
        } else {
            param.append(",parent=").append(this.parent.getName());
        }
        return param.toString();
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.paramString() + ']';
    }

    public void list() {
        this.list(System.out, 0);
    }

    public void list(PrintStream out) {
        this.list(out, 0);
    }

    public void list(PrintStream out, int indent) {
        int i = 0;
        while (i < indent) {
            out.print(' ');
            ++i;
        }
        out.println(this.toString());
    }

    public void list(PrintWriter out) {
        this.list(out, 0);
    }

    public void list(PrintWriter out, int indent) {
        int i = 0;
        while (i < indent) {
            out.print(' ');
            ++i;
        }
        out.println(this.toString());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport == null ? new PropertyChangeListener[]{} : this.changeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String property) {
        return this.changeSupport == null ? new PropertyChangeListener[]{} : this.changeSupport.getPropertyChangeListeners(property);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void setComponentOrientation(ComponentOrientation o) {
        if (o == null) {
            throw new NullPointerException();
        }
        ComponentOrientation oldOrientation = this.orientation;
        this.orientation = o;
        this.firePropertyChange("componentOrientation", oldOrientation, o);
    }

    public ComponentOrientation getComponentOrientation() {
        return this.orientation;
    }

    public void applyComponentOrientation(ComponentOrientation o) {
        this.setComponentOrientation(o);
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    String generateName() {
        return null;
    }

    final void setPeer(ComponentPeer peer) {
        this.peer = peer;
    }

    GraphicsConfiguration getGraphicsConfigurationImpl() {
        GraphicsConfiguration config;
        if (this.peer != null && (config = this.peer.getGraphicsConfiguration()) != null) {
            return config;
        }
        if (this.parent != null) {
            return this.parent.getGraphicsConfiguration();
        }
        return null;
    }

    static Event translateEvent(AWTEvent e) {
        Component target = (Component)e.getSource();
        Event translated = null;
        if (e instanceof InputEvent) {
            InputEvent ie = (InputEvent)e;
            long when = ie.getWhen();
            int oldID = 0;
            int id = e.getID();
            int oldMods = 0;
            int mods = ie.getModifiersEx();
            if ((mods & 0x800) != 0) {
                oldMods |= 4;
            } else if ((mods & 0x1000) != 0) {
                oldMods |= 8;
            }
            if ((mods & 0x40) != 0) {
                oldMods |= 1;
            }
            if ((mods & 0x80) != 0) {
                oldMods |= 2;
            }
            if ((mods & 0x100) != 0) {
                oldMods |= 4;
            }
            if ((mods & 0x200) != 0) {
                oldMods |= 8;
            }
            if (e instanceof MouseEvent) {
                if (id == 501) {
                    oldID = 501;
                } else if (id == 502) {
                    oldID = 502;
                } else if (id == 503) {
                    oldID = 503;
                } else if (id == 506) {
                    oldID = 506;
                } else if (id == 504) {
                    oldID = 504;
                } else if (id == 505) {
                    oldID = 505;
                } else {
                    return null;
                }
                MouseEvent me = (MouseEvent)e;
                translated = new Event(target, when, oldID, me.getX(), me.getY(), 0, oldMods);
            } else if (e instanceof KeyEvent) {
                if (id == 401) {
                    oldID = 401;
                } else if (e.getID() == 402) {
                    oldID = 402;
                } else {
                    return null;
                }
                int oldKey = 0;
                int newKey = ((KeyEvent)e).getKeyCode();
                switch (newKey) {
                    case 8: {
                        oldKey = 8;
                        break;
                    }
                    case 20: {
                        oldKey = 1022;
                        break;
                    }
                    case 127: {
                        oldKey = 127;
                        break;
                    }
                    case 40: 
                    case 225: {
                        oldKey = 1005;
                        break;
                    }
                    case 35: {
                        oldKey = 1001;
                        break;
                    }
                    case 10: {
                        oldKey = 10;
                        break;
                    }
                    case 27: {
                        oldKey = 27;
                        break;
                    }
                    case 112: {
                        oldKey = 1008;
                        break;
                    }
                    case 121: {
                        oldKey = 1017;
                        break;
                    }
                    case 122: {
                        oldKey = 1018;
                        break;
                    }
                    case 123: {
                        oldKey = 1019;
                        break;
                    }
                    case 113: {
                        oldKey = 1009;
                        break;
                    }
                    case 114: {
                        oldKey = 1010;
                        break;
                    }
                    case 115: {
                        oldKey = 1011;
                        break;
                    }
                    case 116: {
                        oldKey = 1012;
                        break;
                    }
                    case 117: {
                        oldKey = 1013;
                        break;
                    }
                    case 118: {
                        oldKey = 1014;
                        break;
                    }
                    case 119: {
                        oldKey = 1015;
                        break;
                    }
                    case 120: {
                        oldKey = 1016;
                        break;
                    }
                    case 36: {
                        oldKey = 1000;
                        break;
                    }
                    case 155: {
                        oldKey = 1025;
                        break;
                    }
                    case 37: 
                    case 226: {
                        oldKey = 1006;
                        break;
                    }
                    case 144: {
                        oldKey = 1023;
                        break;
                    }
                    case 19: {
                        oldKey = 1024;
                        break;
                    }
                    case 34: {
                        oldKey = 1003;
                        break;
                    }
                    case 33: {
                        oldKey = 1002;
                        break;
                    }
                    case 154: {
                        oldKey = 1020;
                        break;
                    }
                    case 39: 
                    case 227: {
                        oldKey = 1007;
                        break;
                    }
                    case 145: {
                        oldKey = 1021;
                        break;
                    }
                    case 9: {
                        oldKey = 9;
                        break;
                    }
                    case 38: 
                    case 224: {
                        oldKey = 1004;
                        break;
                    }
                    default: {
                        oldKey = newKey;
                    }
                }
                translated = new Event(target, when, oldID, 0, 0, oldKey, oldMods);
            }
        } else if (e instanceof ActionEvent) {
            translated = new Event(target, 1001, ((ActionEvent)e).getActionCommand());
        }
        return translated;
    }

    void dispatchEventImpl(AWTEvent e) {
        Event oldEvent = Component.translateEvent(e);
        if (oldEvent != null) {
            this.postEvent(oldEvent);
        }
        if (this.eventTypeEnabled(e.id)) {
            if (!Thread.holdsLock(e)) {
                switch (e.id) {
                    case 207: 
                    case 208: 
                    case 400: 
                    case 401: 
                    case 402: 
                    case 1004: 
                    case 1005: {
                        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(e)) {
                            return;
                        }
                    }
                    case 501: {
                        if (!this.isLightweight()) break;
                        this.requestFocus();
                        break;
                    }
                }
            }
            if (e.id != 800 && e.id != 801) {
                this.processEvent(e);
            }
        }
        if (this.peer != null) {
            this.peer.handleEvent(e);
        }
    }

    boolean eventTypeEnabled(int type) {
        if (type > 1999) {
            return true;
        }
        switch (type) {
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                boolean bl = false;
                if (this.componentListener != null || (this.eventMask & 1L) != 0L) {
                    bl = true;
                }
                return bl;
            }
            case 400: 
            case 401: 
            case 402: {
                boolean bl = false;
                if (this.keyListener != null || (this.eventMask & 8L) != 0L) {
                    bl = true;
                }
                return bl;
            }
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                boolean bl = false;
                if (this.mouseListener != null || this.mouseMotionListener != null || (this.eventMask & 0x10L) != 0L) {
                    bl = true;
                }
                return bl;
            }
            case 1004: 
            case 1005: {
                boolean bl = false;
                if (this.focusListener != null || (this.eventMask & (long)4) != 0L) {
                    bl = true;
                }
                return bl;
            }
            case 1100: 
            case 1101: {
                boolean bl = false;
                if (this.inputMethodListener != null || (this.eventMask & 0x800L) != 0L) {
                    bl = true;
                }
                return bl;
            }
            case 800: 
            case 801: {
                boolean bl = false;
                if ((this.eventMask & 0x2000L) != 0L) {
                    bl = true;
                }
                return bl;
            }
        }
        return false;
    }

    private final PaintEvent coalescePaintEvents(PaintEvent queuedEvent, PaintEvent newEvent) {
        Rectangle r1 = queuedEvent.getUpdateRect();
        Rectangle r2 = newEvent.getUpdateRect();
        Rectangle union = r1.union(r2);
        int ua = union.width * union.height;
        int r1a = r1.width * r1.height;
        int r2a = r2.width * r2.height;
        if (ua > (r1a + r2a) * 2) {
            return null;
        }
        newEvent.setUpdateRect(union);
        return newEvent;
    }

    Component findNextFocusComponent(Component child) {
        return null;
    }

    private final void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        String key = (String)s.readObject();
        while (key != null) {
            Object listener = s.readObject();
            if ("componentL".equals(key)) {
                this.addComponentListener((ComponentListener)listener);
            } else if ("focusL".equals(key)) {
                this.addFocusListener((FocusListener)listener);
            } else if ("keyL".equals(key)) {
                this.addKeyListener((KeyListener)listener);
            } else if ("mouseL".equals(key)) {
                this.addMouseListener((MouseListener)listener);
            } else if ("mouseMotionL".equals(key)) {
                this.addMouseMotionListener((MouseMotionListener)listener);
            } else if ("inputMethodL".equals(key)) {
                this.addInputMethodListener((InputMethodListener)listener);
            } else if ("hierarchyL".equals(key)) {
                this.addHierarchyListener((HierarchyListener)listener);
            } else if ("hierarchyBoundsL".equals(key)) {
                this.addHierarchyBoundsListener((HierarchyBoundsListener)listener);
            } else if ("mouseWheelL".equals(key)) {
                this.addMouseWheelListener((MouseWheelListener)listener);
            }
            key = (String)s.readObject();
        }
    }

    private final void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster.save(s, "componentL", this.componentListener);
        AWTEventMulticaster.save(s, "focusL", this.focusListener);
        AWTEventMulticaster.save(s, "keyL", this.keyListener);
        AWTEventMulticaster.save(s, "mouseL", this.mouseListener);
        AWTEventMulticaster.save(s, "mouseMotionL", this.mouseMotionListener);
        AWTEventMulticaster.save(s, "inputMethodL", this.inputMethodListener);
        AWTEventMulticaster.save(s, "hierarchyL", this.hierarchyListener);
        AWTEventMulticaster.save(s, "hierarchyBoundsL", this.hierarchyBoundsListener);
        AWTEventMulticaster.save(s, "mouseWheelL", this.mouseWheelListener);
        s.writeObject(null);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.locale = Locale.getDefault();
        this.visible = true;
        this.enabled = true;
        this.focusable = true;
        this.focusTraversalKeysEnabled = true;
        this.eventMask = 4096L;
        this.componentSerializedDataVersion = 4;
        this.orientation = ComponentOrientation.UNKNOWN;
        this.pendingFocusRequest = null;
    }

    protected Component() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class FlipBufferStrategy
    extends BufferStrategy {
        protected int numBuffers;
        protected BufferCapabilities caps;
        protected Image drawBuffer;
        protected VolatileImage drawVBuffer;
        protected boolean validatedContents;
        private int width;
        private int height;

        protected void createBuffers(int numBuffers, BufferCapabilities caps) throws AWTException {
            if (numBuffers <= 1) {
                throw new IllegalArgumentException("FlipBufferStrategy.createBuffers: numBuffers must be greater than one.");
            }
            if (!caps.isPageFlipping()) {
                throw new IllegalArgumentException("FlipBufferStrategy.createBuffers: flipping must be a specified capability.");
            }
            Component.this.peer.createBuffers(numBuffers, caps);
        }

        protected Image getBackBuffer() {
            return Component.this.peer.getBackBuffer();
        }

        protected void flip(BufferCapabilities.FlipContents flipAction) {
            Component.this.peer.flip(flipAction);
        }

        protected void destroyBuffers() {
            Component.this.peer.destroyBuffers();
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            return this.drawVBuffer.getGraphics();
        }

        protected void revalidate() {
            GraphicsConfiguration c = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            if (this.drawVBuffer.validate(c) == 2) {
                this.drawVBuffer = Component.this.peer.createVolatileImage(this.width, this.height);
            }
            this.validatedContents = true;
        }

        public boolean contentsLost() {
            if (this.drawVBuffer.contentsLost()) {
                this.validatedContents = false;
                return true;
            }
            this.validatedContents = true;
            return false;
        }

        public boolean contentsRestored() {
            GraphicsConfiguration c = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            int result = this.drawVBuffer.validate(c);
            boolean imageRestored = false;
            if (result == 1) {
                imageRestored = true;
            } else if (result == 2) {
                return false;
            }
            this.validatedContents = true;
            return imageRestored;
        }

        public void show() {
            this.flip(this.caps.getFlipContents());
        }

        protected FlipBufferStrategy(int numBuffers, BufferCapabilities caps) throws AWTException {
            this.caps = caps;
            this.width = Component.this.getWidth();
            this.height = Component.this.getHeight();
            if (numBuffers > 1) {
                this.createBuffers(numBuffers, caps);
            } else {
                this.drawVBuffer = Component.this.peer.createVolatileImage(this.width, this.height);
                this.drawBuffer = this.drawVBuffer;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class BltBufferStrategy
    extends BufferStrategy {
        protected BufferCapabilities caps;
        protected VolatileImage[] backBuffers;
        protected boolean validatedContents;
        protected int width;
        protected int height;
        private VolatileImage frontBuffer;

        protected void createBackBuffers(int numBuffers) {
            GraphicsConfiguration c = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.backBuffers = new VolatileImage[numBuffers];
            int i = 0;
            while (i < numBuffers) {
                this.backBuffers[i] = c.createCompatibleVolatileImage(this.width, this.height);
                ++i;
            }
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            return this.backBuffers[0].getGraphics();
        }

        public void show() {
            GraphicsConfiguration c = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            Component.this.getGraphics().drawImage(this.backBuffers[this.backBuffers.length - 1], this.width, this.height, null);
            BufferCapabilities.FlipContents f = this.getCapabilities().getFlipContents();
            int i = this.backBuffers.length - 1;
            while (i > 0) {
                this.backBuffers[i] = this.backBuffers[i - 1];
                --i;
            }
            if (f == BufferCapabilities.FlipContents.UNDEFINED) {
                this.backBuffers[0] = c.createCompatibleVolatileImage(this.width, this.height);
            }
            if (f == BufferCapabilities.FlipContents.BACKGROUND) {
                this.backBuffers[0] = c.createCompatibleVolatileImage(this.width, this.height);
                this.backBuffers[0].getGraphics().clearRect(0, 0, this.width, this.height);
            }
            if (f == BufferCapabilities.FlipContents.COPIED) {
                this.backBuffers[0] = this.backBuffers[this.backBuffers.length - 1];
            }
        }

        protected void revalidate() {
            GraphicsConfiguration c = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            int i = 0;
            while (i < this.backBuffers.length) {
                int result = this.backBuffers[i].validate(c);
                if (result == 2) {
                    this.backBuffers[i] = c.createCompatibleVolatileImage(this.width, this.height);
                }
                ++i;
            }
            this.validatedContents = true;
        }

        public boolean contentsLost() {
            int i = 0;
            while (i < this.backBuffers.length) {
                if (this.backBuffers[i].contentsLost()) {
                    this.validatedContents = false;
                    return true;
                }
                ++i;
            }
            this.validatedContents = true;
            return false;
        }

        public boolean contentsRestored() {
            GraphicsConfiguration c = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            boolean imageRestored = false;
            int i = 0;
            while (i < this.backBuffers.length) {
                int result = this.backBuffers[i].validate(c);
                if (result == 1) {
                    imageRestored = true;
                } else if (result == 2) {
                    return false;
                }
                ++i;
            }
            this.validatedContents = true;
            return imageRestored;
        }

        protected BltBufferStrategy(int numBuffers, BufferCapabilities caps) {
            this.caps = caps;
            this.createBackBuffers(numBuffers - 1);
            this.width = Component.this.getWidth();
            this.height = Component.this.getHeight();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected abstract class AccessibleAWTComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        private static final long serialVersionUID = 642321655757800191L;
        protected ComponentListener accessibleAWTComponentHandler;
        protected FocusListener accessibleAWTFocusHandler;

        public void addPropertyChangeListener(PropertyChangeListener l) {
            Component.this.addPropertyChangeListener(l);
            super.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            Component.this.removePropertyChangeListener(l);
            super.removePropertyChangeListener(l);
        }

        public String getAccessibleName() {
            return this.accessibleName == null ? Component.this.getName() : this.accessibleName;
        }

        public String getAccessibleDescription() {
            return this.accessibleDescription;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet s = new AccessibleStateSet();
            if (Component.this.isEnabled()) {
                s.add(AccessibleState.ENABLED);
            }
            if (Component.this.isFocusable()) {
                s.add(AccessibleState.FOCUSABLE);
            }
            if (Component.this.isFocusOwner()) {
                s.add(AccessibleState.FOCUSED);
            }
            if (Component.this.isOpaque()) {
                s.add(AccessibleState.OPAQUE);
            }
            if (Component.this.isShowing()) {
                s.add(AccessibleState.SHOWING);
            }
            if (Component.this.isVisible()) {
                s.add(AccessibleState.VISIBLE);
            }
            return s;
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent == null) {
                Container parent = Component.this.getParent();
                this.accessibleParent = parent instanceof Accessible ? (Accessible)((Object)parent) : null;
            }
            return this.accessibleParent;
        }

        public int getAccessibleIndexInParent() {
            if (this.getAccessibleParent() == null) {
                return -1;
            }
            AccessibleContext context = ((Component)((Object)this.accessibleParent)).getAccessibleContext();
            if (context == null) {
                return -1;
            }
            int i = context.getAccessibleChildrenCount();
            while (--i >= 0) {
                if (context.getAccessibleChild(i) != Component.this) continue;
                return i;
            }
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int i) {
            return null;
        }

        public Locale getLocale() {
            return Component.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return Component.this.getBackground();
        }

        public void setBackground(Color c) {
            Component.this.setBackground(c);
        }

        public Color getForeground() {
            return Component.this.getForeground();
        }

        public void setForeground(Color c) {
            Component.this.setForeground(c);
        }

        public Cursor getCursor() {
            return Component.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            Component.this.setCursor(cursor);
        }

        public Font getFont() {
            return Component.this.getFont();
        }

        public void setFont(Font f) {
            Component.this.setFont(f);
        }

        public FontMetrics getFontMetrics(Font f) {
            return Component.this.getFontMetrics(f);
        }

        public boolean isEnabled() {
            return Component.this.isEnabled();
        }

        public void setEnabled(boolean b) {
            Component.this.setEnabled(b);
        }

        public boolean isVisible() {
            return Component.this.isVisible();
        }

        public void setVisible(boolean b) {
            Component.this.setVisible(b);
        }

        public boolean isShowing() {
            return Component.this.isShowing();
        }

        public boolean contains(Point p) {
            return Component.this.contains(p.x, p.y);
        }

        public Point getLocationOnScreen() {
            return Component.this.isShowing() ? Component.this.getLocationOnScreen() : null;
        }

        public Point getLocation() {
            return Component.this.isShowing() ? Component.this.getLocation() : null;
        }

        public void setLocation(Point p) {
            Component.this.setLocation(p.x, p.y);
        }

        public Rectangle getBounds() {
            return Component.this.isShowing() ? Component.this.getBounds() : null;
        }

        public void setBounds(Rectangle r) {
            Component.this.setBounds(r.x, r.y, r.width, r.height);
        }

        public Dimension getSize() {
            return Component.this.isShowing() ? Component.this.getSize() : null;
        }

        public void setSize(Dimension d) {
            Component.this.setSize(d.width, d.height);
        }

        public Accessible getAccessibleAt(Point p) {
            return null;
        }

        public boolean isFocusTraversable() {
            return Component.this.isFocusTraversable();
        }

        public void requestFocus() {
            Component.this.requestFocus();
        }

        public void addFocusListener(FocusListener l) {
            Component.this.addFocusListener(l);
        }

        public void removeFocusListener(FocusListener l) {
            Component.this.removeFocusListener(l);
        }

        private final /* synthetic */ void this() {
            this.accessibleAWTComponentHandler = new AccessibleAWTComponentHandler();
            this.accessibleAWTFocusHandler = new AccessibleAWTFocusHandler();
        }

        protected AccessibleAWTComponent() {
            this.this();
            Component.this.addComponentListener(this.accessibleAWTComponentHandler);
            Component.this.addFocusListener(this.accessibleAWTFocusHandler);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleAWTComponentHandler
        implements ComponentListener {
            public void componentHidden(ComponentEvent e) {
                AccessibleAWTComponent.this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent e) {
                AccessibleAWTComponent.this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
            }

            protected AccessibleAWTComponentHandler() {
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleAWTFocusHandler
        implements FocusListener {
            public void focusGained(FocusEvent e) {
                AccessibleAWTComponent.this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }

            public void focusLost(FocusEvent e) {
                AccessibleAWTComponent.this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }

            protected AccessibleAWTFocusHandler() {
            }
        }
    }
}

