/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class GeneralPath
implements Shape,
Cloneable {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final int INIT_SIZE = 10;
    private static final double BIG_VALUE = 1.7976931348623158E307;
    int rule;
    byte[] types;
    float[] xpoints;
    float[] ypoints;
    private int subpath;
    int index;

    public final void moveTo(float x, float y) {
        this.subpath = this.index;
        this.ensureSize(this.index + 1);
        this.types[this.index] = 0;
        this.xpoints[this.index] = x;
        this.ypoints[this.index++] = y;
    }

    public final void lineTo(float x, float y) {
        this.ensureSize(this.index + 1);
        this.types[this.index] = 1;
        this.xpoints[this.index] = x;
        this.ypoints[this.index++] = y;
    }

    public final void quadTo(float x1, float y1, float x2, float y2) {
        this.ensureSize(this.index + 2);
        this.types[this.index] = 2;
        this.xpoints[this.index] = x1;
        this.ypoints[this.index++] = y1;
        this.xpoints[this.index] = x2;
        this.ypoints[this.index++] = y2;
    }

    public final void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.ensureSize(this.index + 3);
        this.types[this.index] = 3;
        this.xpoints[this.index] = x1;
        this.ypoints[this.index++] = y1;
        this.xpoints[this.index] = x2;
        this.ypoints[this.index++] = y2;
        this.xpoints[this.index] = x3;
        this.ypoints[this.index++] = y3;
    }

    public final void closePath() {
        this.ensureSize(this.index + 1);
        this.types[this.index] = 4;
        this.xpoints[this.index] = this.xpoints[this.subpath];
        this.ypoints[this.index++] = this.ypoints[this.subpath];
    }

    public final void append(Shape s, boolean connect) {
        this.append(s.getPathIterator(null), connect);
    }

    public final void append(PathIterator iter, boolean connect) {
        float[] f = new float[6];
        while (!iter.isDone()) {
            switch (iter.currentSegment(f)) {
                case 0: {
                    if (!connect || this.index == 0) {
                        this.moveTo(f[0], f[1]);
                        break;
                    }
                    if (this.index >= 1 && this.types[this.index - 1] == 4 && f[0] == this.xpoints[this.index - 1] && f[1] == this.ypoints[this.index - 1]) break;
                }
                case 1: {
                    this.lineTo(f[0], f[1]);
                    break;
                }
                case 2: {
                    this.quadTo(f[0], f[1], f[2], f[3]);
                    break;
                }
                case 3: {
                    this.curveTo(f[0], f[1], f[2], f[3], f[4], f[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                    break;
                }
            }
            connect = false;
            iter.next();
        }
    }

    public final int getWindingRule() {
        return this.rule;
    }

    public final void setWindingRule(int rule) {
        if (rule != 0 && rule != 1) {
            throw new IllegalArgumentException();
        }
        this.rule = rule;
    }

    public final Point2D getCurrentPoint() {
        if (this.subpath < 0) {
            return null;
        }
        return new Point2D.Float(this.xpoints[this.index - 1], this.ypoints[this.index - 1]);
    }

    public final void reset() {
        this.subpath = -1;
        this.index = 0;
    }

    public final void transform(AffineTransform xform) {
        double[] m = new double[6];
        xform.getMatrix(m);
        int i = 0;
        while (i < this.index) {
            double nx = m[0] * (double)this.xpoints[i] + m[2] * (double)this.ypoints[i] + m[4];
            double ny = m[1] * (double)this.xpoints[i] + m[3] * (double)this.ypoints[i] + m[5];
            this.xpoints[i] = (float)nx;
            this.ypoints[i] = (float)ny;
            ++i;
        }
    }

    public final Shape createTransformedShape(AffineTransform xform) {
        GeneralPath p = new GeneralPath(this);
        p.transform(xform);
        return p;
    }

    public final Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public final Rectangle2D getBounds2D() {
        float y1;
        float y2;
        float x1;
        float x2;
        if (this.index > 0) {
            x1 = x2 = this.xpoints[0];
            y1 = y2 = this.ypoints[0];
        } else {
            y2 = 0.0f;
            y1 = 0.0f;
            x2 = 0.0f;
            x1 = 0.0f;
        }
        int i = 0;
        while (i < this.index) {
            x1 = Math.min(this.xpoints[i], x1);
            y1 = Math.min(this.ypoints[i], y1);
            x2 = Math.max(this.xpoints[i], x2);
            y2 = Math.max(this.ypoints[i], y2);
            ++i;
        }
        return new Rectangle2D.Float(x1, y1, x2 - x1, y2 - y1);
    }

    public final boolean contains(double x, double y) {
        boolean bl = false;
        if (this.getWindingNumber(x, y) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public final boolean contains(double x, double y, double w, double h) {
        if (!this.getBounds2D().intersects(x, y, w, h)) {
            return false;
        }
        if (this.getAxisIntersections(x, y, false, w) != 0 || this.getAxisIntersections(x, y + h, false, w) != 0 || this.getAxisIntersections(x + w, y, true, h) != 0 || this.getAxisIntersections(x, y, true, h) != 0) {
            return false;
        }
        return this.getWindingNumber(x, y) != 0;
    }

    public final boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean intersects(double x, double y, double w, double h) {
        if (this.getAxisIntersections(x, y, false, w) != 0 || this.getAxisIntersections(x, y + h, false, w) != 0 || this.getAxisIntersections(x + w, y, true, h) != 0 || this.getAxisIntersections(x, y, true, h) != 0) {
            return true;
        }
        return this.getWindingNumber(x, y) != 0;
    }

    public final boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final PathIterator getPathIterator(AffineTransform at) {
        return new GeneralPathIterator(this, at);
    }

    public final PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    public final Object clone() {
        return new GeneralPath(this);
    }

    private final void ensureSize(int size) {
        if (this.subpath < 0) {
            throw new IllegalPathStateException("need initial moveto");
        }
        if (size <= this.xpoints.length) {
            return;
        }
        byte[] b = new byte[this.types.length << 1];
        System.arraycopy(this.types, 0, b, 0, this.index);
        this.types = b;
        float[] f = new float[this.xpoints.length << 1];
        System.arraycopy(this.xpoints, 0, f, 0, this.index);
        this.xpoints = f;
        f = new float[this.ypoints.length << 1];
        System.arraycopy(this.ypoints, 0, f, 0, this.index);
        this.ypoints = f;
    }

    private final int getAxisIntersections(double x, double y, boolean useYaxis, double distance) {
        return this.evaluateCrossings(x, y, false, useYaxis, distance);
    }

    private final int getWindingNumber(double x, double y) {
        return this.evaluateCrossings(x, y, true, true, 1.7976931348623158E307);
    }

    private final int evaluateCrossings(double x, double y, boolean neg, boolean useYaxis, double distance) {
        float cx = 0.0f;
        float cy = 0.0f;
        float firstx = 0.0f;
        float firsty = 0.0f;
        int negative = neg ? -1 : 1;
        double[] r = new double[4];
        double epsilon = 0.0;
        int pos = 0;
        int windingNumber = 0;
        boolean pathStarted = false;
        if (this.index == 0) {
            return 0;
        }
        if (useYaxis) {
            float[] swap1 = this.ypoints;
            this.ypoints = this.xpoints;
            this.xpoints = swap1;
            double swap2 = y;
            y = x;
            x = swap2;
        }
        if ((epsilon = (double)this.ypoints[0] * 1.0E-7) == 0.0) {
            epsilon = 1.0E-7;
        }
        pos = 0;
        while (pos < this.index) {
            switch (this.types[pos]) {
                case 0: {
                    double y1;
                    double x1;
                    double y0;
                    double x0;
                    if (pathStarted) {
                        x0 = cx;
                        y0 = cy;
                        x1 = firstx;
                        y1 = firsty;
                        if (y0 == 0.0) {
                            y0 -= epsilon;
                        }
                        if (y1 == 0.0) {
                            y1 -= epsilon;
                        }
                        if (Line2D.linesIntersect(x0, y0, x1, y1, epsilon, 0.0, distance, 0.0)) {
                            int n = 1;
                            if (!(y1 < y0)) {
                                n = negative;
                            }
                            windingNumber += n;
                        }
                        cx = firstx;
                        cy = firsty;
                    }
                    cx = firstx = this.xpoints[pos] - (float)x;
                    cy = firsty = this.ypoints[pos++] - (float)y;
                    pathStarted = true;
                    break;
                }
                case 4: {
                    double x0 = cx;
                    double y0 = cy;
                    double x1 = firstx;
                    double y1 = firsty;
                    if (y0 == 0.0) {
                        y0 -= epsilon;
                    }
                    if (y1 == 0.0) {
                        y1 -= epsilon;
                    }
                    if (Line2D.linesIntersect(x0, y0, x1, y1, epsilon, 0.0, distance, 0.0)) {
                        int n = 1;
                        if (!(y1 < y0)) {
                            n = negative;
                        }
                        windingNumber += n;
                    }
                    cx = firstx;
                    cy = firsty;
                    ++pos;
                    pathStarted = false;
                    break;
                }
                case 1: {
                    double x0 = cx;
                    double y0 = cy;
                    double x1 = this.xpoints[pos] - (float)x;
                    double y1 = this.ypoints[pos++] - (float)y;
                    if (y0 == 0.0) {
                        y0 -= epsilon;
                    }
                    if (y1 == 0.0) {
                        y1 -= epsilon;
                    }
                    if (Line2D.linesIntersect(x0, y0, x1, y1, epsilon, 0.0, distance, 0.0)) {
                        int n = 1;
                        if (!(y1 < y0)) {
                            n = negative;
                        }
                        windingNumber += n;
                    }
                    cx = this.xpoints[pos - 1] - (float)x;
                    cy = this.ypoints[pos - 1] - (float)y;
                    break;
                }
                case 2: {
                    double crossing;
                    int nRoots;
                    double x0 = cx;
                    double y0 = cy;
                    double x1 = (double)this.xpoints[pos] - x;
                    double y1 = (double)this.ypoints[pos++] - y;
                    double x2 = (double)this.xpoints[pos] - x;
                    double y2 = (double)this.ypoints[pos++] - y;
                    if ((x0 > 0.0 || x1 > 0.0 || x2 > 0.0) && (y0 * y1 <= 0.0 || y1 * y2 <= 0.0)) {
                        if (y0 == 0.0) {
                            y0 -= epsilon;
                        }
                        if (y2 == 0.0) {
                            y2 -= epsilon;
                        }
                        r[0] = y0;
                        r[1] = (double)2 * (y1 - y0);
                        r[2] = y2 - (double)2 * y1 + y0;
                        nRoots = QuadCurve2D.solveQuadratic(r);
                        if (nRoots == 2) {
                            int i = 0;
                            while (i < nRoots) {
                                float t = (float)r[i];
                                if (t > 0.0f && t < 1.0f && (crossing = (double)(t * t) * (x2 - (double)2 * x1 + x0) + (double)(2.0f * t) * (x1 - x0) + x0) >= 0.0 && crossing <= distance) {
                                    int n = 1;
                                    if (!((double)(2.0f * t) * (y2 - (double)2 * y1 + y0) + (double)2 * (y1 - y0) < 0.0)) {
                                        n = negative;
                                    }
                                    windingNumber += n;
                                }
                                ++i;
                            }
                        }
                    }
                    cx = this.xpoints[pos - 1] - (float)x;
                    cy = this.ypoints[pos - 1] - (float)y;
                    break;
                }
                case 3: {
                    double crossing;
                    int nRoots;
                    double x0 = cx;
                    double y0 = cy;
                    double x1 = (double)this.xpoints[pos] - x;
                    double y1 = (double)this.ypoints[pos++] - y;
                    double x2 = (double)this.xpoints[pos] - x;
                    double y2 = (double)this.ypoints[pos++] - y;
                    double x3 = (double)this.xpoints[pos] - x;
                    double y3 = (double)this.ypoints[pos++] - y;
                    if ((x0 > 0.0 || x1 > 0.0 || x2 > 0.0 || x3 > 0.0) && (y0 * y1 <= 0.0 || y1 * y2 <= 0.0 || y2 * y3 <= 0.0)) {
                        if (y0 == 0.0) {
                            y0 -= epsilon;
                        }
                        if (y3 == 0.0) {
                            y3 -= epsilon;
                        }
                        r[0] = y0;
                        r[1] = (double)3 * (y1 - y0);
                        r[2] = (double)3 * (y2 + y0 - (double)2 * y1);
                        r[3] = y3 - (double)3 * y2 + (double)3 * y1 - y0;
                        nRoots = CubicCurve2D.solveCubic(r);
                        if (nRoots != 0) {
                            int i = 0;
                            while (i < nRoots) {
                                float t = (float)r[i];
                                if ((double)t > 0.0 && (double)t < 1.0 && (crossing = (double)(-(t * t * t)) * (x0 - (double)3 * x1 + (double)3 * x2 - x3) + (double)((float)3 * t * t) * (x0 - (double)2 * x1 + x2) + (double)((float)3 * t) * (x1 - x0) + x0) >= 0.0 && crossing <= distance) {
                                    int n = 1;
                                    if (!((double)((float)3 * t * t) * (y3 + (double)3 * y1 - (double)3 * y2 - y0) + (double)(6.0f * t) * (y0 - (double)2 * y1 + y2) + (double)3 * (y1 - y0) < 0.0)) {
                                        n = negative;
                                    }
                                    windingNumber += n;
                                }
                                ++i;
                            }
                        }
                    }
                    cx = this.xpoints[pos - 1] - (float)x;
                    cy = this.ypoints[pos - 1] - (float)y;
                    break;
                }
            }
        }
        if (useYaxis) {
            float[] swap = this.ypoints;
            this.ypoints = this.xpoints;
            this.xpoints = swap;
        }
        return windingNumber;
    }

    private final /* synthetic */ void this() {
        this.subpath = -1;
    }

    public GeneralPath() {
        this(1, 10);
    }

    public GeneralPath(int rule) {
        this(rule, 10);
    }

    public GeneralPath(int rule, int capacity) {
        this.this();
        if (rule != 0 && rule != 1) {
            throw new IllegalArgumentException();
        }
        this.rule = rule;
        if (capacity < 10) {
            capacity = 10;
        }
        this.types = new byte[capacity];
        this.xpoints = new float[capacity];
        this.ypoints = new float[capacity];
    }

    public GeneralPath(Shape s) {
        this.this();
        this.types = new byte[10];
        this.xpoints = new float[10];
        this.ypoints = new float[10];
        PathIterator pi = s.getPathIterator(null);
        this.setWindingRule(pi.getWindingRule());
        this.append(pi, false);
    }

    private static class GeneralPathIterator
    implements PathIterator {
        private static final int[] NUM_COORDS;
        final GeneralPath path;
        private final AffineTransform transform;
        private int pos;

        public int getWindingRule() {
            return this.path.rule;
        }

        public boolean isDone() {
            boolean bl = false;
            if (this.pos >= this.path.index) {
                bl = true;
            }
            return bl;
        }

        public void next() {
            byte seg = this.path.types[this.pos];
            this.pos = seg == 4 ? ++this.pos : (this.pos += NUM_COORDS[seg]);
        }

        public int currentSegment(float[] coords) {
            byte seg = this.path.types[this.pos];
            int numCoords = NUM_COORDS[seg];
            if (numCoords > 0) {
                int i = 0;
                while (i < numCoords) {
                    coords[i << 1] = this.path.xpoints[this.pos + i];
                    coords[(i << 1) + 1] = this.path.ypoints[this.pos + i];
                    ++i;
                }
                if (this.transform != null) {
                    this.transform.transform(coords, 0, coords, 0, numCoords);
                }
            }
            return seg;
        }

        public int currentSegment(double[] coords) {
            byte seg = this.path.types[this.pos];
            int numCoords = NUM_COORDS[seg];
            if (numCoords > 0) {
                int i = 0;
                while (i < numCoords) {
                    coords[i << 1] = this.path.xpoints[this.pos + i];
                    coords[(i << 1) + 1] = this.path.ypoints[this.pos + i];
                    ++i;
                }
                if (this.transform != null) {
                    this.transform.transform(coords, 0, coords, 0, numCoords);
                }
            }
            return seg;
        }

        GeneralPathIterator(GeneralPath path, AffineTransform transform) {
            this.path = path;
            this.transform = transform;
        }

        static {
            int[] nArray = new int[5];
            nArray[0] = 1;
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            NUM_COORDS = nArray;
        }
    }
}

