/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Timestamp
extends Date {
    static final long serialVersionUID = 2745179027874758501L;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static DecimalFormat decimalFormat = new DecimalFormat("000000000");
    private static StringBuffer sbuf = new StringBuffer(29);
    private int nanos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Timestamp valueOf(String str) {
        int nanos = 0;
        int dot = str.indexOf(46);
        if (dot != -1) {
            if (str.lastIndexOf(46) != dot) {
                throw new IllegalArgumentException(str);
            }
            int len = str.length() - dot - 1;
            if (len < 1 || len > 9) {
                throw new IllegalArgumentException(str);
            }
            nanos = Integer.parseInt(str.substring(dot + 1));
            int i = len;
            while (i < 9) {
                nanos *= 10;
                ++i;
            }
            str = str.substring(0, dot);
        }
        try {
            Date d;
            block9: {
                SimpleDateFormat simpleDateFormat = dateFormat;
                synchronized (simpleDateFormat) {
                    d = (Date)dateFormat.parseObject(str);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl21 : MonitorExitStatement: MONITOREXIT : var4_7
                    if (d != null) break block9;
                    throw new IllegalArgumentException(str);
                }
            }
            Timestamp ts = new Timestamp(d.getTime() + (long)(nanos / 1000000));
            ts.nanos = nanos;
            return ts;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(str);
        }
    }

    public long getTime() {
        return super.getTime() + (long)(this.nanos / 1000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            sbuf.setLength(0);
            dateFormat.format(this, sbuf, null);
            sbuf.append('.');
            decimalFormat.format(this.nanos, sbuf, (FieldPosition)null);
            int end = sbuf.length() - 1;
            while (end > 20 && sbuf.charAt(end) == '0') {
                --end;
            }
            return sbuf.substring(0, end + 1);
        }
    }

    public int getNanos() {
        return this.nanos;
    }

    public void setNanos(int nanos) {
        this.nanos = nanos;
    }

    public boolean before(Timestamp ts) {
        long time2;
        long time1 = this.getTime();
        return time1 < (time2 = ts.getTime()) || time1 == time2 && this.getNanos() < ts.getNanos();
    }

    public boolean after(Timestamp ts) {
        long time2;
        long time1 = this.getTime();
        return time1 > (time2 = ts.getTime()) || time1 == time2 && this.getNanos() > ts.getNanos();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Timestamp)) {
            return false;
        }
        return this.equals((Timestamp)obj);
    }

    public boolean equals(Timestamp ts) {
        if (ts == null) {
            return false;
        }
        if (ts.getTime() != this.getTime()) {
            return false;
        }
        return ts.getNanos() == this.getNanos();
    }

    public int compareTo(Timestamp ts) {
        int s = super.compareTo(ts);
        if (s != 0) {
            return s;
        }
        return this.nanos - ts.nanos;
    }

    public int compareTo(Object obj) {
        return this.compareTo((Timestamp)obj);
    }

    public Timestamp(int year, int month, int day, int hour, int minute, int second, int nanos) {
        super(year, month, day, hour, minute, second);
        this.nanos = nanos;
    }

    public Timestamp(long date) {
        super(date - date % 1000L);
        this.nanos = (int)(date % 1000L) * 1000000;
    }
}

