/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataFormatImpl;
import javax.imageio.spi.IIOServiceProvider;

public abstract class ImageReaderWriterSpi
extends IIOServiceProvider {
    protected String[] names;
    protected String[] suffixes;
    protected String[] MIMETypes;
    protected String pluginClassName;
    protected boolean supportsStandardStreamMetadataFormat;
    protected String nativeStreamMetadataFormatName;
    protected String nativeStreamMetadataFormatClassName;
    protected String[] extraStreamMetadataFormatNames;
    protected String[] extraStreamMetadataFormatClassNames;
    protected boolean supportsStandardImageMetadataFormat;
    protected String nativeImageMetadataFormatName;
    protected String nativeImageMetadataFormatClassName;
    protected String[] extraImageMetadataFormatNames;
    protected String[] extraImageMetadataFormatClassNames;

    public String[] getFormatNames() {
        return (String[])this.names.clone();
    }

    public String[] getFileSuffixes() {
        return this.suffixes;
    }

    public String[] getMIMETypes() {
        return this.MIMETypes;
    }

    public String getPluginClassName() {
        return this.pluginClassName;
    }

    public boolean isStandardStreamMetadataFormatSupported() {
        return this.supportsStandardStreamMetadataFormat;
    }

    public String getNativeStreamMetadataFormatName() {
        return this.nativeStreamMetadataFormatName;
    }

    public String[] getExtraStreamMetadataFormatNames() {
        return this.extraStreamMetadataFormatNames;
    }

    public boolean isStandardImageMetadataFormatSupported() {
        return this.supportsStandardImageMetadataFormat;
    }

    public String getNativeImageMetadataFormatName() {
        return this.nativeImageMetadataFormatName;
    }

    public String[] getExtraImageMetadataFormatNames() {
        return this.extraImageMetadataFormatNames;
    }

    public IIOMetadataFormat getStreamMetadataFormat(String formatName) {
        if (formatName == null) {
            throw new IllegalArgumentException("null stream metadata format name");
        }
        if (!formatName.equals(this.getNativeStreamMetadataFormatName()) && !formatName.equals("javax_imageio_1.0")) {
            String[] extraNames = this.getExtraStreamMetadataFormatNames();
            boolean foundName = false;
            int i = 0;
            while (i < extraNames.length) {
                if (formatName.equals(extraNames[i])) {
                    foundName = true;
                    break;
                }
                ++i;
            }
            if (!foundName) {
                throw new IllegalArgumentException("unsupported stream metadata format name");
            }
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return IIOMetadataFormatImpl.getStandardFormatInstance();
        }
        return null;
    }

    public IIOMetadataFormat getImageMetadataFormat(String formatName) {
        if (formatName == null) {
            throw new IllegalArgumentException("null image metadata format name");
        }
        if (!formatName.equals(this.getNativeImageMetadataFormatName()) && !formatName.equals("javax_imageio_1.0")) {
            String[] extraNames = this.getExtraImageMetadataFormatNames();
            boolean foundName = false;
            int i = 0;
            while (i < extraNames.length) {
                if (formatName.equals(extraNames[i])) {
                    foundName = true;
                    break;
                }
                ++i;
            }
            if (!foundName) {
                throw new IllegalArgumentException("unsupported image metadata format name");
            }
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return IIOMetadataFormatImpl.getStandardFormatInstance();
        }
        return null;
    }

    public ImageReaderWriterSpi() {
    }

    public ImageReaderWriterSpi(String vendorName, String version, String[] names, String[] suffixes, String[] MIMETypes, String pluginClassName, boolean supportsStandardStreamMetadataFormat, String nativeStreamMetadataFormatName, String nativeStreamMetadataFormatClassName, String[] extraStreamMetadataFormatNames, String[] extraStreamMetadataFormatClassNames, boolean supportsStandardImageMetadataFormat, String nativeImageMetadataFormatName, String nativeImageMetadataFormatClassName, String[] extraImageMetadataFormatNames, String[] extraImageMetadataFormatClassNames) {
        super(vendorName, version);
        if (names == null || names.length == 0 || pluginClassName == null) {
            throw new IllegalArgumentException();
        }
        this.names = names;
        this.suffixes = suffixes;
        this.MIMETypes = MIMETypes;
        this.pluginClassName = pluginClassName;
        this.supportsStandardStreamMetadataFormat = supportsStandardStreamMetadataFormat;
        this.nativeStreamMetadataFormatName = nativeStreamMetadataFormatName;
        this.nativeStreamMetadataFormatClassName = nativeStreamMetadataFormatClassName;
        this.extraStreamMetadataFormatNames = extraStreamMetadataFormatNames;
        this.extraStreamMetadataFormatClassNames = extraStreamMetadataFormatClassNames;
        this.supportsStandardImageMetadataFormat = supportsStandardImageMetadataFormat;
        this.nativeImageMetadataFormatName = nativeImageMetadataFormatName;
        this.nativeImageMetadataFormatClassName = nativeImageMetadataFormatClassName;
        this.extraImageMetadataFormatNames = extraImageMetadataFormatNames;
        this.extraImageMetadataFormatClassNames = extraImageMetadataFormatClassNames;
    }
}

