#                                                         -*- Perl -*-
# Copyright (c) 1999, 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# ե뤿Υ饹
#
package FreePWING::Tag;

require 5.005;
require Exporter;
use FileHandle;
use English;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK);

@ISA = qw(Exporter);

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    my $new = {
	# եΥϥɥ
	'handle' => FileHandle->new(),

	# ե̾
	'file_name' => '',

	# ޤǤ˽񤭹ȥ
	'entry_count' => 0,

	# 顼å
	'error_message' => '',
    };
    return bless($new, $type);
}

#
# :
#	open(file_name)
#           file_name
#		ե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽å
# :
# 	񤭹Ѥ˥ե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    my ($file_name) = @ARG;

    #
    # ե򳫤
    #
    $self->{'file_name'} = $file_name;
    if (!$self->{'handle'}->open($self->{'file_name'}, 'w')) {
	$self->{'error_message'} = 
	    "failed to open the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }

    return 1;
}

#
# :
#	close()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	եĤ롣ƤʤС⤷ʤ
# :
#	 1 ֤
#
sub close {
    my $self = shift;

    $self->close_internal();
    return 1;
}

#
# :
#	close_internal()
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
#	close() ѥ᥽åɡ
#
sub close_internal {
    my $self = shift;

    if ($self->{'handle'}->fileno()) {
	$self->{'handle'}->close();
    }
}

#
# :
#	add_entry(tag_name, target_position)
#           tag_name
#		̾
#           position
# 		
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ե˥ɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_entry {
    my $self = shift;
    my ($tag_name, $position) = @ARG;

    if ($tag_name !~ /^[0-9A-Za-z_\:\-]*$/) {
	$self->{'error_message'} = "invalid tag name: $tag_name";
	$self->close_internal();
	return 0;
    }
    if (!$self->{'handle'}->printf("\%s\t%08x\n", $tag_name, $position)) {
	$self->{'error_message'} = 
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }
    $self->{'entry_count'}++;
    return 1;
}

######################################################################
# <󥹥ѿ֤ͤ᥽åɷ>
#
# :
#	󥹥ѿ̾()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
#	󥹥ѿ֤ͤ
#
sub file_name {
    my $self = shift;
    return $self->{'file_name'};
}

sub tag_file_name {
    my $self = shift;
    return $self->{'tag_file_name'};
}

sub entry_count {
    my $self = shift;
    return $self->{'entry_count'};
}

sub error_message {
    my $self = shift;
    return $self->{'error_message'};
}

1;
