/*****
 NAME
 	csystem.h - header file for CSystem class
 VERSION
 	$Id$
 CHANGELOG	
 	$Log$
 */

#if !defined(CSYSTEM_H_INCLUDED)
#define	CSYSTEM_H_INCLUDED

#include <coconut/cobject.h>
#include <coconut/psystem.h>
#include <coconut/pallocator.h>
#include <setjmp.h>

int start_program(id <PSystem> system, int argc, const char ** argv) ;

@interface CSystem : CObject <PSystemFactory, PSystem>
{
	id <POptParser>	system_opt_parser ;
	id <PObstack>	system_obstack ;

	/* result of the main loop which is set nil in the initializer
	   and set in the exitMainLoop method. */
	id <PError>	main_result ;
	int		main_loop_nest ;
}

 + pushJump: (jmp_buf *) env ;
 + popJump ;
 + getJump: (jmp_buf *) env ;

@end

#endif /* !defined(CSYSTEM_H_INCLUDED) */

