/* -*- Mode: C; c-file-style: "gnu" -*-
   native-threads.h -- API for native threads and monitors.
   Created: Chris Toshok <toshok@hungry.com>, 26-Jul-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _native_threads_h
#define _native_threads_h

#include "jni.h"

#ifdef __cplusplus
extern "C" {
#endif

  /* These should mirror the constants set in the java Thread class */
#define JTHR_MAX_PRIORITY 10
#define JTHR_MIN_PRIORITY 1
#define JTHR_DEFAULT_PRIORITY 5

  typedef void* HThread;

  JNIEXPORT HThread JNICALL THREAD_start(void *(*start_function)(void*),
					 void *start_arg,
					 int priority,
					 int initialStackSize);

  JNIEXPORT void JNICALL THREAD_setPriority(HThread thread, int priority);
  JNIEXPORT void JNICALL THREAD_exit(void);

  JNIEXPORT int JNICALL THREAD_delete(HThread thread);

  JNIEXPORT void JNICALL THREAD_yield(void);
  JNIEXPORT void JNICALL THREAD_sleep(jlong);

  JNIEXPORT void JNICALL THREAD_suspend(HThread thread);
  JNIEXPORT void JNICALL THREAD_resume(HThread thread);

  JNIEXPORT HThread JNICALL THREAD_getCurrent(void);

  JNIEXPORT void JNICALL THREAD_setName(HThread thread, char *name);

  JNIEXPORT void JNICALL THREAD_setEnv(JNIEnv *env);
  JNIEXPORT void JNICALL THREAD_setVM(JavaVM *vm);
  JNIEXPORT JNIEnv * JNICALL THREAD_getEnv(void);
  JNIEXPORT JavaVM * JNICALL THREAD_getVM(void);

  JNIEXPORT void JNICALL THREAD_setJavaInfo(void *info);
  JNIEXPORT void * JNICALL THREAD_getJavaInfo(void);


  typedef struct MonitorStruct* HMonitor;

  JNIEXPORT HMonitor JNICALL MONITOR_create(void);
  JNIEXPORT void JNICALL MONITOR_destroy(HMonitor mon);
  JNIEXPORT void JNICALL MONITOR_enter(HMonitor mon);
  /* Return 1 on success and 0 if current thread don't own the monitor */
  JNIEXPORT int JNICALL MONITOR_exit(HMonitor mon);
  JNIEXPORT int JNICALL MONITOR_wait(HMonitor mon);
  JNIEXPORT int JNICALL MONITOR_timedWait(HMonitor mon, jlong time_to_wait);
  JNIEXPORT int JNICALL MONITOR_notifyOne(HMonitor mon);
  JNIEXPORT int JNICALL MONITOR_notifyAll(HMonitor mon);

  JNIEXPORT HMonitor JNICALL MONITOR_getForObject(jobject obj);

#ifdef __cplusplus
};
#endif

#endif /* _native_threads_h */
