require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_ERR_H)) {
    eval 'sub OPENSSL_ERR_H () {1;}' unless defined(&OPENSSL_ERR_H);
    require 'openssl/macros.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub HEADER_ERR_H () {1;}' unless defined(&HEADER_ERR_H);
    }
    require 'openssl/e_os2.ph';
    unless(defined(&OPENSSL_NO_STDIO)) {
	require 'stdio.ph';
	require 'stdlib.ph';
    }
    require 'openssl/types.ph';
    require 'openssl/bio.ph';
    require 'openssl/lhash.ph';
    require 'openssl/cryptoerr_legacy.ph';
    if(defined(&__cplusplus)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	unless(defined(&OPENSSL_NO_FILENAMES)) {
	    eval 'sub ERR_PUT_error {
	        my($l,$f,$r,$fn,$ln) = @_;
    		eval q( &ERR_put_error($l,$f,$r,$fn,$ln));
	    }' unless defined(&ERR_PUT_error);
	} else {
	    eval 'sub ERR_PUT_error {
	        my($l,$f,$r,$fn,$ln) = @_;
    		eval q( &ERR_put_error($l,$f,$r, &NULL,0));
	    }' unless defined(&ERR_PUT_error);
	}
    }
    require 'limits.ph';
    require 'errno.ph';
    eval 'sub ERR_TXT_MALLOCED () {0x1;}' unless defined(&ERR_TXT_MALLOCED);
    eval 'sub ERR_TXT_STRING () {0x2;}' unless defined(&ERR_TXT_STRING);
    if(!defined(&OPENSSL_NO_DEPRECATED_3_0) || defined(&OSSL_FORCE_ERR_STATE)) {
	eval 'sub ERR_FLAG_MARK () {0x1;}' unless defined(&ERR_FLAG_MARK);
	eval 'sub ERR_FLAG_CLEAR () {0x2;}' unless defined(&ERR_FLAG_CLEAR);
	eval 'sub ERR_NUM_ERRORS () {16;}' unless defined(&ERR_NUM_ERRORS);
    }
    eval 'sub ERR_LIB_NONE () {1;}' unless defined(&ERR_LIB_NONE);
    eval 'sub ERR_LIB_SYS () {2;}' unless defined(&ERR_LIB_SYS);
    eval 'sub ERR_LIB_BN () {3;}' unless defined(&ERR_LIB_BN);
    eval 'sub ERR_LIB_RSA () {4;}' unless defined(&ERR_LIB_RSA);
    eval 'sub ERR_LIB_DH () {5;}' unless defined(&ERR_LIB_DH);
    eval 'sub ERR_LIB_EVP () {6;}' unless defined(&ERR_LIB_EVP);
    eval 'sub ERR_LIB_BUF () {7;}' unless defined(&ERR_LIB_BUF);
    eval 'sub ERR_LIB_OBJ () {8;}' unless defined(&ERR_LIB_OBJ);
    eval 'sub ERR_LIB_PEM () {9;}' unless defined(&ERR_LIB_PEM);
    eval 'sub ERR_LIB_DSA () {10;}' unless defined(&ERR_LIB_DSA);
    eval 'sub ERR_LIB_X509 () {11;}' unless defined(&ERR_LIB_X509);
    eval 'sub ERR_LIB_ASN1 () {13;}' unless defined(&ERR_LIB_ASN1);
    eval 'sub ERR_LIB_CONF () {14;}' unless defined(&ERR_LIB_CONF);
    eval 'sub ERR_LIB_CRYPTO () {15;}' unless defined(&ERR_LIB_CRYPTO);
    eval 'sub ERR_LIB_EC () {16;}' unless defined(&ERR_LIB_EC);
    eval 'sub ERR_LIB_SSL () {20;}' unless defined(&ERR_LIB_SSL);
    eval 'sub ERR_LIB_BIO () {32;}' unless defined(&ERR_LIB_BIO);
    eval 'sub ERR_LIB_PKCS7 () {33;}' unless defined(&ERR_LIB_PKCS7);
    eval 'sub ERR_LIB_X509V3 () {34;}' unless defined(&ERR_LIB_X509V3);
    eval 'sub ERR_LIB_PKCS12 () {35;}' unless defined(&ERR_LIB_PKCS12);
    eval 'sub ERR_LIB_RAND () {36;}' unless defined(&ERR_LIB_RAND);
    eval 'sub ERR_LIB_DSO () {37;}' unless defined(&ERR_LIB_DSO);
    eval 'sub ERR_LIB_ENGINE () {38;}' unless defined(&ERR_LIB_ENGINE);
    eval 'sub ERR_LIB_OCSP () {39;}' unless defined(&ERR_LIB_OCSP);
    eval 'sub ERR_LIB_UI () {40;}' unless defined(&ERR_LIB_UI);
    eval 'sub ERR_LIB_COMP () {41;}' unless defined(&ERR_LIB_COMP);
    eval 'sub ERR_LIB_ECDSA () {42;}' unless defined(&ERR_LIB_ECDSA);
    eval 'sub ERR_LIB_ECDH () {43;}' unless defined(&ERR_LIB_ECDH);
    eval 'sub ERR_LIB_OSSL_STORE () {44;}' unless defined(&ERR_LIB_OSSL_STORE);
    eval 'sub ERR_LIB_FIPS () {45;}' unless defined(&ERR_LIB_FIPS);
    eval 'sub ERR_LIB_CMS () {46;}' unless defined(&ERR_LIB_CMS);
    eval 'sub ERR_LIB_TS () {47;}' unless defined(&ERR_LIB_TS);
    eval 'sub ERR_LIB_HMAC () {48;}' unless defined(&ERR_LIB_HMAC);
    eval 'sub ERR_LIB_CT () {50;}' unless defined(&ERR_LIB_CT);
    eval 'sub ERR_LIB_ASYNC () {51;}' unless defined(&ERR_LIB_ASYNC);
    eval 'sub ERR_LIB_KDF () {52;}' unless defined(&ERR_LIB_KDF);
    eval 'sub ERR_LIB_SM2 () {53;}' unless defined(&ERR_LIB_SM2);
    eval 'sub ERR_LIB_ESS () {54;}' unless defined(&ERR_LIB_ESS);
    eval 'sub ERR_LIB_PROP () {55;}' unless defined(&ERR_LIB_PROP);
    eval 'sub ERR_LIB_CRMF () {56;}' unless defined(&ERR_LIB_CRMF);
    eval 'sub ERR_LIB_PROV () {57;}' unless defined(&ERR_LIB_PROV);
    eval 'sub ERR_LIB_CMP () {58;}' unless defined(&ERR_LIB_CMP);
    eval 'sub ERR_LIB_OSSL_ENCODER () {59;}' unless defined(&ERR_LIB_OSSL_ENCODER);
    eval 'sub ERR_LIB_OSSL_DECODER () {60;}' unless defined(&ERR_LIB_OSSL_DECODER);
    eval 'sub ERR_LIB_HTTP () {61;}' unless defined(&ERR_LIB_HTTP);
    eval 'sub ERR_LIB_USER () {128;}' unless defined(&ERR_LIB_USER);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub ASN1err {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_ASN1, ($r),  &NULL));
	}' unless defined(&ASN1err);
	eval 'sub ASYNCerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_ASYNC, ($r),  &NULL));
	}' unless defined(&ASYNCerr);
	eval 'sub BIOerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_BIO, ($r),  &NULL));
	}' unless defined(&BIOerr);
	eval 'sub BNerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_BN, ($r),  &NULL));
	}' unless defined(&BNerr);
	eval 'sub BUFerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_BUF, ($r),  &NULL));
	}' unless defined(&BUFerr);
	eval 'sub CMPerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_CMP, ($r),  &NULL));
	}' unless defined(&CMPerr);
	eval 'sub CMSerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_CMS, ($r),  &NULL));
	}' unless defined(&CMSerr);
	eval 'sub COMPerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_COMP, ($r),  &NULL));
	}' unless defined(&COMPerr);
	eval 'sub CONFerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_CONF, ($r),  &NULL));
	}' unless defined(&CONFerr);
	eval 'sub CRMFerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_CRMF, ($r),  &NULL));
	}' unless defined(&CRMFerr);
	eval 'sub CRYPTOerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_CRYPTO, ($r),  &NULL));
	}' unless defined(&CRYPTOerr);
	eval 'sub CTerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_CT, ($r),  &NULL));
	}' unless defined(&CTerr);
	eval 'sub DHerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_DH, ($r),  &NULL));
	}' unless defined(&DHerr);
	eval 'sub DSAerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_DSA, ($r),  &NULL));
	}' unless defined(&DSAerr);
	eval 'sub DSOerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_DSO, ($r),  &NULL));
	}' unless defined(&DSOerr);
	eval 'sub ECDHerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_ECDH, ($r),  &NULL));
	}' unless defined(&ECDHerr);
	eval 'sub ECDSAerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_ECDSA, ($r),  &NULL));
	}' unless defined(&ECDSAerr);
	eval 'sub ECerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_EC, ($r),  &NULL));
	}' unless defined(&ECerr);
	eval 'sub ENGINEerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_ENGINE, ($r),  &NULL));
	}' unless defined(&ENGINEerr);
	eval 'sub ESSerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_ESS, ($r),  &NULL));
	}' unless defined(&ESSerr);
	eval 'sub EVPerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_EVP, ($r),  &NULL));
	}' unless defined(&EVPerr);
	eval 'sub FIPSerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_FIPS, ($r),  &NULL));
	}' unless defined(&FIPSerr);
	eval 'sub HMACerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_HMAC, ($r),  &NULL));
	}' unless defined(&HMACerr);
	eval 'sub HTTPerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_HTTP, ($r),  &NULL));
	}' unless defined(&HTTPerr);
	eval 'sub KDFerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_KDF, ($r),  &NULL));
	}' unless defined(&KDFerr);
	eval 'sub OBJerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_OBJ, ($r),  &NULL));
	}' unless defined(&OBJerr);
	eval 'sub OCSPerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_OCSP, ($r),  &NULL));
	}' unless defined(&OCSPerr);
	eval 'sub OSSL_STOREerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_OSSL_STORE, ($r),  &NULL));
	}' unless defined(&OSSL_STOREerr);
	eval 'sub PEMerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_PEM, ($r),  &NULL));
	}' unless defined(&PEMerr);
	eval 'sub PKCS12err {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_PKCS12, ($r),  &NULL));
	}' unless defined(&PKCS12err);
	eval 'sub PKCS7err {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_PKCS7, ($r),  &NULL));
	}' unless defined(&PKCS7err);
	eval 'sub PROPerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_PROP, ($r),  &NULL));
	}' unless defined(&PROPerr);
	eval 'sub PROVerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_PROV, ($r),  &NULL));
	}' unless defined(&PROVerr);
	eval 'sub RANDerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_RAND, ($r),  &NULL));
	}' unless defined(&RANDerr);
	eval 'sub RSAerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_RSA, ($r),  &NULL));
	}' unless defined(&RSAerr);
	eval 'sub KDFerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_KDF, ($r),  &NULL));
	}' unless defined(&KDFerr);
	eval 'sub SM2err {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_SM2, ($r),  &NULL));
	}' unless defined(&SM2err);
	eval 'sub SSLerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_SSL, ($r),  &NULL));
	}' unless defined(&SSLerr);
	eval 'sub SYSerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_SYS, ($r),  &NULL));
	}' unless defined(&SYSerr);
	eval 'sub TSerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_TS, ($r),  &NULL));
	}' unless defined(&TSerr);
	eval 'sub UIerr {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_UI, ($r),  &NULL));
	}' unless defined(&UIerr);
	eval 'sub X509V3err {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_X509V3, ($r),  &NULL));
	}' unless defined(&X509V3err);
	eval 'sub X509err {
	    my($f, $r) = @_;
    	    eval q( &ERR_raise_data( &ERR_LIB_X509, ($r),  &NULL));
	}' unless defined(&X509err);
    }
    eval 'sub ERR_SYSTEM_FLAG () {( &INT_MAX + 1);}' unless defined(&ERR_SYSTEM_FLAG);
    eval 'sub ERR_SYSTEM_MASK () {( &INT_MAX);}' unless defined(&ERR_SYSTEM_MASK);
    eval 'sub ERR_LIB_OFFSET () {23;}' unless defined(&ERR_LIB_OFFSET);
    eval 'sub ERR_LIB_MASK () {0xff;}' unless defined(&ERR_LIB_MASK);
    eval 'sub ERR_RFLAGS_OFFSET () {18;}' unless defined(&ERR_RFLAGS_OFFSET);
    eval 'sub ERR_RFLAGS_MASK () {0x1f;}' unless defined(&ERR_RFLAGS_MASK);
    eval 'sub ERR_REASON_MASK () {0x7fffff;}' unless defined(&ERR_REASON_MASK);
    eval 'sub ERR_RFLAG_FATAL () {(0x1 <<  &ERR_RFLAGS_OFFSET);}' unless defined(&ERR_RFLAG_FATAL);
    eval 'sub ERR_RFLAG_COMMON () {(0x2 <<  &ERR_RFLAGS_OFFSET);}' unless defined(&ERR_RFLAG_COMMON);
    eval 'sub ERR_SYSTEM_ERROR {
        my($errcode) = @_;
	    eval q(((($errcode) &  &ERR_SYSTEM_FLAG) != 0));
    }' unless defined(&ERR_SYSTEM_ERROR);
    eval 'sub ERR_PACK {
        my($lib,$func,$reason) = @_;
	    eval q(( (( &  &ERR_LIB_MASK ) <<  &ERR_LIB_OFFSET) | ((($reason) &  &ERR_REASON_MASK)) ));
    }' unless defined(&ERR_PACK);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub SYS_F_FOPEN () {0;}' unless defined(&SYS_F_FOPEN);
	eval 'sub SYS_F_CONNECT () {0;}' unless defined(&SYS_F_CONNECT);
	eval 'sub SYS_F_GETSERVBYNAME () {0;}' unless defined(&SYS_F_GETSERVBYNAME);
	eval 'sub SYS_F_SOCKET () {0;}' unless defined(&SYS_F_SOCKET);
	eval 'sub SYS_F_IOCTLSOCKET () {0;}' unless defined(&SYS_F_IOCTLSOCKET);
	eval 'sub SYS_F_BIND () {0;}' unless defined(&SYS_F_BIND);
	eval 'sub SYS_F_LISTEN () {0;}' unless defined(&SYS_F_LISTEN);
	eval 'sub SYS_F_ACCEPT () {0;}' unless defined(&SYS_F_ACCEPT);
	eval 'sub SYS_F_WSASTARTUP () {0;}' unless defined(&SYS_F_WSASTARTUP);
	eval 'sub SYS_F_OPENDIR () {0;}' unless defined(&SYS_F_OPENDIR);
	eval 'sub SYS_F_FREAD () {0;}' unless defined(&SYS_F_FREAD);
	eval 'sub SYS_F_GETADDRINFO () {0;}' unless defined(&SYS_F_GETADDRINFO);
	eval 'sub SYS_F_GETNAMEINFO () {0;}' unless defined(&SYS_F_GETNAMEINFO);
	eval 'sub SYS_F_SETSOCKOPT () {0;}' unless defined(&SYS_F_SETSOCKOPT);
	eval 'sub SYS_F_GETSOCKOPT () {0;}' unless defined(&SYS_F_GETSOCKOPT);
	eval 'sub SYS_F_GETSOCKNAME () {0;}' unless defined(&SYS_F_GETSOCKNAME);
	eval 'sub SYS_F_GETHOSTBYNAME () {0;}' unless defined(&SYS_F_GETHOSTBYNAME);
	eval 'sub SYS_F_FFLUSH () {0;}' unless defined(&SYS_F_FFLUSH);
	eval 'sub SYS_F_OPEN () {0;}' unless defined(&SYS_F_OPEN);
	eval 'sub SYS_F_CLOSE () {0;}' unless defined(&SYS_F_CLOSE);
	eval 'sub SYS_F_IOCTL () {0;}' unless defined(&SYS_F_IOCTL);
	eval 'sub SYS_F_STAT () {0;}' unless defined(&SYS_F_STAT);
	eval 'sub SYS_F_FCNTL () {0;}' unless defined(&SYS_F_FCNTL);
	eval 'sub SYS_F_FSTAT () {0;}' unless defined(&SYS_F_FSTAT);
	eval 'sub SYS_F_SENDFILE () {0;}' unless defined(&SYS_F_SENDFILE);
    }
    eval 'sub ERR_R_SYS_LIB () {( &ERR_LIB_SYS |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_SYS_LIB);
    eval 'sub ERR_R_BN_LIB () {( &ERR_LIB_BN |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_BN_LIB);
    eval 'sub ERR_R_RSA_LIB () {( &ERR_LIB_RSA |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_RSA_LIB);
    eval 'sub ERR_R_DH_LIB () {( &ERR_LIB_DH |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_DH_LIB);
    eval 'sub ERR_R_EVP_LIB () {( &ERR_LIB_EVP |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_EVP_LIB);
    eval 'sub ERR_R_BUF_LIB () {( &ERR_LIB_BUF |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_BUF_LIB);
    eval 'sub ERR_R_OBJ_LIB () {( &ERR_LIB_OBJ |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_OBJ_LIB);
    eval 'sub ERR_R_PEM_LIB () {( &ERR_LIB_PEM |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_PEM_LIB);
    eval 'sub ERR_R_DSA_LIB () {( &ERR_LIB_DSA |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_DSA_LIB);
    eval 'sub ERR_R_X509_LIB () {( &ERR_LIB_X509 |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_X509_LIB);
    eval 'sub ERR_R_ASN1_LIB () {( &ERR_LIB_ASN1 |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_ASN1_LIB);
    eval 'sub ERR_R_CONF_LIB () {( &ERR_LIB_CONF |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_CONF_LIB);
    eval 'sub ERR_R_CRYPTO_LIB () {( &ERR_LIB_CRYPTO |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_CRYPTO_LIB);
    eval 'sub ERR_R_EC_LIB () {( &ERR_LIB_EC |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_EC_LIB);
    eval 'sub ERR_R_SSL_LIB () {( &ERR_LIB_SSL |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_SSL_LIB);
    eval 'sub ERR_R_BIO_LIB () {( &ERR_LIB_BIO |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_BIO_LIB);
    eval 'sub ERR_R_PKCS7_LIB () {( &ERR_LIB_PKCS7 |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_PKCS7_LIB);
    eval 'sub ERR_R_X509V3_LIB () {( &ERR_LIB_X509V3 |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_X509V3_LIB);
    eval 'sub ERR_R_PKCS12_LIB () {( &ERR_LIB_PKCS12 |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_PKCS12_LIB);
    eval 'sub ERR_R_RAND_LIB () {( &ERR_LIB_RAND |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_RAND_LIB);
    eval 'sub ERR_R_DSO_LIB () {( &ERR_LIB_DSO |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_DSO_LIB);
    eval 'sub ERR_R_ENGINE_LIB () {( &ERR_LIB_ENGINE |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_ENGINE_LIB);
    eval 'sub ERR_R_UI_LIB () {( &ERR_LIB_UI |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_UI_LIB);
    eval 'sub ERR_R_ECDSA_LIB () {( &ERR_LIB_ECDSA |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_ECDSA_LIB);
    eval 'sub ERR_R_OSSL_STORE_LIB () {( &ERR_LIB_OSSL_STORE |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_OSSL_STORE_LIB);
    eval 'sub ERR_R_CMS_LIB () {( &ERR_LIB_CMS |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_CMS_LIB);
    eval 'sub ERR_R_TS_LIB () {( &ERR_LIB_TS |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_TS_LIB);
    eval 'sub ERR_R_CT_LIB () {( &ERR_LIB_CT |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_CT_LIB);
    eval 'sub ERR_R_PROV_LIB () {( &ERR_LIB_PROV |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_PROV_LIB);
    eval 'sub ERR_R_ESS_LIB () {( &ERR_LIB_ESS |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_ESS_LIB);
    eval 'sub ERR_R_CMP_LIB () {( &ERR_LIB_CMP |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_CMP_LIB);
    eval 'sub ERR_R_OSSL_ENCODER_LIB () {( &ERR_LIB_OSSL_ENCODER |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_OSSL_ENCODER_LIB);
    eval 'sub ERR_R_OSSL_DECODER_LIB () {( &ERR_LIB_OSSL_DECODER |  &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_OSSL_DECODER_LIB);
    eval 'sub ERR_R_FATAL () {( &ERR_RFLAG_FATAL| &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_FATAL);
    eval 'sub ERR_R_MALLOC_FAILURE () {(256| &ERR_R_FATAL);}' unless defined(&ERR_R_MALLOC_FAILURE);
    eval 'sub ERR_R_SHOULD_NOT_HAVE_BEEN_CALLED () {(257| &ERR_R_FATAL);}' unless defined(&ERR_R_SHOULD_NOT_HAVE_BEEN_CALLED);
    eval 'sub ERR_R_PASSED_NULL_PARAMETER () {(258| &ERR_R_FATAL);}' unless defined(&ERR_R_PASSED_NULL_PARAMETER);
    eval 'sub ERR_R_INTERNAL_ERROR () {(259| &ERR_R_FATAL);}' unless defined(&ERR_R_INTERNAL_ERROR);
    eval 'sub ERR_R_DISABLED () {(260| &ERR_R_FATAL);}' unless defined(&ERR_R_DISABLED);
    eval 'sub ERR_R_INIT_FAIL () {(261| &ERR_R_FATAL);}' unless defined(&ERR_R_INIT_FAIL);
    eval 'sub ERR_R_PASSED_INVALID_ARGUMENT () {(262| &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_PASSED_INVALID_ARGUMENT);
    eval 'sub ERR_R_OPERATION_FAIL () {(263| &ERR_R_FATAL);}' unless defined(&ERR_R_OPERATION_FAIL);
    eval 'sub ERR_R_INVALID_PROVIDER_FUNCTIONS () {(264| &ERR_R_FATAL);}' unless defined(&ERR_R_INVALID_PROVIDER_FUNCTIONS);
    eval 'sub ERR_R_INTERRUPTED_OR_CANCELLED () {(265| &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_INTERRUPTED_OR_CANCELLED);
    eval 'sub ERR_R_NESTED_ASN1_ERROR () {(266| &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_NESTED_ASN1_ERROR);
    eval 'sub ERR_R_MISSING_ASN1_EOS () {(267| &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_MISSING_ASN1_EOS);
    eval 'sub ERR_R_UNSUPPORTED () {(268| &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_UNSUPPORTED);
    eval 'sub ERR_R_FETCH_FAILED () {(269| &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_FETCH_FAILED);
    eval 'sub ERR_R_INVALID_PROPERTY_DEFINITION () {(270| &ERR_RFLAG_COMMON);}' unless defined(&ERR_R_INVALID_PROPERTY_DEFINITION);
    eval 'sub ERR_R_UNABLE_TO_GET_READ_LOCK () {(271| &ERR_R_FATAL);}' unless defined(&ERR_R_UNABLE_TO_GET_READ_LOCK);
    eval 'sub ERR_R_UNABLE_TO_GET_WRITE_LOCK () {(272| &ERR_R_FATAL);}' unless defined(&ERR_R_UNABLE_TO_GET_WRITE_LOCK);
    eval 'sub lh_ERR_STRING_DATA_new {
        my($hfn, $cmp) = @_;
	    eval q((( &LHASH_OF( &ERR_STRING_DATA) *) &OPENSSL_LH_new( &ossl_check_ERR_STRING_DATA_lh_hashfunc_type($hfn),  &ossl_check_ERR_STRING_DATA_lh_compfunc_type($cmp))));
    }' unless defined(&lh_ERR_STRING_DATA_new);
    eval 'sub lh_ERR_STRING_DATA_free {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_free( &ossl_check_ERR_STRING_DATA_lh_type($lh)));
    }' unless defined(&lh_ERR_STRING_DATA_free);
    eval 'sub lh_ERR_STRING_DATA_flush {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_flush( &ossl_check_ERR_STRING_DATA_lh_type($lh)));
    }' unless defined(&lh_ERR_STRING_DATA_flush);
    eval 'sub lh_ERR_STRING_DATA_insert {
        my($lh, $ptr) = @_;
	    eval q((( &ERR_STRING_DATA *) &OPENSSL_LH_insert( &ossl_check_ERR_STRING_DATA_lh_type($lh),  &ossl_check_ERR_STRING_DATA_lh_plain_type($ptr))));
    }' unless defined(&lh_ERR_STRING_DATA_insert);
    eval 'sub lh_ERR_STRING_DATA_delete {
        my($lh, $ptr) = @_;
	    eval q((( &ERR_STRING_DATA *) &OPENSSL_LH_delete( &ossl_check_ERR_STRING_DATA_lh_type($lh),  &ossl_check_const_ERR_STRING_DATA_lh_plain_type($ptr))));
    }' unless defined(&lh_ERR_STRING_DATA_delete);
    eval 'sub lh_ERR_STRING_DATA_retrieve {
        my($lh, $ptr) = @_;
	    eval q((( &ERR_STRING_DATA *) &OPENSSL_LH_retrieve( &ossl_check_ERR_STRING_DATA_lh_type($lh),  &ossl_check_const_ERR_STRING_DATA_lh_plain_type($ptr))));
    }' unless defined(&lh_ERR_STRING_DATA_retrieve);
    eval 'sub lh_ERR_STRING_DATA_error {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_error( &ossl_check_ERR_STRING_DATA_lh_type($lh)));
    }' unless defined(&lh_ERR_STRING_DATA_error);
    eval 'sub lh_ERR_STRING_DATA_num_items {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_num_items( &ossl_check_ERR_STRING_DATA_lh_type($lh)));
    }' unless defined(&lh_ERR_STRING_DATA_num_items);
    eval 'sub lh_ERR_STRING_DATA_node_stats_bio {
        my($lh, $out) = @_;
	    eval q( &OPENSSL_LH_node_stats_bio( &ossl_check_const_ERR_STRING_DATA_lh_type($lh), $out));
    }' unless defined(&lh_ERR_STRING_DATA_node_stats_bio);
    eval 'sub lh_ERR_STRING_DATA_node_usage_stats_bio {
        my($lh, $out) = @_;
	    eval q( &OPENSSL_LH_node_usage_stats_bio( &ossl_check_const_ERR_STRING_DATA_lh_type($lh), $out));
    }' unless defined(&lh_ERR_STRING_DATA_node_usage_stats_bio);
    eval 'sub lh_ERR_STRING_DATA_stats_bio {
        my($lh, $out) = @_;
	    eval q( &OPENSSL_LH_stats_bio( &ossl_check_const_ERR_STRING_DATA_lh_type($lh), $out));
    }' unless defined(&lh_ERR_STRING_DATA_stats_bio);
    eval 'sub lh_ERR_STRING_DATA_get_down_load {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_get_down_load( &ossl_check_ERR_STRING_DATA_lh_type($lh)));
    }' unless defined(&lh_ERR_STRING_DATA_get_down_load);
    eval 'sub lh_ERR_STRING_DATA_set_down_load {
        my($lh, $dl) = @_;
	    eval q( &OPENSSL_LH_set_down_load( &ossl_check_ERR_STRING_DATA_lh_type($lh), $dl));
    }' unless defined(&lh_ERR_STRING_DATA_set_down_load);
    eval 'sub lh_ERR_STRING_DATA_doall {
        my($lh, $dfn) = @_;
	    eval q( &OPENSSL_LH_doall( &ossl_check_ERR_STRING_DATA_lh_type($lh),  &ossl_check_ERR_STRING_DATA_lh_doallfunc_type($dfn)));
    }' unless defined(&lh_ERR_STRING_DATA_doall);
    eval 'sub ERR_MAX_DATA_SIZE () {1024;}' unless defined(&ERR_MAX_DATA_SIZE);
    eval 'sub ERR_raise {
        my($lib, $reason) = @_;
	    eval q( &ERR_raise_data(($lib),($reason), &NULL));
    }' unless defined(&ERR_raise);
    eval 'sub ERR_raise_data () {( &ERR_new(),  &ERR_set_debug( &OPENSSL_FILE, &OPENSSL_LINE, &OPENSSL_FUNC),  &ERR_set_error);}' unless defined(&ERR_raise_data);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub ERR_put_error {
	    my($lib, $func, $reason, $file, $line) = @_;
    	    eval q(( &ERR_new(),  &ERR_set_debug(($file), ($line),  &OPENSSL_FUNC),  &ERR_set_error(($lib), ($reason),  &NULL)));
	}' unless defined(&ERR_put_error);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    unless(defined(&OPENSSL_NO_STDIO)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub ERR_load_crypto_strings () {
	    eval q( &OPENSSL_init_crypto( &OPENSSL_INIT_LOAD_CRYPTO_STRINGS,  &NULL));
	}' unless defined(&ERR_load_crypto_strings);
	eval 'sub ERR_free_strings () {
	    eval q( &while(0)  &continue);
	}' unless defined(&ERR_free_strings);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_1_0_0)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
    }
    if(defined(&__cplusplus)) {
    }
}
1;
