<?php

class ChangeAccountAction  extends SOY2Action{

    protected function execute(SOY2ActionRequest &$request,SOY2ActionForm &$form,SOY2ActionResponse &$response){
    	
    	$this->setAttribute("ChangeAccount",$form);
    	
    	if($form->hasError()){
			foreach($form->getErrors() as $key => $value){
				$this->setErrorMessage($key,$form->getErrorString($key));
			}
			
			return SOY2Action::FAILED;
		}
		
    	return SOY2Action::SUCCESS;
    	
    	
    }
}

class ChangeAccountActionForm extends SOY2ActionForm{

	var $firstName;
	var $lastName;
	var $firstNameReading;
	var $lastNameReading;
	var $birthDate;
	var $nickname;

	function getFirstName() {
		return $this->firstName;
	}
	
	/**
	 * @validator string {"require" : true , "max" : 100, 
	 * 	"message" : {
	 *		"require" : "この項目は必須です。",
	 *		"max" : "名前（名）は100文字以内でお願いします。"
	 *	}
	 * }
	 */
	function setFirstName($firstName) {
		$this->firstName = $firstName;
	}
	
	function getLastName() {
		return $this->lastName;
	}
	
	/**
	 * @validator string {"require" : true , "max" : 100, 
	 * 	"message" : {
	 *		"require" : "この項目は必須です。",
	 *		"max" : "名前（氏）は100文字以内でお願いします。"
	 *	}
	 * }
	 */
	function setLastName($lastName) {
		$this->lastName = $lastName;
	}
	
	function getFirstNameReading() {
		return $this->firstNameReading;
	}
	
	/**
	 * @validator string {"max" : 100, 
	 * 	"message" : {
	 *		"max" : "名前（ふりがな）は100文字以内でお願いします。"
	 *	}
	 * }
	 */
	function setFirstNameReading($firstNameReading) {
		$this->firstNameReading = $firstNameReading;
	}
	
	function getLastNameReading() {
		return $this->lastNameReading;
	}
	
	/**
	 * @validator string {"max" : 100, 
	 * 	"message" : {
	 *		"max" : "名前（ふりがな）は100文字以内でお願いします。"
	 *	}
	 * }
	 */
	function setLastNameReading($lastNameReading) {
		$this->lastNameReading = $lastNameReading;
	}
	
	function getBirthDate() {
		return $this->birthDate;
	}
	
	function setBirthDate($birthDate) {
		if(is_array($birthDate)){
			if($birthDate["day"] && $birthDate["month"] && $birthDate["year"]){
				$date = mktime(0,0,0,$birthDate["month"],$birthDate["day"],$birthDate["year"]);
				$birthDate = $date;
			}else{
				$birthDate = null;
			}
		}
		if(is_string($birthDate)){
			$birthDate = strtotime($birthDate);
		}
		
		$this->birthDate = $birthDate;
	}

	function getNickname() {
		return $this->nickname;
	}
	
	/**
	 * @validator string {"require" : true , "max" : 20, 
	 * 	"message" : {
	 *		"require" : "この項目は必須です。",
	 *		"max" : "表示名は半角20文字以内でお願いします。"
	 *	}
	 * }
	 */
	function setNickname($nickname) {
		$this->nickname = $nickname;
	}
}
?>