<?php

/**
 * BaseLeaveComment
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int           $id                             Type: integer(4), primary key
 * @property int           $leave_id                       Type: integer(4)
 * @property string        $created                        Type: datetime, Date and time in ISO-8601 format (YYYY-MM-DD HH:MI)
 * @property string        $created_by_name                Type: string(255)
 * @property int           $created_by_id                  Type: integer(10)
 * @property int           $created_by_emp_number          Type: integer(4)
 * @property string        $comments                       Type: string(255)
 * @property Employee      $Employee                       
 * @property SystemUser    $SystemUser                     
 * @property Leave         $Leave                          
 *  
 * @method int             getId()                         Type: integer(4), primary key
 * @method int             getLeaveId()                    Type: integer(4)
 * @method string          getCreated()                    Type: datetime, Date and time in ISO-8601 format (YYYY-MM-DD HH:MI)
 * @method string          getCreatedByName()              Type: string(255)
 * @method int             getCreatedById()                Type: integer(10)
 * @method int             getCreatedByEmpNumber()         Type: integer(4)
 * @method string          getComments()                   Type: string(255)
 * @method Employee        getEmployee()                   
 * @method SystemUser      getSystemUser()                 
 * @method Leave           getLeave()                      
 *  
 * @method LeaveComment    setId(int $val)                 Type: integer(4), primary key
 * @method LeaveComment    setLeaveId(int $val)            Type: integer(4)
 * @method LeaveComment    setCreated(string $val)         Type: datetime, Date and time in ISO-8601 format (YYYY-MM-DD HH:MI)
 * @method LeaveComment    setCreatedByName(string $val)   Type: string(255)
 * @method LeaveComment    setCreatedById(int $val)        Type: integer(10)
 * @method LeaveComment    setCreatedByEmpNumber(int $val) Type: integer(4)
 * @method LeaveComment    setComments(string $val)        Type: string(255)
 * @method LeaveComment    setEmployee(Employee $val)      
 * @method LeaveComment    setSystemUser(SystemUser $val)  
 * @method LeaveComment    setLeave(Leave $val)            
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseLeaveComment extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_leave_comment');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('leave_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => true,
             'notnull' => true,
             'length' => 4,
             ));
        $this->hasColumn('created', 'datetime', null, array(
             'type' => 'datetime',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             ));
        $this->hasColumn('created_by_name', 'string', 255, array(
             'type' => 'string',
             'notnull' => true,
             'length' => 255,
             ));
        $this->hasColumn('created_by_id', 'integer', 10, array(
             'type' => 'integer',
             'notnull' => false,
             'length' => 10,
             ));
        $this->hasColumn('created_by_emp_number', 'integer', 4, array(
             'type' => 'integer',
             'notnull' => false,
             'length' => 4,
             ));
        $this->hasColumn('comments', 'string', 255, array(
             'type' => 'string',
             'notnull' => false,
             'length' => 255,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Employee', array(
             'local' => 'created_by_emp_number',
             'foreign' => 'emp_number'));

        $this->hasOne('SystemUser', array(
             'local' => 'created_by_id',
             'foreign' => 'id'));

        $this->hasOne('Leave', array(
             'local' => 'leave_id',
             'foreign' => 'id'));
    }
}