<?php
/**
 * データベースの設定ファイルが無いときのエラーの処理
 */
$message = "";

$message .= '<h4>Can not get a data source.</h4>';
$message .= '<p>No database configuration file is found.<br/>Check your database configuration in SOY CMS.</p>';
$message .= '<hr style="margin: 1em 0;">';
$message .= '';
$message .= '<h4>データベースの設定ファイルが存在しません。</h4>';
$message .= '<p>データベースの設定ファイルが存在しません。</p>';

$exception = new SOYCMSDAOConfigException($message);


class SOYCMSDAOConfigException extends Exception{
	function getResolve(){
		$message = "";
		
		$message .= '<h4>Create the database configuration file.</h4>';
		$message .= '<p>The configuration file should be ['.SOY2::RootDir()."config/db/".SOYCMS_DB_TYPE.".php".'].<br>';
		$message .= '<p>See '.SOY2::RootDir()."config/db/".SOYCMS_DB_TYPE.".sample.php".' for example.';
		//if(SOYCMS_DB_TYPE=="mysql") $message .= '<p>Refer to <a href="http://www.soycms.net/man/mysql_configuration.html">how to write the configuration file for MySQL</a>.';
		$message .= '<hr style="margin: 1em 0;">';
		$message .= '<h4>設定ファイルを置いてください。</h4>';
		$message .= '<p>データベースの設定ファイルを'.SOY2::RootDir()."config/db/".SOYCMS_DB_TYPE.".php".'に置いてください。<br>';
		$message .= '<p>設定ファイルの例は'.SOY2::RootDir()."config/db/".SOYCMS_DB_TYPE.".sample.php".'にあります。';
		if(SOYCMS_DB_TYPE=="mysql") $message .= '<p>設定ファイルの書き方は「<a href="http://www.soycms.net/man/mysql_configuration.html">MySQLの設定</a>」で読むことができます。';
		
		return $message;
	}
}
