<?php

class DetailPage extends CMSWebPageBase{

	private $id;

	function doPost(){
    	if(soy2_check_token()){

			$result = SOY2ActionFactory::createInstance("EntryTemplate.UpdateAction")->run();
	    	if($result->success()){
				if($result->getAttribute("mode") == "create"){
					$this->addMessage("ENTRY_TEMPLATE_CREATE_SUCCESS");
				}else{
					$this->addMessage("ENTRY_TEMPLATE_SAVE_SUCCESS");	
				}			
			}else{
				if($result->getAttribute("mode") == "create"){
					$this->addMessage("ENTRY_TEMPLATE_CREATE_FAILED");
				}else{
					$this->addMessage("ENTRY_TEMPLATE_SAVE_FAIELD");	
				}
			}
			
			if($this->id){
				$this->jump("EntryTemplate.Detail.".$this->id);
			}else{
				$this->jump("EntryTemplate");
			}
    	}
	}

    function DetailPage($arg) {
    	
    	$id = @$arg[0];
    	$this->id =$id;
    	WebPage::WebPage();
    	
    	$result = SOY2ActionFactory::createInstance("EntryTemplate.TemplateDetailAction",array("id"=>$id))->run();
    	$template = $result->getAttribute("entity");
    	
    	HTMLHead::addLink("entry_template",array(
			"type" => "text/css",
			"rel" => "stylesheet",
			"href" => SOY2PageController::createRelativeLink("css/entry_template/entry_template.css")."?".SOYCMS_BUILD_TIME
		));
    	
    	$this->createAdd("template_id","HTMLInput",array(
			"value"=>$template->getId(),
			"name"=>"template_id"
		));
    	$this->createAdd("name","HTMLInput",array(
			"value"=>$template->getName(),
			"name"=>"name"
		));
		
		$this->createAdd("description","HTMLTextArea",array(
			"text"=>$template->getDescription(),
			"name"=>"description"
		));
		$temp = $template->getTemplates();
		$this->createAdd("content","HTMLTextArea",array(
			"text"=>$temp['content'],
			"name"=>"templates[content]"
		));
		$this->createAdd("more","HTMLTextArea",array(
			"text"=>$temp['more'],
			"name"=>"templates[more]"
		));
		$this->createAdd("style","HTMLTextArea",array(
			"text"=>$temp['style'],
			"name"=>"templates[style]"
		));
		
		$this->createAdd("label_list","HTMLSelect",array(
			"name" => "templates[labelId]",
			"options" => $this->getLabelList(),
			"property" => "caption",
			"selected" => @$temp["labelId"]
		));
		
		$this->createAdd("submit_button","HTMLInput",array(
			"value" => (strlen($id)<1) ? CMSMessageManager::get("SOYCMS_CREATE") : CMSMessageManager::get("SOYCMS_UPDATE")
		));
				
		$this->createAdd("update_form","HTMLForm");
		
		//ラベルによる呼び出し制限の追加用
		$list = SOY2HTMLFactory::createInstance("LabelList",array(
	    	"includeParentTag" => true
	    ));
    	//制限用に設定されているラベルIDを全て渡す
    	$labels =  $this->getLabelList();;
    	
    	if($this->initLabelList){
    		$list->setSelectedLabelList($this->initLabelList);
    	}else{
    		
    		$list->setSelectedLabelList($template->getLabelRestrictionPositive());
    	}
    	$list->setList($labels);
    	$this->add("labels",$list);
    	
		
    }
    
    function getLabelList(){
    	$res = $this->run("Label.LabelListAction");
    	if($res->success()){
    		return $res->getAttribute("list");
    	}
    	
    	return array();
    }
    
    function getLabelRestrictionPositive(){
    	return array();
    }
    
}

class LabelList extends HTMLList{
	
	var $selectedLabelList = array();
	
	function setIncludeParentTag($inc){
		$this->setAttribute("includeParentTag",$inc);
	}
	
	function setSelectedLabelList($array){
		if(is_array($array)){
			$this->selectedLabelList = $array;
		}
	}
	
	function populateItem($entity){
		
		$elementID = "label_".$entity->getId();

		$this->createAdd("label_check","HTMLCheckBox",array(
			"name"      => "labelRestrictionPositive[]",
			"value"     => $entity->getId(),
			"selected"  => in_array($entity->getId(),$this->selectedLabelList),
			"elementId" => $elementID,
			"onclick" => 'toggle_labelmemo(this.value,this.checked);'
		));
		$this->createAdd("label_label","HTMLModel",array(
			"for" => $elementID,
		));
		$this->createAdd("label_caption","HTMLLabel",array(
			"text" => $entity->getCaption(),
			"style"=> "color:#" . sprintf("%06X",$entity->getColor()).";"
			         ."background-color:#" . sprintf("%06X",$entity->getBackgroundColor()).";"
		));

		$this->createAdd("label_icon","HTMLImage",array(
			"src" => $entity->getIconUrl()
		));
		
	}
	
}
?>