package Container::Item;
# $Id: Item.pm,v 1.3 2000/11/29 19:20:43 tom Exp $
################################################################

use strict;
use vars qw(@ISA);

use ObjectTemplate;

@ISA = qw(ObjectTemplate);

attributes qw(content key);

sub initialize($)
{
    my $self = shift;

    $self->key('Key') unless $self->key;
    
    $self->content({});;
    $self->SUPER::initialize;
}
sub SetByLine($$)
{
    my ($self, $line) = @_;
    chomp $line;
    my ($key, $cont) = $line =~ m/([^\s]+)\s(.*)$/;
    $self->Set($key, $cont);
}    
sub convert_tag ($$)
{
    my ($self, $tag) = @_;

    $tag = lc($tag);
    $tag =~ s!^(.)!uc($1)!e;
    $tag =~ s!\-(.)!-uc($1)!eg;
    return $tag;
}
    
sub Value($$)
{
    my ($self, $tag) = @_;

    return $self->content->{$self->convert_tag($tag)};
}
sub Set($$$)
{
    my ($self, $tag, $text) = @_;

    $self->content->{$self->convert_tag($tag)} = $text;
}
sub Add($$$)
{
    my ($self, $tag, $text) = @_;

    my $value = $self->Value($tag);
    if ($value){
	unless ($text =~ /$value/){
	    $value .= ",$text";
	}
    } else {
	$value = "$text";
    }
    $self->Set($tag, $value);
}

sub Clear($)
{
    my $self = shift;

    $self->content({});
    $self;
}
sub Copy($$)
{
    my ($self, $item) = @_;

    $self->Clear;
    
    for (keys %{$item->content}){
	$self->Set($_, $item->Value($_));
    }
    $self;
}
sub AsPlain($)
{
    my $self = shift;

    my $line;
    for (keys %{$self->content}){
	next unless $self->content->{$_};
	$line .= sprintf("%s: %s\n", $_, $self->content->{$_});
    }
    return "$line\n";
}
sub GetParams($)
{
    my $self = shift;

    my $params = {};
    for (keys %{$self->content}){
	$params->{$_} = $self->content->{$_};
    }
    return $params;
}

1;
