# awk file to convert tn.dbs file into prep7/ANSYS files.
#
# usage:
#  gawk -f makeansy.awk tn.dbs 
# creates 
#        tn.inp       top input file
#        tn.node      nodes
#        tn.elem      elements
#        tn.mods      modify element material pointers to actual values
#        tn.etli      ansys element type list (et commands).
# and in ANSYS prep7, use: 
# /inp,tn,inp    
#
# Author Osman F. Buyukisik        june 9 1998
# $Id: mkansys.awk,v 1.1 2000/05/22 18:15:51 roddemandennis Exp $
# $Log: mkansys.awk,v $
# Revision 1.1  2000/05/22 18:15:51  roddemandennis
# start
#
# Revision 1.1  2000/04/11 23:12:30  osman
# Initial revision
#
#
BEGIN { 
        printf("/nopr\n/inp,tn,etli\n/inp,tn,node\n/inp,tn,elem\n") > "tn.inp";
        printf("/inp,tn,mods\n/gopr\n") >> "tn.inp";
        printf("! element file \nshp,OFF\n") > "tn.elem";
        printf("! element type list \n") > "tn.etli";
        printf("! node file\n") > "tn.node";itype=0;etype="dummy";
        printf("! post data\n/NOPR\n") > "tn.pos1";
        printf("/graph,full, ! this is needed due to a bug.\n") >> "tn.pos1";
        printf("desol,all,all,s,x,1,1,1,0,0,0\n") >> "tn.pos1";
        ansyelem=0;anal_type="plane";
      }
{
if ($1=="node") printf("n,%d,%f,%f,%f\n",$2+1,$3,$4,$5) >> "tn.node";
if ($1=="element\_group") {
   ie=$2+1; im=$3+1;
   maters[ie]=im;
                         }
if ($1=="group_axisymmetric") {anal_type="axisymmetric";}
if ($1=="element") {
  if ($3=="-hex8") {
            if (etype!=$3 ) {itype=itype+1; 
                             etype=$3; printf("type,%d\n",itype) >> "tn.elem";
                             ansytype=45;
                             printf("et,%d,%d\n",itype,ansytype) >> "tn.etli"; 
                            };
            types[$2+1]=itype;ansyelem=ansyelem+1;elemno[$2+1]=ansyelem;
            printf("e,%d,%d,%d,%d,%d,%d,%d,%d\n",$4+1,$5+1,$7+1,$6+1,$8+1,$9+1,$11+1,$10+1) >> "tn.elem";
                   }
  if ($3=="-quad4") {
            if (etype!=$3 ) {itype=itype+1; 
                             etype=$3; printf("type,%d\n",itype) >> "tn.elem";
                             ansytype=42;
                             printf("et,%d,%d\n",itype,ansytype) >> "tn.etli"; 
                            };
            types[$2+1]=itype;ansyelem=ansyelem+1;elemno[$2+1]=ansyelem;
            printf("e,%d,%d,%d,%d\n",$4+1,$5+1,$7+1,$6+1) >> "tn.elem";
                    }
  if ($3=="-quad9") {
            if (etype!=$3 ) {itype=itype+1; 
                             etype=$3; printf("type,%d\n",itype) >> "tn.elem";
                             ansytype=82;
                             printf("et,%d,%d\n",itype,ansytype) >> "tn.etli"; 
                            };
            types[$2+1]=itype;ansyelem=ansyelem+1;elemno[$2+1]=ansyelem;
            printf("e,%d,%d,%d,%d,%d,%d,%d,%d\n",$4+1,$6+1,$12+1,$10+1,$5+1,$9+1,$11+1,$7+1) >> "tn.elem";
                    }
  if ($3=="-tria3") {
            if (etype!=$3 ) {itype=itype+1; 
                             etype=$3; printf("type,%d\n",itype) >> "tn.elem";
                             ansytype=42;
                             printf("et,%d,%d\n",itype,ansytype) >> "tn.etli"; 
                            }
            types[$2+1]=itype;ansyelem=ansyelem+1;elemno[$2+1]=ansyelem;
            printf("e,%d,%d,%d\n",$4+1,$5+1,$6+1) >> "tn.elem";
                    } 
  if ($3=="-tria6") {
            if (etype!=$3 ) {itype=itype+1; 
                             etype=$3; printf("type,%d\n",itype) >> "tn.elem";
                             ansytype=2;
                             printf("et,%d,%d\n",itype,ansytype) >> "tn.etli"; 
                            }
            types[$2+1]=itype;ansyelem=ansyelem+1;elemno[$2+1]=ansyelem;
            printf("e,%d,%d,%d,%d,%d,%d\n",$4+1,$6+1,$9+1,$5+1,$8+1,$7+1) >> "tn.elem";
                    } 
  if ($3=="-bar2") {
            if (etype!=$3 ) {itype=itype+1; 
                             etype=$3; printf("type,%d\n",itype) >> "tn.elem";
                             ansytype=1;
                             printf("et,%d,%d\n",itype,ansytype) >> "tn.etli"; 
                            };
            types[$2+1]=itype;ansyelem=ansyelem+1;elemno[$2+1]=ansyelem;
            printf("e,%d,%d\n",$4+1,$5+1) >> "tn.elem";
                   }
  if ($3=="-tet4") {
            if (etype!=$3 ) {itype=itype+1; 
                             etype=$3; printf("type,%d\n",itype) >> "tn.elem";
                             ansytype=45;
                             printf("et,%d,%d\n",itype,ansytype) >> "tn.etli"; 
                            };
            types[$2+1]=itype;ansyelem=ansyelem+1;elemno[$2+1]=ansyelem;
            printf("e,%d,%d,%d,%d\n",$4+1,$5+1,$6+1,$7+1) >> "tn.elem";
                   }
                   }
 if ($1=="number_of_space_dimensions") {ndim=$2+0;}
 if ($1=="dof_label") {
    for (i=2;i<=NF;i++)dof_labels[$i]=i+1;n_dofs=NF-1;
                      }
 if ($1=="node_dof") {
            node=$2+1;
            if ( dof_labels["-disx"] != 0 ) {
                 vx=$(dof_labels["-disx"]);
                 vy=$(dof_labels["-disy"]);
                 vz=$(dof_labels["-disz"]);
                                            }
            else {
            vx=$(dof_labels["-velx"]);
            vy=$(dof_labels["-vely"]);
            vz=$(dof_labels["-velz"]);
                  };
            sx=$(dof_labels["-sigxx"]);
            sxy=$(dof_labels["-sigxy"]);
            sxz=$(dof_labels["-sigxz"]);
            syz=$(dof_labels["-sigyz"]);
            sy=$(dof_labels["-sigyy"]);
            sz=$(dof_labels["-sigzz"]);
            printf("dnsol,%d,S,X,%g,%g,%g,%g,%g,%g\n",node,sx,sy,sz,sxy,syz,sxz) >> "tn.pos1";
            printf("dnsol,%d,U,X,%g,%g\n",node,vx,vy,vz) >> "tn.pos1";
            sige=sqrt(0.5*((sx-sy)^2+(sy-sz)^2+(sz-sx)^2+6.0*(sxy^2+syz^2+sxz^2)));
            printf("dnsol,%d,S,EQV,%g\n",node,sige) >> "tn.pos1";
                     }
 if ($1=="node_dof_calcul") {
            node=$2+1;sige=$3+0.0;
            printf("dnsol,%d,S,EQV,%g\n",node,sige) >> "tn.pos1";
                            }
 
 
} 
END {
    printf("!element material mods\n/nopr\n") > "tn.mods";
    for (ie in maters) 
        printf("type,%d\$mat,%d\$emod,%d\n",types[ie],maters[ie],elemno[ie]) >> "tn.mods";
                     
    printf("/gopr\n") >> "tn.mods";
    printf("/gopr\n") >> "tn.pos1";
    }
