(game-module "cherbourg"
  (title "Fall of Cherbourg")
  (version "1.0")
  (blurb "The American drive on Cherbourg, June 1944")
  (base-module "ww2-bn")
  (variants
   (see-all false)
   (sequential true)
   )
  (instructions (
   "The Americans have cut off the Cotentin peninsula and must now attempt"
   "to capture Cherbourg before the Germans destroy its port."
   ))
  )

(scorekeeper (do last-side-wins))

;; This will cause units to focus appropriately.

(add u* point-value 1)
(add hq-inf-corps point-value 100)
(add port point-value 1000)

;; Make port destruction very difficult in this game.

(add port hp-max 200)

;(scorekeeper
;  (who 1)
;  (do (if (occupied 28 108) (win 1) (lose 2)))
;  )

(set initial-date "8:00 19 Jun 1944")

(set initial-day-part 1.50)

;; The game lasts one week.

(set last-turn 21)

(add u* start-with 0)

(side 1 (name "Allies") (adjective "Allied") (class "allied")
  (color "blue") (emblem-name "white-star")
  (instructions (
   "Your goal is to capture Cherbourg as soon as possible; in 7 days the Germans "
   "will have rendered the port unusable."
   )))

(side 2 (name "Germany") (adjective "German") (class "german")
  (color "black") (emblem-name "german-cross")
  (instructions (
   "Your goal is to hold back the Americans for 7 days; "
   "all your units may be sacrificed if necessary."
   )))

(set sides-min 2)
(set sides-max 2)

(area 54 45 (restrict 186 159 12 104))

(include "t-normandy") ; has to go here so towns get on German side

(unit-defaults (@ 0 104))

;; Towns in Allied hands.

(unit "Barneville" (s 1))
(unit "Carteret" (s 1))
(unit "Quineville" (s 1))
(unit "St Mere-Eglise" (s 1))
(unit "St Sauveur" (s 1))

;; Make this vanish - still German, but irrelevant here.

(unit "La Haye-du-Puits" (hp 0))

;;; Allies consist of basically three American divisions.

(inf-mot 24 18 1 (n "1/39"))
(inf-mot 26 17 1 (n "2/39"))
(inf-mot 27 17 1 (n "3/39"))
(inf-mot 28 16 1 (n "1/47"))
(inf-mot 30 16 1 (n "2/47"))
(inf-mot 31 15 1 (n "3/47"))
(inf-mot 32 15 1 (n "1/80"))
(inf-mot 34 14 1 (n "2/80"))
(inf-mot 35 14 1 (n "3/80"))
(inf-mot 36 14 1 (n "1/313"))
(inf-mot 39 12 1 (n "2/313"))
(inf-mot 40 11 1 (n "3/313"))
(inf-mot 42 11 1 (n "1/314"))
(inf-mot 43 11 1 (n "2/314"))
(inf-mot 44 11 1 (n "3/314"))
(inf-mot 54 11 1 (n "3/22"))
(inf-mot 42 10 1 (n "1/315"))
(inf-mot 45 10 1 (n "2/315"))
(inf-mot 46 10 1 (n "3/315"))
(inf-mot 47 10 1 (n "1/8"))
(inf-mot 48 10 1 (n "2/8"))
(inf-mot 49 10 1 (n "3/8"))
(inf-mot 50 10 1 (n "1/12"))
(inf-mot 51 10 1 (n "2/12"))
(inf-mot 52 10 1 (n "3/12"))
(inf-mot 53 10 1 (n "1/22"))
(inf-mot 54 10 1 (n "2/22"))
(cav-mech 55 11 1 (nb 24))
(cav-mech 41 10 1 (nb 4))
(cav-mech-trp 25 18 1 (nb 9))
(cav-mech-trp 38 13 1)
(cav-mech-trp 50 8 1 (nb 4))
(arty-hq 49 9 1)
(arty-hq 51 9 1 (nb 4))
(arty-hq 48 8 1 (nb 79))
(arty-hq 52 8 1 (n "VII"))
(arty-towed 51 8 1 (nb 20))
(arty-towed 51 8 1 (nb 29))
(arty-towed 51 8 1 (nb 42))
(arty-towed 51 8 1 (nb 44))
(arty-towed 28 15 1 (nb 26))
(arty-towed 28 15 1 (nb 34))
(arty-towed 28 15 1 (nb 60))
(arty-towed 28 15 1 (nb 84))
(arty-towed 42 9 1 (nb 310))
(arty-towed 42 9 1 (nb 311))
(arty-towed 42 9 1 (nb 312))
(arty-towed 42 9 1 (nb 904))
(arty-at 37 14 1 (nb 801))
(arty-at 44 9 1 (nb 812))
(arty-mortar4.2 52 9 1)
(arty-sp-at 45 9 1 (nb 899))
(tank 29 16 1 (nb 746))
(tank 41 11 1 (nb 749))
(tank 50 9 1 (nb 70))
(hq-mot-div 29 15 1 (nb 9))
(hq-mot-div 44 7 1 (nb 79))
(hq-mot-div 51 7 1 (nb 4))
(hq-inf-corps 53 4 1 (n "VII"))

;;; Germans have a mixed bag with plenty of artillery and fortifications.
;;; Most infantry should be damaged to some extent.

(inf 26 18 2)
(inf 28 17 2)
(inf 30 17 2)
(inf 31 16 2)
(inf 33 15 2)
(inf 35 15 2)
(inf 37 15 2)
(inf 38 14 2)
(inf 39 13 2)
(inf 40 12 2)
(inf 41 12 2)
(inf 42 12 2)
(inf 44 12 2)
(inf 45 11 2)
(inf 47 11 2)
(inf 48 11 2)
(inf 49 11 2)
(inf 51 11 2)
(inf-bicycle 46 11 2)
(inf-ost 53 11 2 (nb 561))
(inf-ost 52 11 2 (nb 649))
(inf-ost 50 11 2 (nb 795))
(inf-ost 49 11 2 (nb 797))
(inf-mot 34 15 2 (n "AOK 7"))
(inf-mg-co 24 19 2 (n "1/17"))
(inf-mg-co 27 18 2 (n "2/17"))
(inf-mg-co 29 17 2 (n "3/17"))
(arty-cd-cased 53 23 2 (n "10/1261"))
(arty-cd-cased 50 15 2 (n "5/1261"))
(arty-cd-cased 53 15 2 (n "8/1261"))
(arty-cd-cased 41 29 2 (n "MKB BROM"))
(arty-cd-cased 43 29 2 (n "MKB HAMBURG"))
(arty-cd-cased 37 27 2 (n "MKB ROUL"))
(arty-cd-cased 30 35 2 (n "MKB YORK"))
(arty-cd-cased 37 31 2)
(arty-cd-open 52 14 2 (n "4/1261"))
(arty-cd-open 52 15 2 (n "6/1261"))
(arty-cd-open 52 18 2 (n "9/1261"))
(arty-cd-open 52 25 2 (n "MKB BLANK"))
(arty-rr 33 23 2)
(arty-horse 35 16 2 (nb 458))
(arty-horse 45 17 2 (nb 467))
(arty-flak-bty 32 30 2)
(arty-flak-bty 34 30 2)
(arty-flak-bty 37 30 2)
(arty-flak-bty 33 28 2)
(arty-flak-bty 35 28 2)
(arty-flak-bty 43 28 2)
(arty-flak-bty 42 27 2)
(arty-flak-bty 43 27 2)
(arty-flak-bty 42 26 2)
(arty-flak-bty 43 26 2)
(arty-flak-bty 44 26 2)
(arty-flak-bty 42 25 2)
(arty-flak-bty 43 25 2)
(arty-flak-bty 44 25 2)
(arty-flak-bty 42 24 2)
(arty-nebel 39 21 2 (n "I/101"))
(arty-nebel 40 20 2 (n "II/101"))
(arty-nebel 41 19 2 (n "III/101"))
(tank 45 12 2)
(assault-gun 43 12 2)
(hq-inf-div 32 17 2)
(hq-inf-div 36 17 2)
(hq-inf-div 44 15 2)
(hq-inf-corps 35 30 2 (n "LXXXIV"))
(fort 36 28 2 (n "Fort du Roule"))
(fort 32 35 2)
(fort 34 33 2)
(fort 32 32 2)
(fort 33 31 2)
(fort 36 26 2)
(fortification 28 37 2)
(fortification 28 36 2)
(fortification 29 35 2)
(fortification 29 34 2)
(fortification 29 33 2)
(fortification 29 32 2)
(fortification 30 31 2)
(fortification 30 30 2)
(fortification 40 30 2)
(fortification 31 29 2)
(fortification 40 29 2)
(fortification 44 29 2)
(fortification 32 28 2)
(fortification 39 28 2)
(fortification 44 28 2)
(fortification 33 27 2)
(fortification 34 27 2)
(fortification 44 27 2)
(fortification 35 26 2)
(fortification 37 26 2)
(fortification 45 26 2)
(fortification 38 25 2)
(fortification 45 25 2)
(fortification 39 24 2)
(fortification 40 24 2)
(fortification 44 24 2)
(fortification 45 24 2)
(fortification 41 23 2)
(fortification 42 23 2)
(fortification 43 23 2)
(fortification 44 23 2)
