;;; uni-case-conv.el --- Case-conversion support for Unicode

;; Copyright (C) 2010 Ben Wing.

;; Keywords: multilingual, case, uppercase, lowercase, Unicode

;; This file is part of XEmacs.

;; XEmacs is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XEmacs is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Commentary:

;; DO NOT MODIFY THIS FILE!!!!!!!!!!!!!!!!
;; This file is autogenerated by make-case-conv.el.  Modify that
;; file instead.

;;; Code:

;; We process UnicodeData.txt in reverse order so that the more
;; desirable mappings, which come early, override less desirable later ones.
;; In particular, we definitely do not want the following bindings to work
;; both ways:

;;        (?\u017F ?\u0073) ;; LATIN SMALL LETTER LONG S
;;        (?\u212A ?\u006B) ;; KELVIN SIGN
;;        (?\u212B ?\u00E5) ;; ANGSTROM SIGN

;; The first two are especially bad as they will cause upcasing operations
;; on lowercase s and k to give strange results.  It's actually worse than
;; that -- for unknown reasons, with the bad mappings in place, the byte-
;; compiler produces broken code for some files, which results in a stack-
;; underflow crash upon loadup in preparation for dumping.
(loop
  for (upper lower)
  in '((?\U0001E921 ?\U0001E943) ;; ADLAM LETTER SHA
       (?\U0001E920 ?\U0001E942) ;; ADLAM LETTER KPO
       (?\U0001E91F ?\U0001E941) ;; ADLAM LETTER ZAL
       (?\U0001E91E ?\U0001E940) ;; ADLAM LETTER GBE
       (?\U0001E91D ?\U0001E93F) ;; ADLAM LETTER KHA
       (?\U0001E91C ?\U0001E93E) ;; ADLAM LETTER VA
       (?\U0001E91B ?\U0001E93D) ;; ADLAM LETTER NHA
       (?\U0001E91A ?\U0001E93C) ;; ADLAM LETTER TU
       (?\U0001E919 ?\U0001E93B) ;; ADLAM LETTER NYA
       (?\U0001E918 ?\U0001E93A) ;; ADLAM LETTER GA
       (?\U0001E917 ?\U0001E939) ;; ADLAM LETTER QAAF
       (?\U0001E916 ?\U0001E938) ;; ADLAM LETTER HA
       (?\U0001E915 ?\U0001E937) ;; ADLAM LETTER CHI
       (?\U0001E914 ?\U0001E936) ;; ADLAM LETTER JIIM
       (?\U0001E913 ?\U0001E935) ;; ADLAM LETTER U
       (?\U0001E912 ?\U0001E934) ;; ADLAM LETTER YA
       (?\U0001E911 ?\U0001E933) ;; ADLAM LETTER KAF
       (?\U0001E910 ?\U0001E932) ;; ADLAM LETTER NUN
       (?\U0001E90F ?\U0001E931) ;; ADLAM LETTER WAW
       (?\U0001E90E ?\U0001E930) ;; ADLAM LETTER YHE
       (?\U0001E90D ?\U0001E92F) ;; ADLAM LETTER DHA
       (?\U0001E90C ?\U0001E92E) ;; ADLAM LETTER O
       (?\U0001E90B ?\U0001E92D) ;; ADLAM LETTER I
       (?\U0001E90A ?\U0001E92C) ;; ADLAM LETTER FA
       (?\U0001E909 ?\U0001E92B) ;; ADLAM LETTER E
       (?\U0001E908 ?\U0001E92A) ;; ADLAM LETTER RA
       (?\U0001E907 ?\U0001E929) ;; ADLAM LETTER BHE
       (?\U0001E906 ?\U0001E928) ;; ADLAM LETTER PE
       (?\U0001E905 ?\U0001E927) ;; ADLAM LETTER SINNYIIYHE
       (?\U0001E904 ?\U0001E926) ;; ADLAM LETTER BA
       (?\U0001E903 ?\U0001E925) ;; ADLAM LETTER MIIM
       (?\U0001E902 ?\U0001E924) ;; ADLAM LETTER LAAM
       (?\U0001E901 ?\U0001E923) ;; ADLAM LETTER DAALI
       (?\U0001E900 ?\U0001E922) ;; ADLAM LETTER ALIF
       (?\U00016E5F ?\U00016E7F) ;; MEDEFAIDRIN LETTER Y
       (?\U00016E5E ?\U00016E7E) ;; MEDEFAIDRIN LETTER AI
       (?\U00016E5D ?\U00016E7D) ;; MEDEFAIDRIN LETTER O
       (?\U00016E5C ?\U00016E7C) ;; MEDEFAIDRIN LETTER R
       (?\U00016E5B ?\U00016E7B) ;; MEDEFAIDRIN LETTER N
       (?\U00016E5A ?\U00016E7A) ;; MEDEFAIDRIN LETTER OE
       (?\U00016E59 ?\U00016E79) ;; MEDEFAIDRIN LETTER D
       (?\U00016E58 ?\U00016E78) ;; MEDEFAIDRIN LETTER X
       (?\U00016E57 ?\U00016E77) ;; MEDEFAIDRIN LETTER NY
       (?\U00016E56 ?\U00016E76) ;; MEDEFAIDRIN LETTER HP
       (?\U00016E55 ?\U00016E75) ;; MEDEFAIDRIN LETTER Q
       (?\U00016E54 ?\U00016E74) ;; MEDEFAIDRIN LETTER L
       (?\U00016E53 ?\U00016E73) ;; MEDEFAIDRIN LETTER YU
       (?\U00016E52 ?\U00016E72) ;; MEDEFAIDRIN LETTER U
       (?\U00016E51 ?\U00016E71) ;; MEDEFAIDRIN LETTER C
       (?\U00016E50 ?\U00016E70) ;; MEDEFAIDRIN LETTER B
       (?\U00016E4F ?\U00016E6F) ;; MEDEFAIDRIN LETTER E
       (?\U00016E4E ?\U00016E6E) ;; MEDEFAIDRIN LETTER J
       (?\U00016E4D ?\U00016E6D) ;; MEDEFAIDRIN LETTER A
       (?\U00016E4C ?\U00016E6C) ;; MEDEFAIDRIN LETTER K
       (?\U00016E4B ?\U00016E6B) ;; MEDEFAIDRIN LETTER I
       (?\U00016E4A ?\U00016E6A) ;; MEDEFAIDRIN LETTER F
       (?\U00016E49 ?\U00016E69) ;; MEDEFAIDRIN LETTER G
       (?\U00016E48 ?\U00016E68) ;; MEDEFAIDRIN LETTER T
       (?\U00016E47 ?\U00016E67) ;; MEDEFAIDRIN LETTER P
       (?\U00016E46 ?\U00016E66) ;; MEDEFAIDRIN LETTER KP
       (?\U00016E45 ?\U00016E65) ;; MEDEFAIDRIN LETTER Z
       (?\U00016E44 ?\U00016E64) ;; MEDEFAIDRIN LETTER ATIU
       (?\U00016E43 ?\U00016E63) ;; MEDEFAIDRIN LETTER W
       (?\U00016E42 ?\U00016E62) ;; MEDEFAIDRIN LETTER V
       (?\U00016E41 ?\U00016E61) ;; MEDEFAIDRIN LETTER S
       (?\U00016E40 ?\U00016E60) ;; MEDEFAIDRIN LETTER M
       (?\U000118BF ?\U000118DF) ;; WARANG CITI LETTER VIYO
       (?\U000118BE ?\U000118DE) ;; WARANG CITI LETTER SII
       (?\U000118BD ?\U000118DD) ;; WARANG CITI LETTER SSUU
       (?\U000118BC ?\U000118DC) ;; WARANG CITI LETTER HAR
       (?\U000118BB ?\U000118DB) ;; WARANG CITI LETTER HORR
       (?\U000118BA ?\U000118DA) ;; WARANG CITI LETTER HOLO
       (?\U000118B9 ?\U000118D9) ;; WARANG CITI LETTER HIYO
       (?\U000118B8 ?\U000118D8) ;; WARANG CITI LETTER PU
       (?\U000118B7 ?\U000118D7) ;; WARANG CITI LETTER BU
       (?\U000118B6 ?\U000118D6) ;; WARANG CITI LETTER AM
       (?\U000118B5 ?\U000118D5) ;; WARANG CITI LETTER AT
       (?\U000118B4 ?\U000118D4) ;; WARANG CITI LETTER DA
       (?\U000118B3 ?\U000118D3) ;; WARANG CITI LETTER NUNG
       (?\U000118B2 ?\U000118D2) ;; WARANG CITI LETTER TTE
       (?\U000118B1 ?\U000118D1) ;; WARANG CITI LETTER ODD
       (?\U000118B0 ?\U000118D0) ;; WARANG CITI LETTER ENN
       (?\U000118AF ?\U000118CF) ;; WARANG CITI LETTER UC
       (?\U000118AE ?\U000118CE) ;; WARANG CITI LETTER YUJ
       (?\U000118AD ?\U000118CD) ;; WARANG CITI LETTER ENY
       (?\U000118AC ?\U000118CC) ;; WARANG CITI LETTER KO
       (?\U000118AB ?\U000118CB) ;; WARANG CITI LETTER GA
       (?\U000118AA ?\U000118CA) ;; WARANG CITI LETTER ANG
       (?\U000118A9 ?\U000118C9) ;; WARANG CITI LETTER O
       (?\U000118A8 ?\U000118C8) ;; WARANG CITI LETTER E
       (?\U000118A7 ?\U000118C7) ;; WARANG CITI LETTER UU
       (?\U000118A6 ?\U000118C6) ;; WARANG CITI LETTER II
       (?\U000118A5 ?\U000118C5) ;; WARANG CITI LETTER YO
       (?\U000118A4 ?\U000118C4) ;; WARANG CITI LETTER YA
       (?\U000118A3 ?\U000118C3) ;; WARANG CITI LETTER YU
       (?\U000118A2 ?\U000118C2) ;; WARANG CITI LETTER WI
       (?\U000118A1 ?\U000118C1) ;; WARANG CITI LETTER A
       (?\U000118A0 ?\U000118C0) ;; WARANG CITI LETTER NGAA
       (?\U00010CB2 ?\U00010CF2) ;; OLD HUNGARIAN LETTER US
       (?\U00010CB1 ?\U00010CF1) ;; OLD HUNGARIAN LETTER ENT-SHAPED SIGN
       (?\U00010CB0 ?\U00010CF0) ;; OLD HUNGARIAN LETTER EZS
       (?\U00010CAF ?\U00010CEF) ;; OLD HUNGARIAN LETTER EZ
       (?\U00010CAE ?\U00010CEE) ;; OLD HUNGARIAN LETTER EV
       (?\U00010CAD ?\U00010CED) ;; OLD HUNGARIAN LETTER RUDIMENTA UE
       (?\U00010CAC ?\U00010CEC) ;; OLD HUNGARIAN LETTER NIKOLSBURG UE
       (?\U00010CAB ?\U00010CEB) ;; OLD HUNGARIAN LETTER UU
       (?\U00010CAA ?\U00010CEA) ;; OLD HUNGARIAN LETTER U
       (?\U00010CA9 ?\U00010CE9) ;; OLD HUNGARIAN LETTER ECH
       (?\U00010CA8 ?\U00010CE8) ;; OLD HUNGARIAN LETTER ETY
       (?\U00010CA7 ?\U00010CE7) ;; OLD HUNGARIAN LETTER ENT
       (?\U00010CA6 ?\U00010CE6) ;; OLD HUNGARIAN LETTER ET
       (?\U00010CA5 ?\U00010CE5) ;; OLD HUNGARIAN LETTER ESZ
       (?\U00010CA4 ?\U00010CE4) ;; OLD HUNGARIAN LETTER ES
       (?\U00010CA3 ?\U00010CE3) ;; OLD HUNGARIAN LETTER SHORT ER
       (?\U00010CA2 ?\U00010CE2) ;; OLD HUNGARIAN LETTER ER
       (?\U00010CA1 ?\U00010CE1) ;; OLD HUNGARIAN LETTER EMP
       (?\U00010CA0 ?\U00010CE0) ;; OLD HUNGARIAN LETTER EP
       (?\U00010C9F ?\U00010CDF) ;; OLD HUNGARIAN LETTER OEE
       (?\U00010C9E ?\U00010CDE) ;; OLD HUNGARIAN LETTER RUDIMENTA OE
       (?\U00010C9D ?\U00010CDD) ;; OLD HUNGARIAN LETTER NIKOLSBURG OE
       (?\U00010C9C ?\U00010CDC) ;; OLD HUNGARIAN LETTER OO
       (?\U00010C9B ?\U00010CDB) ;; OLD HUNGARIAN LETTER O
       (?\U00010C9A ?\U00010CDA) ;; OLD HUNGARIAN LETTER ENY
       (?\U00010C99 ?\U00010CD9) ;; OLD HUNGARIAN LETTER EN
       (?\U00010C98 ?\U00010CD8) ;; OLD HUNGARIAN LETTER EM
       (?\U00010C97 ?\U00010CD7) ;; OLD HUNGARIAN LETTER ELY
       (?\U00010C96 ?\U00010CD6) ;; OLD HUNGARIAN LETTER EL
       (?\U00010C95 ?\U00010CD5) ;; OLD HUNGARIAN LETTER UNK
       (?\U00010C94 ?\U00010CD4) ;; OLD HUNGARIAN LETTER AK
       (?\U00010C93 ?\U00010CD3) ;; OLD HUNGARIAN LETTER EK
       (?\U00010C92 ?\U00010CD2) ;; OLD HUNGARIAN LETTER EJ
       (?\U00010C91 ?\U00010CD1) ;; OLD HUNGARIAN LETTER II
       (?\U00010C90 ?\U00010CD0) ;; OLD HUNGARIAN LETTER I
       (?\U00010C8F ?\U00010CCF) ;; OLD HUNGARIAN LETTER EH
       (?\U00010C8E ?\U00010CCE) ;; OLD HUNGARIAN LETTER EGY
       (?\U00010C8D ?\U00010CCD) ;; OLD HUNGARIAN LETTER EG
       (?\U00010C8C ?\U00010CCC) ;; OLD HUNGARIAN LETTER EF
       (?\U00010C8B ?\U00010CCB) ;; OLD HUNGARIAN LETTER EE
       (?\U00010C8A ?\U00010CCA) ;; OLD HUNGARIAN LETTER CLOSE E
       (?\U00010C89 ?\U00010CC9) ;; OLD HUNGARIAN LETTER E
       (?\U00010C88 ?\U00010CC8) ;; OLD HUNGARIAN LETTER AND
       (?\U00010C87 ?\U00010CC7) ;; OLD HUNGARIAN LETTER ED
       (?\U00010C86 ?\U00010CC6) ;; OLD HUNGARIAN LETTER ECS
       (?\U00010C85 ?\U00010CC5) ;; OLD HUNGARIAN LETTER ENC
       (?\U00010C84 ?\U00010CC4) ;; OLD HUNGARIAN LETTER EC
       (?\U00010C83 ?\U00010CC3) ;; OLD HUNGARIAN LETTER AMB
       (?\U00010C82 ?\U00010CC2) ;; OLD HUNGARIAN LETTER EB
       (?\U00010C81 ?\U00010CC1) ;; OLD HUNGARIAN LETTER AA
       (?\U00010C80 ?\U00010CC0) ;; OLD HUNGARIAN LETTER A
       (?\U00010595 ?\U000105BC) ;; VITHKUQI LETTER ZE
       (?\U00010594 ?\U000105BB) ;; VITHKUQI LETTER Y
       (?\U00010592 ?\U000105B9) ;; VITHKUQI LETTER XE
       (?\U00010591 ?\U000105B8) ;; VITHKUQI LETTER VE
       (?\U00010590 ?\U000105B7) ;; VITHKUQI LETTER U
       (?\U0001058F ?\U000105B6) ;; VITHKUQI LETTER THE
       (?\U0001058E ?\U000105B5) ;; VITHKUQI LETTER TE
       (?\U0001058D ?\U000105B4) ;; VITHKUQI LETTER SHE
       (?\U0001058C ?\U000105B3) ;; VITHKUQI LETTER SE
       (?\U0001058A ?\U000105B1) ;; VITHKUQI LETTER RE
       (?\U00010589 ?\U000105B0) ;; VITHKUQI LETTER QA
       (?\U00010588 ?\U000105AF) ;; VITHKUQI LETTER PE
       (?\U00010587 ?\U000105AE) ;; VITHKUQI LETTER O
       (?\U00010586 ?\U000105AD) ;; VITHKUQI LETTER NJE
       (?\U00010585 ?\U000105AC) ;; VITHKUQI LETTER NE
       (?\U00010584 ?\U000105AB) ;; VITHKUQI LETTER ME
       (?\U00010583 ?\U000105AA) ;; VITHKUQI LETTER LLA
       (?\U00010582 ?\U000105A9) ;; VITHKUQI LETTER LA
       (?\U00010581 ?\U000105A8) ;; VITHKUQI LETTER KA
       (?\U00010580 ?\U000105A7) ;; VITHKUQI LETTER JE
       (?\U0001057F ?\U000105A6) ;; VITHKUQI LETTER IJE
       (?\U0001057E ?\U000105A5) ;; VITHKUQI LETTER I
       (?\U0001057D ?\U000105A4) ;; VITHKUQI LETTER HHA
       (?\U0001057C ?\U000105A3) ;; VITHKUQI LETTER HA
       (?\U0001057A ?\U000105A1) ;; VITHKUQI LETTER GA
       (?\U00010579 ?\U000105A0) ;; VITHKUQI LETTER FE
       (?\U00010578 ?\U0001059F) ;; VITHKUQI LETTER E
       (?\U00010577 ?\U0001059E) ;; VITHKUQI LETTER EI
       (?\U00010576 ?\U0001059D) ;; VITHKUQI LETTER DHE
       (?\U00010575 ?\U0001059C) ;; VITHKUQI LETTER DE
       (?\U00010574 ?\U0001059B) ;; VITHKUQI LETTER CHE
       (?\U00010573 ?\U0001059A) ;; VITHKUQI LETTER CE
       (?\U00010572 ?\U00010599) ;; VITHKUQI LETTER BE
       (?\U00010571 ?\U00010598) ;; VITHKUQI LETTER BBE
       (?\U00010570 ?\U00010597) ;; VITHKUQI LETTER A
       (?\U000104D3 ?\U000104FB) ;; OSAGE LETTER ZHA
       (?\U000104D2 ?\U000104FA) ;; OSAGE LETTER ZA
       (?\U000104D1 ?\U000104F9) ;; OSAGE LETTER GHA
       (?\U000104D0 ?\U000104F8) ;; OSAGE LETTER KHA
       (?\U000104CF ?\U000104F7) ;; OSAGE LETTER WA
       (?\U000104CE ?\U000104F6) ;; OSAGE LETTER U
       (?\U000104CD ?\U000104F5) ;; OSAGE LETTER DHA
       (?\U000104CC ?\U000104F4) ;; OSAGE LETTER TSHA
       (?\U000104CB ?\U000104F3) ;; OSAGE LETTER EHTSA
       (?\U000104CA ?\U000104F2) ;; OSAGE LETTER TSA
       (?\U000104C9 ?\U000104F1) ;; OSAGE LETTER EHTA
       (?\U000104C8 ?\U000104F0) ;; OSAGE LETTER TA
       (?\U000104C7 ?\U000104EF) ;; OSAGE LETTER SHA
       (?\U000104C6 ?\U000104EE) ;; OSAGE LETTER SA
       (?\U000104C5 ?\U000104ED) ;; OSAGE LETTER EHPA
       (?\U000104C4 ?\U000104EC) ;; OSAGE LETTER PA
       (?\U000104C3 ?\U000104EB) ;; OSAGE LETTER OIN
       (?\U000104C2 ?\U000104EA) ;; OSAGE LETTER O
       (?\U000104C1 ?\U000104E9) ;; OSAGE LETTER NA
       (?\U000104C0 ?\U000104E8) ;; OSAGE LETTER MA
       (?\U000104BF ?\U000104E7) ;; OSAGE LETTER LA
       (?\U000104BE ?\U000104E6) ;; OSAGE LETTER KYA
       (?\U000104BD ?\U000104E5) ;; OSAGE LETTER EHKA
       (?\U000104BC ?\U000104E4) ;; OSAGE LETTER KA
       (?\U000104BB ?\U000104E3) ;; OSAGE LETTER I
       (?\U000104BA ?\U000104E2) ;; OSAGE LETTER HYA
       (?\U000104B9 ?\U000104E1) ;; OSAGE LETTER HA
       (?\U000104B8 ?\U000104E0) ;; OSAGE LETTER EIN
       (?\U000104B7 ?\U000104DF) ;; OSAGE LETTER E
       (?\U000104B6 ?\U000104DE) ;; OSAGE LETTER EHCHA
       (?\U000104B5 ?\U000104DD) ;; OSAGE LETTER CHA
       (?\U000104B4 ?\U000104DC) ;; OSAGE LETTER BRA
       (?\U000104B3 ?\U000104DB) ;; OSAGE LETTER AH
       (?\U000104B2 ?\U000104DA) ;; OSAGE LETTER AIN
       (?\U000104B1 ?\U000104D9) ;; OSAGE LETTER AI
       (?\U000104B0 ?\U000104D8) ;; OSAGE LETTER A
       (?\U00010427 ?\U0001044F) ;; DESERET LETTER EW
       (?\U00010426 ?\U0001044E) ;; DESERET LETTER OI
       (?\U00010425 ?\U0001044D) ;; DESERET LETTER ENG
       (?\U00010424 ?\U0001044C) ;; DESERET LETTER EN
       (?\U00010423 ?\U0001044B) ;; DESERET LETTER EM
       (?\U00010422 ?\U0001044A) ;; DESERET LETTER EL
       (?\U00010421 ?\U00010449) ;; DESERET LETTER ER
       (?\U00010420 ?\U00010448) ;; DESERET LETTER ZHEE
       (?\U0001041F ?\U00010447) ;; DESERET LETTER ESH
       (?\U0001041E ?\U00010446) ;; DESERET LETTER ZEE
       (?\U0001041D ?\U00010445) ;; DESERET LETTER ES
       (?\U0001041C ?\U00010444) ;; DESERET LETTER THEE
       (?\U0001041B ?\U00010443) ;; DESERET LETTER ETH
       (?\U0001041A ?\U00010442) ;; DESERET LETTER VEE
       (?\U00010419 ?\U00010441) ;; DESERET LETTER EF
       (?\U00010418 ?\U00010440) ;; DESERET LETTER GAY
       (?\U00010417 ?\U0001043F) ;; DESERET LETTER KAY
       (?\U00010416 ?\U0001043E) ;; DESERET LETTER JEE
       (?\U00010415 ?\U0001043D) ;; DESERET LETTER CHEE
       (?\U00010414 ?\U0001043C) ;; DESERET LETTER DEE
       (?\U00010413 ?\U0001043B) ;; DESERET LETTER TEE
       (?\U00010412 ?\U0001043A) ;; DESERET LETTER BEE
       (?\U00010411 ?\U00010439) ;; DESERET LETTER PEE
       (?\U00010410 ?\U00010438) ;; DESERET LETTER H
       (?\U0001040F ?\U00010437) ;; DESERET LETTER YEE
       (?\U0001040E ?\U00010436) ;; DESERET LETTER WU
       (?\U0001040D ?\U00010435) ;; DESERET LETTER OW
       (?\U0001040C ?\U00010434) ;; DESERET LETTER AY
       (?\U0001040B ?\U00010433) ;; DESERET LETTER SHORT OO
       (?\U0001040A ?\U00010432) ;; DESERET LETTER SHORT O
       (?\U00010409 ?\U00010431) ;; DESERET LETTER SHORT AH
       (?\U00010408 ?\U00010430) ;; DESERET LETTER SHORT A
       (?\U00010407 ?\U0001042F) ;; DESERET LETTER SHORT E
       (?\U00010406 ?\U0001042E) ;; DESERET LETTER SHORT I
       (?\U00010405 ?\U0001042D) ;; DESERET LETTER LONG OO
       (?\U00010404 ?\U0001042C) ;; DESERET LETTER LONG O
       (?\U00010403 ?\U0001042B) ;; DESERET LETTER LONG AH
       (?\U00010402 ?\U0001042A) ;; DESERET LETTER LONG A
       (?\U00010401 ?\U00010429) ;; DESERET LETTER LONG E
       (?\U00010400 ?\U00010428) ;; DESERET LETTER LONG I
       (?\uFF3A ?\uFF5A) ;; FULLWIDTH LATIN LETTER Z
       (?\uFF39 ?\uFF59) ;; FULLWIDTH LATIN LETTER Y
       (?\uFF38 ?\uFF58) ;; FULLWIDTH LATIN LETTER X
       (?\uFF37 ?\uFF57) ;; FULLWIDTH LATIN LETTER W
       (?\uFF36 ?\uFF56) ;; FULLWIDTH LATIN LETTER V
       (?\uFF35 ?\uFF55) ;; FULLWIDTH LATIN LETTER U
       (?\uFF34 ?\uFF54) ;; FULLWIDTH LATIN LETTER T
       (?\uFF33 ?\uFF53) ;; FULLWIDTH LATIN LETTER S
       (?\uFF32 ?\uFF52) ;; FULLWIDTH LATIN LETTER R
       (?\uFF31 ?\uFF51) ;; FULLWIDTH LATIN LETTER Q
       (?\uFF30 ?\uFF50) ;; FULLWIDTH LATIN LETTER P
       (?\uFF2F ?\uFF4F) ;; FULLWIDTH LATIN LETTER O
       (?\uFF2E ?\uFF4E) ;; FULLWIDTH LATIN LETTER N
       (?\uFF2D ?\uFF4D) ;; FULLWIDTH LATIN LETTER M
       (?\uFF2C ?\uFF4C) ;; FULLWIDTH LATIN LETTER L
       (?\uFF2B ?\uFF4B) ;; FULLWIDTH LATIN LETTER K
       (?\uFF2A ?\uFF4A) ;; FULLWIDTH LATIN LETTER J
       (?\uFF29 ?\uFF49) ;; FULLWIDTH LATIN LETTER I
       (?\uFF28 ?\uFF48) ;; FULLWIDTH LATIN LETTER H
       (?\uFF27 ?\uFF47) ;; FULLWIDTH LATIN LETTER G
       (?\uFF26 ?\uFF46) ;; FULLWIDTH LATIN LETTER F
       (?\uFF25 ?\uFF45) ;; FULLWIDTH LATIN LETTER E
       (?\uFF24 ?\uFF44) ;; FULLWIDTH LATIN LETTER D
       (?\uFF23 ?\uFF43) ;; FULLWIDTH LATIN LETTER C
       (?\uFF22 ?\uFF42) ;; FULLWIDTH LATIN LETTER B
       (?\uFF21 ?\uFF41) ;; FULLWIDTH LATIN LETTER A
       (?\u13EF ?\uABBF) ;; CHEROKEE LETTER YA, CHEROKEE SMALL LETTER YA
       (?\u13EE ?\uABBE) ;; CHEROKEE LETTER WV, CHEROKEE SMALL LETTER WV
       (?\u13ED ?\uABBD) ;; CHEROKEE LETTER WU, CHEROKEE SMALL LETTER WU
       (?\u13EC ?\uABBC) ;; CHEROKEE LETTER WO, CHEROKEE SMALL LETTER WO
       (?\u13EB ?\uABBB) ;; CHEROKEE LETTER WI, CHEROKEE SMALL LETTER WI
       (?\u13EA ?\uABBA) ;; CHEROKEE LETTER WE, CHEROKEE SMALL LETTER WE
       (?\u13E9 ?\uABB9) ;; CHEROKEE LETTER WA, CHEROKEE SMALL LETTER WA
       (?\u13E8 ?\uABB8) ;; CHEROKEE LETTER TSV, CHEROKEE SMALL LETTER TSV
       (?\u13E7 ?\uABB7) ;; CHEROKEE LETTER TSU, CHEROKEE SMALL LETTER TSU
       (?\u13E6 ?\uABB6) ;; CHEROKEE LETTER TSO, CHEROKEE SMALL LETTER TSO
       (?\u13E5 ?\uABB5) ;; CHEROKEE LETTER TSI, CHEROKEE SMALL LETTER TSI
       (?\u13E4 ?\uABB4) ;; CHEROKEE LETTER TSE, CHEROKEE SMALL LETTER TSE
       (?\u13E3 ?\uABB3) ;; CHEROKEE LETTER TSA, CHEROKEE SMALL LETTER TSA
       (?\u13E2 ?\uABB2) ;; CHEROKEE LETTER TLV, CHEROKEE SMALL LETTER TLV
       (?\u13E1 ?\uABB1) ;; CHEROKEE LETTER TLU, CHEROKEE SMALL LETTER TLU
       (?\u13E0 ?\uABB0) ;; CHEROKEE LETTER TLO, CHEROKEE SMALL LETTER TLO
       (?\u13DF ?\uABAF) ;; CHEROKEE LETTER TLI, CHEROKEE SMALL LETTER TLI
       (?\u13DE ?\uABAE) ;; CHEROKEE LETTER TLE, CHEROKEE SMALL LETTER TLE
       (?\u13DD ?\uABAD) ;; CHEROKEE LETTER TLA, CHEROKEE SMALL LETTER TLA
       (?\u13DC ?\uABAC) ;; CHEROKEE LETTER DLA, CHEROKEE SMALL LETTER DLA
       (?\u13DB ?\uABAB) ;; CHEROKEE LETTER DV, CHEROKEE SMALL LETTER DV
       (?\u13DA ?\uABAA) ;; CHEROKEE LETTER DU, CHEROKEE SMALL LETTER DU
       (?\u13D9 ?\uABA9) ;; CHEROKEE LETTER DO, CHEROKEE SMALL LETTER DO
       (?\u13D8 ?\uABA8) ;; CHEROKEE LETTER TI, CHEROKEE SMALL LETTER TI
       (?\u13D7 ?\uABA7) ;; CHEROKEE LETTER DI, CHEROKEE SMALL LETTER DI
       (?\u13D6 ?\uABA6) ;; CHEROKEE LETTER TE, CHEROKEE SMALL LETTER TE
       (?\u13D5 ?\uABA5) ;; CHEROKEE LETTER DE, CHEROKEE SMALL LETTER DE
       (?\u13D4 ?\uABA4) ;; CHEROKEE LETTER TA, CHEROKEE SMALL LETTER TA
       (?\u13D3 ?\uABA3) ;; CHEROKEE LETTER DA, CHEROKEE SMALL LETTER DA
       (?\u13D2 ?\uABA2) ;; CHEROKEE LETTER SV, CHEROKEE SMALL LETTER SV
       (?\u13D1 ?\uABA1) ;; CHEROKEE LETTER SU, CHEROKEE SMALL LETTER SU
       (?\u13D0 ?\uABA0) ;; CHEROKEE LETTER SO, CHEROKEE SMALL LETTER SO
       (?\u13CF ?\uAB9F) ;; CHEROKEE LETTER SI, CHEROKEE SMALL LETTER SI
       (?\u13CE ?\uAB9E) ;; CHEROKEE LETTER SE, CHEROKEE SMALL LETTER SE
       (?\u13CD ?\uAB9D) ;; CHEROKEE LETTER S, CHEROKEE SMALL LETTER S
       (?\u13CC ?\uAB9C) ;; CHEROKEE LETTER SA, CHEROKEE SMALL LETTER SA
       (?\u13CB ?\uAB9B) ;; CHEROKEE LETTER QUV, CHEROKEE SMALL LETTER QUV
       (?\u13CA ?\uAB9A) ;; CHEROKEE LETTER QUU, CHEROKEE SMALL LETTER QUU
       (?\u13C9 ?\uAB99) ;; CHEROKEE LETTER QUO, CHEROKEE SMALL LETTER QUO
       (?\u13C8 ?\uAB98) ;; CHEROKEE LETTER QUI, CHEROKEE SMALL LETTER QUI
       (?\u13C7 ?\uAB97) ;; CHEROKEE LETTER QUE, CHEROKEE SMALL LETTER QUE
       (?\u13C6 ?\uAB96) ;; CHEROKEE LETTER QUA, CHEROKEE SMALL LETTER QUA
       (?\u13C5 ?\uAB95) ;; CHEROKEE LETTER NV, CHEROKEE SMALL LETTER NV
       (?\u13C4 ?\uAB94) ;; CHEROKEE LETTER NU, CHEROKEE SMALL LETTER NU
       (?\u13C3 ?\uAB93) ;; CHEROKEE LETTER NO, CHEROKEE SMALL LETTER NO
       (?\u13C2 ?\uAB92) ;; CHEROKEE LETTER NI, CHEROKEE SMALL LETTER NI
       (?\u13C1 ?\uAB91) ;; CHEROKEE LETTER NE, CHEROKEE SMALL LETTER NE
       (?\u13C0 ?\uAB90) ;; CHEROKEE LETTER NAH, CHEROKEE SMALL LETTER NAH
       (?\u13BF ?\uAB8F) ;; CHEROKEE LETTER HNA, CHEROKEE SMALL LETTER HNA
       (?\u13BE ?\uAB8E) ;; CHEROKEE LETTER NA, CHEROKEE SMALL LETTER NA
       (?\u13BD ?\uAB8D) ;; CHEROKEE LETTER MU, CHEROKEE SMALL LETTER MU
       (?\u13BC ?\uAB8C) ;; CHEROKEE LETTER MO, CHEROKEE SMALL LETTER MO
       (?\u13BB ?\uAB8B) ;; CHEROKEE LETTER MI, CHEROKEE SMALL LETTER MI
       (?\u13BA ?\uAB8A) ;; CHEROKEE LETTER ME, CHEROKEE SMALL LETTER ME
       (?\u13B9 ?\uAB89) ;; CHEROKEE LETTER MA, CHEROKEE SMALL LETTER MA
       (?\u13B8 ?\uAB88) ;; CHEROKEE LETTER LV, CHEROKEE SMALL LETTER LV
       (?\u13B7 ?\uAB87) ;; CHEROKEE LETTER LU, CHEROKEE SMALL LETTER LU
       (?\u13B6 ?\uAB86) ;; CHEROKEE LETTER LO, CHEROKEE SMALL LETTER LO
       (?\u13B5 ?\uAB85) ;; CHEROKEE LETTER LI, CHEROKEE SMALL LETTER LI
       (?\u13B4 ?\uAB84) ;; CHEROKEE LETTER LE, CHEROKEE SMALL LETTER LE
       (?\u13B3 ?\uAB83) ;; CHEROKEE LETTER LA, CHEROKEE SMALL LETTER LA
       (?\u13B2 ?\uAB82) ;; CHEROKEE LETTER HV, CHEROKEE SMALL LETTER HV
       (?\u13B1 ?\uAB81) ;; CHEROKEE LETTER HU, CHEROKEE SMALL LETTER HU
       (?\u13B0 ?\uAB80) ;; CHEROKEE LETTER HO, CHEROKEE SMALL LETTER HO
       (?\u13AF ?\uAB7F) ;; CHEROKEE LETTER HI, CHEROKEE SMALL LETTER HI
       (?\u13AE ?\uAB7E) ;; CHEROKEE LETTER HE, CHEROKEE SMALL LETTER HE
       (?\u13AD ?\uAB7D) ;; CHEROKEE LETTER HA, CHEROKEE SMALL LETTER HA
       (?\u13AC ?\uAB7C) ;; CHEROKEE LETTER GV, CHEROKEE SMALL LETTER GV
       (?\u13AB ?\uAB7B) ;; CHEROKEE LETTER GU, CHEROKEE SMALL LETTER GU
       (?\u13AA ?\uAB7A) ;; CHEROKEE LETTER GO, CHEROKEE SMALL LETTER GO
       (?\u13A9 ?\uAB79) ;; CHEROKEE LETTER GI, CHEROKEE SMALL LETTER GI
       (?\u13A8 ?\uAB78) ;; CHEROKEE LETTER GE, CHEROKEE SMALL LETTER GE
       (?\u13A7 ?\uAB77) ;; CHEROKEE LETTER KA, CHEROKEE SMALL LETTER KA
       (?\u13A6 ?\uAB76) ;; CHEROKEE LETTER GA, CHEROKEE SMALL LETTER GA
       (?\u13A5 ?\uAB75) ;; CHEROKEE LETTER V, CHEROKEE SMALL LETTER V
       (?\u13A4 ?\uAB74) ;; CHEROKEE LETTER U, CHEROKEE SMALL LETTER U
       (?\u13A3 ?\uAB73) ;; CHEROKEE LETTER O, CHEROKEE SMALL LETTER O
       (?\u13A2 ?\uAB72) ;; CHEROKEE LETTER I, CHEROKEE SMALL LETTER I
       (?\u13A1 ?\uAB71) ;; CHEROKEE LETTER E, CHEROKEE SMALL LETTER E
       (?\u13A0 ?\uAB70) ;; CHEROKEE LETTER A, CHEROKEE SMALL LETTER A
       (?\uA7B3 ?\uAB53) ;; LATIN LETTER CHI
       (?\uA7F5 ?\uA7F6) ;; LATIN LETTER REVERSED HALF H
       (?\uA7D8 ?\uA7D9) ;; LATIN LETTER SIGMOID S
       (?\uA7D6 ?\uA7D7) ;; LATIN LETTER MIDDLE SCOTS S
       (?\uA7D0 ?\uA7D1) ;; LATIN LETTER CLOSED INSULAR G
       (?\uA7C9 ?\uA7CA) ;; LATIN LETTER S WITH SHORT STROKE OVERLAY
       (?\uA7C7 ?\uA7C8) ;; LATIN LETTER D WITH SHORT STROKE OVERLAY
       (?\uA7C6 ?\u1D8E) ;; LATIN LETTER Z WITH PALATAL HOOK
       (?\uA7C5 ?\u0282) ;; LATIN LETTER S WITH HOOK
       (?\uA7C4 ?\uA794) ;; LATIN LETTER C WITH PALATAL HOOK
       (?\uA7C2 ?\uA7C3) ;; LATIN LETTER ANGLICANA W
       (?\uA7C0 ?\uA7C1) ;; LATIN LETTER OLD POLISH O
       (?\uA7BE ?\uA7BF) ;; LATIN LETTER GLOTTAL U
       (?\uA7BC ?\uA7BD) ;; LATIN LETTER GLOTTAL I
       (?\uA7BA ?\uA7BB) ;; LATIN LETTER GLOTTAL A
       (?\uA7B8 ?\uA7B9) ;; LATIN LETTER U WITH STROKE
       (?\uA7B6 ?\uA7B7) ;; LATIN LETTER OMEGA
       (?\uA7B4 ?\uA7B5) ;; LATIN LETTER BETA
       (?\uA7B2 ?\u029D) ;; LATIN LETTER J WITH CROSSED-TAIL
       (?\uA7B1 ?\u0287) ;; LATIN LETTER TURNED T
       (?\uA7B0 ?\u029E) ;; LATIN LETTER TURNED K
       (?\uA7AE ?\u026A) ;; LATIN CAPITAL LETTER SMALL CAPITAL I, LATIN LETTER SMALL CAPITAL I
       (?\uA7AD ?\u026C) ;; LATIN LETTER L WITH BELT
       (?\uA7AC ?\u0261) ;; LATIN LETTER SCRIPT G
       (?\uA7AB ?\u025C) ;; LATIN LETTER REVERSED OPEN E
       (?\uA7AA ?\u0266) ;; LATIN LETTER H WITH HOOK
       (?\uA7A8 ?\uA7A9) ;; LATIN LETTER S WITH OBLIQUE STROKE
       (?\uA7A6 ?\uA7A7) ;; LATIN LETTER R WITH OBLIQUE STROKE
       (?\uA7A4 ?\uA7A5) ;; LATIN LETTER N WITH OBLIQUE STROKE
       (?\uA7A2 ?\uA7A3) ;; LATIN LETTER K WITH OBLIQUE STROKE
       (?\uA7A0 ?\uA7A1) ;; LATIN LETTER G WITH OBLIQUE STROKE
       (?\uA79E ?\uA79F) ;; LATIN LETTER VOLAPUK UE
       (?\uA79C ?\uA79D) ;; LATIN LETTER VOLAPUK OE
       (?\uA79A ?\uA79B) ;; LATIN LETTER VOLAPUK AE
       (?\uA798 ?\uA799) ;; LATIN LETTER F WITH STROKE
       (?\uA796 ?\uA797) ;; LATIN LETTER B WITH FLOURISH
       (?\uA7C4 ?\uA794) ;; LATIN LETTER C WITH PALATAL HOOK
       (?\uA792 ?\uA793) ;; LATIN LETTER C WITH BAR
       (?\uA790 ?\uA791) ;; LATIN LETTER N WITH DESCENDER
       (?\uA78D ?\u0265) ;; LATIN LETTER TURNED H
       (?\uA78B ?\uA78C) ;; LATIN LETTER SALTILLO
       (?\uA786 ?\uA787) ;; LATIN LETTER INSULAR T
       (?\uA784 ?\uA785) ;; LATIN LETTER INSULAR S
       (?\uA782 ?\uA783) ;; LATIN LETTER INSULAR R
       (?\uA780 ?\uA781) ;; LATIN LETTER TURNED L
       (?\uA77E ?\uA77F) ;; LATIN LETTER TURNED INSULAR G
       (?\uA77D ?\u1D79) ;; LATIN LETTER INSULAR G
       (?\uA77B ?\uA77C) ;; LATIN LETTER INSULAR F
       (?\uA779 ?\uA77A) ;; LATIN LETTER INSULAR D
       (?\uA76E ?\uA76F) ;; LATIN LETTER CON
       (?\uA76C ?\uA76D) ;; LATIN LETTER IS
       (?\uA76A ?\uA76B) ;; LATIN LETTER ET
       (?\uA768 ?\uA769) ;; LATIN LETTER VEND
       (?\uA766 ?\uA767) ;; LATIN LETTER THORN WITH STROKE THROUGH DESCENDER
       (?\uA764 ?\uA765) ;; LATIN LETTER THORN WITH STROKE
       (?\uA762 ?\uA763) ;; LATIN LETTER VISIGOTHIC Z
       (?\uA760 ?\uA761) ;; LATIN LETTER VY
       (?\uA75E ?\uA75F) ;; LATIN LETTER V WITH DIAGONAL STROKE
       (?\uA75C ?\uA75D) ;; LATIN LETTER RUM ROTUNDA
       (?\uA75A ?\uA75B) ;; LATIN LETTER R ROTUNDA
       (?\uA758 ?\uA759) ;; LATIN LETTER Q WITH DIAGONAL STROKE
       (?\uA756 ?\uA757) ;; LATIN LETTER Q WITH STROKE THROUGH DESCENDER
       (?\uA754 ?\uA755) ;; LATIN LETTER P WITH SQUIRREL TAIL
       (?\uA752 ?\uA753) ;; LATIN LETTER P WITH FLOURISH
       (?\uA750 ?\uA751) ;; LATIN LETTER P WITH STROKE THROUGH DESCENDER
       (?\uA74E ?\uA74F) ;; LATIN LETTER OO
       (?\uA74C ?\uA74D) ;; LATIN LETTER O WITH LOOP
       (?\uA74A ?\uA74B) ;; LATIN LETTER O WITH LONG STROKE OVERLAY
       (?\uA748 ?\uA749) ;; LATIN LETTER L WITH HIGH STROKE
       (?\uA746 ?\uA747) ;; LATIN LETTER BROKEN L
       (?\uA744 ?\uA745) ;; LATIN LETTER K WITH STROKE AND DIAGONAL STROKE
       (?\uA742 ?\uA743) ;; LATIN LETTER K WITH DIAGONAL STROKE
       (?\uA740 ?\uA741) ;; LATIN LETTER K WITH STROKE
       (?\uA73E ?\uA73F) ;; LATIN LETTER REVERSED C WITH DOT
       (?\uA73C ?\uA73D) ;; LATIN LETTER AY
       (?\uA73A ?\uA73B) ;; LATIN LETTER AV WITH HORIZONTAL BAR
       (?\uA738 ?\uA739) ;; LATIN LETTER AV
       (?\uA736 ?\uA737) ;; LATIN LETTER AU
       (?\uA734 ?\uA735) ;; LATIN LETTER AO
       (?\uA732 ?\uA733) ;; LATIN LETTER AA
       (?\uA72E ?\uA72F) ;; LATIN LETTER CUATRILLO WITH COMMA
       (?\uA72C ?\uA72D) ;; LATIN LETTER CUATRILLO
       (?\uA72A ?\uA72B) ;; LATIN LETTER TRESILLO
       (?\uA728 ?\uA729) ;; LATIN LETTER TZ
       (?\uA726 ?\uA727) ;; LATIN LETTER HENG
       (?\uA724 ?\uA725) ;; LATIN LETTER EGYPTOLOGICAL AIN
       (?\uA722 ?\uA723) ;; LATIN LETTER EGYPTOLOGICAL ALEF
       (?\uA69A ?\uA69B) ;; CYRILLIC LETTER CROSSED O
       (?\uA698 ?\uA699) ;; CYRILLIC LETTER DOUBLE O
       (?\uA696 ?\uA697) ;; CYRILLIC LETTER SHWE
       (?\uA694 ?\uA695) ;; CYRILLIC LETTER HWE
       (?\uA692 ?\uA693) ;; CYRILLIC LETTER TCHE
       (?\uA690 ?\uA691) ;; CYRILLIC LETTER TSSE
       (?\uA68E ?\uA68F) ;; CYRILLIC LETTER TSWE
       (?\uA68C ?\uA68D) ;; CYRILLIC LETTER TWE
       (?\uA68A ?\uA68B) ;; CYRILLIC LETTER TE WITH MIDDLE HOOK
       (?\uA688 ?\uA689) ;; CYRILLIC LETTER DZZE
       (?\uA686 ?\uA687) ;; CYRILLIC LETTER CCHE
       (?\uA684 ?\uA685) ;; CYRILLIC LETTER ZHWE
       (?\uA682 ?\uA683) ;; CYRILLIC LETTER DZWE
       (?\uA680 ?\uA681) ;; CYRILLIC LETTER DWE
       (?\uA66C ?\uA66D) ;; CYRILLIC LETTER DOUBLE MONOCULAR O
       (?\uA66A ?\uA66B) ;; CYRILLIC LETTER BINOCULAR O
       (?\uA668 ?\uA669) ;; CYRILLIC LETTER MONOCULAR O
       (?\uA666 ?\uA667) ;; CYRILLIC LETTER SOFT EM
       (?\uA664 ?\uA665) ;; CYRILLIC LETTER SOFT EL
       (?\uA662 ?\uA663) ;; CYRILLIC LETTER SOFT DE
       (?\uA660 ?\uA661) ;; CYRILLIC LETTER REVERSED TSE
       (?\uA65E ?\uA65F) ;; CYRILLIC LETTER YN
       (?\uA65C ?\uA65D) ;; CYRILLIC LETTER IOTIFIED CLOSED LITTLE YUS
       (?\uA65A ?\uA65B) ;; CYRILLIC LETTER BLENDED YUS
       (?\uA658 ?\uA659) ;; CYRILLIC LETTER CLOSED LITTLE YUS
       (?\uA656 ?\uA657) ;; CYRILLIC LETTER IOTIFIED A
       (?\uA654 ?\uA655) ;; CYRILLIC LETTER REVERSED YU
       (?\uA652 ?\uA653) ;; CYRILLIC LETTER IOTIFIED YAT
       (?\uA650 ?\uA651) ;; CYRILLIC LETTER YERU WITH BACK YER
       (?\uA64E ?\uA64F) ;; CYRILLIC LETTER NEUTRAL YER
       (?\uA64C ?\uA64D) ;; CYRILLIC LETTER BROAD OMEGA
       (?\uA64A ?\uA64B) ;; CYRILLIC LETTER MONOGRAPH UK
       (?\uA648 ?\uA649) ;; CYRILLIC LETTER DJERV
       (?\uA646 ?\uA647) ;; CYRILLIC LETTER IOTA
       (?\uA644 ?\uA645) ;; CYRILLIC LETTER REVERSED DZE
       (?\uA642 ?\uA643) ;; CYRILLIC LETTER DZELO
       (?\uA640 ?\uA641) ;; CYRILLIC LETTER ZEMLYA
       (?\u10CD ?\u2D2D) ;; GEORGIAN LETTER AEN
       (?\u10C7 ?\u2D27) ;; GEORGIAN LETTER YN
       (?\u10C5 ?\u2D25) ;; GEORGIAN LETTER HOE
       (?\u10C4 ?\u2D24) ;; GEORGIAN LETTER HAR
       (?\u10C3 ?\u2D23) ;; GEORGIAN LETTER WE
       (?\u10C2 ?\u2D22) ;; GEORGIAN LETTER HIE
       (?\u10C1 ?\u2D21) ;; GEORGIAN LETTER HE
       (?\u10C0 ?\u2D20) ;; GEORGIAN LETTER HAE
       (?\u10BF ?\u2D1F) ;; GEORGIAN LETTER JHAN
       (?\u10BE ?\u2D1E) ;; GEORGIAN LETTER XAN
       (?\u10BD ?\u2D1D) ;; GEORGIAN LETTER CHAR
       (?\u10BC ?\u2D1C) ;; GEORGIAN LETTER CIL
       (?\u10BB ?\u2D1B) ;; GEORGIAN LETTER JIL
       (?\u10BA ?\u2D1A) ;; GEORGIAN LETTER CAN
       (?\u10B9 ?\u2D19) ;; GEORGIAN LETTER CHIN
       (?\u10B8 ?\u2D18) ;; GEORGIAN LETTER SHIN
       (?\u10B7 ?\u2D17) ;; GEORGIAN LETTER QAR
       (?\u10B6 ?\u2D16) ;; GEORGIAN LETTER GHAN
       (?\u10B5 ?\u2D15) ;; GEORGIAN LETTER KHAR
       (?\u10B4 ?\u2D14) ;; GEORGIAN LETTER PHAR
       (?\u10B3 ?\u2D13) ;; GEORGIAN LETTER UN
       (?\u10B2 ?\u2D12) ;; GEORGIAN LETTER TAR
       (?\u10B1 ?\u2D11) ;; GEORGIAN LETTER SAN
       (?\u10B0 ?\u2D10) ;; GEORGIAN LETTER RAE
       (?\u10AF ?\u2D0F) ;; GEORGIAN LETTER ZHAR
       (?\u10AE ?\u2D0E) ;; GEORGIAN LETTER PAR
       (?\u10AD ?\u2D0D) ;; GEORGIAN LETTER ON
       (?\u10AC ?\u2D0C) ;; GEORGIAN LETTER NAR
       (?\u10AB ?\u2D0B) ;; GEORGIAN LETTER MAN
       (?\u10AA ?\u2D0A) ;; GEORGIAN LETTER LAS
       (?\u10A9 ?\u2D09) ;; GEORGIAN LETTER KAN
       (?\u10A8 ?\u2D08) ;; GEORGIAN LETTER IN
       (?\u10A7 ?\u2D07) ;; GEORGIAN LETTER TAN
       (?\u10A6 ?\u2D06) ;; GEORGIAN LETTER ZEN
       (?\u10A5 ?\u2D05) ;; GEORGIAN LETTER VIN
       (?\u10A4 ?\u2D04) ;; GEORGIAN LETTER EN
       (?\u10A3 ?\u2D03) ;; GEORGIAN LETTER DON
       (?\u10A2 ?\u2D02) ;; GEORGIAN LETTER GAN
       (?\u10A1 ?\u2D01) ;; GEORGIAN LETTER BAN
       (?\u10A0 ?\u2D00) ;; GEORGIAN LETTER AN
       (?\u2CF2 ?\u2CF3) ;; COPTIC LETTER BOHAIRIC KHEI
       (?\u2CED ?\u2CEE) ;; COPTIC LETTER CRYPTOGRAMMIC GANGIA
       (?\u2CEB ?\u2CEC) ;; COPTIC LETTER CRYPTOGRAMMIC SHEI
       (?\u2CE2 ?\u2CE3) ;; COPTIC LETTER OLD NUBIAN WAU
       (?\u2CE0 ?\u2CE1) ;; COPTIC LETTER OLD NUBIAN NYI
       (?\u2CDE ?\u2CDF) ;; COPTIC LETTER OLD NUBIAN NGI
       (?\u2CDC ?\u2CDD) ;; COPTIC LETTER OLD NUBIAN SHIMA
       (?\u2CDA ?\u2CDB) ;; COPTIC LETTER OLD COPTIC SHIMA
       (?\u2CD8 ?\u2CD9) ;; COPTIC LETTER OLD COPTIC DJA
       (?\u2CD6 ?\u2CD7) ;; COPTIC LETTER OLD COPTIC GANGIA
       (?\u2CD4 ?\u2CD5) ;; COPTIC LETTER OLD COPTIC HAT
       (?\u2CD2 ?\u2CD3) ;; COPTIC LETTER OLD COPTIC HEI
       (?\u2CD0 ?\u2CD1) ;; COPTIC LETTER L-SHAPED HA
       (?\u2CCE ?\u2CCF) ;; COPTIC LETTER OLD COPTIC HA
       (?\u2CCC ?\u2CCD) ;; COPTIC LETTER OLD COPTIC HORI
       (?\u2CCA ?\u2CCB) ;; COPTIC LETTER DIALECT-P HORI
       (?\u2CC8 ?\u2CC9) ;; COPTIC LETTER AKHMIMIC KHEI
       (?\u2CC6 ?\u2CC7) ;; COPTIC LETTER OLD COPTIC ESH
       (?\u2CC4 ?\u2CC5) ;; COPTIC LETTER OLD COPTIC SHEI
       (?\u2CC2 ?\u2CC3) ;; COPTIC LETTER CROSSED SHEI
       (?\u2CC0 ?\u2CC1) ;; COPTIC LETTER SAMPI
       (?\u2CBE ?\u2CBF) ;; COPTIC LETTER OLD COPTIC OOU
       (?\u2CBC ?\u2CBD) ;; COPTIC LETTER CRYPTOGRAMMIC NI
       (?\u2CBA ?\u2CBB) ;; COPTIC LETTER DIALECT-P NI
       (?\u2CB8 ?\u2CB9) ;; COPTIC LETTER DIALECT-P KAPA
       (?\u2CB6 ?\u2CB7) ;; COPTIC LETTER CRYPTOGRAMMIC EIE
       (?\u2CB4 ?\u2CB5) ;; COPTIC LETTER OLD COPTIC AIN
       (?\u2CB2 ?\u2CB3) ;; COPTIC LETTER DIALECT-P ALEF
       (?\u2CB0 ?\u2CB1) ;; COPTIC LETTER OOU
       (?\u2CAE ?\u2CAF) ;; COPTIC LETTER PSI
       (?\u2CAC ?\u2CAD) ;; COPTIC LETTER KHI
       (?\u2CAA ?\u2CAB) ;; COPTIC LETTER FI
       (?\u2CA8 ?\u2CA9) ;; COPTIC LETTER UA
       (?\u2CA6 ?\u2CA7) ;; COPTIC LETTER TAU
       (?\u2CA4 ?\u2CA5) ;; COPTIC LETTER SIMA
       (?\u2CA2 ?\u2CA3) ;; COPTIC LETTER RO
       (?\u2CA0 ?\u2CA1) ;; COPTIC LETTER PI
       (?\u2C9E ?\u2C9F) ;; COPTIC LETTER O
       (?\u2C9C ?\u2C9D) ;; COPTIC LETTER KSI
       (?\u2C9A ?\u2C9B) ;; COPTIC LETTER NI
       (?\u2C98 ?\u2C99) ;; COPTIC LETTER MI
       (?\u2C96 ?\u2C97) ;; COPTIC LETTER LAULA
       (?\u2C94 ?\u2C95) ;; COPTIC LETTER KAPA
       (?\u2C92 ?\u2C93) ;; COPTIC LETTER IAUDA
       (?\u2C90 ?\u2C91) ;; COPTIC LETTER THETHE
       (?\u2C8E ?\u2C8F) ;; COPTIC LETTER HATE
       (?\u2C8C ?\u2C8D) ;; COPTIC LETTER ZATA
       (?\u2C8A ?\u2C8B) ;; COPTIC LETTER SOU
       (?\u2C88 ?\u2C89) ;; COPTIC LETTER EIE
       (?\u2C86 ?\u2C87) ;; COPTIC LETTER DALDA
       (?\u2C84 ?\u2C85) ;; COPTIC LETTER GAMMA
       (?\u2C82 ?\u2C83) ;; COPTIC LETTER VIDA
       (?\u2C80 ?\u2C81) ;; COPTIC LETTER ALFA
       (?\u2C7F ?\u0240) ;; LATIN LETTER Z WITH SWASH TAIL
       (?\u2C7E ?\u023F) ;; LATIN LETTER S WITH SWASH TAIL
       (?\u2C75 ?\u2C76) ;; LATIN LETTER HALF H
       (?\u2C72 ?\u2C73) ;; LATIN LETTER W WITH HOOK
       (?\u2C70 ?\u0252) ;; LATIN LETTER TURNED ALPHA
       (?\u2C6F ?\u0250) ;; LATIN LETTER TURNED A
       (?\u2C6E ?\u0271) ;; LATIN LETTER M WITH HOOK
       (?\u2C6D ?\u0251) ;; LATIN LETTER ALPHA
       (?\u2C6B ?\u2C6C) ;; LATIN LETTER Z WITH DESCENDER
       (?\u2C69 ?\u2C6A) ;; LATIN LETTER K WITH DESCENDER
       (?\u2C67 ?\u2C68) ;; LATIN LETTER H WITH DESCENDER
       (?\u023E ?\u2C66) ;; LATIN LETTER T WITH DIAGONAL STROKE
       (?\u023A ?\u2C65) ;; LATIN LETTER A WITH STROKE
       (?\u2C64 ?\u027D) ;; LATIN LETTER R WITH TAIL
       (?\u2C63 ?\u1D7D) ;; LATIN LETTER P WITH STROKE
       (?\u2C62 ?\u026B) ;; LATIN LETTER L WITH MIDDLE TILDE
       (?\u2C60 ?\u2C61) ;; LATIN LETTER L WITH DOUBLE BAR
       (?\u2C2F ?\u2C5F) ;; GLAGOLITIC LETTER CAUDATE CHRIVI
       (?\u2C2E ?\u2C5E) ;; GLAGOLITIC LETTER LATINATE MYSLITE
       (?\u2C2D ?\u2C5D) ;; GLAGOLITIC LETTER TROKUTASTI A
       (?\u2C2C ?\u2C5C) ;; GLAGOLITIC LETTER SHTAPIC
       (?\u2C2B ?\u2C5B) ;; GLAGOLITIC LETTER IZHITSA
       (?\u2C2A ?\u2C5A) ;; GLAGOLITIC LETTER FITA
       (?\u2C29 ?\u2C59) ;; GLAGOLITIC LETTER IOTATED BIG YUS
       (?\u2C28 ?\u2C58) ;; GLAGOLITIC LETTER BIG YUS
       (?\u2C27 ?\u2C57) ;; GLAGOLITIC LETTER IOTATED SMALL YUS
       (?\u2C26 ?\u2C56) ;; GLAGOLITIC LETTER YO
       (?\u2C25 ?\u2C55) ;; GLAGOLITIC LETTER SMALL YUS WITH TAIL
       (?\u2C24 ?\u2C54) ;; GLAGOLITIC LETTER SMALL YUS
       (?\u2C23 ?\u2C53) ;; GLAGOLITIC LETTER YU
       (?\u2C22 ?\u2C52) ;; GLAGOLITIC LETTER SPIDERY HA
       (?\u2C21 ?\u2C51) ;; GLAGOLITIC LETTER YATI
       (?\u2C20 ?\u2C50) ;; GLAGOLITIC LETTER YERI
       (?\u2C1F ?\u2C4F) ;; GLAGOLITIC LETTER YERU
       (?\u2C1E ?\u2C4E) ;; GLAGOLITIC LETTER SHA
       (?\u2C1D ?\u2C4D) ;; GLAGOLITIC LETTER CHRIVI
       (?\u2C1C ?\u2C4C) ;; GLAGOLITIC LETTER TSI
       (?\u2C1B ?\u2C4B) ;; GLAGOLITIC LETTER SHTA
       (?\u2C1A ?\u2C4A) ;; GLAGOLITIC LETTER PE
       (?\u2C19 ?\u2C49) ;; GLAGOLITIC LETTER OTU
       (?\u2C18 ?\u2C48) ;; GLAGOLITIC LETTER HERU
       (?\u2C17 ?\u2C47) ;; GLAGOLITIC LETTER FRITU
       (?\u2C16 ?\u2C46) ;; GLAGOLITIC LETTER UKU
       (?\u2C15 ?\u2C45) ;; GLAGOLITIC LETTER TVRIDO
       (?\u2C14 ?\u2C44) ;; GLAGOLITIC LETTER SLOVO
       (?\u2C13 ?\u2C43) ;; GLAGOLITIC LETTER RITSI
       (?\u2C12 ?\u2C42) ;; GLAGOLITIC LETTER POKOJI
       (?\u2C11 ?\u2C41) ;; GLAGOLITIC LETTER ONU
       (?\u2C10 ?\u2C40) ;; GLAGOLITIC LETTER NASHI
       (?\u2C0F ?\u2C3F) ;; GLAGOLITIC LETTER MYSLITE
       (?\u2C0E ?\u2C3E) ;; GLAGOLITIC LETTER LJUDIJE
       (?\u2C0D ?\u2C3D) ;; GLAGOLITIC LETTER KAKO
       (?\u2C0C ?\u2C3C) ;; GLAGOLITIC LETTER DJERVI
       (?\u2C0B ?\u2C3B) ;; GLAGOLITIC LETTER I
       (?\u2C0A ?\u2C3A) ;; GLAGOLITIC LETTER INITIAL IZHE
       (?\u2C09 ?\u2C39) ;; GLAGOLITIC LETTER IZHE
       (?\u2C08 ?\u2C38) ;; GLAGOLITIC LETTER ZEMLJA
       (?\u2C07 ?\u2C37) ;; GLAGOLITIC LETTER DZELO
       (?\u2C06 ?\u2C36) ;; GLAGOLITIC LETTER ZHIVETE
       (?\u2C05 ?\u2C35) ;; GLAGOLITIC LETTER YESTU
       (?\u2C04 ?\u2C34) ;; GLAGOLITIC LETTER DOBRO
       (?\u2C03 ?\u2C33) ;; GLAGOLITIC LETTER GLAGOLI
       (?\u2C02 ?\u2C32) ;; GLAGOLITIC LETTER VEDE
       (?\u2C01 ?\u2C31) ;; GLAGOLITIC LETTER BUKY
       (?\u2C00 ?\u2C30) ;; GLAGOLITIC LETTER AZU
       (?\u2183 ?\u2184) ;; ROMAN NUMERAL REVERSED ONE HUNDRED, LATIN SMALL LETTER REVERSED C
       (?\u2132 ?\u214E) ;; TURNED CAPITAL F, TURNED SMALL F
       (?\u212B ?\u00E5) ;; ANGSTROM SIGN, LATIN SMALL LETTER A WITH RING ABOVE
       (?\u212A ?\u006B) ;; KELVIN SIGN, LATIN SMALL LETTER K
       (?\u2126 ?\u03C9) ;; OHM SIGN, GREEK SMALL LETTER OMEGA
       (?\u1FFB ?\u1F7D) ;; GREEK LETTER OMEGA WITH OXIA
       (?\u1FFA ?\u1F7C) ;; GREEK LETTER OMEGA WITH VARIA
       (?\u1FF9 ?\u1F79) ;; GREEK LETTER OMICRON WITH OXIA
       (?\u1FF8 ?\u1F78) ;; GREEK LETTER OMICRON WITH VARIA
       (?\u1FEC ?\u1FE5) ;; GREEK LETTER RHO WITH DASIA
       (?\u1FEB ?\u1F7B) ;; GREEK LETTER UPSILON WITH OXIA
       (?\u1FEA ?\u1F7A) ;; GREEK LETTER UPSILON WITH VARIA
       (?\u1FE9 ?\u1FE1) ;; GREEK LETTER UPSILON WITH MACRON
       (?\u1FE8 ?\u1FE0) ;; GREEK LETTER UPSILON WITH VRACHY
       (?\u1FEC ?\u1FE5) ;; GREEK LETTER RHO WITH DASIA
       (?\u1FE9 ?\u1FE1) ;; GREEK LETTER UPSILON WITH MACRON
       (?\u1FE8 ?\u1FE0) ;; GREEK LETTER UPSILON WITH VRACHY
       (?\u1FDB ?\u1F77) ;; GREEK LETTER IOTA WITH OXIA
       (?\u1FDA ?\u1F76) ;; GREEK LETTER IOTA WITH VARIA
       (?\u1FD9 ?\u1FD1) ;; GREEK LETTER IOTA WITH MACRON
       (?\u1FD8 ?\u1FD0) ;; GREEK LETTER IOTA WITH VRACHY
       (?\u1FD9 ?\u1FD1) ;; GREEK LETTER IOTA WITH MACRON
       (?\u1FD8 ?\u1FD0) ;; GREEK LETTER IOTA WITH VRACHY
       (?\u1FCB ?\u1F75) ;; GREEK LETTER ETA WITH OXIA
       (?\u1FCA ?\u1F74) ;; GREEK LETTER ETA WITH VARIA
       (?\u1FC9 ?\u1F73) ;; GREEK LETTER EPSILON WITH OXIA
       (?\u1FC8 ?\u1F72) ;; GREEK LETTER EPSILON WITH VARIA
       (?\u0399 ?\u1FBE) ;; GREEK CAPITAL LETTER IOTA, GREEK PROSGEGRAMMENI
       (?\u1FBB ?\u1F71) ;; GREEK LETTER ALPHA WITH OXIA
       (?\u1FBA ?\u1F70) ;; GREEK LETTER ALPHA WITH VARIA
       (?\u1FB9 ?\u1FB1) ;; GREEK LETTER ALPHA WITH MACRON
       (?\u1FB8 ?\u1FB0) ;; GREEK LETTER ALPHA WITH VRACHY
       (?\u1FB9 ?\u1FB1) ;; GREEK LETTER ALPHA WITH MACRON
       (?\u1FB8 ?\u1FB0) ;; GREEK LETTER ALPHA WITH VRACHY
       (?\u1FFB ?\u1F7D) ;; GREEK LETTER OMEGA WITH OXIA
       (?\u1FFA ?\u1F7C) ;; GREEK LETTER OMEGA WITH VARIA
       (?\u1FEB ?\u1F7B) ;; GREEK LETTER UPSILON WITH OXIA
       (?\u1FEA ?\u1F7A) ;; GREEK LETTER UPSILON WITH VARIA
       (?\u1FF9 ?\u1F79) ;; GREEK LETTER OMICRON WITH OXIA
       (?\u1FF8 ?\u1F78) ;; GREEK LETTER OMICRON WITH VARIA
       (?\u1FDB ?\u1F77) ;; GREEK LETTER IOTA WITH OXIA
       (?\u1FDA ?\u1F76) ;; GREEK LETTER IOTA WITH VARIA
       (?\u1FCB ?\u1F75) ;; GREEK LETTER ETA WITH OXIA
       (?\u1FCA ?\u1F74) ;; GREEK LETTER ETA WITH VARIA
       (?\u1FC9 ?\u1F73) ;; GREEK LETTER EPSILON WITH OXIA
       (?\u1FC8 ?\u1F72) ;; GREEK LETTER EPSILON WITH VARIA
       (?\u1FBB ?\u1F71) ;; GREEK LETTER ALPHA WITH OXIA
       (?\u1FBA ?\u1F70) ;; GREEK LETTER ALPHA WITH VARIA
       (?\u1F6F ?\u1F67) ;; GREEK LETTER OMEGA WITH DASIA AND PERISPOMENI
       (?\u1F6E ?\u1F66) ;; GREEK LETTER OMEGA WITH PSILI AND PERISPOMENI
       (?\u1F6D ?\u1F65) ;; GREEK LETTER OMEGA WITH DASIA AND OXIA
       (?\u1F6C ?\u1F64) ;; GREEK LETTER OMEGA WITH PSILI AND OXIA
       (?\u1F6B ?\u1F63) ;; GREEK LETTER OMEGA WITH DASIA AND VARIA
       (?\u1F6A ?\u1F62) ;; GREEK LETTER OMEGA WITH PSILI AND VARIA
       (?\u1F69 ?\u1F61) ;; GREEK LETTER OMEGA WITH DASIA
       (?\u1F68 ?\u1F60) ;; GREEK LETTER OMEGA WITH PSILI
       (?\u1F6F ?\u1F67) ;; GREEK LETTER OMEGA WITH DASIA AND PERISPOMENI
       (?\u1F6E ?\u1F66) ;; GREEK LETTER OMEGA WITH PSILI AND PERISPOMENI
       (?\u1F6D ?\u1F65) ;; GREEK LETTER OMEGA WITH DASIA AND OXIA
       (?\u1F6C ?\u1F64) ;; GREEK LETTER OMEGA WITH PSILI AND OXIA
       (?\u1F6B ?\u1F63) ;; GREEK LETTER OMEGA WITH DASIA AND VARIA
       (?\u1F6A ?\u1F62) ;; GREEK LETTER OMEGA WITH PSILI AND VARIA
       (?\u1F69 ?\u1F61) ;; GREEK LETTER OMEGA WITH DASIA
       (?\u1F68 ?\u1F60) ;; GREEK LETTER OMEGA WITH PSILI
       (?\u1F5F ?\u1F57) ;; GREEK LETTER UPSILON WITH DASIA AND PERISPOMENI
       (?\u1F5D ?\u1F55) ;; GREEK LETTER UPSILON WITH DASIA AND OXIA
       (?\u1F5B ?\u1F53) ;; GREEK LETTER UPSILON WITH DASIA AND VARIA
       (?\u1F59 ?\u1F51) ;; GREEK LETTER UPSILON WITH DASIA
       (?\u1F5F ?\u1F57) ;; GREEK LETTER UPSILON WITH DASIA AND PERISPOMENI
       (?\u1F5D ?\u1F55) ;; GREEK LETTER UPSILON WITH DASIA AND OXIA
       (?\u1F5B ?\u1F53) ;; GREEK LETTER UPSILON WITH DASIA AND VARIA
       (?\u1F59 ?\u1F51) ;; GREEK LETTER UPSILON WITH DASIA
       (?\u1F4D ?\u1F45) ;; GREEK LETTER OMICRON WITH DASIA AND OXIA
       (?\u1F4C ?\u1F44) ;; GREEK LETTER OMICRON WITH PSILI AND OXIA
       (?\u1F4B ?\u1F43) ;; GREEK LETTER OMICRON WITH DASIA AND VARIA
       (?\u1F4A ?\u1F42) ;; GREEK LETTER OMICRON WITH PSILI AND VARIA
       (?\u1F49 ?\u1F41) ;; GREEK LETTER OMICRON WITH DASIA
       (?\u1F48 ?\u1F40) ;; GREEK LETTER OMICRON WITH PSILI
       (?\u1F4D ?\u1F45) ;; GREEK LETTER OMICRON WITH DASIA AND OXIA
       (?\u1F4C ?\u1F44) ;; GREEK LETTER OMICRON WITH PSILI AND OXIA
       (?\u1F4B ?\u1F43) ;; GREEK LETTER OMICRON WITH DASIA AND VARIA
       (?\u1F4A ?\u1F42) ;; GREEK LETTER OMICRON WITH PSILI AND VARIA
       (?\u1F49 ?\u1F41) ;; GREEK LETTER OMICRON WITH DASIA
       (?\u1F48 ?\u1F40) ;; GREEK LETTER OMICRON WITH PSILI
       (?\u1F3F ?\u1F37) ;; GREEK LETTER IOTA WITH DASIA AND PERISPOMENI
       (?\u1F3E ?\u1F36) ;; GREEK LETTER IOTA WITH PSILI AND PERISPOMENI
       (?\u1F3D ?\u1F35) ;; GREEK LETTER IOTA WITH DASIA AND OXIA
       (?\u1F3C ?\u1F34) ;; GREEK LETTER IOTA WITH PSILI AND OXIA
       (?\u1F3B ?\u1F33) ;; GREEK LETTER IOTA WITH DASIA AND VARIA
       (?\u1F3A ?\u1F32) ;; GREEK LETTER IOTA WITH PSILI AND VARIA
       (?\u1F39 ?\u1F31) ;; GREEK LETTER IOTA WITH DASIA
       (?\u1F38 ?\u1F30) ;; GREEK LETTER IOTA WITH PSILI
       (?\u1F3F ?\u1F37) ;; GREEK LETTER IOTA WITH DASIA AND PERISPOMENI
       (?\u1F3E ?\u1F36) ;; GREEK LETTER IOTA WITH PSILI AND PERISPOMENI
       (?\u1F3D ?\u1F35) ;; GREEK LETTER IOTA WITH DASIA AND OXIA
       (?\u1F3C ?\u1F34) ;; GREEK LETTER IOTA WITH PSILI AND OXIA
       (?\u1F3B ?\u1F33) ;; GREEK LETTER IOTA WITH DASIA AND VARIA
       (?\u1F3A ?\u1F32) ;; GREEK LETTER IOTA WITH PSILI AND VARIA
       (?\u1F39 ?\u1F31) ;; GREEK LETTER IOTA WITH DASIA
       (?\u1F38 ?\u1F30) ;; GREEK LETTER IOTA WITH PSILI
       (?\u1F2F ?\u1F27) ;; GREEK LETTER ETA WITH DASIA AND PERISPOMENI
       (?\u1F2E ?\u1F26) ;; GREEK LETTER ETA WITH PSILI AND PERISPOMENI
       (?\u1F2D ?\u1F25) ;; GREEK LETTER ETA WITH DASIA AND OXIA
       (?\u1F2C ?\u1F24) ;; GREEK LETTER ETA WITH PSILI AND OXIA
       (?\u1F2B ?\u1F23) ;; GREEK LETTER ETA WITH DASIA AND VARIA
       (?\u1F2A ?\u1F22) ;; GREEK LETTER ETA WITH PSILI AND VARIA
       (?\u1F29 ?\u1F21) ;; GREEK LETTER ETA WITH DASIA
       (?\u1F28 ?\u1F20) ;; GREEK LETTER ETA WITH PSILI
       (?\u1F2F ?\u1F27) ;; GREEK LETTER ETA WITH DASIA AND PERISPOMENI
       (?\u1F2E ?\u1F26) ;; GREEK LETTER ETA WITH PSILI AND PERISPOMENI
       (?\u1F2D ?\u1F25) ;; GREEK LETTER ETA WITH DASIA AND OXIA
       (?\u1F2C ?\u1F24) ;; GREEK LETTER ETA WITH PSILI AND OXIA
       (?\u1F2B ?\u1F23) ;; GREEK LETTER ETA WITH DASIA AND VARIA
       (?\u1F2A ?\u1F22) ;; GREEK LETTER ETA WITH PSILI AND VARIA
       (?\u1F29 ?\u1F21) ;; GREEK LETTER ETA WITH DASIA
       (?\u1F28 ?\u1F20) ;; GREEK LETTER ETA WITH PSILI
       (?\u1F1D ?\u1F15) ;; GREEK LETTER EPSILON WITH DASIA AND OXIA
       (?\u1F1C ?\u1F14) ;; GREEK LETTER EPSILON WITH PSILI AND OXIA
       (?\u1F1B ?\u1F13) ;; GREEK LETTER EPSILON WITH DASIA AND VARIA
       (?\u1F1A ?\u1F12) ;; GREEK LETTER EPSILON WITH PSILI AND VARIA
       (?\u1F19 ?\u1F11) ;; GREEK LETTER EPSILON WITH DASIA
       (?\u1F18 ?\u1F10) ;; GREEK LETTER EPSILON WITH PSILI
       (?\u1F1D ?\u1F15) ;; GREEK LETTER EPSILON WITH DASIA AND OXIA
       (?\u1F1C ?\u1F14) ;; GREEK LETTER EPSILON WITH PSILI AND OXIA
       (?\u1F1B ?\u1F13) ;; GREEK LETTER EPSILON WITH DASIA AND VARIA
       (?\u1F1A ?\u1F12) ;; GREEK LETTER EPSILON WITH PSILI AND VARIA
       (?\u1F19 ?\u1F11) ;; GREEK LETTER EPSILON WITH DASIA
       (?\u1F18 ?\u1F10) ;; GREEK LETTER EPSILON WITH PSILI
       (?\u1F0F ?\u1F07) ;; GREEK LETTER ALPHA WITH DASIA AND PERISPOMENI
       (?\u1F0E ?\u1F06) ;; GREEK LETTER ALPHA WITH PSILI AND PERISPOMENI
       (?\u1F0D ?\u1F05) ;; GREEK LETTER ALPHA WITH DASIA AND OXIA
       (?\u1F0C ?\u1F04) ;; GREEK LETTER ALPHA WITH PSILI AND OXIA
       (?\u1F0B ?\u1F03) ;; GREEK LETTER ALPHA WITH DASIA AND VARIA
       (?\u1F0A ?\u1F02) ;; GREEK LETTER ALPHA WITH PSILI AND VARIA
       (?\u1F09 ?\u1F01) ;; GREEK LETTER ALPHA WITH DASIA
       (?\u1F08 ?\u1F00) ;; GREEK LETTER ALPHA WITH PSILI
       (?\u1F0F ?\u1F07) ;; GREEK LETTER ALPHA WITH DASIA AND PERISPOMENI
       (?\u1F0E ?\u1F06) ;; GREEK LETTER ALPHA WITH PSILI AND PERISPOMENI
       (?\u1F0D ?\u1F05) ;; GREEK LETTER ALPHA WITH DASIA AND OXIA
       (?\u1F0C ?\u1F04) ;; GREEK LETTER ALPHA WITH PSILI AND OXIA
       (?\u1F0B ?\u1F03) ;; GREEK LETTER ALPHA WITH DASIA AND VARIA
       (?\u1F0A ?\u1F02) ;; GREEK LETTER ALPHA WITH PSILI AND VARIA
       (?\u1F09 ?\u1F01) ;; GREEK LETTER ALPHA WITH DASIA
       (?\u1F08 ?\u1F00) ;; GREEK LETTER ALPHA WITH PSILI
       (?\u1EFE ?\u1EFF) ;; LATIN LETTER Y WITH LOOP
       (?\u1EFC ?\u1EFD) ;; LATIN LETTER MIDDLE-WELSH V
       (?\u1EFA ?\u1EFB) ;; LATIN LETTER MIDDLE-WELSH LL
       (?\u1EF8 ?\u1EF9) ;; LATIN LETTER Y WITH TILDE
       (?\u1EF6 ?\u1EF7) ;; LATIN LETTER Y WITH HOOK ABOVE
       (?\u1EF4 ?\u1EF5) ;; LATIN LETTER Y WITH DOT BELOW
       (?\u1EF2 ?\u1EF3) ;; LATIN LETTER Y WITH GRAVE
       (?\u1EF0 ?\u1EF1) ;; LATIN LETTER U WITH HORN AND DOT BELOW
       (?\u1EEE ?\u1EEF) ;; LATIN LETTER U WITH HORN AND TILDE
       (?\u1EEC ?\u1EED) ;; LATIN LETTER U WITH HORN AND HOOK ABOVE
       (?\u1EEA ?\u1EEB) ;; LATIN LETTER U WITH HORN AND GRAVE
       (?\u1EE8 ?\u1EE9) ;; LATIN LETTER U WITH HORN AND ACUTE
       (?\u1EE6 ?\u1EE7) ;; LATIN LETTER U WITH HOOK ABOVE
       (?\u1EE4 ?\u1EE5) ;; LATIN LETTER U WITH DOT BELOW
       (?\u1EE2 ?\u1EE3) ;; LATIN LETTER O WITH HORN AND DOT BELOW
       (?\u1EE0 ?\u1EE1) ;; LATIN LETTER O WITH HORN AND TILDE
       (?\u1EDE ?\u1EDF) ;; LATIN LETTER O WITH HORN AND HOOK ABOVE
       (?\u1EDC ?\u1EDD) ;; LATIN LETTER O WITH HORN AND GRAVE
       (?\u1EDA ?\u1EDB) ;; LATIN LETTER O WITH HORN AND ACUTE
       (?\u1ED8 ?\u1ED9) ;; LATIN LETTER O WITH CIRCUMFLEX AND DOT BELOW
       (?\u1ED6 ?\u1ED7) ;; LATIN LETTER O WITH CIRCUMFLEX AND TILDE
       (?\u1ED4 ?\u1ED5) ;; LATIN LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
       (?\u1ED2 ?\u1ED3) ;; LATIN LETTER O WITH CIRCUMFLEX AND GRAVE
       (?\u1ED0 ?\u1ED1) ;; LATIN LETTER O WITH CIRCUMFLEX AND ACUTE
       (?\u1ECE ?\u1ECF) ;; LATIN LETTER O WITH HOOK ABOVE
       (?\u1ECC ?\u1ECD) ;; LATIN LETTER O WITH DOT BELOW
       (?\u1ECA ?\u1ECB) ;; LATIN LETTER I WITH DOT BELOW
       (?\u1EC8 ?\u1EC9) ;; LATIN LETTER I WITH HOOK ABOVE
       (?\u1EC6 ?\u1EC7) ;; LATIN LETTER E WITH CIRCUMFLEX AND DOT BELOW
       (?\u1EC4 ?\u1EC5) ;; LATIN LETTER E WITH CIRCUMFLEX AND TILDE
       (?\u1EC2 ?\u1EC3) ;; LATIN LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
       (?\u1EC0 ?\u1EC1) ;; LATIN LETTER E WITH CIRCUMFLEX AND GRAVE
       (?\u1EBE ?\u1EBF) ;; LATIN LETTER E WITH CIRCUMFLEX AND ACUTE
       (?\u1EBC ?\u1EBD) ;; LATIN LETTER E WITH TILDE
       (?\u1EBA ?\u1EBB) ;; LATIN LETTER E WITH HOOK ABOVE
       (?\u1EB8 ?\u1EB9) ;; LATIN LETTER E WITH DOT BELOW
       (?\u1EB6 ?\u1EB7) ;; LATIN LETTER A WITH BREVE AND DOT BELOW
       (?\u1EB4 ?\u1EB5) ;; LATIN LETTER A WITH BREVE AND TILDE
       (?\u1EB2 ?\u1EB3) ;; LATIN LETTER A WITH BREVE AND HOOK ABOVE
       (?\u1EB0 ?\u1EB1) ;; LATIN LETTER A WITH BREVE AND GRAVE
       (?\u1EAE ?\u1EAF) ;; LATIN LETTER A WITH BREVE AND ACUTE
       (?\u1EAC ?\u1EAD) ;; LATIN LETTER A WITH CIRCUMFLEX AND DOT BELOW
       (?\u1EAA ?\u1EAB) ;; LATIN LETTER A WITH CIRCUMFLEX AND TILDE
       (?\u1EA8 ?\u1EA9) ;; LATIN LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
       (?\u1EA6 ?\u1EA7) ;; LATIN LETTER A WITH CIRCUMFLEX AND GRAVE
       (?\u1EA4 ?\u1EA5) ;; LATIN LETTER A WITH CIRCUMFLEX AND ACUTE
       (?\u1EA2 ?\u1EA3) ;; LATIN LETTER A WITH HOOK ABOVE
       (?\u1EA0 ?\u1EA1) ;; LATIN LETTER A WITH DOT BELOW
       (?\u1E9E ?\u00DF) ;; LATIN LETTER SHARP S
       (?\u1E60 ?\u1E9B) ;; LATIN CAPITAL LETTER S WITH DOT ABOVE, LATIN SMALL LETTER LONG S WITH DOT ABOVE
       (?\u1E94 ?\u1E95) ;; LATIN LETTER Z WITH LINE BELOW
       (?\u1E92 ?\u1E93) ;; LATIN LETTER Z WITH DOT BELOW
       (?\u1E90 ?\u1E91) ;; LATIN LETTER Z WITH CIRCUMFLEX
       (?\u1E8E ?\u1E8F) ;; LATIN LETTER Y WITH DOT ABOVE
       (?\u1E8C ?\u1E8D) ;; LATIN LETTER X WITH DIAERESIS
       (?\u1E8A ?\u1E8B) ;; LATIN LETTER X WITH DOT ABOVE
       (?\u1E88 ?\u1E89) ;; LATIN LETTER W WITH DOT BELOW
       (?\u1E86 ?\u1E87) ;; LATIN LETTER W WITH DOT ABOVE
       (?\u1E84 ?\u1E85) ;; LATIN LETTER W WITH DIAERESIS
       (?\u1E82 ?\u1E83) ;; LATIN LETTER W WITH ACUTE
       (?\u1E80 ?\u1E81) ;; LATIN LETTER W WITH GRAVE
       (?\u1E7E ?\u1E7F) ;; LATIN LETTER V WITH DOT BELOW
       (?\u1E7C ?\u1E7D) ;; LATIN LETTER V WITH TILDE
       (?\u1E7A ?\u1E7B) ;; LATIN LETTER U WITH MACRON AND DIAERESIS
       (?\u1E78 ?\u1E79) ;; LATIN LETTER U WITH TILDE AND ACUTE
       (?\u1E76 ?\u1E77) ;; LATIN LETTER U WITH CIRCUMFLEX BELOW
       (?\u1E74 ?\u1E75) ;; LATIN LETTER U WITH TILDE BELOW
       (?\u1E72 ?\u1E73) ;; LATIN LETTER U WITH DIAERESIS BELOW
       (?\u1E70 ?\u1E71) ;; LATIN LETTER T WITH CIRCUMFLEX BELOW
       (?\u1E6E ?\u1E6F) ;; LATIN LETTER T WITH LINE BELOW
       (?\u1E6C ?\u1E6D) ;; LATIN LETTER T WITH DOT BELOW
       (?\u1E6A ?\u1E6B) ;; LATIN LETTER T WITH DOT ABOVE
       (?\u1E68 ?\u1E69) ;; LATIN LETTER S WITH DOT BELOW AND DOT ABOVE
       (?\u1E66 ?\u1E67) ;; LATIN LETTER S WITH CARON AND DOT ABOVE
       (?\u1E64 ?\u1E65) ;; LATIN LETTER S WITH ACUTE AND DOT ABOVE
       (?\u1E62 ?\u1E63) ;; LATIN LETTER S WITH DOT BELOW
       (?\u1E60 ?\u1E61) ;; LATIN LETTER S WITH DOT ABOVE
       (?\u1E5E ?\u1E5F) ;; LATIN LETTER R WITH LINE BELOW
       (?\u1E5C ?\u1E5D) ;; LATIN LETTER R WITH DOT BELOW AND MACRON
       (?\u1E5A ?\u1E5B) ;; LATIN LETTER R WITH DOT BELOW
       (?\u1E58 ?\u1E59) ;; LATIN LETTER R WITH DOT ABOVE
       (?\u1E56 ?\u1E57) ;; LATIN LETTER P WITH DOT ABOVE
       (?\u1E54 ?\u1E55) ;; LATIN LETTER P WITH ACUTE
       (?\u1E52 ?\u1E53) ;; LATIN LETTER O WITH MACRON AND ACUTE
       (?\u1E50 ?\u1E51) ;; LATIN LETTER O WITH MACRON AND GRAVE
       (?\u1E4E ?\u1E4F) ;; LATIN LETTER O WITH TILDE AND DIAERESIS
       (?\u1E4C ?\u1E4D) ;; LATIN LETTER O WITH TILDE AND ACUTE
       (?\u1E4A ?\u1E4B) ;; LATIN LETTER N WITH CIRCUMFLEX BELOW
       (?\u1E48 ?\u1E49) ;; LATIN LETTER N WITH LINE BELOW
       (?\u1E46 ?\u1E47) ;; LATIN LETTER N WITH DOT BELOW
       (?\u1E44 ?\u1E45) ;; LATIN LETTER N WITH DOT ABOVE
       (?\u1E42 ?\u1E43) ;; LATIN LETTER M WITH DOT BELOW
       (?\u1E40 ?\u1E41) ;; LATIN LETTER M WITH DOT ABOVE
       (?\u1E3E ?\u1E3F) ;; LATIN LETTER M WITH ACUTE
       (?\u1E3C ?\u1E3D) ;; LATIN LETTER L WITH CIRCUMFLEX BELOW
       (?\u1E3A ?\u1E3B) ;; LATIN LETTER L WITH LINE BELOW
       (?\u1E38 ?\u1E39) ;; LATIN LETTER L WITH DOT BELOW AND MACRON
       (?\u1E36 ?\u1E37) ;; LATIN LETTER L WITH DOT BELOW
       (?\u1E34 ?\u1E35) ;; LATIN LETTER K WITH LINE BELOW
       (?\u1E32 ?\u1E33) ;; LATIN LETTER K WITH DOT BELOW
       (?\u1E30 ?\u1E31) ;; LATIN LETTER K WITH ACUTE
       (?\u1E2E ?\u1E2F) ;; LATIN LETTER I WITH DIAERESIS AND ACUTE
       (?\u1E2C ?\u1E2D) ;; LATIN LETTER I WITH TILDE BELOW
       (?\u1E2A ?\u1E2B) ;; LATIN LETTER H WITH BREVE BELOW
       (?\u1E28 ?\u1E29) ;; LATIN LETTER H WITH CEDILLA
       (?\u1E26 ?\u1E27) ;; LATIN LETTER H WITH DIAERESIS
       (?\u1E24 ?\u1E25) ;; LATIN LETTER H WITH DOT BELOW
       (?\u1E22 ?\u1E23) ;; LATIN LETTER H WITH DOT ABOVE
       (?\u1E20 ?\u1E21) ;; LATIN LETTER G WITH MACRON
       (?\u1E1E ?\u1E1F) ;; LATIN LETTER F WITH DOT ABOVE
       (?\u1E1C ?\u1E1D) ;; LATIN LETTER E WITH CEDILLA AND BREVE
       (?\u1E1A ?\u1E1B) ;; LATIN LETTER E WITH TILDE BELOW
       (?\u1E18 ?\u1E19) ;; LATIN LETTER E WITH CIRCUMFLEX BELOW
       (?\u1E16 ?\u1E17) ;; LATIN LETTER E WITH MACRON AND ACUTE
       (?\u1E14 ?\u1E15) ;; LATIN LETTER E WITH MACRON AND GRAVE
       (?\u1E12 ?\u1E13) ;; LATIN LETTER D WITH CIRCUMFLEX BELOW
       (?\u1E10 ?\u1E11) ;; LATIN LETTER D WITH CEDILLA
       (?\u1E0E ?\u1E0F) ;; LATIN LETTER D WITH LINE BELOW
       (?\u1E0C ?\u1E0D) ;; LATIN LETTER D WITH DOT BELOW
       (?\u1E0A ?\u1E0B) ;; LATIN LETTER D WITH DOT ABOVE
       (?\u1E08 ?\u1E09) ;; LATIN LETTER C WITH CEDILLA AND ACUTE
       (?\u1E06 ?\u1E07) ;; LATIN LETTER B WITH LINE BELOW
       (?\u1E04 ?\u1E05) ;; LATIN LETTER B WITH DOT BELOW
       (?\u1E02 ?\u1E03) ;; LATIN LETTER B WITH DOT ABOVE
       (?\u1E00 ?\u1E01) ;; LATIN LETTER A WITH RING BELOW
       (?\uA7C6 ?\u1D8E) ;; LATIN LETTER Z WITH PALATAL HOOK
       (?\u2C63 ?\u1D7D) ;; LATIN LETTER P WITH STROKE
       (?\uA77D ?\u1D79) ;; LATIN LETTER INSULAR G
       (?\u1CBF ?\u10FF) ;; GEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGN, GEORGIAN LETTER LABIAL SIGN
       (?\u1CBE ?\u10FE) ;; GEORGIAN MTAVRULI CAPITAL LETTER HARD SIGN, GEORGIAN LETTER HARD SIGN
       (?\u1CBD ?\u10FD) ;; GEORGIAN MTAVRULI CAPITAL LETTER AEN, GEORGIAN LETTER AEN
       (?\u1CBA ?\u10FA) ;; GEORGIAN MTAVRULI CAPITAL LETTER AIN, GEORGIAN LETTER AIN
       (?\u1CB9 ?\u10F9) ;; GEORGIAN MTAVRULI CAPITAL LETTER TURNED GAN, GEORGIAN LETTER TURNED GAN
       (?\u1CB8 ?\u10F8) ;; GEORGIAN MTAVRULI CAPITAL LETTER ELIFI, GEORGIAN LETTER ELIFI
       (?\u1CB7 ?\u10F7) ;; GEORGIAN MTAVRULI CAPITAL LETTER YN, GEORGIAN LETTER YN
       (?\u1CB6 ?\u10F6) ;; GEORGIAN MTAVRULI CAPITAL LETTER FI, GEORGIAN LETTER FI
       (?\u1CB5 ?\u10F5) ;; GEORGIAN MTAVRULI CAPITAL LETTER HOE, GEORGIAN LETTER HOE
       (?\u1CB4 ?\u10F4) ;; GEORGIAN MTAVRULI CAPITAL LETTER HAR, GEORGIAN LETTER HAR
       (?\u1CB3 ?\u10F3) ;; GEORGIAN MTAVRULI CAPITAL LETTER WE, GEORGIAN LETTER WE
       (?\u1CB2 ?\u10F2) ;; GEORGIAN MTAVRULI CAPITAL LETTER HIE, GEORGIAN LETTER HIE
       (?\u1CB1 ?\u10F1) ;; GEORGIAN MTAVRULI CAPITAL LETTER HE, GEORGIAN LETTER HE
       (?\u1CB0 ?\u10F0) ;; GEORGIAN MTAVRULI CAPITAL LETTER HAE, GEORGIAN LETTER HAE
       (?\u1CAF ?\u10EF) ;; GEORGIAN MTAVRULI CAPITAL LETTER JHAN, GEORGIAN LETTER JHAN
       (?\u1CAE ?\u10EE) ;; GEORGIAN MTAVRULI CAPITAL LETTER XAN, GEORGIAN LETTER XAN
       (?\u1CAD ?\u10ED) ;; GEORGIAN MTAVRULI CAPITAL LETTER CHAR, GEORGIAN LETTER CHAR
       (?\u1CAC ?\u10EC) ;; GEORGIAN MTAVRULI CAPITAL LETTER CIL, GEORGIAN LETTER CIL
       (?\u1CAB ?\u10EB) ;; GEORGIAN MTAVRULI CAPITAL LETTER JIL, GEORGIAN LETTER JIL
       (?\u1CAA ?\u10EA) ;; GEORGIAN MTAVRULI CAPITAL LETTER CAN, GEORGIAN LETTER CAN
       (?\u1CA9 ?\u10E9) ;; GEORGIAN MTAVRULI CAPITAL LETTER CHIN, GEORGIAN LETTER CHIN
       (?\u1CA8 ?\u10E8) ;; GEORGIAN MTAVRULI CAPITAL LETTER SHIN, GEORGIAN LETTER SHIN
       (?\u1CA7 ?\u10E7) ;; GEORGIAN MTAVRULI CAPITAL LETTER QAR, GEORGIAN LETTER QAR
       (?\u1CA6 ?\u10E6) ;; GEORGIAN MTAVRULI CAPITAL LETTER GHAN, GEORGIAN LETTER GHAN
       (?\u1CA5 ?\u10E5) ;; GEORGIAN MTAVRULI CAPITAL LETTER KHAR, GEORGIAN LETTER KHAR
       (?\u1CA4 ?\u10E4) ;; GEORGIAN MTAVRULI CAPITAL LETTER PHAR, GEORGIAN LETTER PHAR
       (?\u1CA3 ?\u10E3) ;; GEORGIAN MTAVRULI CAPITAL LETTER UN, GEORGIAN LETTER UN
       (?\u1CA2 ?\u10E2) ;; GEORGIAN MTAVRULI CAPITAL LETTER TAR, GEORGIAN LETTER TAR
       (?\u1CA1 ?\u10E1) ;; GEORGIAN MTAVRULI CAPITAL LETTER SAN, GEORGIAN LETTER SAN
       (?\u1CA0 ?\u10E0) ;; GEORGIAN MTAVRULI CAPITAL LETTER RAE, GEORGIAN LETTER RAE
       (?\u1C9F ?\u10DF) ;; GEORGIAN MTAVRULI CAPITAL LETTER ZHAR, GEORGIAN LETTER ZHAR
       (?\u1C9E ?\u10DE) ;; GEORGIAN MTAVRULI CAPITAL LETTER PAR, GEORGIAN LETTER PAR
       (?\u1C9D ?\u10DD) ;; GEORGIAN MTAVRULI CAPITAL LETTER ON, GEORGIAN LETTER ON
       (?\u1C9C ?\u10DC) ;; GEORGIAN MTAVRULI CAPITAL LETTER NAR, GEORGIAN LETTER NAR
       (?\u1C9B ?\u10DB) ;; GEORGIAN MTAVRULI CAPITAL LETTER MAN, GEORGIAN LETTER MAN
       (?\u1C9A ?\u10DA) ;; GEORGIAN MTAVRULI CAPITAL LETTER LAS, GEORGIAN LETTER LAS
       (?\u1C99 ?\u10D9) ;; GEORGIAN MTAVRULI CAPITAL LETTER KAN, GEORGIAN LETTER KAN
       (?\u1C98 ?\u10D8) ;; GEORGIAN MTAVRULI CAPITAL LETTER IN, GEORGIAN LETTER IN
       (?\u1C97 ?\u10D7) ;; GEORGIAN MTAVRULI CAPITAL LETTER TAN, GEORGIAN LETTER TAN
       (?\u1C96 ?\u10D6) ;; GEORGIAN MTAVRULI CAPITAL LETTER ZEN, GEORGIAN LETTER ZEN
       (?\u1C95 ?\u10D5) ;; GEORGIAN MTAVRULI CAPITAL LETTER VIN, GEORGIAN LETTER VIN
       (?\u1C94 ?\u10D4) ;; GEORGIAN MTAVRULI CAPITAL LETTER EN, GEORGIAN LETTER EN
       (?\u1C93 ?\u10D3) ;; GEORGIAN MTAVRULI CAPITAL LETTER DON, GEORGIAN LETTER DON
       (?\u1C92 ?\u10D2) ;; GEORGIAN MTAVRULI CAPITAL LETTER GAN, GEORGIAN LETTER GAN
       (?\u1C91 ?\u10D1) ;; GEORGIAN MTAVRULI CAPITAL LETTER BAN, GEORGIAN LETTER BAN
       (?\u1C90 ?\u10D0) ;; GEORGIAN MTAVRULI CAPITAL LETTER AN, GEORGIAN LETTER AN
       (?\uA64A ?\u1C88) ;; CYRILLIC CAPITAL LETTER MONOGRAPH UK, CYRILLIC SMALL LETTER UNBLENDED UK
       (?\u0462 ?\u1C87) ;; CYRILLIC CAPITAL LETTER YAT, CYRILLIC SMALL LETTER TALL YAT
       (?\u042A ?\u1C86) ;; CYRILLIC CAPITAL LETTER HARD SIGN, CYRILLIC SMALL LETTER TALL HARD SIGN
       (?\u0422 ?\u1C85) ;; CYRILLIC CAPITAL LETTER TE, CYRILLIC SMALL LETTER THREE-LEGGED TE
       (?\u0422 ?\u1C84) ;; CYRILLIC CAPITAL LETTER TE, CYRILLIC SMALL LETTER TALL TE
       (?\u0421 ?\u1C83) ;; CYRILLIC CAPITAL LETTER ES, CYRILLIC SMALL LETTER WIDE ES
       (?\u041E ?\u1C82) ;; CYRILLIC CAPITAL LETTER O, CYRILLIC SMALL LETTER NARROW O
       (?\u0414 ?\u1C81) ;; CYRILLIC CAPITAL LETTER DE, CYRILLIC SMALL LETTER LONG-LEGGED DE
       (?\u0412 ?\u1C80) ;; CYRILLIC CAPITAL LETTER VE, CYRILLIC SMALL LETTER ROUNDED VE
       (?\u13F5 ?\u13FD) ;; CHEROKEE LETTER MV, CHEROKEE SMALL LETTER MV
       (?\u13F4 ?\u13FC) ;; CHEROKEE LETTER YV, CHEROKEE SMALL LETTER YV
       (?\u13F3 ?\u13FB) ;; CHEROKEE LETTER YU, CHEROKEE SMALL LETTER YU
       (?\u13F2 ?\u13FA) ;; CHEROKEE LETTER YO, CHEROKEE SMALL LETTER YO
       (?\u13F1 ?\u13F9) ;; CHEROKEE LETTER YI, CHEROKEE SMALL LETTER YI
       (?\u13F0 ?\u13F8) ;; CHEROKEE LETTER YE, CHEROKEE SMALL LETTER YE
       (?\u1CBF ?\u10FF) ;; GEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGN, GEORGIAN LETTER LABIAL SIGN
       (?\u1CBE ?\u10FE) ;; GEORGIAN MTAVRULI CAPITAL LETTER HARD SIGN, GEORGIAN LETTER HARD SIGN
       (?\u1CBD ?\u10FD) ;; GEORGIAN MTAVRULI CAPITAL LETTER AEN, GEORGIAN LETTER AEN
       (?\u1CBA ?\u10FA) ;; GEORGIAN MTAVRULI CAPITAL LETTER AIN, GEORGIAN LETTER AIN
       (?\u1CB9 ?\u10F9) ;; GEORGIAN MTAVRULI CAPITAL LETTER TURNED GAN, GEORGIAN LETTER TURNED GAN
       (?\u1CB8 ?\u10F8) ;; GEORGIAN MTAVRULI CAPITAL LETTER ELIFI, GEORGIAN LETTER ELIFI
       (?\u1CB7 ?\u10F7) ;; GEORGIAN MTAVRULI CAPITAL LETTER YN, GEORGIAN LETTER YN
       (?\u1CB6 ?\u10F6) ;; GEORGIAN MTAVRULI CAPITAL LETTER FI, GEORGIAN LETTER FI
       (?\u1CB5 ?\u10F5) ;; GEORGIAN MTAVRULI CAPITAL LETTER HOE, GEORGIAN LETTER HOE
       (?\u1CB4 ?\u10F4) ;; GEORGIAN MTAVRULI CAPITAL LETTER HAR, GEORGIAN LETTER HAR
       (?\u1CB3 ?\u10F3) ;; GEORGIAN MTAVRULI CAPITAL LETTER WE, GEORGIAN LETTER WE
       (?\u1CB2 ?\u10F2) ;; GEORGIAN MTAVRULI CAPITAL LETTER HIE, GEORGIAN LETTER HIE
       (?\u1CB1 ?\u10F1) ;; GEORGIAN MTAVRULI CAPITAL LETTER HE, GEORGIAN LETTER HE
       (?\u1CB0 ?\u10F0) ;; GEORGIAN MTAVRULI CAPITAL LETTER HAE, GEORGIAN LETTER HAE
       (?\u1CAF ?\u10EF) ;; GEORGIAN MTAVRULI CAPITAL LETTER JHAN, GEORGIAN LETTER JHAN
       (?\u1CAE ?\u10EE) ;; GEORGIAN MTAVRULI CAPITAL LETTER XAN, GEORGIAN LETTER XAN
       (?\u1CAD ?\u10ED) ;; GEORGIAN MTAVRULI CAPITAL LETTER CHAR, GEORGIAN LETTER CHAR
       (?\u1CAC ?\u10EC) ;; GEORGIAN MTAVRULI CAPITAL LETTER CIL, GEORGIAN LETTER CIL
       (?\u1CAB ?\u10EB) ;; GEORGIAN MTAVRULI CAPITAL LETTER JIL, GEORGIAN LETTER JIL
       (?\u1CAA ?\u10EA) ;; GEORGIAN MTAVRULI CAPITAL LETTER CAN, GEORGIAN LETTER CAN
       (?\u1CA9 ?\u10E9) ;; GEORGIAN MTAVRULI CAPITAL LETTER CHIN, GEORGIAN LETTER CHIN
       (?\u1CA8 ?\u10E8) ;; GEORGIAN MTAVRULI CAPITAL LETTER SHIN, GEORGIAN LETTER SHIN
       (?\u1CA7 ?\u10E7) ;; GEORGIAN MTAVRULI CAPITAL LETTER QAR, GEORGIAN LETTER QAR
       (?\u1CA6 ?\u10E6) ;; GEORGIAN MTAVRULI CAPITAL LETTER GHAN, GEORGIAN LETTER GHAN
       (?\u1CA5 ?\u10E5) ;; GEORGIAN MTAVRULI CAPITAL LETTER KHAR, GEORGIAN LETTER KHAR
       (?\u1CA4 ?\u10E4) ;; GEORGIAN MTAVRULI CAPITAL LETTER PHAR, GEORGIAN LETTER PHAR
       (?\u1CA3 ?\u10E3) ;; GEORGIAN MTAVRULI CAPITAL LETTER UN, GEORGIAN LETTER UN
       (?\u1CA2 ?\u10E2) ;; GEORGIAN MTAVRULI CAPITAL LETTER TAR, GEORGIAN LETTER TAR
       (?\u1CA1 ?\u10E1) ;; GEORGIAN MTAVRULI CAPITAL LETTER SAN, GEORGIAN LETTER SAN
       (?\u1CA0 ?\u10E0) ;; GEORGIAN MTAVRULI CAPITAL LETTER RAE, GEORGIAN LETTER RAE
       (?\u1C9F ?\u10DF) ;; GEORGIAN MTAVRULI CAPITAL LETTER ZHAR, GEORGIAN LETTER ZHAR
       (?\u1C9E ?\u10DE) ;; GEORGIAN MTAVRULI CAPITAL LETTER PAR, GEORGIAN LETTER PAR
       (?\u1C9D ?\u10DD) ;; GEORGIAN MTAVRULI CAPITAL LETTER ON, GEORGIAN LETTER ON
       (?\u1C9C ?\u10DC) ;; GEORGIAN MTAVRULI CAPITAL LETTER NAR, GEORGIAN LETTER NAR
       (?\u1C9B ?\u10DB) ;; GEORGIAN MTAVRULI CAPITAL LETTER MAN, GEORGIAN LETTER MAN
       (?\u1C9A ?\u10DA) ;; GEORGIAN MTAVRULI CAPITAL LETTER LAS, GEORGIAN LETTER LAS
       (?\u1C99 ?\u10D9) ;; GEORGIAN MTAVRULI CAPITAL LETTER KAN, GEORGIAN LETTER KAN
       (?\u1C98 ?\u10D8) ;; GEORGIAN MTAVRULI CAPITAL LETTER IN, GEORGIAN LETTER IN
       (?\u1C97 ?\u10D7) ;; GEORGIAN MTAVRULI CAPITAL LETTER TAN, GEORGIAN LETTER TAN
       (?\u1C96 ?\u10D6) ;; GEORGIAN MTAVRULI CAPITAL LETTER ZEN, GEORGIAN LETTER ZEN
       (?\u1C95 ?\u10D5) ;; GEORGIAN MTAVRULI CAPITAL LETTER VIN, GEORGIAN LETTER VIN
       (?\u1C94 ?\u10D4) ;; GEORGIAN MTAVRULI CAPITAL LETTER EN, GEORGIAN LETTER EN
       (?\u1C93 ?\u10D3) ;; GEORGIAN MTAVRULI CAPITAL LETTER DON, GEORGIAN LETTER DON
       (?\u1C92 ?\u10D2) ;; GEORGIAN MTAVRULI CAPITAL LETTER GAN, GEORGIAN LETTER GAN
       (?\u1C91 ?\u10D1) ;; GEORGIAN MTAVRULI CAPITAL LETTER BAN, GEORGIAN LETTER BAN
       (?\u1C90 ?\u10D0) ;; GEORGIAN MTAVRULI CAPITAL LETTER AN, GEORGIAN LETTER AN
       (?\u0556 ?\u0586) ;; ARMENIAN LETTER FEH
       (?\u0555 ?\u0585) ;; ARMENIAN LETTER OH
       (?\u0554 ?\u0584) ;; ARMENIAN LETTER KEH
       (?\u0553 ?\u0583) ;; ARMENIAN LETTER PIWR
       (?\u0552 ?\u0582) ;; ARMENIAN LETTER YIWN
       (?\u0551 ?\u0581) ;; ARMENIAN LETTER CO
       (?\u0550 ?\u0580) ;; ARMENIAN LETTER REH
       (?\u054F ?\u057F) ;; ARMENIAN LETTER TIWN
       (?\u054E ?\u057E) ;; ARMENIAN LETTER VEW
       (?\u054D ?\u057D) ;; ARMENIAN LETTER SEH
       (?\u054C ?\u057C) ;; ARMENIAN LETTER RA
       (?\u054B ?\u057B) ;; ARMENIAN LETTER JHEH
       (?\u054A ?\u057A) ;; ARMENIAN LETTER PEH
       (?\u0549 ?\u0579) ;; ARMENIAN LETTER CHA
       (?\u0548 ?\u0578) ;; ARMENIAN LETTER VO
       (?\u0547 ?\u0577) ;; ARMENIAN LETTER SHA
       (?\u0546 ?\u0576) ;; ARMENIAN LETTER NOW
       (?\u0545 ?\u0575) ;; ARMENIAN LETTER YI
       (?\u0544 ?\u0574) ;; ARMENIAN LETTER MEN
       (?\u0543 ?\u0573) ;; ARMENIAN LETTER CHEH
       (?\u0542 ?\u0572) ;; ARMENIAN LETTER GHAD
       (?\u0541 ?\u0571) ;; ARMENIAN LETTER JA
       (?\u0540 ?\u0570) ;; ARMENIAN LETTER HO
       (?\u053F ?\u056F) ;; ARMENIAN LETTER KEN
       (?\u053E ?\u056E) ;; ARMENIAN LETTER CA
       (?\u053D ?\u056D) ;; ARMENIAN LETTER XEH
       (?\u053C ?\u056C) ;; ARMENIAN LETTER LIWN
       (?\u053B ?\u056B) ;; ARMENIAN LETTER INI
       (?\u053A ?\u056A) ;; ARMENIAN LETTER ZHE
       (?\u0539 ?\u0569) ;; ARMENIAN LETTER TO
       (?\u0538 ?\u0568) ;; ARMENIAN LETTER ET
       (?\u0537 ?\u0567) ;; ARMENIAN LETTER EH
       (?\u0536 ?\u0566) ;; ARMENIAN LETTER ZA
       (?\u0535 ?\u0565) ;; ARMENIAN LETTER ECH
       (?\u0534 ?\u0564) ;; ARMENIAN LETTER DA
       (?\u0533 ?\u0563) ;; ARMENIAN LETTER GIM
       (?\u0532 ?\u0562) ;; ARMENIAN LETTER BEN
       (?\u0531 ?\u0561) ;; ARMENIAN LETTER AYB
       (?\u052E ?\u052F) ;; CYRILLIC LETTER EL WITH DESCENDER
       (?\u052C ?\u052D) ;; CYRILLIC LETTER DCHE
       (?\u052A ?\u052B) ;; CYRILLIC LETTER DZZHE
       (?\u0528 ?\u0529) ;; CYRILLIC LETTER EN WITH LEFT HOOK
       (?\u0526 ?\u0527) ;; CYRILLIC LETTER SHHA WITH DESCENDER
       (?\u0524 ?\u0525) ;; CYRILLIC LETTER PE WITH DESCENDER
       (?\u0522 ?\u0523) ;; CYRILLIC LETTER EN WITH MIDDLE HOOK
       (?\u0520 ?\u0521) ;; CYRILLIC LETTER EL WITH MIDDLE HOOK
       (?\u051E ?\u051F) ;; CYRILLIC LETTER ALEUT KA
       (?\u051C ?\u051D) ;; CYRILLIC LETTER WE
       (?\u051A ?\u051B) ;; CYRILLIC LETTER QA
       (?\u0518 ?\u0519) ;; CYRILLIC LETTER YAE
       (?\u0516 ?\u0517) ;; CYRILLIC LETTER RHA
       (?\u0514 ?\u0515) ;; CYRILLIC LETTER LHA
       (?\u0512 ?\u0513) ;; CYRILLIC LETTER EL WITH HOOK
       (?\u0510 ?\u0511) ;; CYRILLIC LETTER REVERSED ZE
       (?\u050E ?\u050F) ;; CYRILLIC LETTER KOMI TJE
       (?\u050C ?\u050D) ;; CYRILLIC LETTER KOMI SJE
       (?\u050A ?\u050B) ;; CYRILLIC LETTER KOMI NJE
       (?\u0508 ?\u0509) ;; CYRILLIC LETTER KOMI LJE
       (?\u0506 ?\u0507) ;; CYRILLIC LETTER KOMI DZJE
       (?\u0504 ?\u0505) ;; CYRILLIC LETTER KOMI ZJE
       (?\u0502 ?\u0503) ;; CYRILLIC LETTER KOMI DJE
       (?\u0500 ?\u0501) ;; CYRILLIC LETTER KOMI DE
       (?\u04FE ?\u04FF) ;; CYRILLIC LETTER HA WITH STROKE
       (?\u04FC ?\u04FD) ;; CYRILLIC LETTER HA WITH HOOK
       (?\u04FA ?\u04FB) ;; CYRILLIC LETTER GHE WITH STROKE AND HOOK
       (?\u04F8 ?\u04F9) ;; CYRILLIC LETTER YERU WITH DIAERESIS
       (?\u04F6 ?\u04F7) ;; CYRILLIC LETTER GHE WITH DESCENDER
       (?\u04F4 ?\u04F5) ;; CYRILLIC LETTER CHE WITH DIAERESIS
       (?\u04F2 ?\u04F3) ;; CYRILLIC LETTER U WITH DOUBLE ACUTE
       (?\u04F0 ?\u04F1) ;; CYRILLIC LETTER U WITH DIAERESIS
       (?\u04EE ?\u04EF) ;; CYRILLIC LETTER U WITH MACRON
       (?\u04EC ?\u04ED) ;; CYRILLIC LETTER E WITH DIAERESIS
       (?\u04EA ?\u04EB) ;; CYRILLIC LETTER BARRED O WITH DIAERESIS
       (?\u04E8 ?\u04E9) ;; CYRILLIC LETTER BARRED O
       (?\u04E6 ?\u04E7) ;; CYRILLIC LETTER O WITH DIAERESIS
       (?\u04E4 ?\u04E5) ;; CYRILLIC LETTER I WITH DIAERESIS
       (?\u04E2 ?\u04E3) ;; CYRILLIC LETTER I WITH MACRON
       (?\u04E0 ?\u04E1) ;; CYRILLIC LETTER ABKHASIAN DZE
       (?\u04DE ?\u04DF) ;; CYRILLIC LETTER ZE WITH DIAERESIS
       (?\u04DC ?\u04DD) ;; CYRILLIC LETTER ZHE WITH DIAERESIS
       (?\u04DA ?\u04DB) ;; CYRILLIC LETTER SCHWA WITH DIAERESIS
       (?\u04D8 ?\u04D9) ;; CYRILLIC LETTER SCHWA
       (?\u04D6 ?\u04D7) ;; CYRILLIC LETTER IE WITH BREVE
       (?\u04D4 ?\u04D5) ;; CYRILLIC CAPITAL LIGATURE A IE, CYRILLIC SMALL LIGATURE A IE
       (?\u04D2 ?\u04D3) ;; CYRILLIC LETTER A WITH DIAERESIS
       (?\u04D0 ?\u04D1) ;; CYRILLIC LETTER A WITH BREVE
       (?\u04C0 ?\u04CF) ;; CYRILLIC LETTER PALOCHKA, CYRILLIC SMALL LETTER PALOCHKA
       (?\u04CD ?\u04CE) ;; CYRILLIC LETTER EM WITH TAIL
       (?\u04CB ?\u04CC) ;; CYRILLIC LETTER KHAKASSIAN CHE
       (?\u04C9 ?\u04CA) ;; CYRILLIC LETTER EN WITH TAIL
       (?\u04C7 ?\u04C8) ;; CYRILLIC LETTER EN WITH HOOK
       (?\u04C5 ?\u04C6) ;; CYRILLIC LETTER EL WITH TAIL
       (?\u04C3 ?\u04C4) ;; CYRILLIC LETTER KA WITH HOOK
       (?\u04C1 ?\u04C2) ;; CYRILLIC LETTER ZHE WITH BREVE
       (?\u04BE ?\u04BF) ;; CYRILLIC LETTER ABKHASIAN CHE WITH DESCENDER
       (?\u04BC ?\u04BD) ;; CYRILLIC LETTER ABKHASIAN CHE
       (?\u04BA ?\u04BB) ;; CYRILLIC LETTER SHHA
       (?\u04B8 ?\u04B9) ;; CYRILLIC LETTER CHE WITH VERTICAL STROKE
       (?\u04B6 ?\u04B7) ;; CYRILLIC LETTER CHE WITH DESCENDER
       (?\u04B4 ?\u04B5) ;; CYRILLIC CAPITAL LIGATURE TE TSE, CYRILLIC SMALL LIGATURE TE TSE
       (?\u04B2 ?\u04B3) ;; CYRILLIC LETTER HA WITH DESCENDER
       (?\u04B0 ?\u04B1) ;; CYRILLIC LETTER STRAIGHT U WITH STROKE
       (?\u04AE ?\u04AF) ;; CYRILLIC LETTER STRAIGHT U
       (?\u04AC ?\u04AD) ;; CYRILLIC LETTER TE WITH DESCENDER
       (?\u04AA ?\u04AB) ;; CYRILLIC LETTER ES WITH DESCENDER
       (?\u04A8 ?\u04A9) ;; CYRILLIC LETTER ABKHASIAN HA
       (?\u04A6 ?\u04A7) ;; CYRILLIC LETTER PE WITH MIDDLE HOOK
       (?\u04A4 ?\u04A5) ;; CYRILLIC CAPITAL LIGATURE EN GHE, CYRILLIC SMALL LIGATURE EN GHE
       (?\u04A2 ?\u04A3) ;; CYRILLIC LETTER EN WITH DESCENDER
       (?\u04A0 ?\u04A1) ;; CYRILLIC LETTER BASHKIR KA
       (?\u049E ?\u049F) ;; CYRILLIC LETTER KA WITH STROKE
       (?\u049C ?\u049D) ;; CYRILLIC LETTER KA WITH VERTICAL STROKE
       (?\u049A ?\u049B) ;; CYRILLIC LETTER KA WITH DESCENDER
       (?\u0498 ?\u0499) ;; CYRILLIC LETTER ZE WITH DESCENDER
       (?\u0496 ?\u0497) ;; CYRILLIC LETTER ZHE WITH DESCENDER
       (?\u0494 ?\u0495) ;; CYRILLIC LETTER GHE WITH MIDDLE HOOK
       (?\u0492 ?\u0493) ;; CYRILLIC LETTER GHE WITH STROKE
       (?\u0490 ?\u0491) ;; CYRILLIC LETTER GHE WITH UPTURN
       (?\u048E ?\u048F) ;; CYRILLIC LETTER ER WITH TICK
       (?\u048C ?\u048D) ;; CYRILLIC LETTER SEMISOFT SIGN
       (?\u048A ?\u048B) ;; CYRILLIC LETTER SHORT I WITH TAIL
       (?\u0480 ?\u0481) ;; CYRILLIC LETTER KOPPA
       (?\u047E ?\u047F) ;; CYRILLIC LETTER OT
       (?\u047C ?\u047D) ;; CYRILLIC LETTER OMEGA WITH TITLO
       (?\u047A ?\u047B) ;; CYRILLIC LETTER ROUND OMEGA
       (?\u0478 ?\u0479) ;; CYRILLIC LETTER UK
       (?\u0476 ?\u0477) ;; CYRILLIC LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
       (?\u0474 ?\u0475) ;; CYRILLIC LETTER IZHITSA
       (?\u0472 ?\u0473) ;; CYRILLIC LETTER FITA
       (?\u0470 ?\u0471) ;; CYRILLIC LETTER PSI
       (?\u046E ?\u046F) ;; CYRILLIC LETTER KSI
       (?\u046C ?\u046D) ;; CYRILLIC LETTER IOTIFIED BIG YUS
       (?\u046A ?\u046B) ;; CYRILLIC LETTER BIG YUS
       (?\u0468 ?\u0469) ;; CYRILLIC LETTER IOTIFIED LITTLE YUS
       (?\u0466 ?\u0467) ;; CYRILLIC LETTER LITTLE YUS
       (?\u0464 ?\u0465) ;; CYRILLIC LETTER IOTIFIED E
       (?\u0462 ?\u0463) ;; CYRILLIC LETTER YAT
       (?\u0460 ?\u0461) ;; CYRILLIC LETTER OMEGA
       (?\u040F ?\u045F) ;; CYRILLIC LETTER DZHE
       (?\u040E ?\u045E) ;; CYRILLIC LETTER SHORT U
       (?\u040D ?\u045D) ;; CYRILLIC LETTER I WITH GRAVE
       (?\u040C ?\u045C) ;; CYRILLIC LETTER KJE
       (?\u040B ?\u045B) ;; CYRILLIC LETTER TSHE
       (?\u040A ?\u045A) ;; CYRILLIC LETTER NJE
       (?\u0409 ?\u0459) ;; CYRILLIC LETTER LJE
       (?\u0408 ?\u0458) ;; CYRILLIC LETTER JE
       (?\u0407 ?\u0457) ;; CYRILLIC LETTER YI
       (?\u0406 ?\u0456) ;; CYRILLIC LETTER BYELORUSSIAN-UKRAINIAN I
       (?\u0405 ?\u0455) ;; CYRILLIC LETTER DZE
       (?\u0404 ?\u0454) ;; CYRILLIC LETTER UKRAINIAN IE
       (?\u0403 ?\u0453) ;; CYRILLIC LETTER GJE
       (?\u0402 ?\u0452) ;; CYRILLIC LETTER DJE
       (?\u0401 ?\u0451) ;; CYRILLIC LETTER IO
       (?\u0400 ?\u0450) ;; CYRILLIC LETTER IE WITH GRAVE
       (?\u042F ?\u044F) ;; CYRILLIC LETTER YA
       (?\u042E ?\u044E) ;; CYRILLIC LETTER YU
       (?\u042D ?\u044D) ;; CYRILLIC LETTER E
       (?\u042C ?\u044C) ;; CYRILLIC LETTER SOFT SIGN
       (?\u042B ?\u044B) ;; CYRILLIC LETTER YERU
       (?\u042A ?\u044A) ;; CYRILLIC LETTER HARD SIGN
       (?\u0429 ?\u0449) ;; CYRILLIC LETTER SHCHA
       (?\u0428 ?\u0448) ;; CYRILLIC LETTER SHA
       (?\u0427 ?\u0447) ;; CYRILLIC LETTER CHE
       (?\u0426 ?\u0446) ;; CYRILLIC LETTER TSE
       (?\u0425 ?\u0445) ;; CYRILLIC LETTER HA
       (?\u0424 ?\u0444) ;; CYRILLIC LETTER EF
       (?\u0423 ?\u0443) ;; CYRILLIC LETTER U
       (?\u0422 ?\u0442) ;; CYRILLIC LETTER TE
       (?\u0421 ?\u0441) ;; CYRILLIC LETTER ES
       (?\u0420 ?\u0440) ;; CYRILLIC LETTER ER
       (?\u041F ?\u043F) ;; CYRILLIC LETTER PE
       (?\u041E ?\u043E) ;; CYRILLIC LETTER O
       (?\u041D ?\u043D) ;; CYRILLIC LETTER EN
       (?\u041C ?\u043C) ;; CYRILLIC LETTER EM
       (?\u041B ?\u043B) ;; CYRILLIC LETTER EL
       (?\u041A ?\u043A) ;; CYRILLIC LETTER KA
       (?\u0419 ?\u0439) ;; CYRILLIC LETTER SHORT I
       (?\u0418 ?\u0438) ;; CYRILLIC LETTER I
       (?\u0417 ?\u0437) ;; CYRILLIC LETTER ZE
       (?\u0416 ?\u0436) ;; CYRILLIC LETTER ZHE
       (?\u0415 ?\u0435) ;; CYRILLIC LETTER IE
       (?\u0414 ?\u0434) ;; CYRILLIC LETTER DE
       (?\u0413 ?\u0433) ;; CYRILLIC LETTER GHE
       (?\u0412 ?\u0432) ;; CYRILLIC LETTER VE
       (?\u0411 ?\u0431) ;; CYRILLIC LETTER BE
       (?\u0410 ?\u0430) ;; CYRILLIC LETTER A
       (?\u03FF ?\u037D) ;; GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL, GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
       (?\u03FE ?\u037C) ;; GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL, GREEK SMALL DOTTED LUNATE SIGMA SYMBOL
       (?\u03FD ?\u037B) ;; GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL, GREEK SMALL REVERSED LUNATE SIGMA SYMBOL
       (?\u03FA ?\u03FB) ;; GREEK LETTER SAN
       (?\u03F9 ?\u03F2) ;; GREEK CAPITAL LUNATE SIGMA SYMBOL, GREEK LUNATE SIGMA SYMBOL
       (?\u03F7 ?\u03F8) ;; GREEK LETTER SHO
       (?\u0395 ?\u03F5) ;; GREEK CAPITAL LETTER EPSILON, GREEK LUNATE EPSILON SYMBOL
       (?\u03F4 ?\u03B8) ;; GREEK CAPITAL THETA SYMBOL, GREEK SMALL LETTER THETA
       (?\u037F ?\u03F3) ;; GREEK CAPITAL LETTER YOT, GREEK LETTER YOT
       (?\u03F9 ?\u03F2) ;; GREEK CAPITAL LUNATE SIGMA SYMBOL, GREEK LUNATE SIGMA SYMBOL
       (?\u03A1 ?\u03F1) ;; GREEK CAPITAL LETTER RHO, GREEK RHO SYMBOL
       (?\u039A ?\u03F0) ;; GREEK CAPITAL LETTER KAPPA, GREEK KAPPA SYMBOL
       (?\u03EE ?\u03EF) ;; COPTIC LETTER DEI
       (?\u03EC ?\u03ED) ;; COPTIC LETTER SHIMA
       (?\u03EA ?\u03EB) ;; COPTIC LETTER GANGIA
       (?\u03E8 ?\u03E9) ;; COPTIC LETTER HORI
       (?\u03E6 ?\u03E7) ;; COPTIC LETTER KHEI
       (?\u03E4 ?\u03E5) ;; COPTIC LETTER FEI
       (?\u03E2 ?\u03E3) ;; COPTIC LETTER SHEI
       (?\u03E0 ?\u03E1) ;; GREEK LETTER SAMPI, GREEK SMALL LETTER SAMPI
       (?\u03DE ?\u03DF) ;; GREEK LETTER KOPPA, GREEK SMALL LETTER KOPPA
       (?\u03DC ?\u03DD) ;; GREEK LETTER DIGAMMA, GREEK SMALL LETTER DIGAMMA
       (?\u03DA ?\u03DB) ;; GREEK LETTER STIGMA, GREEK SMALL LETTER STIGMA
       (?\u03D8 ?\u03D9) ;; GREEK LETTER ARCHAIC KOPPA, GREEK SMALL LETTER ARCHAIC KOPPA
       (?\u03CF ?\u03D7) ;; GREEK CAPITAL KAI SYMBOL, GREEK KAI SYMBOL
       (?\u03A0 ?\u03D6) ;; GREEK CAPITAL LETTER PI, GREEK PI SYMBOL
       (?\u03A6 ?\u03D5) ;; GREEK CAPITAL LETTER PHI, GREEK PHI SYMBOL
       (?\u0398 ?\u03D1) ;; GREEK CAPITAL LETTER THETA, GREEK THETA SYMBOL
       (?\u0392 ?\u03D0) ;; GREEK CAPITAL LETTER BETA, GREEK BETA SYMBOL
       (?\u038F ?\u03CE) ;; GREEK LETTER OMEGA WITH TONOS
       (?\u038E ?\u03CD) ;; GREEK LETTER UPSILON WITH TONOS
       (?\u038C ?\u03CC) ;; GREEK LETTER OMICRON WITH TONOS
       (?\u03AB ?\u03CB) ;; GREEK LETTER UPSILON WITH DIALYTIKA
       (?\u03AA ?\u03CA) ;; GREEK LETTER IOTA WITH DIALYTIKA
       (?\u03A9 ?\u03C9) ;; GREEK LETTER OMEGA
       (?\u03A8 ?\u03C8) ;; GREEK LETTER PSI
       (?\u03A7 ?\u03C7) ;; GREEK LETTER CHI
       (?\u03A6 ?\u03C6) ;; GREEK LETTER PHI
       (?\u03A5 ?\u03C5) ;; GREEK LETTER UPSILON
       (?\u03A4 ?\u03C4) ;; GREEK LETTER TAU
       (?\u03A3 ?\u03C3) ;; GREEK LETTER SIGMA
       (?\u03A3 ?\u03C2) ;; GREEK CAPITAL LETTER SIGMA, GREEK SMALL LETTER FINAL SIGMA
       (?\u03A1 ?\u03C1) ;; GREEK LETTER RHO
       (?\u03A0 ?\u03C0) ;; GREEK LETTER PI
       (?\u039F ?\u03BF) ;; GREEK LETTER OMICRON
       (?\u039E ?\u03BE) ;; GREEK LETTER XI
       (?\u039D ?\u03BD) ;; GREEK LETTER NU
       (?\u039C ?\u03BC) ;; GREEK LETTER MU
       (?\u039B ?\u03BB) ;; GREEK LETTER LAMDA
       (?\u039A ?\u03BA) ;; GREEK LETTER KAPPA
       (?\u0399 ?\u03B9) ;; GREEK LETTER IOTA
       (?\u0398 ?\u03B8) ;; GREEK LETTER THETA
       (?\u0397 ?\u03B7) ;; GREEK LETTER ETA
       (?\u0396 ?\u03B6) ;; GREEK LETTER ZETA
       (?\u0395 ?\u03B5) ;; GREEK LETTER EPSILON
       (?\u0394 ?\u03B4) ;; GREEK LETTER DELTA
       (?\u0393 ?\u03B3) ;; GREEK LETTER GAMMA
       (?\u0392 ?\u03B2) ;; GREEK LETTER BETA
       (?\u0391 ?\u03B1) ;; GREEK LETTER ALPHA
       (?\u038A ?\u03AF) ;; GREEK LETTER IOTA WITH TONOS
       (?\u0389 ?\u03AE) ;; GREEK LETTER ETA WITH TONOS
       (?\u0388 ?\u03AD) ;; GREEK LETTER EPSILON WITH TONOS
       (?\u0386 ?\u03AC) ;; GREEK LETTER ALPHA WITH TONOS
       (?\u03A3 ?\u03C3) ;; GREEK LETTER SIGMA
       (?\u03FF ?\u037D) ;; GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL, GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
       (?\u03FE ?\u037C) ;; GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL, GREEK SMALL DOTTED LUNATE SIGMA SYMBOL
       (?\u03FD ?\u037B) ;; GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL, GREEK SMALL REVERSED LUNATE SIGMA SYMBOL
       (?\u0376 ?\u0377) ;; GREEK LETTER PAMPHYLIAN DIGAMMA
       (?\u0372 ?\u0373) ;; GREEK LETTER ARCHAIC SAMPI
       (?\u0370 ?\u0371) ;; GREEK LETTER HETA
       (?\uA7B0 ?\u029E) ;; LATIN LETTER TURNED K
       (?\uA7B2 ?\u029D) ;; LATIN LETTER J WITH CROSSED-TAIL
       (?\u01B7 ?\u0292) ;; LATIN LETTER EZH
       (?\u0245 ?\u028C) ;; LATIN LETTER TURNED V
       (?\u01B2 ?\u028B) ;; LATIN LETTER V WITH HOOK
       (?\u01B1 ?\u028A) ;; LATIN LETTER UPSILON
       (?\u0244 ?\u0289) ;; LATIN LETTER U BAR
       (?\u01AE ?\u0288) ;; LATIN LETTER T WITH RETROFLEX HOOK
       (?\uA7B1 ?\u0287) ;; LATIN LETTER TURNED T
       (?\u01A9 ?\u0283) ;; LATIN LETTER ESH
       (?\uA7C5 ?\u0282) ;; LATIN LETTER S WITH HOOK
       (?\u01A6 ?\u0280) ;; LATIN LETTER YR, LATIN LETTER SMALL CAPITAL R
       (?\u2C64 ?\u027D) ;; LATIN LETTER R WITH TAIL
       (?\u019F ?\u0275) ;; LATIN CAPITAL LETTER O WITH MIDDLE TILDE, LATIN SMALL LETTER BARRED O
       (?\u019D ?\u0272) ;; LATIN LETTER N WITH LEFT HOOK
       (?\u2C6E ?\u0271) ;; LATIN LETTER M WITH HOOK
       (?\u019C ?\u026F) ;; LATIN LETTER TURNED M
       (?\uA7AD ?\u026C) ;; LATIN LETTER L WITH BELT
       (?\u2C62 ?\u026B) ;; LATIN LETTER L WITH MIDDLE TILDE
       (?\uA7AE ?\u026A) ;; LATIN CAPITAL LETTER SMALL CAPITAL I, LATIN LETTER SMALL CAPITAL I
       (?\u0196 ?\u0269) ;; LATIN LETTER IOTA
       (?\u0197 ?\u0268) ;; LATIN LETTER I WITH STROKE
       (?\uA7AA ?\u0266) ;; LATIN LETTER H WITH HOOK
       (?\uA78D ?\u0265) ;; LATIN LETTER TURNED H
       (?\u0194 ?\u0263) ;; LATIN LETTER GAMMA
       (?\uA7AC ?\u0261) ;; LATIN LETTER SCRIPT G
       (?\u0193 ?\u0260) ;; LATIN LETTER G WITH HOOK
       (?\uA7AB ?\u025C) ;; LATIN LETTER REVERSED OPEN E
       (?\u0190 ?\u025B) ;; LATIN LETTER OPEN E
       (?\u018F ?\u0259) ;; LATIN LETTER SCHWA
       (?\u018A ?\u0257) ;; LATIN LETTER D WITH HOOK
       (?\u0189 ?\u0256) ;; LATIN CAPITAL LETTER AFRICAN D, LATIN SMALL LETTER D WITH TAIL
       (?\u0186 ?\u0254) ;; LATIN LETTER OPEN O
       (?\u0181 ?\u0253) ;; LATIN LETTER B WITH HOOK
       (?\u2C70 ?\u0252) ;; LATIN LETTER TURNED ALPHA
       (?\u2C6D ?\u0251) ;; LATIN LETTER ALPHA
       (?\u2C6F ?\u0250) ;; LATIN LETTER TURNED A
       (?\u024E ?\u024F) ;; LATIN LETTER Y WITH STROKE
       (?\u024C ?\u024D) ;; LATIN LETTER R WITH STROKE
       (?\u024A ?\u024B) ;; LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL, LATIN SMALL LETTER Q WITH HOOK TAIL
       (?\u0248 ?\u0249) ;; LATIN LETTER J WITH STROKE
       (?\u0246 ?\u0247) ;; LATIN LETTER E WITH STROKE
       (?\u0243 ?\u0180) ;; LATIN LETTER B WITH STROKE
       (?\u0241 ?\u0242) ;; LATIN LETTER GLOTTAL STOP
       (?\u2C7F ?\u0240) ;; LATIN LETTER Z WITH SWASH TAIL
       (?\u2C7E ?\u023F) ;; LATIN LETTER S WITH SWASH TAIL
       (?\u023D ?\u019A) ;; LATIN LETTER L WITH BAR
       (?\u023B ?\u023C) ;; LATIN LETTER C WITH STROKE
       (?\u0232 ?\u0233) ;; LATIN LETTER Y WITH MACRON
       (?\u0230 ?\u0231) ;; LATIN LETTER O WITH DOT ABOVE AND MACRON
       (?\u022E ?\u022F) ;; LATIN LETTER O WITH DOT ABOVE
       (?\u022C ?\u022D) ;; LATIN LETTER O WITH TILDE AND MACRON
       (?\u022A ?\u022B) ;; LATIN LETTER O WITH DIAERESIS AND MACRON
       (?\u0228 ?\u0229) ;; LATIN LETTER E WITH CEDILLA
       (?\u0226 ?\u0227) ;; LATIN LETTER A WITH DOT ABOVE
       (?\u0224 ?\u0225) ;; LATIN LETTER Z WITH HOOK
       (?\u0222 ?\u0223) ;; LATIN LETTER OU
       (?\u0220 ?\u019E) ;; LATIN LETTER N WITH LONG RIGHT LEG
       (?\u021E ?\u021F) ;; LATIN LETTER H WITH CARON
       (?\u021C ?\u021D) ;; LATIN LETTER YOGH
       (?\u021A ?\u021B) ;; LATIN LETTER T WITH COMMA BELOW
       (?\u0218 ?\u0219) ;; LATIN LETTER S WITH COMMA BELOW
       (?\u0216 ?\u0217) ;; LATIN LETTER U WITH INVERTED BREVE
       (?\u0214 ?\u0215) ;; LATIN LETTER U WITH DOUBLE GRAVE
       (?\u0212 ?\u0213) ;; LATIN LETTER R WITH INVERTED BREVE
       (?\u0210 ?\u0211) ;; LATIN LETTER R WITH DOUBLE GRAVE
       (?\u020E ?\u020F) ;; LATIN LETTER O WITH INVERTED BREVE
       (?\u020C ?\u020D) ;; LATIN LETTER O WITH DOUBLE GRAVE
       (?\u020A ?\u020B) ;; LATIN LETTER I WITH INVERTED BREVE
       (?\u0208 ?\u0209) ;; LATIN LETTER I WITH DOUBLE GRAVE
       (?\u0206 ?\u0207) ;; LATIN LETTER E WITH INVERTED BREVE
       (?\u0204 ?\u0205) ;; LATIN LETTER E WITH DOUBLE GRAVE
       (?\u0202 ?\u0203) ;; LATIN LETTER A WITH INVERTED BREVE
       (?\u0200 ?\u0201) ;; LATIN LETTER A WITH DOUBLE GRAVE
       (?\u01FE ?\u01FF) ;; LATIN LETTER O WITH STROKE AND ACUTE
       (?\u01FC ?\u01FD) ;; LATIN LETTER AE WITH ACUTE
       (?\u01FA ?\u01FB) ;; LATIN LETTER A WITH RING ABOVE AND ACUTE
       (?\u01F8 ?\u01F9) ;; LATIN LETTER N WITH GRAVE
       (?\u01F7 ?\u01BF) ;; LATIN CAPITAL LETTER WYNN, LATIN LETTER WYNN
       (?\u01F6 ?\u0195) ;; LATIN CAPITAL LETTER HWAIR, LATIN SMALL LETTER HV
       (?\u01F4 ?\u01F5) ;; LATIN LETTER G WITH ACUTE
       (?\u01F1 ?\u01F3) ;; LATIN LETTER DZ
       (?\u01EE ?\u01EF) ;; LATIN LETTER EZH WITH CARON
       (?\u01EC ?\u01ED) ;; LATIN LETTER O WITH OGONEK AND MACRON
       (?\u01EA ?\u01EB) ;; LATIN LETTER O WITH OGONEK
       (?\u01E8 ?\u01E9) ;; LATIN LETTER K WITH CARON
       (?\u01E6 ?\u01E7) ;; LATIN LETTER G WITH CARON
       (?\u01E4 ?\u01E5) ;; LATIN LETTER G WITH STROKE
       (?\u01E2 ?\u01E3) ;; LATIN LETTER AE WITH MACRON
       (?\u01E0 ?\u01E1) ;; LATIN LETTER A WITH DOT ABOVE AND MACRON
       (?\u01DE ?\u01DF) ;; LATIN LETTER A WITH DIAERESIS AND MACRON
       (?\u018E ?\u01DD) ;; LATIN CAPITAL LETTER REVERSED E, LATIN SMALL LETTER TURNED E
       (?\u01DB ?\u01DC) ;; LATIN LETTER U WITH DIAERESIS AND GRAVE
       (?\u01D9 ?\u01DA) ;; LATIN LETTER U WITH DIAERESIS AND CARON
       (?\u01D7 ?\u01D8) ;; LATIN LETTER U WITH DIAERESIS AND ACUTE
       (?\u01D5 ?\u01D6) ;; LATIN LETTER U WITH DIAERESIS AND MACRON
       (?\u01D3 ?\u01D4) ;; LATIN LETTER U WITH CARON
       (?\u01D1 ?\u01D2) ;; LATIN LETTER O WITH CARON
       (?\u01CF ?\u01D0) ;; LATIN LETTER I WITH CARON
       (?\u01CD ?\u01CE) ;; LATIN LETTER A WITH CARON
       (?\u01CA ?\u01CC) ;; LATIN LETTER NJ
       (?\u01C7 ?\u01C9) ;; LATIN LETTER LJ
       (?\u01C4 ?\u01C6) ;; LATIN LETTER DZ WITH CARON
       (?\u01F7 ?\u01BF) ;; LATIN CAPITAL LETTER WYNN, LATIN LETTER WYNN
       (?\u01BC ?\u01BD) ;; LATIN LETTER TONE FIVE
       (?\u01B8 ?\u01B9) ;; LATIN LETTER EZH REVERSED
       (?\u01B5 ?\u01B6) ;; LATIN LETTER Z WITH STROKE
       (?\u01B3 ?\u01B4) ;; LATIN LETTER Y WITH HOOK
       (?\u01AF ?\u01B0) ;; LATIN LETTER U WITH HORN
       (?\u01AC ?\u01AD) ;; LATIN LETTER T WITH HOOK
       (?\u01A7 ?\u01A8) ;; LATIN LETTER TONE TWO
       (?\u01A4 ?\u01A5) ;; LATIN LETTER P WITH HOOK
       (?\u01A2 ?\u01A3) ;; LATIN LETTER OI
       (?\u01A0 ?\u01A1) ;; LATIN LETTER O WITH HORN
       (?\u0220 ?\u019E) ;; LATIN LETTER N WITH LONG RIGHT LEG
       (?\u023D ?\u019A) ;; LATIN LETTER L WITH BAR
       (?\u0198 ?\u0199) ;; LATIN LETTER K WITH HOOK
       (?\u01F6 ?\u0195) ;; LATIN CAPITAL LETTER HWAIR, LATIN SMALL LETTER HV
       (?\u0191 ?\u0192) ;; LATIN LETTER F WITH HOOK
       (?\u018B ?\u018C) ;; LATIN LETTER D WITH TOPBAR
       (?\u0187 ?\u0188) ;; LATIN LETTER C WITH HOOK
       (?\u0184 ?\u0185) ;; LATIN LETTER TONE SIX
       (?\u0182 ?\u0183) ;; LATIN LETTER B WITH TOPBAR
       (?\u0243 ?\u0180) ;; LATIN LETTER B WITH STROKE
       (?\u0053 ?\u017F) ;; LATIN CAPITAL LETTER S, LATIN SMALL LETTER LONG S
       (?\u017D ?\u017E) ;; LATIN LETTER Z WITH CARON
       (?\u017B ?\u017C) ;; LATIN LETTER Z WITH DOT ABOVE
       (?\u0179 ?\u017A) ;; LATIN LETTER Z WITH ACUTE
       (?\u0178 ?\u00FF) ;; LATIN LETTER Y WITH DIAERESIS
       (?\u0176 ?\u0177) ;; LATIN LETTER Y WITH CIRCUMFLEX
       (?\u0174 ?\u0175) ;; LATIN LETTER W WITH CIRCUMFLEX
       (?\u0172 ?\u0173) ;; LATIN LETTER U WITH OGONEK
       (?\u0170 ?\u0171) ;; LATIN LETTER U WITH DOUBLE ACUTE
       (?\u016E ?\u016F) ;; LATIN LETTER U WITH RING ABOVE
       (?\u016C ?\u016D) ;; LATIN LETTER U WITH BREVE
       (?\u016A ?\u016B) ;; LATIN LETTER U WITH MACRON
       (?\u0168 ?\u0169) ;; LATIN LETTER U WITH TILDE
       (?\u0166 ?\u0167) ;; LATIN LETTER T WITH STROKE
       (?\u0164 ?\u0165) ;; LATIN LETTER T WITH CARON
       (?\u0162 ?\u0163) ;; LATIN LETTER T WITH CEDILLA
       (?\u0160 ?\u0161) ;; LATIN LETTER S WITH CARON
       (?\u015E ?\u015F) ;; LATIN LETTER S WITH CEDILLA
       (?\u015C ?\u015D) ;; LATIN LETTER S WITH CIRCUMFLEX
       (?\u015A ?\u015B) ;; LATIN LETTER S WITH ACUTE
       (?\u0158 ?\u0159) ;; LATIN LETTER R WITH CARON
       (?\u0156 ?\u0157) ;; LATIN LETTER R WITH CEDILLA
       (?\u0154 ?\u0155) ;; LATIN LETTER R WITH ACUTE
       (?\u0152 ?\u0153) ;; LATIN CAPITAL LIGATURE OE, LATIN SMALL LIGATURE OE
       (?\u0150 ?\u0151) ;; LATIN LETTER O WITH DOUBLE ACUTE
       (?\u014E ?\u014F) ;; LATIN LETTER O WITH BREVE
       (?\u014C ?\u014D) ;; LATIN LETTER O WITH MACRON
       (?\u014A ?\u014B) ;; LATIN LETTER ENG
       (?\u0147 ?\u0148) ;; LATIN LETTER N WITH CARON
       (?\u0145 ?\u0146) ;; LATIN LETTER N WITH CEDILLA
       (?\u0143 ?\u0144) ;; LATIN LETTER N WITH ACUTE
       (?\u0141 ?\u0142) ;; LATIN LETTER L WITH STROKE
       (?\u013F ?\u0140) ;; LATIN LETTER L WITH MIDDLE DOT
       (?\u013D ?\u013E) ;; LATIN LETTER L WITH CARON
       (?\u013B ?\u013C) ;; LATIN LETTER L WITH CEDILLA
       (?\u0139 ?\u013A) ;; LATIN LETTER L WITH ACUTE
       (?\u0136 ?\u0137) ;; LATIN LETTER K WITH CEDILLA
       (?\u0134 ?\u0135) ;; LATIN LETTER J WITH CIRCUMFLEX
       (?\u0132 ?\u0133) ;; LATIN CAPITAL LIGATURE IJ, LATIN SMALL LIGATURE IJ
       (?\u0049 ?\u0131) ;; LATIN CAPITAL LETTER I, LATIN SMALL LETTER DOTLESS I
       (?\u0130 ?\u0069) ;; LATIN CAPITAL LETTER I WITH DOT ABOVE, LATIN SMALL LETTER I
       (?\u012E ?\u012F) ;; LATIN LETTER I WITH OGONEK
       (?\u012C ?\u012D) ;; LATIN LETTER I WITH BREVE
       (?\u012A ?\u012B) ;; LATIN LETTER I WITH MACRON
       (?\u0128 ?\u0129) ;; LATIN LETTER I WITH TILDE
       (?\u0126 ?\u0127) ;; LATIN LETTER H WITH STROKE
       (?\u0124 ?\u0125) ;; LATIN LETTER H WITH CIRCUMFLEX
       (?\u0122 ?\u0123) ;; LATIN LETTER G WITH CEDILLA
       (?\u0120 ?\u0121) ;; LATIN LETTER G WITH DOT ABOVE
       (?\u011E ?\u011F) ;; LATIN LETTER G WITH BREVE
       (?\u011C ?\u011D) ;; LATIN LETTER G WITH CIRCUMFLEX
       (?\u011A ?\u011B) ;; LATIN LETTER E WITH CARON
       (?\u0118 ?\u0119) ;; LATIN LETTER E WITH OGONEK
       (?\u0116 ?\u0117) ;; LATIN LETTER E WITH DOT ABOVE
       (?\u0114 ?\u0115) ;; LATIN LETTER E WITH BREVE
       (?\u0112 ?\u0113) ;; LATIN LETTER E WITH MACRON
       (?\u0110 ?\u0111) ;; LATIN LETTER D WITH STROKE
       (?\u010E ?\u010F) ;; LATIN LETTER D WITH CARON
       (?\u010C ?\u010D) ;; LATIN LETTER C WITH CARON
       (?\u010A ?\u010B) ;; LATIN LETTER C WITH DOT ABOVE
       (?\u0108 ?\u0109) ;; LATIN LETTER C WITH CIRCUMFLEX
       (?\u0106 ?\u0107) ;; LATIN LETTER C WITH ACUTE
       (?\u0104 ?\u0105) ;; LATIN LETTER A WITH OGONEK
       (?\u0102 ?\u0103) ;; LATIN LETTER A WITH BREVE
       (?\u0100 ?\u0101) ;; LATIN LETTER A WITH MACRON
       (?\u0178 ?\u00FF) ;; LATIN LETTER Y WITH DIAERESIS
       (?\u00DE ?\u00FE) ;; LATIN LETTER THORN
       (?\u00DD ?\u00FD) ;; LATIN LETTER Y WITH ACUTE
       (?\u00DC ?\u00FC) ;; LATIN LETTER U WITH DIAERESIS
       (?\u00DB ?\u00FB) ;; LATIN LETTER U WITH CIRCUMFLEX
       (?\u00DA ?\u00FA) ;; LATIN LETTER U WITH ACUTE
       (?\u00D9 ?\u00F9) ;; LATIN LETTER U WITH GRAVE
       (?\u00D8 ?\u00F8) ;; LATIN LETTER O WITH STROKE
       (?\u00D6 ?\u00F6) ;; LATIN LETTER O WITH DIAERESIS
       (?\u00D5 ?\u00F5) ;; LATIN LETTER O WITH TILDE
       (?\u00D4 ?\u00F4) ;; LATIN LETTER O WITH CIRCUMFLEX
       (?\u00D3 ?\u00F3) ;; LATIN LETTER O WITH ACUTE
       (?\u00D2 ?\u00F2) ;; LATIN LETTER O WITH GRAVE
       (?\u00D1 ?\u00F1) ;; LATIN LETTER N WITH TILDE
       (?\u00D0 ?\u00F0) ;; LATIN LETTER ETH
       (?\u00CF ?\u00EF) ;; LATIN LETTER I WITH DIAERESIS
       (?\u00CE ?\u00EE) ;; LATIN LETTER I WITH CIRCUMFLEX
       (?\u00CD ?\u00ED) ;; LATIN LETTER I WITH ACUTE
       (?\u00CC ?\u00EC) ;; LATIN LETTER I WITH GRAVE
       (?\u00CB ?\u00EB) ;; LATIN LETTER E WITH DIAERESIS
       (?\u00CA ?\u00EA) ;; LATIN LETTER E WITH CIRCUMFLEX
       (?\u00C9 ?\u00E9) ;; LATIN LETTER E WITH ACUTE
       (?\u00C8 ?\u00E8) ;; LATIN LETTER E WITH GRAVE
       (?\u00C7 ?\u00E7) ;; LATIN LETTER C WITH CEDILLA
       (?\u00C6 ?\u00E6) ;; LATIN LETTER AE
       (?\u00C5 ?\u00E5) ;; LATIN LETTER A WITH RING ABOVE
       (?\u00C4 ?\u00E4) ;; LATIN LETTER A WITH DIAERESIS
       (?\u00C3 ?\u00E3) ;; LATIN LETTER A WITH TILDE
       (?\u00C2 ?\u00E2) ;; LATIN LETTER A WITH CIRCUMFLEX
       (?\u00C1 ?\u00E1) ;; LATIN LETTER A WITH ACUTE
       (?\u00C0 ?\u00E0) ;; LATIN LETTER A WITH GRAVE
       (?\u039C ?\u00B5) ;; GREEK CAPITAL LETTER MU, MICRO SIGN
       (?\u005A ?\u007A) ;; LATIN LETTER Z
       (?\u0059 ?\u0079) ;; LATIN LETTER Y
       (?\u0058 ?\u0078) ;; LATIN LETTER X
       (?\u0057 ?\u0077) ;; LATIN LETTER W
       (?\u0056 ?\u0076) ;; LATIN LETTER V
       (?\u0055 ?\u0075) ;; LATIN LETTER U
       (?\u0054 ?\u0074) ;; LATIN LETTER T
       (?\u0053 ?\u0073) ;; LATIN LETTER S
       (?\u0052 ?\u0072) ;; LATIN LETTER R
       (?\u0051 ?\u0071) ;; LATIN LETTER Q
       (?\u0050 ?\u0070) ;; LATIN LETTER P
       (?\u004F ?\u006F) ;; LATIN LETTER O
       (?\u004E ?\u006E) ;; LATIN LETTER N
       (?\u004D ?\u006D) ;; LATIN LETTER M
       (?\u004C ?\u006C) ;; LATIN LETTER L
       (?\u004B ?\u006B) ;; LATIN LETTER K
       (?\u004A ?\u006A) ;; LATIN LETTER J
       (?\u0049 ?\u0069) ;; LATIN LETTER I
       (?\u0048 ?\u0068) ;; LATIN LETTER H
       (?\u0047 ?\u0067) ;; LATIN LETTER G
       (?\u0046 ?\u0066) ;; LATIN LETTER F
       (?\u0045 ?\u0065) ;; LATIN LETTER E
       (?\u0044 ?\u0064) ;; LATIN LETTER D
       (?\u0043 ?\u0063) ;; LATIN LETTER C
       (?\u0042 ?\u0062) ;; LATIN LETTER B
       (?\u0041 ?\u0061) ;; LATIN LETTER A
       )
  with case-table = (standard-case-table)
  do
  (put-case-table-pair upper lower case-table))

(provide 'uni-case-conv)

;;; uni-case-conv.el ends here
