/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.NamingService;

import gnu.CORBA.IOR;
import gnu.CORBA.NamingService.NameTransformer;
import gnu.CORBA.OrbFunctional;
import gnu.CORBA.Unexpected;
import gnu.CORBA.Version;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming._NamingContextStub;

public class NameParser
extends NameTransformer {
    public static final String pxCORBALOC = "corbaloc";
    public static final String pxCORBANAME = "corbaname";
    public static final String pxIOR = "ior";
    public static final String IIOP = "iiop";
    public static final String RIR = "rir";
    public static final int DEFAULT_PORT = 2809;
    public static final String DEFAULT_NAME = "NameService";
    static NameTransformer converter;
    static NameParser n;
    int p;
    String[] t;

    public synchronized Object corbaloc(String corbaloc, OrbFunctional orb) throws BAD_PARAM {
        boolean corbaname;
        ArrayList alt_addr = new ArrayList();
        int major = 1;
        int minor = 0;
        int port = 2809;
        StringTokenizer st = new StringTokenizer(corbaloc, ":@/.,#", true);
        this.t = new String[st.countTokens()];
        int i = 0;
        while (i < this.t.length) {
            this.t[i] = st.nextToken();
            ++i;
        }
        this.p = 0;
        if (this.t[this.p].startsWith(pxCORBANAME)) {
            corbaname = true;
        } else if (this.t[this.p].equalsIgnoreCase(pxCORBALOC)) {
            corbaname = false;
        } else {
            if (this.t[this.p].equalsIgnoreCase(pxIOR)) {
                IOR ior = IOR.parse(corbaloc);
                return orb.ior_to_object(ior);
            }
            throw new DATA_CONVERSION("Unsupported protocol: '" + this.t[this.p] + '\'');
        }
        ++this.p;
        if (!this.t[this.p++].equals(":")) {
            throw new BAD_PARAM("Syntax (':' expected after name prefix)");
        }
        if (this.t[this.p].equals(RIR)) {
            ++this.p;
            if (!this.t[this.p++].equals(":")) {
                throw new BAD_PARAM("':' expected after 'rir'");
            }
            String key = this.readKey("/");
            try {
                Object object = orb.resolve_initial_references(key);
                return corbaname ? this.resolve(object) : object;
            }
            catch (InvalidName e) {
                throw new BAD_PARAM("Unknown initial reference '" + key + '\'');
            }
        }
        if (this.t[this.p].equals(IIOP) || this.t[this.p].equals(":")) {
            IOR ior = new IOR();
            while (true) {
                String host;
                if (this.t[this.p].equals(":")) {
                    ++this.p;
                } else {
                    ++this.p;
                    if (!this.t[this.p++].equals(":")) {
                        throw new BAD_PARAM("':' expected after 'iiop'");
                    }
                    if (this.t[this.p + 1].equals(".") && this.t[this.p + 3].equals("@")) {
                        try {
                            major = Integer.parseInt(this.t[this.p++]);
                        }
                        catch (NumberFormatException e) {
                            throw new BAD_PARAM("Major version number '" + this.t[this.p - 1] + '\'');
                        }
                        ++this.p;
                        try {
                            minor = Integer.parseInt(this.t[this.p++]);
                        }
                        catch (NumberFormatException e) {
                            throw new BAD_PARAM("Major version number '" + this.t[this.p - 1] + '\'');
                        }
                        ++this.p;
                    }
                }
                ior.Internet.version = new Version(major, minor);
                StringBuffer bhost = new StringBuffer(corbaloc.length());
                while (!(this.t[this.p].equals(":") || this.t[this.p].equals("/") || this.t[this.p].equals(","))) {
                    bhost.append(this.t[this.p++]);
                }
                ior.Internet.host = host = bhost.toString();
                if (this.t[this.p].equals(":")) {
                    ++this.p;
                    try {
                        port = Integer.parseInt(this.t[this.p++]);
                    }
                    catch (NumberFormatException e) {
                        throw new BAD_PARAM("Invalid port '" + this.t[this.p - 1] + '\'');
                    }
                }
                ior.Internet.port = port;
                ior.Id = "";
                if (!this.t[this.p].equals(",")) break;
                ++this.p;
            }
            String key = this.readKey("/");
            ior.key = key.getBytes();
            Object object = orb.ior_to_object(ior);
            return corbaname ? this.resolve(object) : object;
        }
        throw new DATA_CONVERSION("Unsupported protocol '" + this.t[this.p] + '\'');
    }

    private final Object resolve(Object object) {
        NamingContext ns;
        String key = "?";
        try {
            if (object instanceof NamingContext) {
                ns = (NamingContext)object;
            } else {
                Delegate delegate = ((ObjectImpl)object)._get_delegate();
                ns = new _NamingContextStub(delegate);
            }
        }
        catch (Exception ex) {
            BAD_PARAM bad = new BAD_PARAM("The CORBANAME target " + object + " is not a NamingContext");
            bad.minor = 10;
            bad.initCause(ex);
            throw bad;
        }
        if (converter == null) {
            converter = new NameTransformer();
        }
        try {
            key = this.readKey("#");
            object = ns.resolve(converter.toName(key));
            return object;
        }
        catch (Exception ex) {
            BAD_PARAM bad = new BAD_PARAM("Wrong CORBANAME '" + key + '\'');
            bad.minor = 10;
            bad.initCause(ex);
            throw bad;
        }
    }

    private final String readKey(String delimiter) throws BAD_PARAM {
        if (this.p < this.t.length && !this.t[this.p].equals(delimiter)) {
            if (this.t[this.p].equals("#")) {
                return DEFAULT_NAME;
            }
            throw new BAD_PARAM("'" + delimiter + "String' expected '" + this.t[this.p] + "' found");
        }
        StringBuffer bKey = new StringBuffer();
        ++this.p;
        while (this.p < this.t.length && !this.t[this.p].equals("#")) {
            bKey.append(this.t[this.p++]);
        }
        if (bKey.length() == 0) {
            return DEFAULT_NAME;
        }
        try {
            return URLDecoder.decode(bKey.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Unexpected("URLDecoder does not support UTF-8", e);
        }
    }

    static void corbalocT(String ior, OrbFunctional orb) {
        System.out.println(ior);
        System.out.println(n.corbaloc(ior, orb));
        System.out.println();
    }

    public static void main(String[] args) {
        try {
            OrbFunctional orb = (OrbFunctional)ORB.init(args, null);
            NameParser.corbalocT("corbaloc:iiop:1.3@155axyz.com/Prod/aTradingService", orb);
            NameParser.corbalocT("corbaloc:iiop:2.7@255bxyz.com/Prod/bTradingService", orb);
            NameParser.corbalocT("corbaloc:iiop:355cxyz.com/Prod/cTradingService", orb);
            NameParser.corbalocT("corbaloc:iiop:2.7@255bxyz.com/Prod/bTradingService", orb);
            NameParser.corbalocT("corbaloc:iiop:355cxyz.com:7777/Prod/cTradingService", orb);
            NameParser.corbalocT("corbaloc::556xyz.com:80/Dev/NameService", orb);
            NameParser.corbalocT("corbaloc:iiop:1.2@host1:3076/0", orb);
            NameParser.corbalocT("corbaloc:rir:/NameService", orb);
            NameParser.corbalocT("corbaloc:rir:/", orb);
            NameParser.corbalocT("corbaloc:rir:", orb);
            NameParser.corbalocT("corbaloc:rir:/NameService", orb);
            NameParser.corbalocT("corbaloc:rir:/", orb);
            NameParser.corbalocT("corbaloc:rir:", orb);
            NameParser.corbalocT("corbaloc::555xyz.com,:556xyz.com:80/Dev/NameService", orb);
        }
        catch (BAD_PARAM e) {
            e.printStackTrace(System.out);
        }
    }

    static {
        n = new NameParser();
    }
}

