/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import gnu.java.io.Base64InputStream;
import gnu.java.security.OID;
import gnu.java.security.pkcs.PKCS7SignedData;
import gnu.java.security.pkcs.SignerInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JarFile
extends ZipFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final String META_INF = "META-INF/";
    private static final String PKCS7_DSA_SUFFIX = ".DSA";
    private static final String PKCS7_RSA_SUFFIX = ".RSA";
    private static final String DIGEST_KEY_SUFFIX = "-Digest";
    private static final String SF_SUFFIX = ".SF";
    private static final OID MD2_OID = new OID("1.2.840.113549.2.2");
    private static final OID MD4_OID = new OID("1.2.840.113549.2.4");
    private static final OID MD5_OID = new OID("1.2.840.113549.2.5");
    private static final OID SHA1_OID = new OID("1.3.14.3.2.26");
    private static final OID DSA_ENCRYPTION_OID = new OID("1.2.840.10040.4.1");
    private static final OID RSA_ENCRYPTION_OID = new OID("1.2.840.113549.1.1.1");
    static boolean DEBUG = false;
    private Manifest manifest;
    boolean verify;
    private boolean manifestRead;
    boolean signaturesRead;
    HashMap verified;
    HashMap entryCerts;
    static /* synthetic */ Class class$java$util$jar$JarFile;

    static void debug(Object msg) {
        Class clazz = class$java$util$jar$JarFile;
        if (clazz == null) {
            clazz = class$java$util$jar$JarFile = JarFile.class("[Ljava.util.jar.JarFile;", false);
        }
        System.err.print(clazz.getName());
        System.err.print(" >>> ");
        System.err.println(msg);
    }

    private final void verify() {
        if (this.manifest == null) {
            this.verify = false;
            return;
        }
        this.verify = true;
    }

    private final Manifest readManifest() {
        try {
            ZipEntry manEntry = super.getEntry(MANIFEST_NAME);
            if (manEntry != null) {
                InputStream in = super.getInputStream(manEntry);
                this.manifestRead = true;
                return new Manifest(in);
            }
            this.manifestRead = true;
            return null;
        }
        catch (IOException ioe) {
            this.manifestRead = true;
            return null;
        }
    }

    public Enumeration entries() throws IllegalStateException {
        return new JarEnumeration(super.entries(), this);
    }

    public synchronized ZipEntry getEntry(String name) {
        ZipEntry entry = super.getEntry(name);
        if (entry != null) {
            Set certs;
            Manifest manifest;
            JarEntry jarEntry = new JarEntry(entry);
            try {
                manifest = this.getManifest();
            }
            catch (IOException ioe) {
                manifest = null;
            }
            if (manifest != null) {
                jarEntry.attr = manifest.getAttributes(name);
            }
            if (this.verify && !this.signaturesRead) {
                try {
                    this.readSignatures();
                }
                catch (IOException ioe) {
                    if (DEBUG) {
                        JarFile.debug(ioe);
                        ioe.printStackTrace();
                    }
                    this.signaturesRead = true;
                }
            }
            if (DEBUG) {
                JarFile.debug("entryCerts=" + this.entryCerts + " verified " + name + " ? " + this.verified.get(name));
            }
            if (this.entryCerts != null && this.verified.get(name) == Boolean.TRUE && (certs = (Set)this.entryCerts.get(name)) != null) {
                jarEntry.certs = (Certificate[])certs.toArray(new Certificate[certs.size()]);
            }
            return jarEntry;
        }
        return null;
    }

    public synchronized InputStream getInputStream(ZipEntry entry) throws ZipException, IOException {
        if (!this.verified.containsKey(entry.getName()) && this.verify) {
            if (DEBUG) {
                JarFile.debug("reading and verifying " + entry);
            }
            return new EntryInputStream(entry, super.getInputStream(entry), this);
        }
        if (DEBUG) {
            JarFile.debug("reading already verified entry " + entry);
        }
        if (this.verify && this.verified.get(entry.getName()) == Boolean.FALSE) {
            throw new ZipException("digest for " + entry + " is invalid");
        }
        return super.getInputStream(entry);
    }

    public JarEntry getJarEntry(String name) {
        return (JarEntry)this.getEntry(name);
    }

    public synchronized Manifest getManifest() throws IOException {
        if (!this.manifestRead) {
            this.manifest = this.readManifest();
        }
        return this.manifest;
    }

    void readSignatures() throws IOException {
        HashMap pkcs7Dsa = new HashMap();
        HashMap pkcs7Rsa = new HashMap();
        HashMap sigFiles = new HashMap();
        Enumeration e = super.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = (ZipEntry)e.nextElement();
            String name = ze.getName();
            if (!name.startsWith(META_INF)) continue;
            String alias = name.substring(META_INF.length());
            if (alias.lastIndexOf(46) >= 0) {
                alias = alias.substring(0, alias.lastIndexOf(46));
            }
            if (name.endsWith(PKCS7_DSA_SUFFIX) || name.endsWith(PKCS7_RSA_SUFFIX)) {
                if (DEBUG) {
                    JarFile.debug("reading PKCS7 info from " + name + ", alias=" + alias);
                }
                PKCS7SignedData sig = null;
                try {
                    sig = new PKCS7SignedData(super.getInputStream(ze));
                }
                catch (CertificateException ce) {
                    IOException ioe = new IOException("certificate parsing error");
                    ioe.initCause(ce);
                    throw ioe;
                }
                catch (CRLException crle) {
                    IOException ioe = new IOException("CRL parsing error");
                    ioe.initCause(crle);
                    throw ioe;
                }
                if (name.endsWith(PKCS7_DSA_SUFFIX)) {
                    pkcs7Dsa.put(alias, sig);
                    continue;
                }
                if (!name.endsWith(PKCS7_RSA_SUFFIX)) continue;
                pkcs7Rsa.put(alias, sig);
                continue;
            }
            if (!name.endsWith(SF_SUFFIX)) continue;
            if (DEBUG) {
                JarFile.debug("reading signature file for " + alias + ": " + name);
            }
            Manifest sf = new Manifest(super.getInputStream(ze));
            sigFiles.put(alias, sf);
            if (!DEBUG) continue;
            JarFile.debug("result: " + sf);
        }
        HashSet validCerts = new HashSet();
        HashMap entryCerts = new HashMap();
        Iterator it = sigFiles.entrySet().iterator();
        while (it.hasNext()) {
            Iterator it2;
            Set signerInfos;
            Certificate[] certs;
            boolean valid = false;
            Map.Entry e2 = (Map.Entry)it.next();
            String alias = (String)e2.getKey();
            PKCS7SignedData sig = (PKCS7SignedData)pkcs7Dsa.get(alias);
            if (sig != null) {
                certs = sig.getCertificates();
                signerInfos = sig.getSignerInfos();
                it2 = signerInfos.iterator();
                while (it2.hasNext()) {
                    this.verify(certs, (SignerInfo)it2.next(), alias, validCerts);
                }
            }
            if ((sig = (PKCS7SignedData)pkcs7Rsa.get(alias)) != null) {
                certs = sig.getCertificates();
                signerInfos = sig.getSignerInfos();
                it2 = signerInfos.iterator();
                while (it2.hasNext()) {
                    this.verify(certs, (SignerInfo)it2.next(), alias, validCerts);
                }
            }
            if (validCerts.isEmpty()) {
                it.remove();
                continue;
            }
            entryCerts.put(e2.getValue(), new HashSet(validCerts));
            validCerts.clear();
        }
        this.entryCerts = new HashMap();
        it = entryCerts.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e3 = (Map.Entry)it.next();
            Manifest sigfile = (Manifest)e3.getKey();
            Map entries = sigfile.getEntries();
            Set certificates = (Set)e3.getValue();
            Iterator it2 = entries.entrySet().iterator();
            while (it2.hasNext()) {
                Set s;
                Attributes attr;
                Map.Entry e2 = (Map.Entry)it2.next();
                String entryname = String.valueOf(e2.getKey());
                if (!this.verifyHashes(entryname, attr = (Attributes)e2.getValue())) continue;
                if (DEBUG) {
                    JarFile.debug("entry " + entryname + " has certificates " + certificates);
                }
                if ((s = (Set)this.entryCerts.get(entryname)) != null) {
                    s.addAll(certificates);
                    continue;
                }
                this.entryCerts.put(entryname, new HashSet(certificates));
            }
        }
        this.signaturesRead = true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void verify(Certificate[] certs, SignerInfo signerInfo, String alias, Set validCerts) {
        block25: {
            sig = null;
            try {
                alg = signerInfo.getDigestEncryptionAlgorithmId();
                if (alg.equals(JarFile.DSA_ENCRYPTION_OID)) {
                    if (!signerInfo.getDigestAlgorithmId().equals(JarFile.SHA1_OID)) {
                        return;
                    }
                    sig = Signature.getInstance("SHA1withDSA");
                    break block25;
                }
                if (!alg.equals(JarFile.RSA_ENCRYPTION_OID)) ** GOTO lbl25
                hash = signerInfo.getDigestAlgorithmId();
                if (hash.equals(JarFile.MD2_OID)) {
                    sig = Signature.getInstance("md2WithRsaEncryption");
                } else if (hash.equals(JarFile.MD4_OID)) {
                    sig = Signature.getInstance("md4WithRsaEncryption");
                } else if (hash.equals(JarFile.MD5_OID)) {
                    sig = Signature.getInstance("md5WithRsaEncryption");
                } else {
                    if (!hash.equals(JarFile.SHA1_OID)) {
                        return;
                    }
                    sig = Signature.getInstance("sha1WithRsaEncryption");
                }
                break block25;
lbl25:
                // 1 sources

                if (JarFile.DEBUG) {
                    JarFile.debug("unsupported signature algorithm: " + alg);
                }
                return;
            }
            catch (NoSuchAlgorithmException nsae) {
                if (JarFile.DEBUG) {
                    JarFile.debug(nsae);
                    nsae.printStackTrace();
                }
                return;
            }
        }
        sigFileEntry = super.getEntry("META-INF/" + alias + ".SF");
        if (sigFileEntry == null) {
            return;
        }
        i = 0;
        while (i < certs.length) {
            block26: {
                if (certs[i] instanceof X509Certificate && (cert = (X509Certificate)certs[i]).getIssuerX500Principal().equals(signerInfo.getIssuer()) && cert.getSerialNumber().equals(signerInfo.getSerialNumber())) {
                    try {
                        sig.initVerify(cert.getPublicKey());
                        in = super.getInputStream(sigFileEntry);
                        if (in == null) break block26;
                        buf = new byte[1024];
                        len = 0;
                        while (true) {
                            if ((len = in.read(buf)) == -1) {
                                if (sig.verify(signerInfo.getEncryptedDigest())) {
                                    if (JarFile.DEBUG) {
                                        JarFile.debug("signature for " + cert.getSubjectDN() + " is good");
                                    }
                                    validCerts.add(cert);
                                }
                                break;
                            }
                            sig.update(buf, 0, len);
                        }
                    }
                    catch (IOException ioe) {
                    }
                    catch (InvalidKeyException ike) {
                    }
                    catch (SignatureException se) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
    }

    private final boolean verifyHashes(String entry, Attributes attr) {
        int verified = 0;
        byte[] entryBytes = null;
        try {
            ZipEntry e = super.getEntry(entry);
            if (e == null) {
                if (DEBUG) {
                    JarFile.debug("verifyHashes: no entry '" + entry + '\'');
                }
                return false;
            }
            entryBytes = this.readManifestEntry(e);
        }
        catch (IOException ioe) {
            if (DEBUG) {
                JarFile.debug(ioe);
                ioe.printStackTrace();
            }
            return false;
        }
        Iterator it = attr.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            String key = String.valueOf(e.getKey());
            if (!key.endsWith(DIGEST_KEY_SUFFIX)) continue;
            String alg = key.substring(0, key.length() - DIGEST_KEY_SUFFIX.length());
            try {
                byte[] hash = Base64InputStream.decode((String)e.getValue());
                MessageDigest md = MessageDigest.getInstance(alg);
                md.update(entryBytes);
                byte[] hash2 = md.digest();
                if (DEBUG) {
                    JarFile.debug("verifying SF entry " + entry + " alg: " + md.getAlgorithm() + " expect=" + new BigInteger(hash).toString(16) + " comp=" + new BigInteger(hash2).toString(16));
                }
                if (!Arrays.equals(hash, hash2)) {
                    return false;
                }
                ++verified;
            }
            catch (IOException ioe) {
                if (DEBUG) {
                    JarFile.debug(ioe);
                    ioe.printStackTrace();
                }
                return false;
            }
            catch (NoSuchAlgorithmException nsae) {
                if (DEBUG) {
                    JarFile.debug(nsae);
                    nsae.printStackTrace();
                }
                return false;
            }
        }
        boolean bl = false;
        if (verified > 0) {
            bl = true;
        }
        return bl;
    }

    private final byte[] readManifestEntry(ZipEntry entry) throws IOException {
        int c;
        InputStream in = super.getInputStream(super.getEntry(MANIFEST_NAME));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] target = ("Name: " + entry.getName()).getBytes();
        int t = 0;
        int prev = -1;
        int state = 0;
        int l = -1;
        block5: while ((c = in.read()) != -1) {
            switch (state) {
                case 0: {
                    if ((byte)c != target[t]) {
                        t = 0;
                        break;
                    }
                    if (++t != target.length) continue block5;
                    out.write(target);
                    state = 1;
                    break;
                }
                case 1: {
                    if (c != 10 && c != 13) {
                        out.reset();
                        t = 0;
                        state = 0;
                        break;
                    }
                    out.write(c);
                    state = 2;
                    break;
                }
                case 2: {
                    if (c == 10) {
                        out.write(c);
                        if (l == 0 || l == 1 && prev == 13) {
                            return out.toByteArray();
                        }
                        l = 0;
                    } else {
                        if (l == 1 && prev == 13) {
                            return out.toByteArray();
                        }
                        out.write(c);
                        ++l;
                    }
                    prev = c;
                    break;
                }
                default: {
                    throw new RuntimeException("this statement should be unreachable");
                }
            }
        }
        if (state == 2 && prev == 13 && l == 0) {
            return out.toByteArray();
        }
        throw new IOException("could not find " + entry + " in manifest");
    }

    static /* synthetic */ String access$0() {
        return DIGEST_KEY_SUFFIX;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.manifestRead = false;
        this.signaturesRead = false;
        this.verified = new HashMap();
    }

    public JarFile(String fileName) throws FileNotFoundException, IOException {
        this(fileName, true);
    }

    public JarFile(String fileName, boolean verify) throws FileNotFoundException, IOException {
        super(fileName);
        this.this();
        if (verify) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    public JarFile(File file) throws FileNotFoundException, IOException {
        this(file, true);
    }

    public JarFile(File file, boolean verify) throws FileNotFoundException, IOException {
        super(file);
        this.this();
        if (verify) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    public JarFile(File file, boolean verify, int mode) throws FileNotFoundException, IOException, IllegalArgumentException {
        super(file, mode);
        this.this();
        if (verify) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    private static class JarEnumeration
    implements Enumeration {
        private final Enumeration entries;
        private final JarFile jarfile;

        public boolean hasMoreElements() {
            return this.entries.hasMoreElements();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object nextElement() {
            Manifest manifest;
            ZipEntry zip = (ZipEntry)this.entries.nextElement();
            JarEntry jar = new JarEntry(zip);
            try {
                manifest = this.jarfile.getManifest();
            }
            catch (IOException ioe) {
                manifest = null;
            }
            if (manifest != null) {
                jar.attr = manifest.getAttributes(jar.getName());
            }
            JarFile jarFile = this.jarfile;
            synchronized (jarFile) {
                Set certs;
                if (this.jarfile.verify && !this.jarfile.signaturesRead) {
                    try {
                        this.jarfile.readSignatures();
                    }
                    catch (IOException ioe) {
                        if (DEBUG) {
                            JarFile.debug(ioe);
                            ioe.printStackTrace();
                        }
                        this.jarfile.signaturesRead = true;
                    }
                }
                if (this.jarfile.entryCerts != null && this.jarfile.verified.get(zip.getName()) == Boolean.TRUE && (certs = (Set)this.jarfile.entryCerts.get(jar.getName())) != null) {
                    jar.certs = (Certificate[])certs.toArray(new Certificate[certs.size()]);
                }
                return jar;
            }
        }

        JarEnumeration(Enumeration e, JarFile f) {
            this.entries = e;
            this.jarfile = f;
        }
    }

    private static class EntryInputStream
    extends FilterInputStream {
        private final JarFile jarfile;
        private final long length;
        private long pos;
        private final ZipEntry entry;
        private final byte[][] hashes;
        private final MessageDigest[] md;
        private boolean checked;

        public boolean markSupported() {
            return false;
        }

        public void mark(int readLimit) {
        }

        public void reset() {
        }

        public int read() throws IOException {
            int b = super.read();
            if (b == -1) {
                this.eof();
                return -1;
            }
            int i = 0;
            while (i < this.md.length) {
                this.md[i].update((byte)b);
                ++i;
            }
            ++this.pos;
            if (this.length > 0L && this.pos >= this.length) {
                this.eof();
            }
            return b;
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            int count = super.read(buf, off, (int)Math.min((long)len, this.length != 0L ? this.length - this.pos : Integer.MAX_VALUE));
            if (count == -1 || this.length > 0L && this.pos >= this.length) {
                this.eof();
                return -1;
            }
            int i = 0;
            while (i < this.md.length) {
                this.md[i].update(buf, off, count);
                ++i;
            }
            this.pos += (long)count;
            if (this.length != 0L && this.pos >= this.length) {
                this.eof();
            }
            return count;
        }

        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        public long skip(long bytes) throws IOException {
            byte[] b = new byte[1024];
            long amount = 0L;
            while (amount < bytes) {
                int l = this.read(b, 0, (int)Math.min((long)b.length, bytes - amount));
                if (l == -1) break;
                amount += (long)l;
            }
            return amount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void eof() throws IOException {
            if (this.checked) {
                return;
            }
            this.checked = true;
            int i = 0;
            while (i < this.md.length) {
                byte[] hash = this.md[i].digest();
                if (DEBUG) {
                    JarFile.debug("verifying " + this.md[i].getAlgorithm() + " expect=" + new BigInteger(this.hashes[i]).toString(16) + " comp=" + new BigInteger(hash).toString(16));
                }
                if (!Arrays.equals(hash, this.hashes[i])) {
                    JarFile jarFile = this.jarfile;
                    synchronized (jarFile) {
                        if (DEBUG) {
                            JarFile.debug(this.entry + " could NOT be verified");
                        }
                        this.jarfile.verified.put(this.entry.getName(), Boolean.FALSE);
                        return;
                    }
                }
                ++i;
            }
            JarFile jarFile = this.jarfile;
            synchronized (jarFile) {
                if (DEBUG) {
                    JarFile.debug(this.entry + " has been VERIFIED");
                }
                this.jarfile.verified.put(this.entry.getName(), Boolean.TRUE);
                return;
            }
        }

        EntryInputStream(ZipEntry entry, InputStream in, JarFile jar) throws IOException {
            super(in);
            this.entry = entry;
            this.jarfile = jar;
            this.length = entry.getSize();
            this.pos = 0L;
            this.checked = false;
            Manifest manifest = this.jarfile.getManifest();
            Attributes attr = manifest != null ? manifest.getAttributes(entry.getName()) : null;
            if (DEBUG) {
                JarFile.debug("verifying entry " + entry + " attr=" + attr);
            }
            if (attr == null) {
                this.hashes = new byte[0][];
                this.md = new MessageDigest[0];
            } else {
                LinkedList hashes = new LinkedList();
                LinkedList md = new LinkedList();
                Iterator it = attr.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = (Map.Entry)it.next();
                    String key = String.valueOf(e.getKey());
                    if (key == null || !key.endsWith(JarFile.DIGEST_KEY_SUFFIX)) continue;
                    hashes.add(Base64InputStream.decode((String)e.getValue()));
                    try {
                        md.add(MessageDigest.getInstance(key.substring(0, key.length() - JarFile.DIGEST_KEY_SUFFIX.length())));
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        IOException ioe = new IOException("no such message digest: " + key);
                        ioe.initCause(nsae);
                        throw ioe;
                    }
                }
                if (DEBUG) {
                    JarFile.debug("digests=" + md);
                }
                this.hashes = (byte[][])hashes.toArray((Object[])new byte[hashes.size()][]);
                this.md = (MessageDigest[])md.toArray(new MessageDigest[md.size()]);
            }
        }
    }
}

