/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.InvalidFieldException;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.MethodResult;
import gnu.classpath.jdwp.util.Value;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class ClassTypeCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeSuperclass(bb, os);
                    break;
                }
                case 2: {
                    this.executeSetValues(bb, os);
                    break;
                }
                case 3: {
                    this.executeInvokeMethod(bb, os);
                    break;
                }
                case 4: {
                    this.executeNewInstance(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in ClassType Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private final void executeSuperclass(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        Class superClazz = clazz.getSuperclass();
        ReferenceTypeId clazzId = this.idMan.getReferenceTypeId(superClazz);
        clazzId.write(os);
    }

    private final void executeSetValues(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        int numValues = bb.getInt();
        int i = 0;
        while (i < numValues) {
            ObjectId fieldId = this.idMan.readObjectId(bb);
            Field field = (Field)fieldId.getObject();
            Object value = Value.getUntaggedObj(bb, field.getType());
            try {
                field.setAccessible(true);
                field.set(null, value);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidFieldException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new JdwpInternalErrorException(ex);
            }
            ++i;
        }
    }

    private final void executeInvokeMethod(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        MethodResult mr = this.invokeMethod(bb);
        Object value = mr.getReturnedValue();
        Exception exception = mr.getThrownException();
        ObjectId eId = this.idMan.getObjectId(exception);
        Value.writeTaggedValue(os, value);
        eId.writeTagged(os);
    }

    private final void executeNewInstance(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        MethodResult mr = this.invokeMethod(bb);
        Object obj = mr.getReturnedValue();
        ObjectId oId = this.idMan.getObjectId(obj);
        Exception exception = mr.getThrownException();
        ObjectId eId = this.idMan.getObjectId(exception);
        oId.writeTagged(os);
        eId.writeTagged(os);
    }

    private final MethodResult invokeMethod(ByteBuffer bb) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        ObjectId tId = this.idMan.readObjectId(bb);
        Thread thread = (Thread)tId.getObject();
        ObjectId mId = this.idMan.readObjectId(bb);
        Method method = (Method)mId.getObject();
        int args = bb.getInt();
        Object[] values = new Object[args];
        int i = 0;
        while (i < args) {
            values[i] = Value.getObj(bb);
            ++i;
        }
        int invokeOpts = bb.getInt();
        boolean bl = false;
        if ((invokeOpts & 1) != 0) {
            bl = true;
        }
        boolean suspend = bl;
        try {
            if (suspend) {
                VMVirtualMachine.suspendAllThreads();
            }
            MethodResult mr = VMVirtualMachine.executeMethod(null, thread, clazz, method, values, false);
            if (suspend) {
                VMVirtualMachine.resumeAllThreads();
            }
            return mr;
        }
        catch (Exception ex) {
            if (suspend) {
                VMVirtualMachine.resumeAllThreads();
            }
            throw new JdwpInternalErrorException(ex);
        }
    }
}

