/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.html2;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomElement;
import gnu.xml.dom.DomEvent;
import gnu.xml.dom.html2.DomHTMLDocument;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLElement;

public abstract class DomHTMLElement
extends DomElement
implements HTMLElement {
    protected String getHTMLAttribute(String name) {
        if (this.hasAttributes()) {
            NamedNodeMap attrs = this.getAttributes();
            int len = attrs.getLength();
            int i = 0;
            while (i < len) {
                Node attr = attrs.item(i);
                String attrName = attr.getLocalName();
                if (attrName == null) {
                    attrName = attr.getNodeName();
                }
                if (attrName.equalsIgnoreCase(name)) {
                    return attr.getNodeValue();
                }
                ++i;
            }
        }
        return "";
    }

    protected int getIntHTMLAttribute(String name) {
        String value = this.getHTMLAttribute(name);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected boolean getBooleanHTMLAttribute(String name) {
        String value = this.getHTMLAttribute(name);
        boolean bl = false;
        if (value != null) {
            bl = true;
        }
        return bl;
    }

    protected void setHTMLAttribute(String name, String value) {
        Node attr;
        NamedNodeMap attrs = this.getAttributes();
        int len = attrs.getLength();
        int i = 0;
        while (i < len) {
            attr = attrs.item(i);
            String attrName = attr.getLocalName();
            if (attrName == null) {
                attrName = attr.getNodeName();
            }
            if (attrName.equalsIgnoreCase(name)) {
                if (value != null) {
                    attr.setNodeValue(value);
                } else {
                    attrs.removeNamedItem(attr.getNodeName());
                }
                return;
            }
            ++i;
        }
        if (value != null) {
            DomHTMLDocument doc = (DomHTMLDocument)this.getOwnerDocument();
            attr = doc.createAttribute(name);
            attr.setNodeValue(value);
        }
    }

    protected void setIntHTMLAttribute(String name, int value) {
        this.setHTMLAttribute(name, Integer.toString(value));
    }

    protected void setBooleanHTMLAttribute(String name, boolean value) {
        this.setHTMLAttribute(name, value ? name : null);
    }

    protected Node getParentElement(String name) {
        Node parent = this.getParentNode();
        while (parent != null) {
            String parentName = parent.getLocalName();
            if (parentName == null) {
                parentName = parent.getNodeName();
            }
            if (name.equalsIgnoreCase(parentName)) {
                return parent;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    protected Node getChildElement(String name) {
        Node child = this.getFirstChild();
        while (child != null) {
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getLocalName();
            }
            if (name.equalsIgnoreCase(childName)) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    protected int getIndex() {
        int index = 0;
        Node parent = this.getParentNode();
        if (parent != null) {
            Node ctx = parent.getFirstChild();
            while (ctx != null) {
                if (ctx == this) {
                    return index;
                }
                ++index;
                ctx = ctx.getNextSibling();
            }
        }
        throw new DomDOMException(8);
    }

    protected void dispatchUIEvent(String name) {
        DomEvent.DomUIEvent event = new DomEvent.DomUIEvent(name);
        this.dispatchEvent(event);
    }

    public String getId() {
        return this.getHTMLAttribute("id");
    }

    public void setId(String id) {
        this.setHTMLAttribute("id", id);
    }

    public String getTitle() {
        return this.getHTMLAttribute("title");
    }

    public void setTitle(String title) {
        this.setHTMLAttribute("title", title);
    }

    public String getLang() {
        return this.getHTMLAttribute("lang");
    }

    public void setLang(String lang) {
        this.setHTMLAttribute("lang", lang);
    }

    public String getDir() {
        return this.getHTMLAttribute("dir");
    }

    public void setDir(String dir) {
        this.setHTMLAttribute("dir", dir);
    }

    public String getClassName() {
        return this.getHTMLAttribute("class");
    }

    public void setClassName(String className) {
        this.setHTMLAttribute("class", className);
    }

    protected DomHTMLElement(DomHTMLDocument owner, String namespaceURI, String name) {
        super(owner, namespaceURI, name);
    }
}

