/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public abstract class Ellipse2D
extends RectangularShape {
    public boolean contains(double x, double y) {
        double rx = this.getWidth() / (double)2;
        double ry = this.getHeight() / (double)2;
        double tx = (x - (this.getX() + rx)) / rx;
        double ty = (y - (this.getY() + ry)) / ry;
        boolean bl = false;
        if (tx * tx + ty * ty < 1.0) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(double x, double y, double w, double h) {
        double x2 = x + w;
        double y2 = y + h;
        boolean bl = false;
        if (this.contains(x, y) && this.contains(x, y2) && this.contains(x2, y) && this.contains(x2, y2)) {
            bl = true;
        }
        return bl;
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new Arc2D.ArcIterator(this, at);
    }

    public boolean intersects(double x, double y, double w, double h) {
        Rectangle2D.Double r = new Rectangle2D.Double(x, y, w, h);
        if (!r.intersects(this.getX(), this.getY(), this.getWidth(), this.getHeight())) {
            return false;
        }
        if (this.contains(x, y) || this.contains(x, y + h) || this.contains(x + w, y) || this.contains(x + w, y + h)) {
            return true;
        }
        Line2D.Double l1 = new Line2D.Double(this.getX(), this.getY() + this.getHeight() / (double)2, this.getX() + this.getWidth(), this.getY() + this.getHeight() / (double)2);
        Line2D.Double l2 = new Line2D.Double(this.getX() + this.getWidth() / (double)2, this.getY(), this.getX() + this.getWidth() / (double)2, this.getY() + this.getHeight());
        return l1.intersects(r) || l2.intersects(r);
    }

    protected Ellipse2D() {
    }

    public static class Float
    extends Ellipse2D {
        public float height;
        public float width;
        public float x;
        public float y;

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }

        public double getHeight() {
            return this.height;
        }

        public double getWidth() {
            return this.width;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public boolean isEmpty() {
            boolean bl = false;
            if (this.height <= 0.0f || this.width <= 0.0f) {
                bl = true;
            }
            return bl;
        }

        public void setFrame(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.height = h;
            this.width = w;
        }

        public void setFrame(double x, double y, double w, double h) {
            this.x = (float)x;
            this.y = (float)y;
            this.height = (float)h;
            this.width = (float)w;
        }

        public Float() {
        }

        public Float(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.height = h;
            this.width = w;
        }
    }

    public static class Double
    extends Ellipse2D {
        public double height;
        public double width;
        public double x;
        public double y;

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }

        public double getHeight() {
            return this.height;
        }

        public double getWidth() {
            return this.width;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public boolean isEmpty() {
            boolean bl = false;
            if (this.height <= 0.0 || this.width <= 0.0) {
                bl = true;
            }
            return bl;
        }

        public void setFrame(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.height = h;
            this.width = w;
        }

        public Double() {
        }

        public Double(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.height = h;
            this.width = w;
        }
    }
}

