/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractSpinnerModel;

public class SpinnerListModel
extends AbstractSpinnerModel
implements Serializable {
    private static final long serialVersionUID = 3358804052191994516L;
    private List list;
    private transient int index;

    public List getList() {
        return this.list;
    }

    public Object getNextValue() {
        if (this.index < this.list.size() - 1) {
            return this.list.get(this.index + 1);
        }
        return null;
    }

    public Object getPreviousValue() {
        if (this.index > 0) {
            return this.list.get(this.index - 1);
        }
        return null;
    }

    public Object getValue() {
        return this.list.get(this.index);
    }

    public void setList(List list2) {
        if (list2 == null || list2.size() == 0) {
            throw new IllegalArgumentException("The supplied list was invalid.");
        }
        if (this.list != list2) {
            this.list = list2;
            this.fireStateChanged();
        }
        this.index = 0;
    }

    public void setValue(Object value) {
        int valueIndex = this.list.indexOf(value);
        if (valueIndex == -1) {
            throw new IllegalArgumentException("The supplied value does not exist in this list");
        }
        this.index = valueIndex;
        this.fireStateChanged();
    }

    public SpinnerListModel() {
        ArrayList defaultList = new ArrayList();
        defaultList.add("empty");
        this.setList(defaultList);
    }

    public SpinnerListModel(List list2) {
        this.setList(list2);
    }

    public SpinnerListModel(Object[] array) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("The supplied array was invalid.");
        }
        this.setList(Arrays.asList(array));
    }
}

