/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath;

import java.util.Properties;

class VMSystemProperties {
    static void preInit(Properties p) {
        p.setProperty("java.version", "1.4.2");
        p.setProperty("java.vendor", "SableVM Project");
        p.setProperty("java.vendor.url", "http://sablevm.org");
        p.setProperty("java.vendor.url.bug", "http://sablevm.org/bugs");
        p.setProperty("java.home", VMSystemProperties.getJavaHome());
        p.setProperty("java.vm.specification.version", "Second Edition");
        p.setProperty("java.vm.specification.vendor", "Addison Wesley");
        p.setProperty("java.vm.specification.name", "ISBN 0-201-43294-3");
        p.setProperty("java.vm.version", VMSystemProperties.getSableVMVersion());
        p.setProperty("java.vm.vendor", "Etienne M. Gagnon and others");
        p.setProperty("java.vm.name", "SableVM");
        p.setProperty("java.specification.version", "1.2");
        p.setProperty("java.specification.vendor", "Sun Microsystems Inc.");
        p.setProperty("java.specification.name", "Java Platform API Specification");
        p.setProperty("java.class.version", "46.0");
        p.setProperty("java.class.path", ".");
        p.setProperty("java.library.path", ".");
        p.setProperty("java.io.tmpdir", "/tmp");
        p.setProperty("java.compiler", "");
        p.setProperty("java.ext.dirs", p.getProperty("java.home") + "/jre/lib/ext");
        p.setProperty("os.name", VMSystemProperties.getOSName());
        p.setProperty("os.arch", VMSystemProperties.getOSArch());
        p.setProperty("os.version", VMSystemProperties.getOSVersion());
        p.setProperty("file.separator", VMSystemProperties.getFileSeparator());
        p.setProperty("path.separator", VMSystemProperties.getPathSeparator());
        p.setProperty("line.separator", VMSystemProperties.getLineSeparator());
        p.setProperty("user.name", VMSystemProperties.getUserName());
        p.setProperty("user.home", VMSystemProperties.getUserHome());
        p.setProperty("user.dir", VMSystemProperties.getWorkDir());
        p.setProperty("gnu.cpu.endian", VMSystemProperties.isBigEndian() ? "big" : "little");
        p.setProperty("sablevm.boot.class.path", VMSystemProperties.getBootstrapClassPath());
        p.setProperty("gnu.classpath.boot.library.path", VMSystemProperties.getBootstrapLibraryPath());
        p.setProperty("gnu.classpath.vm.shortname", "SableVM");
        p.setProperty("java.runtime.name", p.getProperty("java.vm.name"));
        p.setProperty("java.runtime.version", p.getProperty("java.vm.version"));
        p.setProperty("sun.boot.class.path", VMSystemProperties.getBootstrapClassPath());
        p.setProperty("sun.boot.library.path", VMSystemProperties.getBootstrapLibraryPath());
    }

    private static final native String getSableVMVersion();

    private static final native String getOSName();

    private static final native String getOSArch();

    private static final native String getOSVersion();

    private static final native String getFileSeparator();

    private static final native String getPathSeparator();

    private static final native String getLineSeparator();

    private static final native String getUserName();

    private static final native String getUserHome();

    private static final native String getWorkDir();

    private static final native boolean isBigEndian();

    private static final native String getBootstrapLibraryPath();

    private static final native String getBootstrapClassPath();

    private static final native String getJavaHome();

    private static final native int getPropertyCount();

    private static final native String getProperty(int var0);

    static void postInit(Properties p) {
        int count = VMSystemProperties.getPropertyCount();
        int i = 0;
        while (i < count) {
            String property = VMSystemProperties.getProperty(i);
            int equal_position = property.indexOf(61);
            String name = property.substring(0, equal_position);
            String value = equal_position < property.length() ? property.substring(equal_position + 1) : "";
            p.setProperty(name, value);
            ++i;
        }
    }

    VMSystemProperties() {
    }
}

