/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.dom.JAXPFactory;
import gnu.xml.xpath.DocumentOrderComparator;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class Expr
implements XPathExpression {
    protected static final Comparator documentOrderComparator = new DocumentOrderComparator();
    protected static final DecimalFormat decimalFormat = new DecimalFormat("####################################################.####################################################", new DecimalFormatSymbols(Locale.US));

    public Object evaluate(Object item, QName returnType) throws XPathExpressionException {
        Object ret = null;
        Node context = null;
        if (item instanceof Node) {
            context = (Node)item;
            ret = this.evaluate(context, 1, 1);
            if (XPathConstants.STRING == returnType && !(ret instanceof String)) {
                ret = Expr._string(context, ret);
            } else if (XPathConstants.NUMBER == returnType && !(ret instanceof Double)) {
                ret = new Double(Expr._number(context, ret));
            } else if (XPathConstants.BOOLEAN == returnType && !(ret instanceof Boolean)) {
                ret = Expr._boolean(context, ret) ? Boolean.TRUE : Boolean.FALSE;
            } else if (XPathConstants.NODE == returnType) {
                if (ret instanceof Collection) {
                    Collection ns = (Collection)ret;
                    switch (ns.size()) {
                        case 0: {
                            ret = null;
                            break;
                        }
                        case 1: {
                            ret = (Node)ns.iterator().next();
                            break;
                        }
                        default: {
                            throw new XPathExpressionException("multiple nodes in node-set");
                        }
                    }
                } else if (ret != null) {
                    throw new XPathExpressionException("return value is not a node-set");
                }
            } else if (XPathConstants.NODESET == returnType && ret != null && !(ret instanceof Collection)) {
                throw new XPathExpressionException("return value is not a node-set");
            }
        }
        return ret;
    }

    public String evaluate(Object item) throws XPathExpressionException {
        return (String)this.evaluate(item, XPathConstants.STRING);
    }

    public Object evaluate(InputSource source, QName returnType) throws XPathExpressionException {
        try {
            JAXPFactory factory = new JAXPFactory();
            DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
            Document doc = builder.parse(source);
            return this.evaluate(doc, returnType);
        }
        catch (ParserConfigurationException e) {
            throw new XPathExpressionException(e);
        }
        catch (SAXException e) {
            throw new XPathExpressionException(e);
        }
        catch (IOException e) {
            throw new XPathExpressionException(e);
        }
    }

    public String evaluate(InputSource source) throws XPathExpressionException {
        return (String)this.evaluate(source, XPathConstants.STRING);
    }

    public abstract Object evaluate(Node var1, int var2, int var3);

    public abstract Expr clone(Object var1);

    public abstract boolean references(QName var1);

    public static Collection _id(Node context, Object object) {
        HashSet ret = new HashSet();
        if (object instanceof Collection) {
            Collection nodeSet = (Collection)object;
            Iterator i = nodeSet.iterator();
            while (i.hasNext()) {
                String string = Expr.stringValue((Node)i.next());
                ret.addAll(Expr._id(context, string));
            }
        } else {
            Document doc = context instanceof Document ? (Document)context : context.getOwnerDocument();
            String string = Expr._string(context, object);
            StringTokenizer st = new StringTokenizer(string, " \t\r\n");
            while (st.hasMoreTokens()) {
                Element element = doc.getElementById(st.nextToken());
                if (element == null) continue;
                ret.add(element);
            }
        }
        return ret;
    }

    public static String _local_name(Node context, Collection nodeSet) {
        Node node2 = nodeSet == null || nodeSet.size() == 0 ? context : Expr.firstNode(nodeSet);
        return node2.getLocalName();
    }

    public static String _namespace_uri(Node context, Collection nodeSet) {
        Node node2 = nodeSet == null || nodeSet.size() == 0 ? context : Expr.firstNode(nodeSet);
        return node2.getNamespaceURI();
    }

    public static String _name(Node context, Collection nodeSet) {
        Node node2 = nodeSet == null || nodeSet.size() == 0 ? context : Expr.firstNode(nodeSet);
        switch (node2.getNodeType()) {
            case 1: 
            case 2: 
            case 7: {
                return node2.getNodeName();
            }
        }
        return "";
    }

    static Node firstNode(Collection nodeSet) {
        ArrayList list2 = new ArrayList(nodeSet);
        Collections.sort(list2, documentOrderComparator);
        return (Node)list2.get(0);
    }

    public static String _string(Node context, Object object) {
        if (object == null) {
            return Expr.stringValue(context);
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Double) {
            double d = (Double)object;
            if (Double.isNaN(d)) {
                return "NaN";
            }
            if (d == 0.0) {
                return "0";
            }
            if (Double.isInfinite(d)) {
                if (d < 0.0) {
                    return "-Infinity";
                }
                return "Infinity";
            }
            String ret = decimalFormat.format(d);
            if (ret.endsWith(".0")) {
                ret = ret.substring(0, ret.length() - 2);
            }
            return ret;
        }
        if (object instanceof Collection) {
            Collection nodeSet = (Collection)object;
            if (nodeSet.isEmpty()) {
                return "";
            }
            Node node2 = Expr.firstNode(nodeSet);
            return Expr.stringValue(node2);
        }
        throw new IllegalArgumentException(object.toString());
    }

    public static boolean _boolean(Node context, Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Double) {
            boolean bl = false;
            if ((Double)object != 0.0) {
                bl = true;
            }
            return bl;
        }
        if (object instanceof String) {
            boolean bl = false;
            if (((String)object).length() != 0) {
                bl = true;
            }
            return bl;
        }
        if (object instanceof Collection) {
            boolean bl = false;
            if (((Collection)object).size() != 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public static double _number(Node context, Object object) {
        if (object == null) {
            object = Collections.singleton(context);
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof Collection) {
            object = Expr.stringValue((Collection)object);
        }
        if (object instanceof String) {
            String string = ((String)object).trim();
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
        return Double.NaN;
    }

    public static String stringValue(Collection nodeSet) {
        StringBuffer buf = new StringBuffer();
        Iterator i = nodeSet.iterator();
        while (i.hasNext()) {
            buf.append(Expr.stringValue((Node)i.next()));
        }
        return buf.toString();
    }

    public static String stringValue(Node node2) {
        return Expr.stringValue(node2, false);
    }

    static String stringValue(Node node2, boolean elementMode) {
        switch (node2.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                StringBuffer buf = new StringBuffer();
                Node ctx = node2.getFirstChild();
                while (ctx != null) {
                    buf.append(Expr.stringValue(ctx, true));
                    ctx = ctx.getNextSibling();
                }
                return buf.toString();
            }
            case 3: 
            case 4: {
                return node2.getNodeValue();
            }
            case 2: 
            case 7: 
            case 8: {
                if (elementMode) break;
                return node2.getNodeValue();
            }
        }
        return "";
    }
}

