/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.Engine;
import gnu.java.security.provider.SHA1PRNG;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Enumeration;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SecureRandom
extends Random {
    private static final String SECURE_RANDOM = "SecureRandom";
    private static final long serialVersionUID = 4940670005562187L;
    long counter;
    Provider provider;
    byte[] randomBytes;
    int randomBytesUsed;
    SecureRandomSpi secureRandomSpi;
    byte[] state;

    public static SecureRandom getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        int i = 0;
        while (i < p.length) {
            try {
                return SecureRandom.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static SecureRandom getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null || provider.length() == 0) {
            throw new IllegalArgumentException("Illegal provider");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return SecureRandom.getInstance(algorithm, p);
    }

    public static SecureRandom getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("Illegal provider");
        }
        try {
            return new SecureRandom((SecureRandomSpi)Engine.getInstance(SECURE_RANDOM, algorithm, provider), provider);
        }
        catch (InvocationTargetException ite) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        catch (ClassCastException cce) {
            throw new NoSuchAlgorithmException(algorithm);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void setSeed(byte[] seed) {
        this.secureRandomSpi.engineSetSeed(seed);
    }

    public void setSeed(long seed) {
        if (this.secureRandomSpi != null) {
            byte[] tmp = new byte[]{(byte)(0xFFL & seed >> 56), (byte)(0xFFL & seed >> 48), (byte)(0xFFL & seed >> 40), (byte)(0xFFL & seed >> 32), (byte)(0xFFL & seed >> 24), (byte)(0xFFL & seed >> 16), (byte)(0xFFL & seed >> 8), (byte)(0xFFL & seed)};
            this.secureRandomSpi.engineSetSeed(tmp);
        }
    }

    public void nextBytes(byte[] bytes) {
        this.randomBytesUsed += bytes.length;
        ++this.counter;
        this.secureRandomSpi.engineNextBytes(bytes);
    }

    protected final int next(int numBits) {
        if (numBits == 0) {
            return 0;
        }
        byte[] tmp = new byte[numBits / 8 + numBits % 8];
        this.secureRandomSpi.engineNextBytes(tmp);
        this.randomBytesUsed += tmp.length;
        ++this.counter;
        int ret = 0;
        int i = 0;
        while (i < tmp.length) {
            ret |= (tmp[i] & 0xFF) << 8 * i;
            ++i;
        }
        long mask = (1L << numBits) - 1L;
        return (int)((long)ret & mask);
    }

    public static byte[] getSeed(int numBytes) {
        byte[] tmp = new byte[numBytes];
        new Random().nextBytes(tmp);
        return tmp;
    }

    public byte[] generateSeed(int numBytes) {
        return this.secureRandomSpi.engineGenerateSeed(numBytes);
    }

    private final /* synthetic */ void this() {
        this.counter = 0L;
        this.provider = null;
        this.randomBytes = null;
        this.randomBytesUsed = 0;
        this.secureRandomSpi = null;
        this.state = null;
    }

    public SecureRandom() {
        this.this();
        Provider[] p = Security.getProviders();
        String classname = null;
        int i = 0;
        while (i < p.length) {
            Enumeration e = p[i].propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith("SECURERANDOM.") || (classname = p[i].getProperty(key)) == null) continue;
                try {
                    this.secureRandomSpi = (SecureRandomSpi)Class.forName(classname).newInstance();
                    this.provider = p[i];
                    return;
                }
                catch (ThreadDeath death) {
                    throw death;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.secureRandomSpi = new SHA1PRNG();
    }

    public SecureRandom(byte[] seed) {
        this();
        this.setSeed(seed);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this.this();
        this.secureRandomSpi = secureRandomSpi;
        this.provider = provider;
    }
}

