/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileHandler
extends StreamHandler {
    private final int limit;
    private final int count;
    private final String pattern;
    private final boolean append;
    long written;
    private LinkedList logFiles;
    static /* synthetic */ Class class$java$util$logging$XMLFormatter;

    private final OutputStream createFileStream(String pattern2, int limit, int count, boolean append, int generation) {
        int unique = 0;
        LogManager.getLogManager().checkAccess();
        if (pattern2 == null) {
            pattern2 = LogManager.getLogManager().getProperty("java.util.logging.FileHandler.pattern");
        }
        if (pattern2 == null) {
            pattern2 = "%h/java%u.log";
        }
        if (count > 1 && !FileHandler.has(pattern2, 'g')) {
            pattern2 = pattern2 + ".%g";
        }
        while (true) {
            String path = FileHandler.replaceFileNameEscapes(pattern2, generation, unique, count);
            try {
                File file = new File(path);
                if (!file.exists() || append) {
                    FileOutputStream fout = new FileOutputStream(file, append);
                    if (this.logFiles.isEmpty()) {
                        this.logFiles.addFirst(path);
                    }
                    return new ostr(fout);
                }
            }
            catch (Exception ex) {
                this.reportError(null, ex, 4);
            }
            ++unique;
            if (FileHandler.has(pattern2, 'u')) continue;
            pattern2 = pattern2 + ".%u";
        }
    }

    private static final String replaceFileNameEscapes(String pattern2, int generation, int uniqueNumber, int count) {
        StringBuffer buf = new StringBuffer(pattern2);
        boolean foundGeneration = false;
        int pos = 0;
        do {
            String replaceWith;
            if (buf.charAt(pos) == '/') {
                replaceWith = System.getProperty("file.separator");
                buf.replace(pos, pos + 1, replaceWith);
                pos = pos + replaceWith.length() - 1;
                continue;
            }
            if (buf.charAt(pos) != '%') continue;
            switch (buf.charAt(pos + 1)) {
                case 't': {
                    replaceWith = System.getProperty("java.io.tmpdir");
                    break;
                }
                case 'h': {
                    replaceWith = System.getProperty("user.home");
                    break;
                }
                case 'g': {
                    replaceWith = Integer.toString(generation);
                    foundGeneration = true;
                    break;
                }
                case 'u': {
                    replaceWith = Integer.toString(uniqueNumber);
                    break;
                }
                case '%': {
                    replaceWith = "%";
                    break;
                }
                default: {
                    replaceWith = "??";
                    break;
                }
            }
            buf.replace(pos, pos + 2, replaceWith);
            pos = pos + replaceWith.length() - 1;
        } while (++pos < buf.length() - 1);
        if (!foundGeneration && count > 1) {
            buf.append('.');
            buf.append(generation);
        }
        return buf.toString();
    }

    public void publish(LogRecord record) {
        if (this.limit > 0 && this.written >= (long)this.limit) {
            this.rotate();
        }
        super.publish(record);
        this.flush();
    }

    private final synchronized void rotate() {
        if (this.logFiles.size() > 0) {
            File f1 = null;
            ListIterator lit = null;
            if (this.logFiles.size() == this.count) {
                f1 = new File((String)this.logFiles.getLast());
                f1.delete();
                lit = this.logFiles.listIterator(this.logFiles.size() - 1);
            } else {
                String path = FileHandler.replaceFileNameEscapes(this.pattern, this.logFiles.size(), 0, this.count);
                f1 = new File(path);
                this.logFiles.addLast(path);
                lit = this.logFiles.listIterator(this.logFiles.size() - 1);
            }
            while (lit.hasPrevious()) {
                String s = (String)lit.previous();
                File f2 = new File(s);
                f2.renameTo(f1);
                f1 = f2;
            }
        }
        this.setOutputStream(this.createFileStream(this.pattern, this.limit, this.count, this.append, 0));
        this.written = 0L;
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean has(String pattern, char escape) {
        len = pattern.length();
        sawPercent = false;
        i = 0;
        while (i < len) {
            c = pattern.charAt(i);
            if (!sawPercent) ** GOTO lbl-1000
            if (c == escape) {
                return true;
            }
            if (c == '%') {
                sawPercent = false;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
                if (c == '%') {
                    v0 = true;
                }
                sawPercent = v0;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public FileHandler() throws IOException, SecurityException {
        this(null, LogManager.getIntProperty("java.util.logging.FileHandler.limit", 0), LogManager.getIntProperty("java.util.logging.FileHandler.count", 1), LogManager.getBooleanProperty("java.util.logging.FileHandler.append", false));
    }

    public FileHandler(String pattern2) throws IOException, SecurityException {
        this(pattern2, 0, 1, false);
    }

    public FileHandler(String pattern2, boolean append) throws IOException, SecurityException {
        this(pattern2, 0, 1, append);
    }

    public FileHandler(String pattern2, int limit, int count) throws IOException, SecurityException {
        this(pattern2, limit, count, LogManager.getBooleanProperty("java.util.logging.FileHandler.append", false));
    }

    public FileHandler(String pattern2, int limit, int count, boolean append) throws IOException, SecurityException {
        Class clazz = class$java$util$logging$XMLFormatter;
        if (clazz == null) {
            clazz = class$java$util$logging$XMLFormatter = FileHandler.class("[Ljava.util.logging.XMLFormatter;", false);
        }
        super(null, "java.util.logging.FileHandler", Level.ALL, null, clazz);
        if (limit < 0 || count < 1) {
            throw new IllegalArgumentException();
        }
        this.pattern = pattern2;
        this.limit = limit;
        this.count = count;
        this.append = append;
        this.written = 0L;
        this.logFiles = new LinkedList();
        this.setOutputStream(this.createFileStream(pattern2, limit, count, append, 0));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class ostr
    extends FilterOutputStream {
        public final void write(int b) throws IOException {
            this.out.write(b);
            ++FileHandler.this.written;
        }

        public final void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public final void write(byte[] b, int offset, int length) throws IOException {
            this.out.write(b, offset, length);
            FileHandler.this.written += (long)length;
        }

        private ostr(OutputStream out) {
            super(out);
        }
    }
}

