/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.SwingConstants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicArrowButton
extends JButton
implements SwingConstants {
    private static final Dimension PREFERRED_SIZE = new Dimension(16, 16);
    private static final Dimension MINIMUM_SIZE = new Dimension(5, 5);
    private static final Dimension MAXIMUM_SIZE = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected int direction;
    transient Color shadow;
    transient Color darkShadow;
    transient Color highlight;

    public boolean isFocusTraversable() {
        return false;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int dir) {
        this.direction = dir;
    }

    public void paint(Graphics g) {
        super.paint(g);
        Rectangle bounds = this.getBounds();
        int size = bounds.height / 4;
        int x = (bounds.width - size) / 2;
        int y = (bounds.height - size) / 2;
        ButtonModel m = this.getModel();
        if (m.isArmed()) {
            ++x;
            ++y;
        }
        this.paintTriangle(g, x, y, size, this.direction, this.isEnabled());
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    public Dimension getMinimumSize() {
        return MINIMUM_SIZE;
    }

    public Dimension getMaximumSize() {
        return MAXIMUM_SIZE;
    }

    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
        Color savedColor = g.getColor();
        switch (direction) {
            case 1: {
                this.paintTriangleNorth(g, x, y, size, isEnabled);
                break;
            }
            case 5: {
                this.paintTriangleSouth(g, x, y, size, isEnabled);
                break;
            }
            case 2: 
            case 7: {
                this.paintTriangleWest(g, x, y, size, isEnabled);
                break;
            }
            case 3: 
            case 4: {
                this.paintTriangleEast(g, x, y, size, isEnabled);
                break;
            }
        }
        g.setColor(savedColor);
    }

    private final void paintTriangleNorth(Graphics g, int x, int y, int size, boolean isEnabled) {
        int tipX = x + (size - 2) / 2;
        int tipY = y;
        int baseX1 = tipX - (size - 1);
        int baseX2 = tipX + (size - 1);
        int baseY = y + (size - 1);
        Polygon triangle = new Polygon();
        triangle.addPoint(tipX, tipY);
        triangle.addPoint(baseX1, baseY);
        triangle.addPoint(baseX2, baseY);
        if (isEnabled) {
            g.setColor(Color.DARK_GRAY);
            g.fillPolygon(triangle);
            g.drawPolygon(triangle);
        } else {
            g.setColor(Color.GRAY);
            g.fillPolygon(triangle);
            g.drawPolygon(triangle);
            g.setColor(Color.WHITE);
            g.drawLine(baseX1 + 1, baseY + 1, baseX2 + 1, baseY + 1);
        }
    }

    private final void paintTriangleSouth(Graphics g, int x, int y, int size, boolean isEnabled) {
        int tipX = x + (size - 2) / 2;
        int tipY = y + (size - 1);
        int baseX1 = tipX - (size - 1);
        int baseX2 = tipX + (size - 1);
        int baseY = y;
        Polygon triangle = new Polygon();
        triangle.addPoint(tipX, tipY);
        triangle.addPoint(baseX1, baseY);
        triangle.addPoint(baseX2, baseY);
        if (isEnabled) {
            g.setColor(Color.DARK_GRAY);
            g.fillPolygon(triangle);
            g.drawPolygon(triangle);
        } else {
            g.setColor(Color.GRAY);
            g.fillPolygon(triangle);
            g.drawPolygon(triangle);
            g.setColor(Color.WHITE);
            g.drawLine(tipX + 1, tipY, baseX2, baseY + 1);
            g.drawLine(tipX + 1, tipY + 1, baseX2 + 1, baseY + 1);
        }
    }

    private final void paintTriangleEast(Graphics g, int x, int y, int size, boolean isEnabled) {
        int tipX = x + (size - 1);
        int tipY = y + (size - 2) / 2;
        int baseX = x;
        int baseY1 = tipY - (size - 1);
        int baseY2 = tipY + (size - 1);
        Polygon triangle = new Polygon();
        triangle.addPoint(tipX, tipY);
        triangle.addPoint(baseX, baseY1);
        triangle.addPoint(baseX, baseY2);
        if (isEnabled) {
            g.setColor(Color.DARK_GRAY);
            g.fillPolygon(triangle);
            g.drawPolygon(triangle);
        } else {
            g.setColor(Color.GRAY);
            g.fillPolygon(triangle);
            g.drawPolygon(triangle);
            g.setColor(Color.WHITE);
            g.drawLine(baseX + 1, baseY2, tipX, tipY + 1);
            g.drawLine(baseX + 1, baseY2 + 1, tipX + 1, tipY + 1);
        }
    }

    private final void paintTriangleWest(Graphics g, int x, int y, int size, boolean isEnabled) {
        int tipX = x;
        int tipY = y + (size - 2) / 2;
        int baseX = x + (size - 1);
        int baseY1 = tipY - (size - 1);
        int baseY2 = tipY + (size - 1);
        Polygon triangle = new Polygon();
        triangle.addPoint(tipX, tipY);
        triangle.addPoint(baseX, baseY1);
        triangle.addPoint(baseX, baseY2);
        if (isEnabled) {
            g.setColor(Color.DARK_GRAY);
            g.fillPolygon(triangle);
            g.drawPolygon(triangle);
        } else {
            g.setColor(Color.GRAY);
            g.fillPolygon(triangle);
            g.drawPolygon(triangle);
            g.setColor(Color.WHITE);
            g.drawLine(baseX + 1, baseY1 + 1, baseX + 1, baseY2 + 1);
        }
    }

    private final /* synthetic */ void this() {
        this.shadow = Color.GRAY;
        this.darkShadow = new Color(102, 102, 102);
        this.highlight = Color.WHITE;
    }

    public BasicArrowButton(int direction) {
        this.this();
        this.setDirection(direction);
    }

    public BasicArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
        this(direction);
        this.setBackground(background);
        this.shadow = shadow;
        this.darkShadow = darkShadow;
        this.highlight = highlight;
    }
}

