/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultStyledDocument
extends AbstractDocument
implements StyledDocument {
    private static final long serialVersionUID = 940485415728614849L;
    public static final int BUFFER_SIZE_DEFAULT = 4096;
    protected ElementBuffer buffer = new ElementBuffer(this.createDefaultRoot());
    private static final /* synthetic */ boolean assert;

    public Style addStyle(String nm, Style parent) {
        StyleContext context = (StyleContext)this.getAttributeContext();
        return context.addStyle(nm, parent);
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        SectionElement section = new SectionElement();
        AbstractDocument.BranchElement paragraph = (AbstractDocument.BranchElement)this.createBranchElement(section, null);
        paragraph.setResolveParent(this.getStyle("default"));
        Element[] tmp = new Element[]{paragraph};
        section.replace(0, 0, tmp);
        AbstractDocument.LeafElement leaf = new AbstractDocument.LeafElement(paragraph, null, 0, 1);
        tmp = new Element[]{leaf};
        paragraph.replace(0, 0, tmp);
        return section;
    }

    public Element getCharacterElement(int position) {
        Element element = this.getDefaultRootElement();
        while (!element.isLeaf()) {
            int index = element.getElementIndex(position);
            element = element.getElement(index);
        }
        return element;
    }

    public Color getBackground(AttributeSet attributes) {
        StyleContext context = (StyleContext)this.getAttributeContext();
        return context.getBackground(attributes);
    }

    public Element getDefaultRootElement() {
        return this.buffer.getRootElement();
    }

    public Font getFont(AttributeSet attributes) {
        StyleContext context = (StyleContext)this.getAttributeContext();
        return context.getFont(attributes);
    }

    public Color getForeground(AttributeSet attributes) {
        StyleContext context = (StyleContext)this.getAttributeContext();
        return context.getForeground(attributes);
    }

    public Style getLogicalStyle(int position) {
        Element paragraph = this.getParagraphElement(position);
        AttributeSet attributes = paragraph.getAttributes();
        return (Style)attributes.getResolveParent();
    }

    public Element getParagraphElement(int position) {
        AbstractDocument.BranchElement root = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int start = root.getStartOffset();
        int end = root.getEndOffset();
        if (position >= end) {
            position = end - 1;
        } else if (position < start) {
            position = start;
        }
        Element par = root.positionToElement(position);
        if (!assert && par == null) {
            throw new AssertionError((Object)"The paragraph element must not be null");
        }
        return par;
    }

    public Style getStyle(String nm) {
        StyleContext context = (StyleContext)this.getAttributeContext();
        return context.getStyle(nm);
    }

    public void removeStyle(String nm) {
        StyleContext context = (StyleContext)this.getAttributeContext();
        context.removeStyle(nm);
    }

    public void setCharacterAttributes(int offset, int length, AttributeSet attributes, boolean replace) {
        AbstractDocument.DefaultDocumentEvent ev = new AbstractDocument.DefaultDocumentEvent(offset, length, DocumentEvent.EventType.CHANGE);
        this.buffer.change(offset, length, ev);
        Element root = this.getDefaultRootElement();
        int paragraphCount = root.getElementCount();
        int pindex = 0;
        while (pindex < paragraphCount) {
            Element paragraph = root.getElement(pindex);
            if (paragraph.getStartOffset() <= offset + length && paragraph.getEndOffset() >= offset) {
                int contentCount = paragraph.getElementCount();
                int cindex = 0;
                while (cindex < contentCount) {
                    Element content = paragraph.getElement(cindex);
                    if (content.getStartOffset() <= offset + length && content.getEndOffset() >= offset) {
                        if (content instanceof AbstractDocument.AbstractElement) {
                            AbstractDocument.AbstractElement el = (AbstractDocument.AbstractElement)content;
                            if (replace) {
                                el.removeAttributes(el);
                            }
                            el.addAttributes(attributes);
                        } else {
                            throw new AssertionError((Object)"content elements are expected to beinstances of javax.swing.text.AbstractDocument.AbstractElement");
                        }
                    }
                    ++cindex;
                }
            }
            ++pindex;
        }
        this.fireChangedUpdate(ev);
    }

    public void setLogicalStyle(int position, Style style) {
        Element el = this.getParagraphElement(position);
        if (!(el instanceof AbstractDocument.AbstractElement)) {
            throw new AssertionError((Object)"paragraph elements are expected to beinstances of javax.swing.text.AbstractDocument.AbstractElement");
        }
        AbstractDocument.AbstractElement ael = (AbstractDocument.AbstractElement)el;
        ael.setResolveParent(style);
    }

    public void setParagraphAttributes(int offset, int length, AttributeSet attributes, boolean replace) {
        int index = offset;
        while (index < offset + length) {
            AbstractDocument.AbstractElement par = (AbstractDocument.AbstractElement)this.getParagraphElement(index);
            AbstractDocument.AttributeContext ctx = this.getAttributeContext();
            if (replace) {
                par.removeAttributes(par);
            }
            par.addAttributes(attributes);
            index = par.getElementCount();
        }
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent ev, AttributeSet attr) {
        super.insertUpdate(ev, attr);
        int offset = ev.getOffset();
        int length = ev.getLength();
        int endOffset = offset + length;
        Segment txt = new Segment();
        try {
            this.getText(offset, length, txt);
        }
        catch (BadLocationException ex) {
            AssertionError ae = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)ae)).initCause(ex);
            throw ae;
        }
        int len = 0;
        Vector specs = new Vector();
        Element prev = this.getCharacterElement(offset);
        Element next = this.getCharacterElement(endOffset);
        int i = offset;
        while (i < endOffset) {
            ++len;
            if (txt.array[i] == '\n') {
                ElementSpec spec = new ElementSpec(attr, 3, len);
                if (i == endOffset - 1) {
                    if (next.getAttributes().isEqual(attr)) {
                        spec.setDirection((short)5);
                    }
                } else if (specs.size() == 0 && prev.getAttributes().isEqual(attr)) {
                    spec.setDirection((short)4);
                }
                specs.add(spec);
                ElementSpec endTag = new ElementSpec(null, 2);
                specs.add(endTag);
                ElementSpec startTag = new ElementSpec(null, 1);
                startTag.setDirection((short)7);
                specs.add(startTag);
                len = 0;
                offset += len;
            }
            ++i;
        }
        if (len > 0) {
            ElementSpec spec = new ElementSpec(attr, 3, len);
            if (specs.size() == 0) {
                if (prev.getAttributes().isEqual(attr)) {
                    spec.setDirection((short)4);
                }
            } else if (next.getAttributes().isEqual(attr)) {
                spec.setDirection((short)5);
            }
            specs.add(spec);
        }
        ElementSpec[] elSpecs = (ElementSpec[])specs.toArray(new ElementSpec[specs.size()]);
        this.buffer.insert(offset, length, elSpecs, ev);
    }

    public DefaultStyledDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleContext());
    }

    public DefaultStyledDocument(StyleContext context) {
        this((AbstractDocument.Content)new GapContent(4096), context);
    }

    public DefaultStyledDocument(AbstractDocument.Content content, StyleContext context) {
        super(content, context);
        this.setLogicalStyle(0, context.getStyle("default"));
    }

    static {
        assert = Class.forName("[Ljavax.swing.text.DefaultStyledDocument;").getComponentType().desiredAssertionStatus() ^ true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class SectionElement
    extends AbstractDocument.BranchElement {
        public String getName() {
            return "section";
        }

        public SectionElement() {
            super(null, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ElementBuffer
    implements Serializable {
        private static final long serialVersionUID = 1688745877691146623L;
        private Element root;
        private int offset;
        private int length;
        Element[] fracture;
        AbstractDocument.DefaultDocumentEvent documentEvent;

        public Element getRootElement() {
            return this.root;
        }

        public void change(int offset, int length, AbstractDocument.DefaultDocumentEvent ev) {
            this.offset = offset;
            this.length = length;
            this.documentEvent = ev;
            this.changeUpdate();
        }

        protected void changeUpdate() {
            Element el = DefaultStyledDocument.this.getCharacterElement(this.offset);
            this.split(el, this.offset);
            int endOffset = this.offset + this.length;
            el = DefaultStyledDocument.this.getCharacterElement(endOffset);
            this.split(el, endOffset);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void split(Element el, int offset) {
            if (!(el instanceof AbstractDocument.AbstractElement)) throw new AssertionError((Object)"content elements are expected to be instances of javax.swing.text.AbstractDocument.AbstractElement");
            AbstractDocument.AbstractElement ael = (AbstractDocument.AbstractElement)el;
            int startOffset = ael.getStartOffset();
            int endOffset = ael.getEndOffset();
            int len = endOffset - startOffset;
            if (startOffset == offset || endOffset == offset) return;
            Element paragraph = ael.getParentElement();
            if (!(paragraph instanceof AbstractDocument.BranchElement)) throw new AssertionError((Object)"paragraph elements are expected to be instances of javax.swing.text.AbstractDocument.BranchElement");
            AbstractDocument.BranchElement par = (AbstractDocument.BranchElement)paragraph;
            Element child1 = DefaultStyledDocument.this.createLeafElement(par, ael, startOffset, offset);
            Element child2 = DefaultStyledDocument.this.createLeafElement(par, ael, offset, endOffset);
            int index = par.getElementIndex(startOffset);
            Element[] add = new Element[]{child1, child2};
            par.replace(index, 1, add);
            this.documentEvent.addEdit(new AbstractDocument.ElementEdit(par, index, new Element[]{el}, add));
        }

        public void insert(int offset, int length, ElementSpec[] data, AbstractDocument.DefaultDocumentEvent ev) {
            this.offset = offset;
            this.length = length;
            this.documentEvent = ev;
            this.insertUpdate(data);
        }

        protected void insertUpdate(ElementSpec[] data) {
            int i = 0;
            while (i < data.length) {
                switch (data[i].getType()) {
                    case 1: {
                        this.insertStartTag(data[i]);
                        break;
                    }
                    case 2: {
                        this.insertEndTag(data[i]);
                        break;
                    }
                    default: {
                        this.insertContentTag(data[i]);
                        break;
                    }
                }
                ++i;
            }
        }

        void insertStartTag(ElementSpec tag) {
            AbstractDocument.BranchElement root = (AbstractDocument.BranchElement)DefaultStyledDocument.this.getDefaultRootElement();
            int index = root.getElementIndex(this.offset);
            if (index == -1) {
                index = 0;
            }
            AbstractDocument.BranchElement newParagraph = (AbstractDocument.BranchElement)DefaultStyledDocument.this.createBranchElement(root, tag.getAttributes());
            newParagraph.setResolveParent(DefaultStyledDocument.this.getStyle("default"));
            Element[] added = new Element[]{newParagraph};
            root.replace(index + 1, 0, added);
            AbstractDocument.ElementEdit edit = new AbstractDocument.ElementEdit(root, index + 1, new Element[0], added);
            this.documentEvent.addEdit(edit);
            if (tag.getDirection() == 7) {
                Element[] newFracture = new Element[this.fracture.length];
                int i = 0;
                while (i < this.fracture.length) {
                    Element newLeaf;
                    Element oldLeaf = this.fracture[i];
                    newFracture[i] = newLeaf = DefaultStyledDocument.this.createLeafElement(newParagraph, oldLeaf.getAttributes(), oldLeaf.getStartOffset(), oldLeaf.getEndOffset());
                    ++i;
                }
                newParagraph.replace(0, 0, newFracture);
                edit = new AbstractDocument.ElementEdit(newParagraph, 0, new Element[0], this.fracture);
                this.documentEvent.addEdit(edit);
                this.fracture = new Element[0];
            }
        }

        void insertEndTag(ElementSpec tag) {
            AbstractDocument.BranchElement root = (AbstractDocument.BranchElement)DefaultStyledDocument.this.getDefaultRootElement();
            int parIndex = root.getElementIndex(this.offset);
            AbstractDocument.BranchElement paragraph = (AbstractDocument.BranchElement)root.getElement(parIndex);
            int index = paragraph.getElementIndex(this.offset);
            AbstractDocument.LeafElement content = (AbstractDocument.LeafElement)paragraph.getElement(index);
            this.split(content, this.offset);
            index = paragraph.getElementIndex(this.offset);
            int count = paragraph.getElementCount();
            this.fracture = new Element[count - index];
            int i = index;
            while (i < count) {
                this.fracture[i - index] = paragraph.getElement(i);
                ++i;
            }
            paragraph.replace(index, count - index, new Element[0]);
            AbstractDocument.ElementEdit edit = new AbstractDocument.ElementEdit(paragraph, index, this.fracture, new Element[0]);
            this.documentEvent.addEdit(edit);
        }

        void insertContentTag(ElementSpec tag) {
            int len = tag.getLength();
            short dir = tag.getDirection();
            if (dir == 4) {
                Element prev = DefaultStyledDocument.this.getCharacterElement(this.offset);
                AbstractDocument.BranchElement prevParent = (AbstractDocument.BranchElement)prev.getParentElement();
                Element join = DefaultStyledDocument.this.createLeafElement(prevParent, tag.getAttributes(), prev.getStartOffset(), Math.max(prev.getEndOffset(), this.offset + len));
                int ind = prevParent.getElementIndex(this.offset);
                if (ind == -1) {
                    ind = 0;
                }
                Element[] add = new Element[]{join};
                prevParent.replace(ind, 1, add);
                AbstractDocument.ElementEdit edit = new AbstractDocument.ElementEdit(prevParent, ind, new Element[]{prev}, add);
                this.documentEvent.addEdit(edit);
            } else if (dir == 5) {
                Element next = DefaultStyledDocument.this.getCharacterElement(this.offset + len);
                AbstractDocument.BranchElement nextParent = (AbstractDocument.BranchElement)next.getParentElement();
                Element join = DefaultStyledDocument.this.createLeafElement(nextParent, tag.getAttributes(), this.offset, next.getEndOffset());
                int ind = nextParent.getElementIndex(this.offset + len);
                if (ind == -1) {
                    ind = 0;
                }
                Element[] add = new Element[]{join};
                nextParent.replace(ind, 1, add);
                AbstractDocument.ElementEdit edit = new AbstractDocument.ElementEdit(nextParent, ind, new Element[]{next}, add);
                this.documentEvent.addEdit(edit);
            } else {
                Element next;
                int ind;
                AbstractDocument.BranchElement par = (AbstractDocument.BranchElement)DefaultStyledDocument.this.getParagraphElement(this.offset);
                Element prev = par.getElement(ind = par.getElementIndex(this.offset));
                if (prev != null && prev.getStartOffset() < this.offset) {
                    Element cutPrev = DefaultStyledDocument.this.createLeafElement(par, prev.getAttributes(), prev.getStartOffset(), this.offset);
                    Element[] remove = new Element[]{prev};
                    Element[] add = new Element[]{cutPrev};
                    if (prev.getEndOffset() > this.offset + len) {
                        Element rem = DefaultStyledDocument.this.createLeafElement(par, prev.getAttributes(), this.offset + len, prev.getEndOffset());
                        add = new Element[]{cutPrev, rem};
                    }
                    par.replace(ind, 1, add);
                    this.documentEvent.addEdit(new AbstractDocument.ElementEdit(par, ind, remove, add));
                    ++ind;
                }
                if ((next = par.getElement(ind)) != null && next.getStartOffset() < this.offset + len) {
                    Element cutNext = DefaultStyledDocument.this.createLeafElement(par, next.getAttributes(), this.offset + len, next.getEndOffset());
                    Element[] remove = new Element[]{next};
                    Element[] add = new Element[]{cutNext};
                    par.replace(ind, 1, add);
                    this.documentEvent.addEdit(new AbstractDocument.ElementEdit(par, ind, remove, add));
                }
                Element newEl = DefaultStyledDocument.this.createLeafElement(par, tag.getAttributes(), this.offset, this.offset + len);
                Element[] added = new Element[]{newEl};
                par.replace(ind, 0, added);
                AbstractDocument.ElementEdit edit = new AbstractDocument.ElementEdit(par, ind, new Element[0], added);
                this.documentEvent.addEdit(edit);
            }
            this.offset += len;
        }

        public ElementBuffer(Element root) {
            this.root = root;
        }
    }

    public static class ElementSpec {
        public static final short StartTagType = 1;
        public static final short EndTagType = 2;
        public static final short ContentType = 3;
        public static final short JoinPreviousDirection = 4;
        public static final short JoinNextDirection = 5;
        public static final short OriginateDirection = 6;
        public static final short JoinFractureDirection = 7;
        short type;
        short direction;
        int offset;
        int length;
        char[] content;
        AttributeSet attributes;

        public void setType(short type) {
            this.type = type;
        }

        public short getType() {
            return this.type;
        }

        public void setDirection(short dir) {
            this.direction = dir;
        }

        public short getDirection() {
            return this.direction;
        }

        public AttributeSet getAttributes() {
            return this.attributes;
        }

        public char[] getArray() {
            return this.content;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append('<');
            switch (this.type) {
                case 1: {
                    b.append("StartTag");
                    break;
                }
                case 2: {
                    b.append("EndTag");
                    break;
                }
                case 3: {
                    b.append("Content");
                    break;
                }
                default: {
                    b.append("??");
                    break;
                }
            }
            b.append(':');
            switch (this.direction) {
                case 4: {
                    b.append("JoinPrevious");
                    break;
                }
                case 5: {
                    b.append("JoinNext");
                    break;
                }
                case 6: {
                    b.append("Originate");
                    break;
                }
                case 7: {
                    b.append("Fracture");
                    break;
                }
                default: {
                    b.append("??");
                    break;
                }
            }
            b.append(':');
            b.append(this.length);
            return b.toString();
        }

        public ElementSpec(AttributeSet a, short type) {
            this(a, type, 0);
        }

        public ElementSpec(AttributeSet a, short type, int len) {
            this(a, type, null, 0, len);
        }

        public ElementSpec(AttributeSet a, short type, char[] txt, int offs, int len) {
            this.attributes = a;
            this.type = type;
            this.offset = offs;
            this.length = len;
            this.content = txt;
            this.direction = (short)6;
        }
    }
}

