/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingConstants;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.ViewFactory;

public abstract class View
implements SwingConstants {
    public static final int BadBreakWeight = 0;
    public static final int ExcellentBreakWeight = 2000;
    public static final int ForcedBreakWeight = 3000;
    public static final int GoodBreakWeight = 1000;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private float width;
    private float height;
    private Element elt;
    private View parent;

    public abstract void paint(Graphics var1, Shape var2);

    public void setParent(View parent) {
        this.parent = parent;
    }

    public View getParent() {
        return this.parent;
    }

    public Container getContainer() {
        View parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getContainer();
    }

    public Document getDocument() {
        return this.getElement().getDocument();
    }

    public Element getElement() {
        return this.elt;
    }

    public abstract float getPreferredSpan(int var1);

    public int getResizeWeight(int axis) {
        return 0;
    }

    public float getMaximumSpan(int axis) {
        if (this.getResizeWeight(axis) <= 0) {
            return this.getPreferredSpan(axis);
        }
        return 2.1474836E9f;
    }

    public float getMinimumSpan(int axis) {
        if (this.getResizeWeight(axis) <= 0) {
            return this.getPreferredSpan(axis);
        }
        return 2.1474836E9f;
    }

    public void setSize(float width, float height) {
    }

    public float getAlignment(int axis) {
        return 0.5f;
    }

    public AttributeSet getAttributes() {
        return this.getElement().getAttributes();
    }

    public boolean isVisible() {
        return true;
    }

    public int getViewCount() {
        return 0;
    }

    public View getView(int index) {
        return null;
    }

    public ViewFactory getViewFactory() {
        View parent = this.getParent();
        return parent != null ? parent.getViewFactory() : null;
    }

    public void replace(int offset, int length, View[] views) {
    }

    public void insert(int offset, View view) {
        View[] array = new View[]{view};
        this.replace(offset, 1, array);
    }

    public void append(View view) {
        View[] array = new View[]{view};
        int offset = this.getViewCount();
        this.replace(offset, 0, array);
    }

    public void removeAll() {
        this.replace(0, this.getViewCount(), new View[0]);
    }

    public void remove(int index) {
        this.replace(index, 1, null);
    }

    public View createFragment(int p0, int p1) {
        return this;
    }

    public int getStartOffset() {
        return this.getElement().getStartOffset();
    }

    public int getEndOffset() {
        return this.getElement().getEndOffset();
    }

    public Shape getChildAllocation(int index, Shape a) {
        return null;
    }

    public int getViewIndex(float x, float y, Shape allocation) {
        return -1;
    }

    public String getToolTipText(float x, float y, Shape allocation) {
        int index = this.getViewIndex(x, y, allocation);
        if (index < -1) {
            return null;
        }
        Shape childAllocation = this.getChildAllocation(index, allocation);
        if (childAllocation.getBounds().contains(x, y)) {
            return this.getView(index).getToolTipText(x, y, childAllocation);
        }
        return null;
    }

    public Graphics getGraphics() {
        return this.getContainer().getGraphics();
    }

    public void preferenceChanged(View child, boolean width, boolean height) {
        if (this.parent != null) {
            this.parent.preferenceChanged(this, width, height);
        }
    }

    public int getBreakWeight(int axis, float pos, float len) {
        return 0;
    }

    public View breakView(int axis, int offset, float pos, float len) {
        return this;
    }

    public int getViewIndex(int pos, Position.Bias b) {
        return -1;
    }

    public void insertUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
        Element el = this.getElement();
        DocumentEvent.ElementChange ec = ev.getChange(el);
        if (ec != null) {
            this.updateChildren(ec, ev, vf);
        }
        this.forwardUpdate(ec, ev, shape, vf);
        this.updateLayout(ec, ev, shape);
    }

    public void removeUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
        Element el = this.getElement();
        DocumentEvent.ElementChange ec = ev.getChange(el);
        if (ec != null) {
            this.updateChildren(ec, ev, vf);
        }
        this.forwardUpdate(ec, ev, shape, vf);
        this.updateLayout(ec, ev, shape);
    }

    public void changedUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
        Element el = this.getElement();
        DocumentEvent.ElementChange ec = ev.getChange(el);
        if (ec != null) {
            this.updateChildren(ec, ev, vf);
        }
        this.forwardUpdate(ec, ev, shape, vf);
        this.updateLayout(ec, ev, shape);
    }

    protected boolean updateChildren(DocumentEvent.ElementChange ec, DocumentEvent ev, ViewFactory vf) {
        Element[] added = ec.getChildrenAdded();
        Element[] removed = ec.getChildrenRemoved();
        int index = ec.getIndex();
        View[] newChildren = new View[added.length];
        int i = 0;
        while (i < added.length) {
            newChildren[i] = vf.create(added[i]);
            ++i;
        }
        this.replace(index, removed.length, newChildren);
        return true;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange ec, DocumentEvent ev, Shape shape, ViewFactory vf) {
        int count = this.getViewCount();
        int i = 0;
        while (i < count) {
            View child = this.getView(i);
            this.forwardUpdateToView(child, ev, shape, vf);
            ++i;
        }
    }

    protected void forwardUpdateToView(View view, DocumentEvent ev, Shape shape, ViewFactory vf) {
        DocumentEvent.EventType type = ev.getType();
        if (type == DocumentEvent.EventType.INSERT) {
            view.insertUpdate(ev, shape, vf);
        } else if (type == DocumentEvent.EventType.REMOVE) {
            view.removeUpdate(ev, shape, vf);
        } else if (type == DocumentEvent.EventType.CHANGE) {
            view.changedUpdate(ev, shape, vf);
        }
    }

    protected void updateLayout(DocumentEvent.ElementChange ec, DocumentEvent ev, Shape shape) {
        Rectangle b = shape.getBounds();
        if (ec != null) {
            this.preferenceChanged(this, true, true);
        }
    }

    public abstract Shape modelToView(int var1, Shape var2, Position.Bias var3) throws BadLocationException;

    public Shape modelToView(int p1, Position.Bias b1, int p2, Position.Bias b2, Shape a) throws BadLocationException {
        if (b1 != Position.Bias.Forward && b1 != Position.Bias.Backward) {
            throw new IllegalArgumentException("b1 must be either Position.Bias.Forward or Position.Bias.Backward");
        }
        if (b2 != Position.Bias.Forward && b2 != Position.Bias.Backward) {
            throw new IllegalArgumentException("b2 must be either Position.Bias.Forward or Position.Bias.Backward");
        }
        Shape s1 = this.modelToView(p1, a, b1);
        Shape s2 = this.modelToView(p2, a, b2);
        return s1.getBounds().union(s2.getBounds());
    }

    public Shape modelToView(int pos, Shape a) throws BadLocationException {
        return this.modelToView(pos, a, Position.Bias.Forward);
    }

    public abstract int viewToModel(float var1, float var2, Shape var3, Position.Bias[] var4);

    public int viewToModel(float x, float y, Shape a) {
        return this.viewToModel(x, y, a, new Position.Bias[0]);
    }

    void dump() {
        View parent = this.getParent();
        if (parent != null) {
            parent.dump();
        } else {
            this.dump(0);
        }
    }

    void dump(int indent) {
        int i = 0;
        while (i < indent) {
            System.out.print('.');
            ++i;
        }
        System.out.println(this);
        int count = this.getViewCount();
        int i2 = 0;
        while (i2 < count) {
            this.getView(i2).dump(indent + 1);
            ++i2;
        }
    }

    public View(Element elem) {
        this.elt = elem;
    }
}

