/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.LightweightDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.accessibility.Accessible;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Container
extends Component {
    private static final long serialVersionUID = 4613797578919906343L;
    int ncomponents;
    Component[] component;
    LayoutManager layoutMgr;
    LightweightDispatcher dispatcher;
    Dimension maxSize;
    boolean focusCycleRoot;
    int containerSerializedDataVersion;
    transient ContainerListener containerListener;
    transient PropertyChangeSupport changeSupport;
    private FocusTraversalPolicy focusTraversalPolicy;
    transient Set[] focusTraversalKeys;
    static /* synthetic */ Class class$java$awt$event$ContainerListener;

    public int getComponentCount() {
        return this.countComponents();
    }

    public int countComponents() {
        return this.ncomponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Component getComponent(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n >= 0 && n < this.ncomponents) {
                return this.component[n];
            }
            throw new ArrayIndexOutOfBoundsException("no such component");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Component[] getComponents() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] result = new Component[this.ncomponents];
            if (this.ncomponents > 0) {
                System.arraycopy(this.component, 0, result, 0, this.ncomponents);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void swapComponents(int i, int j) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (i >= 0 && i < this.component.length && j >= 0 && j < this.component.length) {
                Component tmp = this.component[i];
                this.component[i] = this.component[j];
                this.component[j] = tmp;
                return;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public Insets getInsets() {
        return this.insets();
    }

    public Insets insets() {
        if (this.peer == null) {
            return new Insets(0, 0, 0, 0);
        }
        return ((ContainerPeer)this.peer).getInsets();
    }

    public Component add(Component comp) {
        this.addImpl(comp, null, -1);
        return comp;
    }

    public Component add(String name, Component comp) {
        this.addImpl(comp, name, -1);
        return comp;
    }

    public Component add(Component comp, int index) {
        this.addImpl(comp, null, index);
        return comp;
    }

    public void add(Component comp, Object constraints) {
        this.addImpl(comp, constraints, -1);
    }

    public void add(Component comp, Object constraints, int index) {
        this.addImpl(comp, constraints, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addImpl(Component comp, Object constraints, int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (index > this.ncomponents || index < 0 && index != -1 || comp instanceof Window || comp instanceof Container && ((Container)comp).isAncestorOf(this)) {
                throw new IllegalArgumentException();
            }
            if (comp.parent != null) {
                comp.parent.remove(comp);
            }
            comp.parent = this;
            if (this.peer != null) {
                comp.addNotify();
                if (comp.isLightweight()) {
                    this.enableEvents(comp.eventMask);
                    if (!this.isLightweight()) {
                        this.enableEvents(8192L);
                    }
                }
            }
            comp.invalidate();
            if (this.component == null) {
                this.component = new Component[4];
            }
            if (this.ncomponents >= this.component.length) {
                int nl = this.component.length * 2;
                Component[] c = new Component[nl];
                System.arraycopy(this.component, 0, c, 0, this.ncomponents);
                this.component = c;
            }
            if (index == -1) {
                this.component[this.ncomponents++] = comp;
            } else {
                System.arraycopy(this.component, index, this.component, index + 1, this.ncomponents - index);
                this.component[index] = comp;
                ++this.ncomponents;
            }
            if (this.layoutMgr != null) {
                if (this.layoutMgr instanceof LayoutManager2) {
                    LayoutManager2 lm2 = (LayoutManager2)this.layoutMgr;
                    lm2.addLayoutComponent(comp, constraints);
                } else if (constraints instanceof String) {
                    this.layoutMgr.addLayoutComponent((String)constraints, comp);
                } else {
                    this.layoutMgr.addLayoutComponent(null, comp);
                }
            }
            ContainerEvent ce = new ContainerEvent(this, 300, comp);
            ContainerListener[] listeners = this.getContainerListeners();
            int i = 0;
            while (i < listeners.length) {
                listeners[i].componentAdded(ce);
                ++i;
            }
            this.repaint(comp.getX(), comp.getY(), comp.getWidth(), comp.getHeight());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component r = this.component[index];
            ComponentListener[] list2 = r.getComponentListeners();
            int j = 0;
            while (true) {
                if (j >= list2.length) {
                    r.removeNotify();
                    System.arraycopy(this.component, index + 1, this.component, index, this.ncomponents - index - 1);
                    this.component[--this.ncomponents] = null;
                    this.invalidate();
                    if (this.layoutMgr != null) {
                        this.layoutMgr.removeLayoutComponent(r);
                    }
                    r.parent = null;
                    if (this.isShowing()) {
                        ContainerEvent ce = new ContainerEvent(this, 301, r);
                        this.getToolkit().getSystemEventQueue().postEvent(ce);
                        this.repaint();
                    }
                    return;
                }
                r.removeComponentListener(list2[j]);
                ++j;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(Component comp) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int i = 0;
            while (i < this.ncomponents) {
                if (this.component[i] == comp) {
                    this.remove(i);
                    break;
                }
                ++i;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            while (this.ncomponents > 0) {
                this.remove(0);
            }
            return;
        }
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager mgr) {
        this.layoutMgr = mgr;
        this.invalidate();
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
        if (this.layoutMgr != null) {
            this.layoutMgr.layoutContainer(this);
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.layoutMgr != null && this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 lm2 = (LayoutManager2)this.layoutMgr;
            lm2.invalidateLayout(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!this.isValid() && this.peer != null) {
                this.validateTree();
            }
            return;
        }
    }

    void invalidateTree() {
        super.invalidate();
        int i = 0;
        while (i < this.ncomponents) {
            Component comp = this.component[i];
            comp.invalidate();
            if (comp instanceof Container) {
                ((Container)comp).invalidateTree();
            }
            ++i;
        }
        if (this.layoutMgr != null && this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 lm2 = (LayoutManager2)this.layoutMgr;
            lm2.invalidateLayout(this);
        }
    }

    protected void validateTree() {
        Component comp;
        if (this.valid) {
            return;
        }
        ContainerPeer cPeer = null;
        if (this.peer != null && !(this.peer instanceof LightweightPeer)) {
            cPeer = (ContainerPeer)this.peer;
            cPeer.beginValidate();
        }
        int i = 0;
        while (i < this.ncomponents) {
            comp = this.component[i];
            if (comp.getPeer() == null) {
                comp.addNotify();
            }
            ++i;
        }
        this.doLayout();
        i = 0;
        while (i < this.ncomponents) {
            comp = this.component[i];
            if (!comp.isValid()) {
                if (comp instanceof Container) {
                    ((Container)comp).validateTree();
                } else {
                    this.component[i].validate();
                }
            }
            ++i;
        }
        this.valid = true;
        if (cPeer != null) {
            cPeer.endValidate();
        }
    }

    public void setFont(Font f) {
        if (f != null && (this.font == null || !this.font.equals(f)) || f == null) {
            super.setFont(f);
            this.invalidateTree();
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Dimension preferredSize() {
        Object object = treeLock;
        synchronized (object) {
            if (this.valid && this.prefSize != null) {
                return new Dimension(this.prefSize);
            }
            LayoutManager layout = this.getLayout();
            if (layout == null) {
                return super.preferredSize();
            }
            Dimension layoutSize = layout.preferredLayoutSize(this);
            if (this.valid) {
                this.prefSize = layoutSize;
            }
            return new Dimension(layoutSize);
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        if (this.valid && this.minSize != null) {
            return new Dimension(this.minSize);
        }
        LayoutManager layout = this.getLayout();
        if (layout != null) {
            this.minSize = layout.minimumLayoutSize(this);
            return this.minSize;
        }
        return super.minimumSize();
    }

    public Dimension getMaximumSize() {
        if (this.valid && this.maxSize != null) {
            return new Dimension(this.maxSize);
        }
        LayoutManager layout = this.getLayout();
        if (layout != null && layout instanceof LayoutManager2) {
            LayoutManager2 lm2 = (LayoutManager2)layout;
            this.maxSize = lm2.maximumLayoutSize(this);
            return this.maxSize;
        }
        return super.getMaximumSize();
    }

    public float getAlignmentX() {
        return super.getAlignmentX();
    }

    public float getAlignmentY() {
        return super.getAlignmentY();
    }

    public void paint(Graphics g) {
        if (!this.isShowing()) {
            return;
        }
        this.visitChildren(g, GfxPaintVisitor.INSTANCE, false);
    }

    public void update(Graphics g) {
        ComponentPeer p = this.peer;
        if (p != null && !(p instanceof LightweightPeer)) {
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.paint(g);
    }

    public void print(Graphics g) {
        super.print(g);
        this.visitChildren(g, GfxPrintVisitor.INSTANCE, true);
    }

    public void paintComponents(Graphics g) {
        super.paint(g);
        this.visitChildren(g, GfxPaintAllVisitor.INSTANCE, true);
    }

    public void printComponents(Graphics g) {
        super.paint(g);
        this.visitChildren(g, GfxPrintAllVisitor.INSTANCE, true);
    }

    public synchronized void addContainerListener(ContainerListener listener) {
        this.containerListener = AWTEventMulticaster.add(this.containerListener, listener);
    }

    public synchronized void removeContainerListener(ContainerListener listener) {
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, listener);
    }

    public synchronized ContainerListener[] getContainerListeners() {
        Class clazz = class$java$awt$event$ContainerListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ContainerListener = Container.class("[Ljava.awt.event.ContainerListener;", false);
        }
        return (ContainerListener[])AWTEventMulticaster.getListeners(this.containerListener, clazz);
    }

    public EventListener[] getListeners(Class listenerType) {
        Class clazz = class$java$awt$event$ContainerListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ContainerListener = Container.class("[Ljava.awt.event.ContainerListener;", false);
        }
        if (listenerType == clazz) {
            return this.getContainerListeners();
        }
        return super.getListeners(listenerType);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    protected void processContainerEvent(ContainerEvent e) {
        if (this.containerListener == null) {
            return;
        }
        switch (e.id) {
            case 300: {
                this.containerListener.componentAdded(e);
                break;
            }
            case 301: {
                this.containerListener.componentRemoved(e);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deliverEvent(Event e) {
        if (this.handleEvent(e)) return;
        Object object = this.getTreeLock();
        synchronized (object) {
            Container parent = this.getParent();
            if (parent == null) return;
            ((Component)parent).deliverEvent(e);
            return;
        }
    }

    public Component getComponentAt(int x, int y) {
        return this.locate(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Component locate(int x, int y) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!this.contains(x, y)) {
                return null;
            }
            int i = 0;
            while (i < this.ncomponents) {
                int y2;
                int x2;
                if (this.component[i].isVisible() && this.component[i].contains(x2 = x - this.component[i].x, y2 = y - this.component[i].y)) {
                    return this.component[i];
                }
                ++i;
            }
            return this;
        }
    }

    public Component getComponentAt(Point p) {
        return this.getComponentAt(p.x, p.y);
    }

    /*
     * Exception decompiling
     */
    public Component findComponentAt(int x, int y) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [4 : 13->168)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    Component findComponentForMouseEventAt(int x, int y) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [5 : 13->180)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Component findComponentAt(Point p) {
        return this.findComponentAt(p.x, p.y);
    }

    public void addNotify() {
        super.addNotify();
        this.addNotifyContainerChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int i = 0;
            while (true) {
                if (i >= this.ncomponents) {
                    super.removeNotify();
                    return;
                }
                this.component[i].removeNotify();
                ++i;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isAncestorOf(Component comp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [3 : 13->38)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String paramString() {
        if (this.layoutMgr == null) {
            return super.paramString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(super.paramString());
        sb.append(",layout=");
        sb.append(this.layoutMgr.getClass().getName());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void list(PrintStream out, int indent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.list(out, indent);
            int i = 0;
            while (i < this.ncomponents) {
                this.component[i].list(out, indent + 2);
                ++i;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void list(PrintWriter out, int indent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.list(out, indent);
            int i = 0;
            while (i < this.ncomponents) {
                this.component[i].list(out, indent + 2);
                ++i;
            }
            return;
        }
    }

    public void setFocusTraversalKeys(int id, Set keystrokes) {
        String name;
        Set sc;
        Set sb;
        Set sa;
        if (id != 0 && id != 1 && id != 2 && id != 3) {
            throw new IllegalArgumentException();
        }
        if (keystrokes == null) {
            Container parent = this.getParent();
            while (parent != null) {
                if (parent.areFocusTraversalKeysSet(id)) {
                    keystrokes = parent.getFocusTraversalKeys(id);
                    break;
                }
                parent = parent.getParent();
            }
            if (keystrokes == null) {
                keystrokes = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id);
            }
        }
        switch (id) {
            case 0: {
                sa = this.getFocusTraversalKeys(1);
                sb = this.getFocusTraversalKeys(2);
                sc = this.getFocusTraversalKeys(3);
                name = "forwardFocusTraversalKeys";
                break;
            }
            case 1: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(2);
                sc = this.getFocusTraversalKeys(3);
                name = "backwardFocusTraversalKeys";
                break;
            }
            case 2: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(1);
                sc = this.getFocusTraversalKeys(3);
                name = "upCycleFocusTraversalKeys";
                break;
            }
            case 3: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(1);
                sc = this.getFocusTraversalKeys(2);
                name = "downCycleFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int i = keystrokes.size();
        Iterator iter = keystrokes.iterator();
        while (--i >= 0) {
            Object o = iter.next();
            if (o instanceof AWTKeyStroke && !sa.contains(o) && !sb.contains(o) && !sc.contains(o) && ((AWTKeyStroke)o).keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        if (this.focusTraversalKeys == null) {
            this.focusTraversalKeys = new Set[4];
        }
        keystrokes = Collections.unmodifiableSet(new HashSet(keystrokes));
        this.firePropertyChange(name, this.focusTraversalKeys[id], keystrokes);
        this.focusTraversalKeys[id] = keystrokes;
    }

    public Set getFocusTraversalKeys(int id) {
        if (id != 0 && id != 1 && id != 2 && id != 3) {
            throw new IllegalArgumentException();
        }
        Set s = null;
        if (this.focusTraversalKeys != null) {
            s = this.focusTraversalKeys[id];
        }
        if (s == null && this.parent != null) {
            s = this.parent.getFocusTraversalKeys(id);
        }
        return s == null ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id) : s;
    }

    public boolean areFocusTraversalKeysSet(int id) {
        if (id != 0 && id != 1 && id != 2 && id != 3) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        if (this.focusTraversalKeys != null && this.focusTraversalKeys[id] != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isFocusCycleRoot(Container c) {
        if (this == c && this.isFocusCycleRoot()) {
            return true;
        }
        Container ancestor = this.getFocusCycleRootAncestor();
        return c == ancestor;
    }

    public void setFocusTraversalPolicy(FocusTraversalPolicy policy) {
        this.focusTraversalPolicy = policy;
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        if (!this.isFocusCycleRoot()) {
            return null;
        }
        if (this.focusTraversalPolicy == null) {
            Container ancestor = this.getFocusCycleRootAncestor();
            if (ancestor != this) {
                return ancestor.getFocusTraversalPolicy();
            }
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            return manager.getDefaultFocusTraversalPolicy();
        }
        return this.focusTraversalPolicy;
    }

    public boolean isFocusTraversalPolicySet() {
        boolean bl = false;
        if (this.focusTraversalPolicy == null) {
            bl = true;
        }
        return bl;
    }

    public void setFocusCycleRoot(boolean focusCycleRoot) {
        this.focusCycleRoot = focusCycleRoot;
    }

    public boolean isFocusCycleRoot() {
        return this.focusCycleRoot;
    }

    public void transferFocusDownCycle() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.downFocusCycle(this);
    }

    public void applyComponentOrientation(ComponentOrientation orientation) {
        if (orientation == null) {
            throw new NullPointerException();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(name, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void visitChildren(Graphics gfx, GfxVisitor visitor, boolean lightweightOnly) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int i = this.ncomponents - 1;
            while (i >= 0) {
                boolean applicable;
                Component comp = this.component[i];
                boolean bl = false;
                if (comp.isVisible() && (comp.isLightweight() || !lightweightOnly)) {
                    bl = true;
                }
                if (applicable = bl) {
                    this.visitChild(gfx, visitor, comp);
                }
                --i;
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void visitChild(Graphics gfx, GfxVisitor visitor, Component comp) {
        Rectangle clip;
        Rectangle bounds = comp.getBounds();
        Rectangle oldClip = gfx.getClipBounds();
        if (oldClip == null) {
            oldClip = bounds;
        }
        if ((clip = oldClip.intersection(bounds)).isEmpty()) {
            return;
        }
        boolean clipped = false;
        boolean translated = false;
        try {
            gfx.setClip(clip.x, clip.y, clip.width, clip.height);
            clipped = true;
            gfx.translate(bounds.x, bounds.y);
            translated = true;
            visitor.visit(comp, gfx);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (translated) {
                gfx.translate(-bounds.x, -bounds.y);
            }
            if (!clipped) throw throwable;
            gfx.setClip(oldClip.x, oldClip.y, oldClip.width, oldClip.height);
            throw throwable;
        }
        {
            Object var10_11 = null;
            if (translated) {
                gfx.translate(-bounds.x, -bounds.y);
            }
            if (!clipped) return;
            gfx.setClip(oldClip.x, oldClip.y, oldClip.width, oldClip.height);
            return;
        }
    }

    void dispatchEventImpl(AWTEvent e) {
        if (this.dispatcher != null && this.dispatcher.handleEvent(e)) {
            return;
        }
        if (e.id <= 301 && e.id >= 300 && (this.containerListener != null || (this.eventMask & (long)2) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    boolean eventTypeEnabled(int eventId) {
        if (eventId <= 301 && eventId >= 300) {
            boolean bl = false;
            if (this.containerListener != null || (this.eventMask & (long)2) != 0L) {
                bl = true;
            }
            return bl;
        }
        return super.eventTypeEnabled(eventId);
    }

    /*
     * Exception decompiling
     */
    Component findNextFocusComponent(Component child) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [4 : 13->202)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addNotifyContainerChildren() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int i = this.ncomponents;
            while (--i >= 0) {
                this.component[i].addNotify();
                if (!this.component[i].isLightweight()) continue;
                if (!this.isLightweight() && this.dispatcher == null) {
                    this.dispatcher = new LightweightDispatcher(this);
                }
                if (this.dispatcher != null) {
                    this.dispatcher.enableEvents(this.component[i].eventMask);
                }
                this.enableEvents(this.component[i].eventMask);
                if (this.peer == null || this.isLightweight()) continue;
                this.enableEvents(8192L);
            }
            return;
        }
    }

    private final void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        String key = (String)s.readObject();
        while (key != null) {
            Object object = s.readObject();
            if ("containerL".equals(key)) {
                this.addContainerListener((ContainerListener)object);
            } else if ("focusTraversalPolicy".equals(key)) {
                this.setFocusTraversalPolicy((FocusTraversalPolicy)object);
            }
            key = (String)s.readObject();
        }
    }

    private final void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster.save(s, "containerL", this.containerListener);
        if (this.focusTraversalPolicy instanceof Serializable) {
            s.writeObject(this.focusTraversalPolicy);
        } else {
            s.writeObject(null);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static class GfxPaintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintVisitor();

        public void visit(Component c, Graphics gfx) {
            c.paint(gfx);
        }

        GfxPaintVisitor() {
        }
    }

    static class GfxPrintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintVisitor();

        public void visit(Component c, Graphics gfx) {
            c.print(gfx);
        }

        GfxPrintVisitor() {
        }
    }

    static class GfxPaintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintAllVisitor();

        public void visit(Component c, Graphics gfx) {
            c.paintAll(gfx);
        }

        GfxPaintAllVisitor() {
        }
    }

    static class GfxPrintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintAllVisitor();

        public void visit(Component c, Graphics gfx) {
            c.printAll(gfx);
        }

        GfxPrintAllVisitor() {
        }
    }

    static abstract class GfxVisitor {
        public abstract void visit(Component var1, Graphics var2);

        GfxVisitor() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTContainer
    extends Component.AccessibleAWTComponent {
        private static final long serialVersionUID = 5081320404842566097L;
        protected ContainerListener accessibleContainerHandler;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int getAccessibleChildrenCount() {
            Object object = Container.this.getTreeLock();
            synchronized (object) {
                int count = 0;
                int n = 0;
                if (Container.this.component != null) {
                    n = Container.this.component.length;
                }
                int i = n;
                while (--i >= 0) {
                    if (!(Container.this.component[i] instanceof Accessible)) continue;
                    ++count;
                }
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Accessible getAccessibleChild(int i) {
            Object object = Container.this.getTreeLock();
            synchronized (object) {
                if (Container.this.component == null) {
                    return null;
                }
                int index = -1;
                while (i >= 0 && ++index < Container.this.component.length) {
                    if (!(Container.this.component[index] instanceof Accessible)) continue;
                    --i;
                }
                if (i < 0) {
                    return (Accessible)((Object)Container.this.component[index]);
                }
                return null;
            }
        }

        public Accessible getAccessibleAt(Point p) {
            Component c = Container.this.getComponentAt(p.x, p.y);
            return c != Container.this && c instanceof Accessible ? (Accessible)((Object)c) : null;
        }

        private final /* synthetic */ void this() {
            this.accessibleContainerHandler = new AccessibleContainerHandler();
        }

        protected AccessibleAWTContainer() {
            this.this();
            Container.this.addContainerListener(this.accessibleContainerHandler);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleContainerHandler
        implements ContainerListener {
            public void componentAdded(ContainerEvent e) {
                AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", null, e.getChild());
            }

            public void componentRemoved(ContainerEvent e) {
                AccessibleAWTContainer.this.firePropertyChange("AccessibleChild", e.getChild(), null);
            }

            protected AccessibleContainerHandler() {
            }
        }
    }
}

