/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.AWTUtilities;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;

class LightweightDispatcher
implements Serializable {
    private static final long serialVersionUID = 5184291520170872969L;
    private Container nativeContainer;
    private Cursor nativeCursor;
    private long eventMask;
    private transient Component pressedComponent;
    private transient Component lastComponentEntered;
    private transient int pressCount;

    void enableEvents(long l) {
        this.eventMask |= l;
    }

    Component getDeepestComponentForMouseEventAt(Component parent, int x, int y) {
        if (parent == null || !parent.contains(x, y)) {
            return null;
        }
        if (!(parent instanceof Container)) {
            return parent;
        }
        Container c = (Container)parent;
        return c.findComponentForMouseEventAt(x, y);
    }

    Component acquireComponentForMouseEvent(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        Component mouseEventTarget = null;
        Container parent = this.nativeContainer;
        Component candidate = null;
        Point p = me.getPoint();
        while (candidate == null && parent != null) {
            candidate = this.getDeepestComponentForMouseEventAt(parent, p.x, p.y);
            if (candidate != null && (candidate.eventMask & (long)me.getID()) != 0L) continue;
            candidate = null;
            p = AWTUtilities.convertPoint(parent, p.x, p.y, parent.parent);
            parent = parent.parent;
        }
        if (candidate == this.nativeContainer) {
            candidate = null;
        }
        if (this.lastComponentEntered != null && this.lastComponentEntered.isShowing() && this.lastComponentEntered != candidate) {
            if (AWTUtilities.isDescendingFrom(this.lastComponentEntered, this.nativeContainer)) {
                Point tp = AWTUtilities.convertPoint(this.nativeContainer, x, y, this.lastComponentEntered);
                MouseEvent exited = new MouseEvent(this.lastComponentEntered, 505, me.getWhen(), me.getModifiersEx(), tp.x, tp.y, me.getClickCount(), me.isPopupTrigger(), me.getButton());
                this.lastComponentEntered.dispatchEvent(exited);
            }
            this.lastComponentEntered = null;
        }
        if (candidate != null) {
            mouseEventTarget = candidate;
            if (candidate.isLightweight() && candidate.isShowing() && candidate != this.nativeContainer && candidate != this.lastComponentEntered) {
                this.lastComponentEntered = mouseEventTarget;
                Point cp = AWTUtilities.convertPoint(this.nativeContainer, x, y, this.lastComponentEntered);
                MouseEvent entered = new MouseEvent(this.lastComponentEntered, 504, me.getWhen(), me.getModifiersEx(), cp.x, cp.y, me.getClickCount(), me.isPopupTrigger(), me.getButton());
                this.lastComponentEntered.dispatchEvent(entered);
            }
        }
        int modifiers = me.getModifiersEx() & 0x1C00;
        switch (me.getButton()) {
            case 1: {
                modifiers &= 0xFFFFFBFF;
                break;
            }
            case 2: {
                modifiers &= 0xFFFFF7FF;
                break;
            }
            case 3: {
                modifiers &= 0xFFFFEFFF;
                break;
            }
        }
        if (me.getID() == 502 || me.getID() == 501 && modifiers > 0 || me.getID() == 506) {
            if (AWTUtilities.isDescendingFrom(this.pressedComponent, this.nativeContainer)) {
                mouseEventTarget = this.pressedComponent;
            }
        } else if (me.getID() == 500) {
            if (candidate != this.pressedComponent) {
                mouseEventTarget = null;
            } else if (this.pressCount == 0) {
                this.pressedComponent = null;
            }
        }
        return mouseEventTarget;
    }

    boolean handleEvent(AWTEvent e) {
        MouseEvent me;
        Component mouseEventTarget;
        if (e instanceof MouseEvent && (mouseEventTarget = this.acquireComponentForMouseEvent(me = (MouseEvent)e)) != null && mouseEventTarget.isShowing() && e.getID() != 504 && e.getID() != 505) {
            switch (e.getID()) {
                case 501: {
                    if (this.pressCount++ != 0) break;
                    this.pressedComponent = mouseEventTarget;
                    break;
                }
                case 502: {
                    if (--this.pressCount != 0 || mouseEventTarget == this.pressedComponent) break;
                    this.pressedComponent = null;
                    break;
                }
            }
            MouseEvent newEvt = AWTUtilities.convertMouseEvent(this.nativeContainer, me, mouseEventTarget);
            mouseEventTarget.dispatchEvent(newEvt);
            if (newEvt.isConsumed()) {
                e.consume();
            }
        }
        return e.isConsumed();
    }

    LightweightDispatcher(Container c) {
        this.nativeContainer = c;
    }
}

