/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class SecretKeySpec
implements KeySpec,
SecretKey {
    private static final long serialVersionUID = 6577238317307289933L;
    private byte[] key;
    private String algorithm;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        return this.key;
    }

    public String getFormat() {
        return "RAW";
    }

    public boolean equals(Object o) {
        byte[] okey = ((SecretKeySpec)o).getEncoded();
        if (this.key.length != okey.length) {
            return false;
        }
        int i = 0;
        while (i < this.key.length) {
            if (this.key[i] != okey[i]) {
                return false;
            }
            ++i;
        }
        return this.algorithm.equals(((SecretKeySpec)o).getAlgorithm());
    }

    public int hashCode() {
        int code = 0;
        int i = 0;
        while (i < this.key.length) {
            code ^= (this.key[i] & 0xFF) << (i << 3 & 0x1F);
            ++i;
        }
        return code ^ this.algorithm.hashCode();
    }

    public SecretKeySpec(byte[] key, String algorithm) {
        this(key, 0, key.length, algorithm);
    }

    public SecretKeySpec(byte[] key, int off, int len, String algorithm) {
        this.key = new byte[len];
        this.algorithm = algorithm;
        System.arraycopy(key, off, this.key, 0, len);
    }
}

