/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkClipboardNotifier;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkSelection;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;

public class GtkClipboard
extends Clipboard {
    static final String stringMimeType = DataFlavor.stringFlavor.getMimeType();
    static final String imageMimeType = DataFlavor.imageFlavor.getMimeType();
    static final String filesMimeType = DataFlavor.javaFileListFlavor.getMimeType();
    static final boolean canCache = GtkClipboard.initNativeState(stringMimeType, imageMimeType, filesMimeType);
    private static GtkClipboard instance = new GtkClipboard();

    static GtkClipboard getInstance() {
        return instance;
    }

    private static final void setSystemContents() {
        GtkClipboardNotifier.announce();
    }

    public synchronized void setContents(Transferable contents, ClipboardOwner owner) {
        super.setContents(contents, owner);
        if (contents == null) {
            this.advertiseContent(null, false, false, false);
            return;
        }
        if (contents instanceof GtkSelection) {
            return;
        }
        boolean text = false;
        boolean images = false;
        boolean files = false;
        if (contents instanceof StringSelection || contents.isDataFlavorSupported(DataFlavor.stringFlavor) || contents.isDataFlavorSupported(DataFlavor.plainTextFlavor) || contents.isDataFlavorSupported(DataFlavor.getTextPlainUnicodeFlavor())) {
            text = true;
        }
        DataFlavor[] flavors = contents.getTransferDataFlavors();
        String[] mimeTargets = new String[flavors.length];
        int i = 0;
        while (i < flavors.length) {
            String mimeType;
            DataFlavor flavor = flavors[i];
            mimeTargets[i] = mimeType = flavor.getMimeType();
            if (!text && ("text".equals(flavor.getPrimaryType()) || flavor.isRepresentationClassReader())) {
                text = true;
            }
            if (!images && flavors[i].equals(DataFlavor.imageFlavor)) {
                try {
                    Object o = contents.getTransferData(DataFlavor.imageFlavor);
                    if (o instanceof GtkImage) {
                        images = true;
                    }
                }
                catch (UnsupportedFlavorException ufe) {
                }
                catch (IOException ioe) {
                }
                catch (ClassCastException cce) {
                    // empty catch block
                }
            }
            if (flavors[i].equals(DataFlavor.javaFileListFlavor)) {
                files = true;
            }
            ++i;
        }
        this.advertiseContent(mimeTargets, text, images, files);
    }

    private final native void advertiseContent(String[] var1, boolean var2, boolean var3, boolean var4);

    private final String provideText() {
        Transferable contents = this.contents;
        if (contents == null || contents instanceof GtkSelection) {
            return null;
        }
        if (contents instanceof StringSelection) {
            try {
                return (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException ufe) {
            }
            catch (IOException ioe) {
            }
            catch (ClassCastException plainText) {
                // empty catch block
            }
        }
        try {
            DataFlavor plainText = DataFlavor.getTextPlainUnicodeFlavor();
            Reader r = plainText.getReaderForText(contents);
            if (r != null) {
                StringBuffer sb = new StringBuffer();
                char[] cs = new char[1024];
                int l = r.read(cs);
                while (l != -1) {
                    sb.append(cs, 0, l);
                    l = r.read(cs);
                }
                return sb.toString();
            }
        }
        catch (IllegalArgumentException iae) {
        }
        catch (UnsupportedEncodingException iee) {
        }
        catch (UnsupportedFlavorException ufe) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private final GtkImage provideImage() {
        Transferable contents = this.contents;
        if (contents == null || contents instanceof GtkSelection) {
            return null;
        }
        try {
            return (GtkImage)contents.getTransferData(DataFlavor.imageFlavor);
        }
        catch (UnsupportedFlavorException ufe) {
        }
        catch (IOException ioe) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    private final String[] provideURIs() {
        Transferable contents = this.contents;
        if (contents == null || contents instanceof GtkSelection) {
            return null;
        }
        try {
            List list2 = (List)contents.getTransferData(DataFlavor.javaFileListFlavor);
            String[] uris = new String[list2.size()];
            int u = 0;
            Iterator it = list2.iterator();
            while (it.hasNext()) {
                uris[u++] = ((File)it.next()).toURI().toString();
            }
            return uris;
        }
        catch (UnsupportedFlavorException ufe) {
        }
        catch (IOException ioe) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    private final byte[] provideContent(String target) {
        Transferable contents = this.contents;
        if (contents == null || contents instanceof GtkSelection) {
            return null;
        }
        try {
            DataFlavor flavor = new DataFlavor(target);
            Object o = contents.getTransferData(flavor);
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            if (o instanceof InputStream) {
                InputStream is = (InputStream)o;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bs = new byte[1024];
                int l = is.read(bs);
                while (l != -1) {
                    baos.write(bs, 0, l);
                    l = is.read(bs);
                }
                return baos.toByteArray();
            }
            if (o instanceof Serializable) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(o);
                oos.close();
                return baos.toByteArray();
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (UnsupportedFlavorException ufe) {
        }
        catch (IOException ioe) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    private static final native boolean initNativeState(String var0, String var1, String var2);

    private GtkClipboard() {
        super("System Clipboard");
        this.setContents(new GtkSelection(), null);
    }
}

