/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import gnu.xml.stream.AttributeImpl;
import gnu.xml.stream.CharactersImpl;
import gnu.xml.stream.CommentImpl;
import gnu.xml.stream.DTDImpl;
import gnu.xml.stream.EndDocumentImpl;
import gnu.xml.stream.EndElementImpl;
import gnu.xml.stream.EntityReferenceImpl;
import gnu.xml.stream.NamespaceImpl;
import gnu.xml.stream.ProcessingInstructionImpl;
import gnu.xml.stream.StartDocumentImpl;
import gnu.xml.stream.StartElementImpl;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.stream.util.XMLEventConsumer;

public class XMLEventAllocatorImpl
implements XMLEventAllocator {
    protected Map entityDeclarations = new HashMap();

    public XMLEvent allocate(XMLStreamReader reader) throws XMLStreamException {
        int eventType = reader.getEventType();
        Location location = reader.getLocation();
        switch (eventType) {
            case 12: {
                String text = reader.getText();
                boolean whitespace = this.isWhitespace(text);
                boolean ignorableWhitespace = false;
                return new CharactersImpl(location, text, whitespace, true, ignorableWhitespace);
            }
            case 4: {
                String text = reader.getText();
                boolean whitespace = false;
                boolean ignorableWhitespace = false;
                return new CharactersImpl(location, text, whitespace, false, ignorableWhitespace);
            }
            case 5: {
                String text = reader.getText();
                return new CommentImpl(location, text);
            }
            case 11: {
                String text = reader.getText();
                LinkedList notations = new LinkedList();
                LinkedList entities = new LinkedList();
                return new DTDImpl(location, text, null, notations, entities);
            }
            case 8: {
                return new EndDocumentImpl(location);
            }
            case 2: {
                int len = reader.getNamespaceCount();
                LinkedList namespaces = new LinkedList();
                int i = 0;
                while (i < len) {
                    namespaces.add(new NamespaceImpl(location, reader.getNamespacePrefix(i), reader.getNamespaceURI(i)));
                    ++i;
                }
                return new EndElementImpl(location, reader.getName(), namespaces);
            }
            case 9: {
                String name = reader.getLocalName();
                return new EntityReferenceImpl(location, name, null, null, null, null);
            }
            case 3: {
                return new ProcessingInstructionImpl(location, reader.getPITarget(), reader.getPIData());
            }
            case 6: {
                String text = reader.getText();
                boolean whitespace = true;
                boolean ignorableWhitespace = false;
                return new CharactersImpl(location, text, whitespace, false, ignorableWhitespace);
            }
            case 7: {
                String xmlVersion;
                boolean encodingDeclared;
                String systemId = location.getLocationURI();
                String encoding = reader.getCharacterEncodingScheme();
                boolean bl = false;
                if (encoding != null) {
                    bl = encodingDeclared = true;
                }
                if (encoding == null && (encoding = reader.getEncoding()) == null) {
                    encoding = "UTF-8";
                }
                if ((xmlVersion = reader.getVersion()) == null) {
                    xmlVersion = "1.0";
                }
                boolean xmlStandalone = reader.isStandalone();
                boolean standaloneDeclared = reader.standaloneSet();
                return new StartDocumentImpl(location, systemId, encoding, xmlVersion, xmlStandalone, standaloneDeclared, encodingDeclared);
            }
            case 1: {
                int len = reader.getNamespaceCount();
                LinkedList namespaces = new LinkedList();
                int i = 0;
                while (i < len) {
                    namespaces.add(new NamespaceImpl(location, reader.getNamespacePrefix(i), reader.getNamespaceURI(i)));
                    ++i;
                }
                len = reader.getAttributeCount();
                LinkedList attributes = new LinkedList();
                int i2 = 0;
                while (i2 < len) {
                    attributes.add(new AttributeImpl(location, reader.getAttributeQName(i2), reader.getAttributeValue(i2), QName.valueOf(reader.getAttributeType(i2)), reader.isAttributeSpecified(i2)));
                    ++i2;
                }
                return new StartElementImpl(location, reader.getName(), attributes, namespaces, reader.getNamespaceContext());
            }
        }
        throw new XMLStreamException("Unknown event type: " + eventType);
    }

    public void allocate(XMLStreamReader reader, XMLEventConsumer consumer) throws XMLStreamException {
        consumer.add(this.allocate(reader));
    }

    public XMLEventAllocator newInstance() {
        return new XMLEventAllocatorImpl();
    }

    protected boolean isWhitespace(String text) {
        int len = text.length();
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected XMLEventAllocatorImpl() {
    }
}

