/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RescaleOp
implements BufferedImageOp,
RasterOp {
    private float[] scale;
    private float[] offsets;
    private RenderingHints hints;

    public final float[] getScaleFactors(float[] scaleFactors) {
        if (scaleFactors == null) {
            scaleFactors = new float[this.scale.length];
        }
        System.arraycopy(this.scale, 0, scaleFactors, 0, this.scale.length);
        return scaleFactors;
    }

    public final float[] getOffsets(float[] offsets) {
        if (offsets == null) {
            offsets = new float[this.offsets.length];
        }
        System.arraycopy(this.offsets, 0, offsets, 0, this.offsets.length);
        return offsets;
    }

    public final int getNumFactors() {
        return this.scale.length;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (this.scale.length != this.offsets.length) {
            throw new IllegalArgumentException();
        }
        ColorModel scm = src.getColorModel();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        WritableRaster wsrc = src.getRaster();
        WritableRaster wdst = dst.getRaster();
        if (this.scale.length == 1 || this.scale.length == scm.getNumColorComponents()) {
            int[] subbands = new int[scm.getNumColorComponents()];
            int i = 0;
            while (i < subbands.length) {
                subbands[i] = i;
                ++i;
            }
            wsrc = wsrc.createWritableChild(wsrc.minX, wsrc.minY, wsrc.width, wsrc.height, wsrc.minX, wsrc.minY, subbands);
        }
        this.filter(wsrc, wdst);
        return dst;
    }

    public final WritableRaster filter(Raster src, WritableRaster dest) {
        if (dest == null) {
            dest = src.createCompatibleWritableRaster();
        }
        if (src.numBands != dest.numBands || this.scale.length != this.offsets.length) {
            throw new IllegalArgumentException();
        }
        if (this.scale.length != 1 && this.scale.length != src.numBands) {
            throw new IllegalArgumentException();
        }
        float[] lscale = this.scale;
        float[] loff = this.offsets;
        if (this.scale.length == 1) {
            lscale = new float[src.numBands];
            Arrays.fill(lscale, this.scale[0]);
            loff = new float[src.numBands];
            Arrays.fill(loff, this.offsets[0]);
        }
        float[] pixel = new float[src.numBands];
        int y = src.minY;
        while (y < src.height + src.minY) {
            int x = src.minX;
            while (x < src.width + src.minX) {
                src.getPixel(x, y, pixel);
                int b = 0;
                while (b < src.numBands) {
                    pixel[b] = pixel[b] * lscale[b] + loff[b];
                    ++b;
                }
                dest.setPixel(x, y, pixel);
                ++x;
            }
            ++y;
        }
        return dest;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        if (dstCM == null) {
            dstCM = src.getColorModel();
        }
        WritableRaster wr = src.getRaster().createCompatibleWritableRaster();
        BufferedImage image = new BufferedImage(dstCM, wr, src.isPremultiplied, null);
        return image;
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public final Rectangle2D getBounds2D(BufferedImage src) {
        return src.getRaster().getBounds();
    }

    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    public final Point2D getPoint2D(Point2D src, Point2D dst) {
        if (dst == null) {
            dst = (Point2D)src.clone();
        } else {
            dst.setLocation(src);
        }
        return dst;
    }

    private final /* synthetic */ void this() {
        this.hints = null;
    }

    public RescaleOp(float[] scaleFactors, float[] offsets, RenderingHints hints) {
        this.this();
        this.scale = scaleFactors;
        this.offsets = offsets;
        this.hints = hints;
    }

    public RescaleOp(float scaleFactor, float offset, RenderingHints hints) {
        this.this();
        this.scale = new float[]{scaleFactor};
        this.offsets = new float[]{offset};
        this.hints = hints;
    }
}

